VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsRecentMenu"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
        
Option Explicit

Dim Owner As Form
Dim Menu
Dim Separator
Dim FileName As String
Dim MaxLength As Long
Dim MaxItems As Integer

Public Sub Initialize(vOwner, vMenu, vFileName, Optional vSeparator, Optional vMaxLength, Optional vMaxItems = 20)
    Set Owner = vOwner
    Set Menu = vMenu
    FileName = vFileName
    If Not IsMissing(vSeparator) Then Set Separator = vSeparator
    If IsMissing(vMaxLength) Then
        MaxLength = Screen.Width \ 15
    Else
        MaxLength = vMaxLength
    End If
    MaxItems = vMaxItems
    CreateRecentMenu
End Sub

Public Function FileExisits(Path As String) As Long
    On Error GoTo ErrLbl
    FileExisits = FileLen(Path)
ErrLbl:
End Function

Private Function ShortPath(Path As String, ValidLength As Long) As String
    Dim Counter As Integer, TempScaleMode As Integer
    Dim File As String, Result As String
    Dim TempPath As String, NewStr As String, PreviousStep As String
    Dim dir() As String
    ReDim dir(0 To 0)
    dir(0) = Left(Path, 3)
    File = Right(Path, Len(Path) - InStrRev(Path, "\", Len(Path)))
    TempPath = Replace(Path, dir(0), "")
    TempPath = Replace(TempPath, File, "")
    While InStr(TempPath, "\") > 0
        ReDim Preserve dir(0 To UBound(dir) + 1)
        dir(UBound(dir)) = Left(TempPath, InStr(TempPath, "\"))
        TempPath = Replace(TempPath, dir(UBound(dir)), "")
    Wend
    Counter = 0
    Result = dir(0) & "...\" & File
    NewStr = ""
    TempScaleMode = Owner.ScaleMode
    Owner.ScaleMode = vbPixels
    PreviousStep = File
    While Owner.TextWidth(Result) <= MaxLength And Counter < UBound(dir)
        NewStr = NewStr & dir(Counter)
        Result = NewStr & "...\" & File
        Counter = Counter + 1
        If Counter = UBound(dir) Then Result = Replace(Result, "...\", "")
        If Owner.TextWidth(Result) <= MaxLength Then PreviousStep = Result
    Wend
    Result = PreviousStep
    Owner.ScaleMode = TempScaleMode
    ShortPath = Result
End Function

Public Sub AddToList(Path As String)
    Dim Free As Integer, Counter As Integer, C As Integer
    Dim LastList() As String, NewList() As String
    Dim Found As Boolean
    Free = FreeFile
    ReDim LastList(1 To 1)
    ReDim NewList(1 To 1)
    If FileExisits(FileName) Then
        Open FileName For Input As Free
        Input #Free, LastList(1)
        While Not EOF(Free)
            ReDim Preserve LastList(1 To UBound(LastList) + 1)
            Input #Free, LastList(UBound(LastList))
        Wend
        Close Free
    Else
        LastList(1) = Path
    End If
    Found = False
    For Counter = 1 To UBound(LastList)
        If LCase(LastList(Counter)) = LCase(Path) Then
            Found = True
            Exit For
        End If
    Next
    If Found Then
        ReDim NewList(1 To UBound(LastList))
    Else
        ReDim NewList(1 To UBound(LastList) + 1)
    End If
    NewList(1) = Path
    C = 1
    For Counter = 1 To UBound(LastList)
        If LCase(LastList(Counter)) <> LCase(Path) Then
            C = C + 1
            NewList(C) = LastList(Counter)
        End If
    Next
    Free = FreeFile
    Open FileName For Output As Free
    For Counter = 1 To UBound(NewList)
        Write #Free, NewList(Counter)
    Next
    Close Free
    CreateRecentMenu
End Sub

Public Sub RemoveFromList(Path As String)
    Dim Free As Integer, Counter As Integer, C As Integer
    Dim LastList() As String, NewList() As String
    Dim Found As Boolean
    Free = FreeFile
    ReDim LastList(1 To 1)
    ReDim NewList(1 To 1)
    If FileExisits(FileName) Then
        Open FileName For Input As Free
        Input #Free, LastList(1)
        While Not EOF(Free)
            ReDim Preserve LastList(1 To UBound(LastList) + 1)
            Input #Free, LastList(UBound(LastList))
        Wend
        Close Free
        Found = False
        If UBound(LastList) = 1 And LCase(LastList(1)) = LCase(Path) Then
            Free = FreeFile
            Open FileName For Output As Free
            Close Free
        Else
            For Counter = 1 To UBound(LastList)
                If LCase(LastList(Counter)) = LCase(Path) Then
                    Found = True
                    Exit For
                End If
            Next
            If Found Then
                ReDim NewList(1 To UBound(LastList) - 1)
                C = 0
                For Counter = 1 To UBound(LastList)
                    If LCase(LastList(Counter)) <> LCase(Path) Then
                        C = C + 1
                        NewList(C) = LastList(Counter)
                    End If
                Next
                Free = FreeFile
                Open FileName For Output As Free
                For Counter = 1 To UBound(NewList)
                    Write #Free, NewList(Counter)
                Next
                Close Free
            End If
        End If
    End If
    CreateRecentMenu
End Sub

Public Sub CreateRecentMenu()
    Dim Free As Integer, Counter As Integer
    Dim Path As String
    Dim Found As Boolean
    For Counter = 1 To Menu.UBound
        Unload Menu(Counter)
    Next
    Counter = -1
    If FileExisits(FileName) Then
        Free = FreeFile
        Open FileName For Input As Free
        While Not EOF(Free) And (Counter + 2) <= MaxItems
            Found = True
            Input #Free, Path
            Counter = Counter + 1
            If Counter > 0 Then Load (Menu(Menu.Count))
            Menu(Menu.UBound).Tag = Path
            Menu(Menu.UBound).Caption = Counter + 1 & " " & ShortPath(Path, MaxLength)
        Wend
        Close Free
    End If
    If Not IsEmpty(Separator) Then Separator.Visible = Found
    For Counter = 0 To Menu.UBound
        Menu(Counter).Visible = Found
    Next
End Sub
