VERSION 5.00
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "COMDLG32.OCX"
Begin VB.Form frmGame 
   Caption         =   "Hussein & Mojtaba"
   ClientHeight    =   3090
   ClientLeft      =   165
   ClientTop       =   855
   ClientWidth     =   4680
   Icon            =   "frmGame.frx":0000
   KeyPreview      =   -1  'True
   LinkTopic       =   "Form1"
   OLEDropMode     =   1  'Manual
   ScaleHeight     =   206
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   312
   StartUpPosition =   3  'Windows Default
   Begin VB.PictureBox Sudoku 
      AutoRedraw      =   -1  'True
      BackColor       =   &H00FFFFFF&
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   178
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Index           =   0
      Left            =   240
      OLEDropMode     =   1  'Manual
      ScaleHeight     =   21
      ScaleMode       =   3  'Pixel
      ScaleWidth      =   21
      TabIndex        =   2
      Top             =   240
      Visible         =   0   'False
      Width           =   375
   End
   Begin MSComDlg.CommonDialog CD 
      Left            =   840
      Top             =   240
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
   End
   Begin VB.PictureBox picSolveHolder 
      AutoRedraw      =   -1  'True
      Height          =   735
      Left            =   1440
      OLEDropMode     =   1  'Manual
      ScaleHeight     =   45
      ScaleMode       =   3  'Pixel
      ScaleWidth      =   109
      TabIndex        =   0
      TabStop         =   0   'False
      Top             =   120
      Width           =   1695
      Begin VB.PictureBox Solve 
         AutoRedraw      =   -1  'True
         BackColor       =   &H80000009&
         Enabled         =   0   'False
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   8.25
            Charset         =   178
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   375
         Index           =   0
         Left            =   120
         ScaleHeight     =   21
         ScaleMode       =   3  'Pixel
         ScaleWidth      =   20
         TabIndex        =   1
         TabStop         =   0   'False
         Top             =   120
         Visible         =   0   'False
         Width           =   360
      End
   End
   Begin VB.Shape Shape1 
      Height          =   615
      Left            =   120
      Top             =   120
      Width           =   615
   End
   Begin VB.Menu mnuFile 
      Caption         =   "File"
      Begin VB.Menu mnuLoad 
         Caption         =   "Load"
         Shortcut        =   ^O
      End
      Begin VB.Menu mnuSave 
         Caption         =   "Save"
         Shortcut        =   ^S
      End
      Begin VB.Menu SepRecent 
         Caption         =   "-"
      End
      Begin VB.Menu mnuRecentFile 
         Caption         =   "Drive:\Directory\Filename.Extension"
         Index           =   0
      End
      Begin VB.Menu Sep1 
         Caption         =   "-"
      End
      Begin VB.Menu mnuExit 
         Caption         =   "Exit"
      End
   End
   Begin VB.Menu mnuGame 
      Caption         =   "Game"
      Begin VB.Menu mnuNewGame 
         Caption         =   "New"
         Shortcut        =   {F2}
      End
      Begin VB.Menu Sep3 
         Caption         =   "-"
      End
      Begin VB.Menu mnuGenerate 
         Caption         =   "Generate"
         Shortcut        =   {F5}
      End
      Begin VB.Menu mnuSolve 
         Caption         =   "Solve"
         Shortcut        =   ^A
      End
      Begin VB.Menu mnuCheck 
         Caption         =   "Check Diagram"
         Shortcut        =   ^C
      End
      Begin VB.Menu Sep2 
         Caption         =   "-"
      End
      Begin VB.Menu mnuClear 
         Caption         =   "Clear blue numbers"
         Shortcut        =   ^Z
      End
   End
   Begin VB.Menu mnuHelp 
      Caption         =   "Help"
      Begin VB.Menu mnuAbout 
         Caption         =   "About"
      End
   End
End
Attribute VB_Name = "frmGame"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Declare Function GetActiveWindow Lib "user32" () As Long

Private WithEvents clsMouseWheel As CMouseWheel
Attribute clsMouseWheel.VB_VarHelpID = -1

Const Space = 5
Const cSuDoKuWidth = 30, cSuDoKuHeight = 30
Const cSolveWidth = 40, cSolveHeight = 41
Const cDefSudBack = vbWhite
Const cErrSudBack = vbYellow

Private Type typSuduko
    Value As Byte
    Lock As Boolean
End Type

Dim arrSudoku(1 To 81) As typSuduko
Dim arrSolve(1 To 81, 1 To 9) As Byte
Dim NewArr(1 To 9, 1 To 9, 1 To 9)
Dim RevNewArr(1 To 9, 1 To 9, 1 To 9)
Dim SudInd As Integer
Dim XDown As Integer, YDown As Integer, CanMove As Boolean
Dim LastButton As Integer
Dim RM As New clsRecentMenu
Public EscPressed As Boolean

Private Sub OLEParam(FileName As String)
    Dim Temp As String
    Temp = FileName
    While InStr(Temp, """") > 0
        Temp = Replace(Temp, """", "")
    Wend
    If RM.FileExisits(Temp) Then
        LoadSDK Temp
        RM.AddToList Temp
    End If
End Sub

Private Sub ArrangeSolve()
    Dim Counter As Byte
    Dim vLeft As Integer, vTop As Integer
    Solve(0).BorderStyle = 0
    Solve(0).Appearance = 0
    Solve(0).Width = cSolveWidth
    Solve(0).Height = cSolveHeight
    vTop = -Solve(0).Height + Space
    vLeft = -Solve(0).Width
    For Counter = 1 To 81
        Load Solve(Counter)
        If Counter Mod 9 = 1 Then
            vLeft = 0
            vTop = vTop + Solve(0).Height + Space
        Else
            vLeft = vLeft + Solve(0).Width + Space
        End If
        If Counter Mod 3 = 1 Then vLeft = vLeft + Space * 2
        If Counter Mod 27 = 1 Then vTop = vTop + Space * 2
        Solve(Counter).Move vLeft, vTop
        Solve(Counter).Visible = True
    Next
    picSolveHolder.Width = picSolveHolder.Width - picSolveHolder.ScaleWidth + vLeft + Solve(0).Width + Space * 2
    picSolveHolder.Height = picSolveHolder.Height - picSolveHolder.ScaleHeight + vTop + Solve(0).Height + Space * 2
End Sub

Private Sub ArrangeSudoku()
    Dim Counter As Byte
    Dim vLeft As Integer, vTop As Integer
    Sudoku(0).Width = cSuDoKuWidth
    Sudoku(0).Height = cSuDoKuHeight
    vTop = -Sudoku(0).Height + Space
    vLeft = -Sudoku(0).Width
    For Counter = 1 To 81
        Load Sudoku(Counter)
        If Counter Mod 9 = 1 Then
            vLeft = 10
            vTop = vTop + Sudoku(0).Height + Space
        Else
            vLeft = vLeft + Sudoku(0).Width + Space
        End If
        If Counter Mod 3 = 1 Then vLeft = vLeft + Space * 2
        If Counter Mod 27 = 1 Then vTop = vTop + Space * 2
        Sudoku(Counter).Move vLeft, vTop
        Sudoku(Counter).Visible = True
    Next
    Shape1.Move Sudoku(1).Left - 1, Sudoku(1).Top - 1, Sudoku(1).Width + 2, Sudoku(1).Height + 2
    Sudoku(1).SetFocus
End Sub

Private Sub SetNumber(Index, Number, Locked As Boolean, Optional BackColor = cDefSudBack)
    If Number = "+" Then
        If arrSudoku(Index).Value = 9 Then arrSudoku(Index).Value = 0 Else arrSudoku(Index).Value = arrSudoku(Index).Value + 1
    ElseIf Number = "-" Then
        If arrSudoku(Index).Value = 0 Then arrSudoku(Index).Value = 9 Else arrSudoku(Index).Value = arrSudoku(Index).Value - 1
    Else
        arrSudoku(Index).Value = Val(Number)
    End If
    arrSudoku(Index).Lock = IIf(arrSudoku(Index).Value = 0, False, Locked)
    Sudoku(Index).Cls
    Sudoku(Index).BackColor = BackColor
    If arrSudoku(Index).Value <> 0 Then
        Sudoku(Index).CurrentX = (Sudoku(Index).ScaleWidth - Sudoku(Index).TextWidth(arrSudoku(Index).Value)) \ 2 - 3
        Sudoku(Index).CurrentY = (Sudoku(Index).ScaleHeight - Sudoku(Index).TextHeight(arrSudoku(Index).Value)) \ 2
        Sudoku(Index).ForeColor = IIf(arrSudoku(Index).Lock, &H80&, &H80000001)
        Sudoku(Index).Print arrSudoku(Index).Value
    End If
End Sub

Private Function FindIndex(Row, Col) As Byte
    FindIndex = (Row - 1) * 9 + Col
End Function

Private Sub FindRowCol(Index, Row, Col)
    Row = Index \ 9
    Col = Index Mod 9
    If Index Mod 9 = 0 Then
        Col = 9
    Else
        Row = Row + 1
    End If
End Sub

Private Sub FindColSet(Index As Byte, Col1 As Byte, Col2 As Byte, Col3 As Byte)
    Dim Row As Byte, Col As Byte
    Dim ColPos As Byte, FirstCol As Byte
    FindRowCol Index, Row, Col
    ColPos = Col Mod 3
    If ColPos = 0 Then ColPos = 3
    FirstCol = Col - ColPos + 1
    Col1 = FirstCol
    Col2 = FirstCol + 1
    Col3 = FirstCol + 2
End Sub

Private Sub Fill()
    Dim I, J
    For I = 1 To 81
        For J = 1 To 9
            arrSolve(I, J) = J
        Next
    Next
End Sub

Private Sub SetEmpty()
    Dim Block As Integer, Number As Integer
    For Block = 1 To 81
        If arrSudoku(Block).Value <> 0 Then
            For Number = 1 To 9
                arrSolve(Block, Number) = 0
            Next
        End If
    Next
End Sub

Private Sub RowSolve()
    Dim Block As Integer, Row As Integer, Col As Integer
    Row = 1
    For Block = 1 To 81
        If arrSudoku(Block).Value <> 0 Then
            For Col = 1 To 9
                arrSolve(FindIndex(Row, Col), arrSudoku(Block).Value) = 0
            Next
        End If
        If Block Mod 9 = 0 Then Row = Row + 1
    Next
End Sub

Private Sub ColSolve()
    Dim Block As Integer, Row As Integer, Col As Integer
    For Block = 1 To 81
        FindRowCol Block, Row, Col
        If arrSudoku(Block).Value <> 0 Then
            For Row = 1 To 9
                arrSolve(FindIndex(Row, Col), arrSudoku(Block).Value) = 0
            Next
        End If
    Next
End Sub

Private Sub SquareSolve()
    Dim Square As Integer, Block As Integer, Block2 As Integer
    Dim S(1 To 9, 1 To 9) As Byte
    S(1, 1) = 1: S(1, 2) = 2: S(1, 3) = 3 '   1
    S(1, 4) = 10: S(1, 5) = 11: S(1, 6) = 12 '1
    S(1, 7) = 19: S(1, 8) = 20: S(1, 9) = 21 '1_____________________
    S(2, 1) = 4: S(2, 2) = 5: S(2, 3) = 6    '2
    S(2, 4) = 13: S(2, 5) = 14: S(2, 6) = 15 '2
    S(2, 7) = 22: S(2, 8) = 23: S(2, 9) = 24 '2_____________________
    S(3, 1) = 7: S(3, 2) = 8: S(3, 3) = 9    '3
    S(3, 4) = 16: S(3, 5) = 17: S(3, 6) = 18 '3
    S(3, 7) = 25: S(3, 8) = 26: S(3, 9) = 27 '3_____________________
    S(4, 1) = 28: S(4, 2) = 29: S(4, 3) = 30 '4
    S(4, 4) = 37: S(4, 5) = 38: S(4, 6) = 39 '4
    S(4, 7) = 46: S(4, 8) = 47: S(4, 9) = 48 '4_____________________
    S(5, 1) = 31: S(5, 2) = 32: S(5, 3) = 33 '5
    S(5, 4) = 40: S(5, 5) = 41: S(5, 6) = 42 '5
    S(5, 7) = 49: S(5, 8) = 50: S(5, 9) = 51 '5_____________________
    S(6, 1) = 34: S(6, 2) = 35: S(6, 3) = 36 '6
    S(6, 4) = 43: S(6, 5) = 44: S(6, 6) = 45 '6
    S(6, 7) = 52: S(6, 8) = 53: S(6, 9) = 54 '6_____________________
    S(7, 1) = 55: S(7, 2) = 56: S(7, 3) = 57 '7
    S(7, 4) = 64: S(7, 5) = 65: S(7, 6) = 66 '7
    S(7, 7) = 73: S(7, 8) = 74: S(7, 9) = 75 '7_____________________
    S(8, 1) = 58: S(8, 2) = 59: S(8, 3) = 60 '8
    S(8, 4) = 67: S(8, 5) = 68: S(8, 6) = 69 '8
    S(8, 7) = 76: S(8, 8) = 77: S(8, 9) = 78 '8_____________________
    S(9, 1) = 61: S(9, 2) = 62: S(9, 3) = 63 '9
    S(9, 4) = 70: S(9, 5) = 71: S(9, 6) = 72 '9
    S(9, 7) = 79: S(9, 8) = 80: S(9, 9) = 81 '9_____________________
    For Square = 1 To 9
        For Block = 1 To 9
            If arrSudoku(S(Square, Block)).Value <> 0 Then
                For Block2 = 1 To 9
                    arrSolve(S(Square, Block2), arrSudoku(S(Square, Block)).Value) = 0
                Next
            End If
        Next
    Next
End Sub

Private Function HelpGearRow() As Boolean
    Dim Row, Col, Index, I
    Dim ArrNums(1 To 9, 1 To 2) As Byte
    For Row = 1 To 9
        For I = 1 To 9
            ArrNums(I, 1) = 0
        Next
        For Col = 1 To 9
            Index = FindIndex(Row, Col)
            For I = 1 To 9
                If arrSolve(Index, I) > 0 Then
                    ArrNums(I, 1) = ArrNums(I, 1) + 1
                    ArrNums(I, 2) = Index
                End If
            Next
        Next
        For I = 1 To 9
            If ArrNums(I, 1) = 1 Then
                SetNumber ArrNums(I, 2), I, False
                HelpGearRow = True
            End If
        Next
    Next
End Function

Private Function HelpGearCol() As Boolean
    Dim Row, Col, Index, I
    Dim ArrNums(1 To 9, 1 To 2) As Byte
    For Col = 1 To 9
        For I = 1 To 9
            ArrNums(I, 1) = 0
        Next
        For Row = 1 To 9
            Index = FindIndex(Row, Col)
            For I = 1 To 9
                If arrSolve(Index, I) > 0 Then
                    ArrNums(I, 1) = ArrNums(I, 1) + 1
                    ArrNums(I, 2) = Index
                End If
            Next
        Next
        For I = 1 To 9
            If ArrNums(I, 1) = 1 Then
                SetNumber ArrNums(I, 2), I, False
                HelpGearCol = True
            End If
        Next
    Next
End Function

Private Function HelpGearSquare() As Boolean
    Dim Row, Row2, Col, Col2, Index, I
    Dim ArrNums(1 To 9, 1 To 2) As Byte
    For Row = 1 To 9 Step 3
        For Col = 1 To 9 Step 3
            For I = 1 To 9
                ArrNums(I, 1) = 0
            Next
            For Row2 = 1 To 3
                For Col2 = 1 To 3
                    Index = FindIndex(Row - 1 + Row2, Col - 1 + Col2)
                    For I = 1 To 9
                        If arrSolve(Index, I) > 0 Then
                            ArrNums(I, 1) = ArrNums(I, 1) + 1
                            ArrNums(I, 2) = Index
                        End If
                    Next
                Next
            Next
            For I = 1 To 9
                If ArrNums(I, 1) = 1 Then
                    SetNumber ArrNums(I, 2), I, False
                    HelpGearSquare = True
                End If
            Next
        Next
    Next
End Function

Private Function FindSingleSelection() As Boolean
    Dim I As Integer, J As Integer, Z As Integer
    For I = 1 To 81
        If arrSudoku(I).Value = 0 Then
            Z = 0
            For J = 1 To 9
                If arrSolve(I, J) = 0 Then Z = Z + 1
            Next
            If Z = 8 Then
                For J = 1 To 9
                    If arrSolve(I, J) <> 0 Then SetNumber I, arrSolve(I, J), False
                Next
                FindSingleSelection = True
            End If
        End If
    Next
End Function

Private Sub PrintArrSolve()
    Dim I, J
    For I = 1 To 81
        Solve(I).Cls
    Next
    For I = 1 To 81
        For J = 1 To 9
            If arrSolve(I, J) = 0 Then
                Solve(I).ForeColor = Solve(0).BackColor
            Else
                Solve(I).ForeColor = Solve(0).ForeColor
            End If
            Solve(I).CurrentX = Solve(I).CurrentX + 1
            Solve(I).Print arrSolve(I, J);
            If J Mod 3 = 0 Then Solve(I).Print
        Next
    Next
End Sub

Private Sub ResetSudBack()
    Dim Counter As Byte
    For Counter = 1 To 81
        SetNumber Counter, arrSudoku(Counter).Value, arrSudoku(Counter).Lock
    Next
End Sub

Private Function CheckDiagram(Optional Mess) As Integer
    Dim Row, Col, Row2, Col2, Index, I, r, C, E, N
    Dim StrError As String
    Dim ArrCheck(1 To 9) As Byte
    For Row = 1 To 9 Step 3
        For Col = 1 To 9 Step 3
            For I = 1 To 9
                ArrCheck(I) = 0
            Next
            For Row2 = 1 To 3
                For Col2 = 1 To 3
                    Index = FindIndex(Row - 1 + Row2, Col - 1 + Col2)
                    If arrSudoku(Index).Value <> 0 Then ArrCheck(arrSudoku(Index).Value) = 1
                Next
            Next
            E = 0
            For I = 1 To 9
                If ArrCheck(I) = 0 Then E = E + 1
            Next
            If E > 0 Then StrError = StrError & vbNewLine & "Error at square " & (Row + 2) \ 3 & "," & (Col + 2) \ 3 & " for " & E & " times."
            N = N + E
        Next
    Next
    StrError = StrError & vbNewLine
    For Row = 1 To 9
        For I = 1 To 9
            ArrCheck(I) = 0
        Next
        For Col = 1 To 9
            Index = FindIndex(Row, Col)
            If arrSudoku(Index).Value <> 0 Then ArrCheck(arrSudoku(Index).Value) = 1
        Next
        E = 0
        For I = 1 To 9
            If ArrCheck(I) = 0 Then E = E + 1
        Next
        If E > 0 Then StrError = StrError & vbNewLine & "Error at row " & Row & " for " & E & " times."
        N = N + E
    Next
    StrError = StrError & vbNewLine
    For Col = 1 To 9
        For I = 1 To 9
            ArrCheck(I) = 0
        Next
        For Row = 1 To 9
            Index = FindIndex(Row, Col)
            If arrSudoku(Index).Value <> 0 Then ArrCheck(arrSudoku(Index).Value) = 1
        Next
        E = 0
        For I = 1 To 9
            If ArrCheck(I) = 0 Then E = E + 1
        Next
        If E > 0 Then StrError = StrError & vbNewLine & "Error at col " & Col & " for " & E & " times."
        N = N + E
    Next
    StrError = StrError & vbNewLine
    CheckDiagram = N
    If Not IsMissing(Mess) Then Mess = StrError
End Function

Private Function CheckEntries() As Integer
    Dim Row As Byte, Col As Byte
    Dim Index As Byte, Number As Byte, Counter As Byte
    Dim Found As Integer
    'Row Checking
    Dim Columns As String
    Dim RowError(1 To 9, 1 To 9) As String
    For Row = 1 To 9
        For Col = 1 To 9
            Index = FindIndex(Row, Col)
            Number = arrSudoku(Index).Value
            If Number <> 0 Then RowError(Row, Number) = RowError(Row, Number) & Col
        Next
        For Number = 1 To 9
            If Len(RowError(Row, Number)) > 1 Then
                For Counter = 1 To Len(RowError(Row, Number))
                    Index = FindIndex(Row, Mid(RowError(Row, Number), Counter, 1))
                    If Sudoku(Index).BackColor <> cErrSudBack Then Found = Found + 1
                    SetNumber Index, arrSudoku(Index).Value, arrSudoku(Index).Lock, cErrSudBack
                Next
            End If
        Next
    Next
    'Column Checking
    Dim Rows As String
    Dim ColError(1 To 9, 1 To 9) As String
    For Col = 1 To 9
        For Row = 1 To 9
            Index = FindIndex(Row, Col)
            Number = arrSudoku(Index).Value
            If Number <> 0 Then ColError(Col, Number) = ColError(Col, Number) & Row
        Next
        For Number = 1 To 9
            If Len(ColError(Col, Number)) > 1 Then
                For Counter = 1 To Len(ColError(Col, Number))
                    Index = FindIndex(Mid(ColError(Col, Number), Counter, 1), Col)
                    If Sudoku(Index).BackColor <> cErrSudBack Then Found = Found + 1
                    SetNumber Index, arrSudoku(Index).Value, arrSudoku(Index).Lock, cErrSudBack
                Next
            End If
        Next
    Next
    'Square Checking
    Dim Square As Integer, Block As Integer, Block2 As Integer
    Dim S(1 To 9, 1 To 9) As Byte
    Dim Blocks As String
    Dim SquareError(1 To 9, 1 To 9) As String
    S(1, 1) = 1: S(1, 2) = 2: S(1, 3) = 3 '   1
    S(1, 4) = 10: S(1, 5) = 11: S(1, 6) = 12 '1
    S(1, 7) = 19: S(1, 8) = 20: S(1, 9) = 21 '1_____________________
    S(2, 1) = 4: S(2, 2) = 5: S(2, 3) = 6    '2
    S(2, 4) = 13: S(2, 5) = 14: S(2, 6) = 15 '2
    S(2, 7) = 22: S(2, 8) = 23: S(2, 9) = 24 '2_____________________
    S(3, 1) = 7: S(3, 2) = 8: S(3, 3) = 9    '3
    S(3, 4) = 16: S(3, 5) = 17: S(3, 6) = 18 '3
    S(3, 7) = 25: S(3, 8) = 26: S(3, 9) = 27 '3_____________________
    S(4, 1) = 28: S(4, 2) = 29: S(4, 3) = 30 '4
    S(4, 4) = 37: S(4, 5) = 38: S(4, 6) = 39 '4
    S(4, 7) = 46: S(4, 8) = 47: S(4, 9) = 48 '4_____________________
    S(5, 1) = 31: S(5, 2) = 32: S(5, 3) = 33 '5
    S(5, 4) = 40: S(5, 5) = 41: S(5, 6) = 42 '5
    S(5, 7) = 49: S(5, 8) = 50: S(5, 9) = 51 '5_____________________
    S(6, 1) = 34: S(6, 2) = 35: S(6, 3) = 36 '6
    S(6, 4) = 43: S(6, 5) = 44: S(6, 6) = 45 '6
    S(6, 7) = 52: S(6, 8) = 53: S(6, 9) = 54 '6_____________________
    S(7, 1) = 55: S(7, 2) = 56: S(7, 3) = 57 '7
    S(7, 4) = 64: S(7, 5) = 65: S(7, 6) = 66 '7
    S(7, 7) = 73: S(7, 8) = 74: S(7, 9) = 75 '7_____________________
    S(8, 1) = 58: S(8, 2) = 59: S(8, 3) = 60 '8
    S(8, 4) = 67: S(8, 5) = 68: S(8, 6) = 69 '8
    S(8, 7) = 76: S(8, 8) = 77: S(8, 9) = 78 '8_____________________
    S(9, 1) = 61: S(9, 2) = 62: S(9, 3) = 63 '9
    S(9, 4) = 70: S(9, 5) = 71: S(9, 6) = 72 '9
    S(9, 7) = 79: S(9, 8) = 80: S(9, 9) = 81 '9_____________________
    For Square = 1 To 9
        For Block = 1 To 9
            Index = S(Square, Block)
            Number = arrSudoku(Index).Value
            If Number <> 0 Then SquareError(Square, Number) = SquareError(Square, Number) & Block
        Next
        For Number = 1 To 9
            If Len(SquareError(Square, Number)) > 1 Then
                For Counter = 1 To Len(SquareError(Square, Number))
                    Index = S(Square, Mid(SquareError(Square, Number), Counter, 1))
                    If Sudoku(Index).BackColor <> cErrSudBack Then Found = Found + 1
                    SetNumber Index, arrSudoku(Index).Value, arrSudoku(Index).Lock, cErrSudBack
                Next
            End If
        Next
    Next
    CheckEntries = Found
End Function

Private Function CheckLogicality() As Integer
    Dim I As Byte, J As Byte, Errors As Byte
    Dim Found As Boolean
    Resolve
    For I = 1 To 81
        Found = False
        For J = 1 To 9
            If arrSolve(I, J) <> 0 Then Found = True
        Next
        If Not Found And arrSudoku(I).Value = 0 Then
            SetNumber I, 0, False, cErrSudBack
            Errors = Errors + 1
        End If
    Next
    CheckLogicality = Errors
End Function

Private Function CanNotContinue() As Boolean
    CanNotContinue = True
    If CheckDiagram = 0 Then
        MsgBox "This puzzle is solved.", vbExclamation
    ElseIf CheckEntries > 0 Then
        MsgBox "Please check entries.", vbExclamation
    ElseIf CheckLogicality > 0 Then
        MsgBox "Please check logicality.", vbExclamation
    Else
        CanNotContinue = False
    End If
End Function

Private Sub Wait(Cancel As Boolean)
    Me.Enabled = False
    If Cancel Then EscPressed = False
    frmWait.lblWait = "Please wait..." & IIf(Cancel, vbCrLf & "Press Esc to cancel", "")
    frmWait.Visible = True
    frmWait.Refresh
End Sub

Private Sub LastTry()
    If CanNotContinue Then Exit Sub
    Dim Found As Boolean
    Dim I As Byte, J As Byte
    Dim MaxIndex As Byte, MaxNums As Byte
    Dim Index() As Byte
    Dim Nums() As String
    ReDim Index(1 To 81)
    ReDim Nums(1 To 81)
    MaxIndex = 0
    MaxNums = 0
    Wait True
NextSquare:
    Found = False
    For I = 1 To 81
        For J = 1 To 9
            If arrSolve(I, J) <> 0 Then
                If Not Found Then
                    Found = True
                    MaxIndex = MaxIndex + 1
                    Index(MaxIndex) = I
                    MaxNums = MaxNums + 1
                End If
                Nums(MaxNums) = Nums(MaxNums) & J
            End If
        Next
        If Found Then Exit For
    Next
    If Not Found Then GoTo Finish
NextNums:
    SetNumber Index(MaxIndex), Left(Nums(MaxNums), 1), False
    DoEvents
    If EscPressed Then GoTo Finish
    Nums(MaxNums) = Replace(Nums(MaxNums), Left(Nums(MaxNums), 1), "")
    Resolve
    If CheckLogicality > 0 Then
        While Nums(MaxNums) = ""
            SetNumber Index(MaxIndex), 0, False
            MaxIndex = MaxIndex - 1
            MaxNums = MaxNums - 1
            If MaxIndex = 0 Then GoTo Finish
        Wend
        GoTo NextNums
    Else
        GoTo NextSquare
    End If
Finish:
    Unload frmWait
    MsgBox "I finished my work.", vbInformation
End Sub

Private Sub qq(Row, Col, S1 As String, S2 As String, S3 As String)
    Dim r, C, I, Index, Min, Max
    r = Row
    S1 = ""
    S2 = ""
    S3 = ""
    If Col < 4 Then
        Min = Col
        Max = Col
    Else
        Min = 1
        Max = 3
    End If
    For C = Min To Max
        Index = FindIndex(r, C)
        For I = 1 To 9
            If InStr(S1, arrSolve(Index, I)) = 0 Then S1 = S1 & arrSolve(Index, I)
        Next
    Next
    If Col > 3 And Col < 7 Then
        Min = Col
        Max = Col
    Else
        Min = 4
        Max = 6
    End If
    For C = Min To Max
        Index = FindIndex(r, C)
        For I = 1 To 9
            If InStr(S2, arrSolve(Index, I)) = 0 Then S2 = S2 & arrSolve(Index, I)
        Next
    Next
    If Col > 6 Then
        Min = Col
        Max = Col
    Else
        Min = 7
        Max = 9
    End If
    For C = Min To Max
        Index = FindIndex(r, C)
        For I = 1 To 9
            If InStr(S3, arrSolve(Index, I)) = 0 Then S3 = S3 & arrSolve(Index, I)
        Next
    Next
    S1 = Replace(S1, "0", "")
    S2 = Replace(S2, "0", "")
    S3 = Replace(S3, "0", "")
    If S2 <> "" Then
        If Len(S3) <= 3 Then
            For I = 1 To Len(S3)
                S2 = Replace(S2, Mid(S3, I, 1), "")
            Next
        End If
    End If
    If S1 <> "" Then
        If Len(S2) <= 3 Then
            For I = 1 To Len(S2)
                S1 = Replace(S1, Mid(S2, I, 1), "")
            Next
        End If
        If Len(S3) <= 3 Then
            For I = 1 To Len(S3)
                S1 = Replace(S1, Mid(S3, I, 1), "")
            Next
        End If
    End If
End Sub

Private Sub AutoSolve()
    Dim Found As Boolean
    Do
        Found = False
        Resolve
        Found = Found Or HelpGearRow
        Resolve
        Found = Found Or HelpGearCol
        Resolve
        Found = Found Or HelpGearSquare
        Resolve
        Found = Found Or FindSingleSelection
    Loop While Found
End Sub

Private Sub Form_Load()
    CD.CancelError = True
    Me.Width = Me.Width - Me.ScaleWidth * 15 + (cSuDoKuWidth + Space * 2) * 9 * 15
    Me.Height = Me.Height - Me.ScaleHeight * 15 + (cSuDoKuHeight + Space * 2) * 9 * 15
    Me.Move (Screen.Width - Me.Width) \ 2, (Screen.Height - Me.Height) \ 2
    Show
    RM.Initialize Me, _
       mnuRecentFile, _
       App.Path & IIf(Right(App.Path, 1) <> "\", "\", "") & "Recent Files.txt", _
       SepRecent, _
       500, _
       9
    Randomize
    ArrangeSudoku
    ArrangeSolve
    Fill
    picSolveHolder.Left = Sudoku(81).Left + Sudoku(81).Width + Space * 3
    picSolveHolder.CurrentX = (picSolveHolder.ScaleWidth - picSolveHolder.TextWidth("Double-Click: Show available numbers for each block")) \ 2
    picSolveHolder.CurrentY = 3
    picSolveHolder.Print "Double-Click: Show available numbers for each block"
    Set clsMouseWheel = New CMouseWheel
    Set clsMouseWheel.Form = Me
    clsMouseWheel.SubClassHookForm
    OLEParam Command
End Sub

Private Sub clsMouseWheel_MouseWheel(direct As Integer, Cancel As Integer)
    If direct = 1 Then
        SetNumber SudInd, "+", True
    Else
        SetNumber SudInd, "-", True
    End If
End Sub

Private Sub Form_OLEDragDrop(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single)
    OLEParam Data.Files(1)
End Sub

Private Sub Form_Unload(Cancel As Integer)
    Set clsMouseWheel.Form = Nothing
    Set clsMouseWheel = Nothing
    Unload frmWait
End Sub

Private Sub mnuAbout_Click()
    MsgBox "Created by:" & vbNewLine & "  Hussein Shah Heydar" & vbNewLine & "  Mojtaba Malaekeh"
End Sub

Private Sub mnuNewGame_Click()
    Dim I As Byte
    If MsgBox("Manual entries will be lost." & vbNewLine & "Are you sure?", vbExclamation + vbYesNo) = vbNo Then Exit Sub
    For I = 1 To 81
        SetNumber I, 0, True
    Next
End Sub

Private Sub mnuSolve_Click()
    AutoSolve
    If CheckDiagram > 0 Then
        If MsgBox("             " & vbCrLf & vbCrLf & "            ", vbYesNo + vbQuestion) = vbYes Then LastTry
    Else
        MsgBox "Puzzle solved.", vbInformation
    End If
End Sub

Private Sub mnuClear_Click()
    Dim I
    For I = 1 To 81
        If Not arrSudoku(I).Lock Then SetNumber I, 0, True
    Next
End Sub

Private Sub mnuExit_Click()
    Unload Me
End Sub

Private Sub mnuGenerate_Click()
    Dim Row As Byte, Col As Byte, Index As Byte, r As Byte
    Dim S As String, S1 As String, S2 As String, S3 As String
    Dim I As Byte
    '{
    Dim C As Integer
    Wait False
    C = -1
    Do
    '}
    For I = 1 To 81
        SetNumber I, 0, True
    Next
    For Row = 1 To 9
        For Col = 1 To 9
            Index = FindIndex(Row, Col)
            If arrSudoku(Index).Value = 0 Then AutoSolve
            If arrSudoku(Index).Value = 0 Then
                qq Row, Col, S1, S2, S3
                If Col < 4 Then
                    S = S1
                ElseIf Col < 7 Then
                    S = S2
                Else
                    S = S3
                End If
                r = Int(Rnd * Len(S)) + 1
                SetNumber Index, Mid(S, r, 1), True
            End If
        Next
    Next
    '{
    C = C + 1
    Loop Until CheckDiagram = 0
    Unload frmWait
    If C > 0 Then
        MsgBox C & IIf(C = 1, " Retry!", " Retries!"), vbExclamation
    Else
        MsgBox "Ready.", vbInformation
    End If
    '}
End Sub

Private Sub LoadSDK(FileName)
    Dim Free, I
    Free = FreeFile
    Open FileName For Binary As Free
    Get Free, , arrSudoku
    Close Free
    For I = 1 To 81
        If arrSudoku(I).Value < 0 Or arrSudoku(I).Value > 9 Then arrSudoku(I).Value = 0
        SetNumber I, arrSudoku(I).Value, arrSudoku(I).Lock
    Next
End Sub

Private Sub mnuLoad_Click()
    On Error GoTo ErrLbl
    CD.InitDir = App.Path
    CD.Flags = CD.Flags And 0 Or &H1000 Or &H4
    CD.Filter = "SDK Files (*.sdk)|*.sdk"
    CD.ShowOpen
    LoadSDK CD.FileName
    RM.AddToList CD.FileName
ErrLbl:
End Sub

Private Sub mnuCheck_Click()
    Dim Errors As Integer
    Dim Mess As String, StrErr As String
    ResetSudBack
    Errors = CheckEntries
    Mess = "1- "
    If Errors = 0 Then
        Mess = Mess & "Entries matched."
    Else
        Mess = Mess & Errors & " error" & IIf(Errors = 1, "", "s") & " found in entries!"
    End If
    Errors = CheckLogicality
    Mess = Mess & vbCrLf & "2- "
    If Errors = 0 Then
        Mess = Mess & "No logical error found."
    Else
        Mess = Mess & Errors & " logical error" & IIf(Errors = 1, "", "s") & " found!"
    End If
    Errors = CheckDiagram(StrErr)
    Mess = Mess & vbCrLf & "3- "
    If Errors = 0 Then
        Mess = Mess & "Puzzle solved."
    Else
        Mess = Mess & "Correct this errors:" & vbCrLf & StrErr
    End If
    MsgBox Mess, vbInformation
End Sub

Private Sub mnuRecentFile_Click(Index As Integer)
    Dim Path As String
    Path = mnuRecentFile(Index).Tag
    If RM.FileExisits(Path) Then
        LoadSDK Path
        RM.AddToList Path
    ElseIf MsgBox(Path & " not found!" & vbNewLine & "Remove it?", vbYesNo + vbExclamation) = vbYes Then
        RM.RemoveFromList Path
    End If
End Sub

Private Sub mnuSave_Click()
    Dim Free
    On Error GoTo ErrLbl
    CD.InitDir = App.Path
    CD.Flags = CD.Flags And 0 Or &H2 Or &H4
    CD.DefaultExt = "sdk"
    CD.Filter = "SDK Files (*.sdk)|*.sdk"
    CD.ShowSave
    Free = FreeFile
    Open CD.FileName For Binary As Free
    Put Free, , arrSudoku
    Close Free
ErrLbl:
End Sub

Private Sub picSolveHolder_DblClick()
    Resolve
    PrintArrSolve
End Sub

Private Sub picSolveHolder_MouseUp(Button As Integer, Shift As Integer, X As Single, Y As Single)
    CanMove = False
End Sub

Private Sub picSolveHolder_OLEDragDrop(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single)
    OLEParam Data.Files(1)
End Sub

Private Sub Sudoku_DblClick(Index As Integer)
    Sudoku_MouseDown Index, LastButton, 0, 0, 0
End Sub

Private Sub Sudoku_GotFocus(Index As Integer)
    Shape1.Move Sudoku(Index).Left - 1, Sudoku(Index).Top - 1
    SudInd = Index
End Sub

Private Sub Sudoku_KeyDown(Index As Integer, KeyCode As Integer, Shift As Integer)
    Dim Row, Col
    FindRowCol Index, Row, Col
    Select Case KeyCode
        Case vbKey0, vbKey1, vbKey2, vbKey3, vbKey4, _
             vbKey5, vbKey6, vbKey7, vbKey8, vbKey9
             SetNumber Index, Val(Chr(KeyCode)), True
        Case vbKeyNumpad0, vbKeyNumpad1, vbKeyNumpad2, vbKeyNumpad3, vbKeyNumpad4, _
             vbKeyNumpad5, vbKeyNumpad6, vbKeyNumpad7, vbKeyNumpad8, vbKeyNumpad9
             SetNumber Index, Val(Chr(KeyCode - 48)), True
        Case vbKeyDelete, vbKeySpace
            SetNumber Index, 0, True
        Case vbKeyLeft
            If Col > 1 Then Sudoku(FindIndex(Row, Col - 1)).SetFocus
        Case vbKeyRight
            If Col < 9 Then Sudoku(FindIndex(Row, Col + 1)).SetFocus
        Case vbKeyUp
            If Row > 1 Then Sudoku(FindIndex(Row - 1, Col)).SetFocus
        Case vbKeyDown
            If Row < 9 Then Sudoku(FindIndex(Row + 1, Col)).SetFocus
        Case vbKeyHome
            Sudoku(FindIndex(Row, 1)).SetFocus
        Case vbKeyEnd
            Sudoku(FindIndex(Row, 9)).SetFocus
        Case vbKeyPageUp
            Sudoku(FindIndex(1, Col)).SetFocus
        Case vbKeyPageDown
            Sudoku(FindIndex(9, Col)).SetFocus
        Case vbKeyReturn, vbKeyAdd
            SetNumber Index, IIf(Shift = vbShiftMask, "-", "+"), True
        Case vbKeySubtract
            SetNumber Index, "-", True
    End Select
End Sub

Private Sub Sudoku_MouseDown(Index As Integer, Button As Integer, Shift As Integer, X As Single, Y As Single)
    If Button = vbLeftButton Then
        SetNumber Index, "+", True
    ElseIf Button = vbRightButton Then
        SetNumber Index, "-", True
    Else
        SetNumber Index, 0, True
    End If
    LastButton = Button
End Sub

Private Sub Resolve()
    Fill
    SetEmpty
    RowSolve
    ColSolve
    SquareSolve
End Sub

Private Sub picSolveHolder_MouseDown(Button As Integer, Shift As Integer, X As Single, Y As Single)
    CanMove = X >= 0 And X < picSolveHolder.ScaleWidth And Y >= 0 And Y < picSolveHolder.ScaleHeight
    XDown = X
    YDown = Y
End Sub

Private Sub picSolveHolder_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)
    If Button = 1 And CanMove Then picSolveHolder.Move picSolveHolder.Left - XDown + X, picSolveHolder.Top - YDown + Y
End Sub

Private Sub Sudoku_MouseMove(Index As Integer, Button As Integer, Shift As Integer, X As Single, Y As Single)
    If GetActiveWindow = Me.hWnd Then Sudoku(Index).SetFocus
End Sub

Private Sub Sudoku_OLEDragDrop(Index As Integer, Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single)
    OLEParam Data.Files(1)
End Sub
