VERSION 5.00
Begin VB.Form frmFormDesign 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "Form Design Demo"
   ClientHeight    =   3015
   ClientLeft      =   150
   ClientTop       =   435
   ClientWidth     =   6870
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   3015
   ScaleWidth      =   6870
   ShowInTaskbar   =   0   'False
   StartUpPosition =   2  'CenterScreen
   Begin VB.Data Data1 
      Caption         =   "Data1"
      Connect         =   "Access"
      DatabaseName    =   ""
      DefaultCursorType=   0  'DefaultCursor
      DefaultType     =   2  'UseODBC
      Exclusive       =   0   'False
      Height          =   345
      Left            =   240
      Options         =   0
      ReadOnly        =   0   'False
      RecordsetType   =   1  'Dynaset
      RecordSource    =   ""
      Top             =   960
      Width           =   4815
   End
   Begin VB.CommandButton Command1 
      Caption         =   "Command1"
      Height          =   300
      Left            =   5160
      TabIndex        =   8
      Top             =   960
      Width           =   1575
   End
   Begin VB.OptionButton Option1 
      BackColor       =   &H00C0FFC0&
      Caption         =   "Option1"
      Height          =   255
      Left            =   2160
      TabIndex        =   6
      Top             =   2640
      Width           =   855
   End
   Begin VB.CheckBox Check1 
      BackColor       =   &H00C0C0FF&
      Caption         =   "Check1"
      Height          =   255
      Left            =   2160
      TabIndex        =   5
      Top             =   2280
      Width           =   855
   End
   Begin VB.PictureBox Picture1 
      Height          =   615
      Left            =   1080
      Picture         =   "FormDsgn.frx":0000
      ScaleHeight     =   555
      ScaleWidth      =   795
      TabIndex        =   4
      Top             =   2280
      Width           =   855
   End
   Begin VB.ListBox List1 
      Height          =   645
      ItemData        =   "FormDsgn.frx":0442
      Left            =   3120
      List            =   "FormDsgn.frx":0449
      TabIndex        =   3
      Top             =   2280
      Width           =   855
   End
   Begin VB.TextBox Text1 
      Height          =   645
      Left            =   4080
      TabIndex        =   2
      Text            =   "Text1"
      Top             =   2280
      Width           =   855
   End
   Begin VB.PictureBox picHandle 
      Appearance      =   0  'Flat
      BackColor       =   &H80000008&
      BorderStyle     =   0  'None
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   178
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H80000008&
      Height          =   375
      Index           =   0
      Left            =   6480
      ScaleHeight     =   375
      ScaleWidth      =   375
      TabIndex        =   0
      Top             =   120
      Visible         =   0   'False
      Width           =   375
   End
   Begin VB.Frame Frame1 
      Caption         =   "Frame1"
      Height          =   735
      Left            =   240
      TabIndex        =   7
      Top             =   120
      Width           =   6495
   End
   Begin VB.Line Line1 
      X1              =   5040
      X2              =   5880
      Y1              =   2280
      Y2              =   2880
   End
   Begin VB.Image Image1 
      Height          =   615
      Left            =   5880
      Picture         =   "FormDsgn.frx":0454
      Stretch         =   -1  'True
      Top             =   2280
      Width           =   855
   End
   Begin VB.Shape Shape1 
      BackColor       =   &H00C0FFFF&
      BackStyle       =   1  'Opaque
      Height          =   255
      Left            =   120
      Top             =   2640
      Width           =   855
   End
   Begin VB.Label Label1 
      BackColor       =   &H00C0E0FF&
      Caption         =   "Label1"
      Height          =   255
      Left            =   120
      TabIndex        =   1
      Top             =   2280
      Width           =   855
   End
   Begin VB.Menu mnuMode 
      Caption         =   "&Mode"
      Begin VB.Menu mnuModeDesign 
         Caption         =   "&Design Mode"
      End
      Begin VB.Menu mnuModeSep10 
         Caption         =   "-"
      End
      Begin VB.Menu mnuModeExit 
         Caption         =   "E&xit"
      End
   End
End
Attribute VB_Name = "frmFormDesign"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Type POINTAPI
    X As Long
    Y As Long
End Type

Private Type RECT
    Left As Long
    Top As Long
    Right As Long
    Bottom As Long
End Type

Private Declare Function SetCapture Lib "user32" (ByVal hwnd As Long) As Long
Private Declare Function ClipCursor Lib "user32" (lpRect As Any) As Long
Private Declare Function ReleaseCapture Lib "user32" () As Long
Private Declare Function GetWindowRect Lib "user32" (ByVal hwnd As Long, lpRect As RECT) As Long
Private Declare Function GetCursorPos Lib "user32" (lpPoint As POINTAPI) As Long
Private Declare Function GetDC Lib "user32" (ByVal hwnd As Long) As Long
Private Declare Function ReleaseDC Lib "user32" (ByVal hwnd As Long, ByVal hdc As Long) As Long
Private Declare Function SelectObject Lib "gdi32" (ByVal hdc As Long, ByVal hObject As Long) As Long
Private Declare Function DeleteObject Lib "gdi32" (ByVal hObject As Long) As Long
Private Declare Function GetStockObject Lib "gdi32" (ByVal nIndex As Long) As Long
Private Declare Function CreatePen Lib "gdi32" (ByVal nPenStyle As Long, ByVal nWidth As Long, ByVal crColor As Long) As Long
Private Declare Function SetROP2 Lib "gdi32" (ByVal hdc As Long, ByVal nDrawMode As Long) As Long
Private Declare Function Rectangle Lib "gdi32" (ByVal hdc As Long, ByVal X1 As Long, ByVal Y1 As Long, ByVal X2 As Long, ByVal Y2 As Long) As Long

Private Const NULL_BRUSH = 5
Private Const PS_SOLID = 0
Private Const R2_NOT = 6

Enum ControlState
    StateNothing = 0
    StateDragging
    StateSizing
End Enum

Private m_CurrCtl As Control
Private m_DragState As ControlState
Private m_DragHandle As Integer
Private m_DragRect As New CRect
Private m_DragPoint As POINTAPI

Private m_bDesignMode As Boolean

Private Sub Check1_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)
    If Button = vbLeftButton And m_bDesignMode Then
        DragBegin Check1
    End If
End Sub

Private Sub Command1_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)
    If Button = vbLeftButton And m_bDesignMode Then
        DragBegin Command1
    End If
End Sub

Private Sub Data1_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)
    If Button = vbLeftButton And m_bDesignMode Then
        DragBegin Data1
    End If
End Sub
Private Sub Form_Load()
    DragInit
End Sub

Private Sub Frame1_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)
    If Button = vbLeftButton And m_bDesignMode Then
        DragBegin Frame1
    End If
End Sub

Private Sub mnuMode_Click()
    mnuModeDesign.Checked = m_bDesignMode
End Sub

Private Sub mnuModeDesign_Click()
    m_bDesignMode = Not m_bDesignMode
    If Not m_bDesignMode Then
        DragEnd
    End If
End Sub

Private Sub mnuModeExit_Click()
    Unload Me
End Sub

Private Sub Label1_MouseDown(Button As Integer, Shift As Integer, X As Single, Y As Single)
    If Button = vbLeftButton And m_bDesignMode Then
        DragBegin Label1
    End If
End Sub


Private Sub Option1_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)
    If Button = vbLeftButton And m_bDesignMode Then
        DragBegin Option1
    End If
End Sub

Private Sub Text1_MouseDown(Button As Integer, Shift As Integer, X As Single, Y As Single)
    If Button = vbLeftButton And m_bDesignMode Then
        DragBegin Text1
    End If
End Sub

Private Sub List1_MouseDown(Button As Integer, Shift As Integer, X As Single, Y As Single)
    If Button = vbLeftButton And m_bDesignMode Then
        DragBegin List1
    End If
End Sub

Private Sub Image1_MouseDown(Button As Integer, Shift As Integer, X As Single, Y As Single)
    If Button = vbLeftButton And m_bDesignMode Then
        DragBegin Image1
    End If
End Sub

Private Sub Picture1_MouseDown(Button As Integer, Shift As Integer, X As Single, Y As Single)
    If Button = vbLeftButton And m_bDesignMode Then
        DragBegin Picture1
    End If
End Sub
Private Sub DragInit()
    Dim i As Integer, xHandle As Single, yHandle As Single
    xHandle = 5 * Screen.TwipsPerPixelX
    yHandle = 5 * Screen.TwipsPerPixelY
    For i = 0 To 7
        If i <> 0 Then
            Load picHandle(i)
        End If
        picHandle(i).Width = xHandle
        picHandle(i).Height = yHandle
        picHandle(i).ZOrder
    Next i
    picHandle(0).MousePointer = vbSizeNWSE
    picHandle(1).MousePointer = vbSizeNS
    picHandle(2).MousePointer = vbSizeNESW
    picHandle(3).MousePointer = vbSizeWE
    picHandle(4).MousePointer = vbSizeNWSE
    picHandle(5).MousePointer = vbSizeNS
    picHandle(6).MousePointer = vbSizeNESW
    picHandle(7).MousePointer = vbSizeWE
    Set m_CurrCtl = Nothing
End Sub

Private Sub DragBegin(ctl As Control)
    Dim rc As RECT

    ShowHandles False
    Set m_CurrCtl = ctl
    GetCursorPos m_DragPoint
    m_DragRect.SetRectToCtrl m_CurrCtl
    m_DragRect.TwipsToScreen m_CurrCtl
    m_DragPoint.X = m_DragPoint.X - m_DragRect.Left
    m_DragPoint.Y = m_DragPoint.Y - m_DragRect.Top
    Refresh
    DrawDragRect
    m_DragState = StateDragging
    ReleaseCapture
    SetCapture hwnd
    GetWindowRect hwnd, rc
    ClipCursor rc
End Sub

Private Sub DragEnd()
    Set m_CurrCtl = Nothing
    ShowHandles False
    m_DragState = StateNothing
End Sub
Private Sub Form_MouseDown(Button As Integer, Shift As Integer, X As Single, Y As Single)
    Dim i As Integer

    If Button = vbLeftButton And m_bDesignMode Then
        For i = 0 To (Controls.Count - 1)
            If Not TypeOf Controls(i) Is Menu And Controls(i).Visible Then
                m_DragRect.SetRectToCtrl Controls(i)
                If m_DragRect.PtInRect(X, Y) Then
                    DragBegin Controls(i)
                    Exit Sub
                End If
            End If
        Next i
        Set m_CurrCtl = Nothing
        ShowHandles False
    End If
End Sub

Private Sub Form_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)
    Dim nWidth As Single, nHeight As Single
    Dim pt As POINTAPI

    If m_DragState = StateDragging Then
        nWidth = m_DragRect.Right - m_DragRect.Left
        nHeight = m_DragRect.Bottom - m_DragRect.Top
        GetCursorPos pt
        DrawDragRect
        m_DragRect.Left = pt.X - m_DragPoint.X
        m_DragRect.Top = pt.Y - m_DragPoint.Y
        m_DragRect.Right = m_DragRect.Left + nWidth
        m_DragRect.Bottom = m_DragRect.Top + nHeight
        DrawDragRect
    ElseIf m_DragState = StateSizing Then
        GetCursorPos pt
        DrawDragRect
        Select Case m_DragHandle
            Case 0
                m_DragRect.Left = pt.X
                m_DragRect.Top = pt.Y
            Case 1
                m_DragRect.Top = pt.Y
            Case 2
                m_DragRect.Right = pt.X
                m_DragRect.Top = pt.Y
            Case 3
                m_DragRect.Right = pt.X
            Case 4
                m_DragRect.Right = pt.X
                m_DragRect.Bottom = pt.Y
            Case 5
                m_DragRect.Bottom = pt.Y
            Case 6
                m_DragRect.Left = pt.X
                m_DragRect.Bottom = pt.Y
            Case 7
                m_DragRect.Left = pt.X
        End Select
        DrawDragRect
    End If
End Sub

Private Sub Form_MouseUp(Button As Integer, Shift As Integer, X As Single, Y As Single)
    If Button = vbLeftButton Then
        If m_DragState = StateDragging Or m_DragState = StateSizing Then
            DrawDragRect
            m_DragRect.ScreenToTwips m_CurrCtl
            m_DragRect.SetCtrlToRect m_CurrCtl
            ShowHandles True
            ClipCursor ByVal 0&
            ReleaseCapture
            m_DragState = StateNothing
        End If
    End If
End Sub
Private Sub picHandle_MouseDown(Index As Integer, Button As Integer, Shift As Integer, X As Single, Y As Single)
    Dim i As Integer
    Dim rc As RECT

    Debug.Assert (Not m_CurrCtl Is Nothing)
    m_DragRect.SetRectToCtrl m_CurrCtl
    m_DragRect.TwipsToScreen m_CurrCtl
    m_DragHandle = Index
    ShowHandles False
    Refresh
    m_DragState = StateSizing
    DrawDragRect
    SetCapture hwnd
    GetWindowRect hwnd, rc
    ClipCursor rc
End Sub
Private Sub ShowHandles(Optional bShowHandles As Boolean = True)
    Dim i As Integer
    Dim xFudge As Long, yFudge As Long
    Dim nWidth As Long, nHeight As Long

    If bShowHandles And Not m_CurrCtl Is Nothing Then
        With m_DragRect
            nWidth = (picHandle(0).Width \ 2)
            nHeight = (picHandle(0).Height \ 2)
            xFudge = (0.5 * Screen.TwipsPerPixelX)
            yFudge = (0.5 * Screen.TwipsPerPixelY)
            picHandle(0).Move (.Left - nWidth) + xFudge, (.Top - nHeight) + yFudge
            picHandle(4).Move (.Left + .Width) - nWidth - xFudge, .Top + .Height - nHeight - yFudge
            picHandle(1).Move .Left + (.Width / 2) - nWidth, .Top - nHeight + yFudge
            picHandle(5).Move .Left + (.Width / 2) - nWidth, .Top + .Height - nHeight - yFudge
            picHandle(2).Move .Left + .Width - nWidth - xFudge, .Top - nHeight + yFudge
            picHandle(6).Move .Left - nWidth + xFudge, .Top + .Height - nHeight - yFudge
            picHandle(3).Move .Left + .Width - nWidth - xFudge, .Top + (.Height / 2) - nHeight
            picHandle(7).Move .Left - nWidth + xFudge, .Top + (.Height / 2) - nHeight
        End With
    End If
    For i = 0 To 7
        picHandle(i).Visible = bShowHandles
    Next i
End Sub

Private Sub DrawDragRect()
    Dim hPen As Long, hOldPen As Long
    Dim hBrush As Long, hOldBrush As Long
    Dim hScreenDC As Long, nDrawMode As Long

    hScreenDC = GetDC(0)
    hPen = CreatePen(PS_SOLID, 2, 0)
    hOldPen = SelectObject(hScreenDC, hPen)
    hBrush = GetStockObject(NULL_BRUSH)
    hOldBrush = SelectObject(hScreenDC, hBrush)
    nDrawMode = SetROP2(hScreenDC, R2_NOT)
    Rectangle hScreenDC, m_DragRect.Left, m_DragRect.Top, _
        m_DragRect.Right, m_DragRect.Bottom
    SetROP2 hScreenDC, nDrawMode
    SelectObject hScreenDC, hOldBrush
    SelectObject hScreenDC, hOldPen
    ReleaseDC 0, hScreenDC
    DeleteObject hPen
End Sub
