//===============================================================
// www.ps-ware.net
// email: info@ps-ware.net
// by Pswin
// author email: pswin@ps-ware.net
//===============================================================


#include "stdafx.h"
#include "ChangeExeIcon.h"
#include "ChangeExeIconDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif



typedef struct tagFileGroupItem 
{ BYTE bWidth; 
  BYTE bHeight; 
  BYTE bColorCount; 
  BYTE bReserved; 
  WORD wPlanes;
  WORD wBitCount; 
  DWORD dwSize; // item size in bytes 
  DWORD dwOffset; // start of item in the file 
} ; 
typedef struct tagFileGroupHeader 
{ WORD wReserved; 
  WORD wType; // 1 for icons, 2 for cursors   
  WORD wCount; 
} ; 

typedef struct tagGroupItem 
{ BYTE bWidth; 
  BYTE bHeight; 
  BYTE bColorCount; 
  BYTE bReserved; 
  WORD wPlanes; 
  WORD wBitCount; 
  DWORD dwBytesInRes; 
  WORD wNameOrdinal; 
} ; 

typedef struct tagGroupHeader 
{ WORD wReserved; 
  WORD wType; // 1 for icons, 2 for cursors  
  WORD wCount; 
} ; 

ChangeMainIcon(LPCTSTR , LPCTSTR);

/////////////////////////////////////////////////////////////////////////////
// CChangeExeIconDlg dialog

CChangeExeIconDlg::CChangeExeIconDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CChangeExeIconDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CChangeExeIconDlg)
	m_ExeFilePath = _T("");
	m_IconFilePath = _T("");
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CChangeExeIconDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CChangeExeIconDlg)
	DDX_Text(pDX, IDC_Edt_ExeFile, m_ExeFilePath);
	DDX_Text(pDX, IDC_Edt_IconFile, m_IconFilePath);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CChangeExeIconDlg, CDialog)
	//{{AFX_MSG_MAP(CChangeExeIconDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_Btn_ChangeICO, OnBtnChangeICO)
	ON_BN_CLICKED(IDC_Btn_FileOpenDlg, OnBtnFileOpenDlg)
	ON_BN_CLICKED(IDC_Btn_FileOpenDlg2, OnBtnFileOpenDlg2)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CChangeExeIconDlg message handlers

BOOL CChangeExeIconDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CChangeExeIconDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CChangeExeIconDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CChangeExeIconDlg::OnBtnChangeICO() 
{
	LPCTSTR s1,s2;

	UpdateData(true);
	s1 =  (LPSTR)HeapAlloc(GetProcessHeap(),HEAP_ZERO_MEMORY,256);
	s2 = (LPSTR)HeapAlloc(GetProcessHeap(),HEAP_ZERO_MEMORY,256);
	s1 = m_IconFilePath;
	s2 = m_ExeFilePath;
	UpdateData(false);
	if( ChangeMainIcon(s1,s2) == 1 )
		MessageBox("Changing Icon finished successfully","Change Icon");
	else
		MessageBox("Changing Icon dont finished successfully","Change Icon",MB_ICONERROR | MB_OK);
	
}



int ChangeMainIcon(LPCTSTR szIconFile,LPCTSTR szResourceFile){
	struct tagFileGroupHeader header;
	struct tagFileGroupItem *Item ;
	struct tagGroupItem *GItem;
	struct tagGroupHeader GHeader;

	HANDLE hFile,hTempFile,hRFile = BeginUpdateResource(szResourceFile, FALSE);
    DWORD dwBytesRead;
	char *buffer,*buffer2;
	
	hFile = CreateFile( szIconFile, GENERIC_READ,  0, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
	
if (INVALID_HANDLE_VALUE != hFile)
{
        if (ReadFile(hFile, &header, 6, &dwBytesRead, NULL) == FALSE)   return 0 ;
		GHeader.wCount = header.wCount;
		GHeader.wReserved = header.wReserved;
		GHeader.wType = header.wType;
		Item = new tagFileGroupItem[header.wCount];
		GItem = new tagGroupItem[header.wCount];


		for(int i = 1;i <= header.wCount ; i++ ){
			if (ReadFile(hFile, &Item[i - 1], sizeof(Item[0]), &dwBytesRead, NULL) == FALSE)   return 0 ;
			GItem[i - 1 ].bColorCount = Item[i-1].bColorCount;
			GItem[i - 1 ].bHeight  = Item[i-1].bHeight;
			GItem[i - 1 ].bReserved  = Item[i-1].bReserved ;
			GItem[i - 1 ].bWidth = Item[i-1].bWidth ;
			GItem[i - 1 ].wNameOrdinal = (WORD)(i);
			GItem[i - 1 ].dwBytesInRes = Item[i-1].dwSize;
			GItem[i - 1 ].wBitCount = Item[i-1].wBitCount;
			GItem[i - 1 ].wPlanes = Item[i-1].wPlanes;
			
		}
	
	for(int j = 1;j <= header.wCount ; j++ ){
		buffer = (char *)malloc(Item[j-1].dwSize);
		SetFilePointer(hFile,Item[j-1].dwOffset,NULL,FILE_BEGIN);
		if (ReadFile(hFile, buffer, Item[j-1].dwSize, &dwBytesRead, NULL) == FALSE)   return 0 ;
		UpdateResource(hRFile,RT_ICON,MAKEINTRESOURCE(j),
			MAKELANGID(LANG_ENGLISH,SUBLANG_DEFAULT),
			buffer,Item[j - 1].dwSize);
		delete buffer;
	}
	
	
	hTempFile = CreateFile( "C:\\$$$Temp$$$.$$$", GENERIC_READ | GENERIC_WRITE ,  0, NULL, OPEN_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);
	if (INVALID_HANDLE_VALUE != hFile)	{
		WriteFile(hTempFile,&header,sizeof(header),&dwBytesRead,NULL);
		for(int m = 0 ; m < header.wCount ; m ++){
			WriteFile(hTempFile,&GItem[m],14,&dwBytesRead,NULL);
		}
		
		buffer = (char *)malloc((int)(14 * header.wCount) + 6);
		SetFilePointer(hTempFile,0,NULL,FILE_BEGIN);
		if (ReadFile(hTempFile, buffer, (14 * header.wCount) + 6, &dwBytesRead, NULL) == FALSE){   
			CloseHandle(hTempFile);
			return 0 ;
		}
		CloseHandle(hTempFile);
		DeleteFile("C:\\$$$Temp$$$.$$$");
		
	}


   UpdateResource(hRFile, RT_GROUP_ICON,"MAINICON",MAKELANGID(LANG_ENGLISH, SUBLANG_DEFAULT), 
   buffer,dwBytesRead);
   
	
	::EndUpdateResource(hRFile, FALSE); 
	CloseHandle(hFile);
	delete Item;
	delete buffer;
	return 1  ;
}
}

void CChangeExeIconDlg::OnBtnFileOpenDlg() 
{
	
	TCHAR szFilters[]= "PE files (*.exe)|*.exe|All files (*.*)|*.*|" ;

	CFileDialog FDlg(true,_T("PE files"), "",OFN_FILEMUSTEXIST, szFilters );
	if(FDlg.DoModal() == IDOK){
		UpdateData(true);
		m_ExeFilePath.Format ("%s",FDlg.GetPathName());
		UpdateData(false);
	}
}


void CChangeExeIconDlg::OnBtnFileOpenDlg2() 
{

		TCHAR szFilters[]= "Icon files (*.ico)|*.ico|All files (*.*)|*.*|" ;

	CFileDialog FDlg(true,_T("Icon files"), "",OFN_FILEMUSTEXIST, szFilters );
	if(FDlg.DoModal() == IDOK){
		UpdateData(true);
		m_IconFilePath.Format ("%s",FDlg.GetPathName());
		UpdateData(false);
	}
}
