'==============================================================================
'
'  SMTP.BAS 2.2 email (SMTP) example for PowerBASIC for Windows
'  Copyright (c) 1999-2008 PowerBASIC, Inc.
'  All Rights Reserved.
'
'  Send plain email through an SMTP server, which must be configured below.
'
'==============================================================================

#COMPILER PBWIN 9
#COMPILE EXE

%USEMACROS = 1
#INCLUDE "Win32API.inc"


'------------------------------------------------------------------------------
' Settings and control ID equates
'
$mailhost    = "mail.yourserver.com" ' and often it is "smtp.yourserver.com"
$mailfrom    = "Your Name <address@yourserver.com>"

%IDC_SERVER  = 101
%IDC_FROM    = 102
%IDC_TO      = 103
%IDC_SUBJECT = 104
%IDC_MESSAGE = 105


'------------------------------------------------------------------------------
' StatusOk200
' Returns %TRUE if the error message is of the 200 class.
'
FUNCTION StatusOk200 (BYVAL sBuffer AS STRING) AS LONG

    LOCAL iVal AS LONG

    iVal = VAL(LEFT$(sBuffer, 3))

    IF iVal >= 200 AND iVal <= 299 THEN
        FUNCTION = %TRUE
    END IF

END FUNCTION


'------------------------------------------------------------------------------
' StatusOk300
' Returns %TRUE if the error message is of the 200 or 300 class.
'
FUNCTION StatusOk300 (BYVAL sBuffer AS STRING) AS LONG

    LOCAL iVal AS LONG

    iVal = VAL(LEFT$(sBuffer, 3))

    IF iVal >= 200 AND iVal <= 399 THEN
        FUNCTION = %TRUE
    END IF

END FUNCTION


'-----------------------------------------------------------------------------
' Retrieve the current time and date in E-mail header format
'
FUNCTION MailDate () AS STRING

    LOCAL szFormat   AS ASCIIZ * 40
    LOCAL szTemp     AS ASCIIZ * 40
    LOCAL sResult    AS STRING
    LOCAL t          AS SYSTEMTIME
    LOCAL sUCTOffset AS STRING
    LOCAL tzi        AS TIME_ZONE_INFORMATION

    GetLocalTime t

    szFormat = "ddd',' dd MMM yyyy"
    GetDateFormat %LOCALE_USER_DEFAULT, 0, t, szFormat, szTemp, SIZEOF(szTemp)
    sResult = szTemp

    szFormat = "HH':'mm':'ss"
    GetTimeFormat %LOCALE_USER_DEFAULT, 0, t, szFormat, szTemp, SIZEOF(szTemp)

    SELECT CASE GetTimeZoneInformation(tzi)
    CASE %TIME_ZONE_ID_DAYLIGHT
        sUCTOffset = IIF$((tzi.bias + tzi.DaylightBias) <= 0, "+", "-") _
                   + FORMAT$((tzi.bias + tzi.DaylightBias) \ 60, "00") _
                   + FORMAT$((tzi.bias + tzi.DaylightBias) MOD 60, "00")
    CASE %TIME_ZONE_ID_STANDARD
        sUCTOffset = IIF$((tzi.bias + tzi.StandardBias) <= 0, "+", "-") _
                   + FORMAT$((tzi.bias + tzi.StandardBias) \ 60, "00") _
                   + FORMAT$((tzi.bias + tzi.StandardBias) MOD 60, "00")
    CASE ELSE
        sUCTOffset = "-0000"
    END SELECT

    FUNCTION = sResult + " " + szTemp + " " + sUCTOffset

END FUNCTION



'------------------------------------------------------------------------------
' SendMail
' Sends email to a specified address, through a specified SMTP server
'
FUNCTION SendMail (BYVAL hDlg AS DWORD) AS LONG

    LOCAL Msg       AS STRING
    LOCAL Buffer    AS STRING
    LOCAL localhost AS STRING
    LOCAL hTcp      AS LONG
    LOCAL position  AS LONG
    LOCAL length    AS LONG

    MOUSEPTR 11

    ' Get the local host name
    HOST ADDR TO hTcp
    HOST NAME hTcp TO localhost

    ' Connect to mail server
    DIALOG DOEVENTS
    hTcp = FREEFILE
    CONTROL GET TEXT hDlg, %IDC_SERVER TO Buffer
    TCP OPEN "smtp" AT Buffer AS hTcp
    IF ERR THEN
        Buffer = "Error connecting to mailhost"
        GOTO SendError
    ELSE
        DO
            TCP LINE hTcp, Buffer
            IF StatusOk200(Buffer) = %FALSE THEN
                GOTO SendError
            END IF
            IF MID$(Buffer, 4, 1) <> "-" THEN EXIT DO
            buffer = ""
        LOOP

    END IF

    ' Greet the mailhost
    DIALOG DOEVENTS
    TCP PRINT hTcp, "HELO " + localhost
    TCP LINE hTcp, Buffer

    IF StatusOk200(Buffer) = %FALSE THEN
        Buffer = "HELO error: " + Buffer
        GOTO SendError
    END IF

    ' Tell the mailhost who we are
    DIALOG DOEVENTS
    CONTROL GET TEXT hDlg, %IDC_FROM TO Buffer
    REGEXPR "([a-z0-9._/+-]+)(@[a-z0-9.-]+)" IN Buffer TO position, length
    IF length = 0 THEN
        Buffer = "Invalid FROM email address"
        GOTO SendError
    ELSE
        Buffer = MID$(Buffer, position, length)
    END IF

    DIALOG DOEVENTS
    TCP PRINT hTcp, "MAIL FROM: <" + Buffer + ">"
    TCP LINE hTcp, Buffer
    IF StatusOk200(Buffer) = %FALSE THEN
        Buffer = "MAIL FROM error: " + Buffer
        GOTO SendError
    END IF

    ' Tell the mailhost who the message is for
    DIALOG DOEVENTS
    CONTROL GET TEXT hDlg, %IDC_TO TO Buffer
    REGEXPR "([a-z0-9._/+-]+)(@[a-z0-9.-]+)" IN Buffer TO position, length
    IF length = 0 THEN
        Buffer = "Invalid TO email address"
        GOTO SendError
    END IF

    Buffer = MID$(Buffer, position, length)

    DIALOG DOEVENTS
    TCP PRINT hTcp, "RCPT TO: <" + Buffer + ">"
    TCP LINE hTcp, Buffer
    IF StatusOk200(Buffer) = %FALSE THEN
        Buffer = "RCPT TO error: " + Buffer
        GOTO SendError
    END IF

    ' Send the message
    DIALOG DOEVENTS
    TCP PRINT hTcp, "DATA"
    TCP LINE hTcp, Buffer
    IF StatusOk300(Buffer) = %FALSE THEN
        Buffer = "DATA error: " + Buffer
        GOTO SendError
    END IF

    TCP PRINT hTCP, "Date: " + MailDate()

    CONTROL GET TEXT hDlg, %IDC_FROM TO Buffer
    TCP PRINT hTcp, "From: " + Buffer

    CONTROL GET TEXT hDlg, %IDC_TO TO Buffer
    TCP PRINT hTcp, "To: " + Buffer

    CONTROL GET TEXT hDlg, %IDC_SUBJECT TO Buffer
    IF LEN(Buffer) THEN
        TCP PRINT hTcp, "Subject: " + Buffer
    END IF



    ' End of header
    TCP PRINT hTcp, "X-Mailer: PowerBASIC SMTP example 2.2"
    TCP PRINT hTcp, ""

    CONTROL GET TEXT hDlg, %IDC_MESSAGE TO Msg
    REPLACE $CRLF WITH $CR IN Msg
    WHILE LEN(Msg)
        Buffer = EXTRACT$(Msg, $CR)
        ' Make sure there are no lines containing a single period
        IF ASC(Buffer) = 46 THEN
            Buffer = "." + Buffer
        END IF
        TCP PRINT hTcp, Buffer
        Msg = MID$(Msg, LEN(Buffer) + 2)
    WEND

    ' Signal the end of the message
    TCP PRINT hTcp, "."
    TCP LINE hTcp, Buffer
    IF StatusOk200(Buffer) = %FALSE THEN
        GOTO SendError
    END IF

    ' Say goodbye
    TCP PRINT hTcp, "QUIT"
    TCP LINE hTcp, Buffer
    IF StatusOk200(Buffer) = %FALSE THEN
        Buffer = "QUIT error: " + Buffer
        GOTO SendError
    END IF

    TCP CLOSE hTcp

    FUNCTION = -1

Done:
    MOUSEPTR 1
    SetFocus hDlg
    EXIT FUNCTION

SendError:
    TCP CLOSE hTcp
    MSGBOX Buffer,, "SMTP Error"
    GOTO Done

END FUNCTION


'------------------------------------------------------------------------------
' Callback function to process events for the main dialog
'
CALLBACK FUNCTION DlgProc () AS LONG

    STATIC hBmp    AS LONG
    STATIC x       AS LONG
    STATIC y       AS LONG

    LOCAL  hBmpDC  AS LONG
    LOCAL  bmpfile AS ASCIIZ * %MAX_PATH

    SELECT CASE CB.MSG

    CASE %WM_INITDIALOG
        CONTROL SET TEXT  CB.HNDL, %IDC_SERVER, $mailhost
        CONTROL SET TEXT  CB.HNDL, %IDC_FROM,   $mailfrom
        CONTROL SET FOCUS CB.HNDL, %IDC_TO

        DIALOG GET CLIENT CB.HNDL TO x, y
        DIALOG UNITS CB.HNDL, x, y TO PIXELS x, y

        ' Load the bitmap from a file
        GetModuleFilename %NULL, bmpfile, SIZEOF(bmpfile)
        bmpfile = UCASE$(bmpfile)
        REPLACE ".EXE" WITH ".BMP" IN bmpfile
        hBmp = LoadImage(BYVAL %NULL, bmpfile, %IMAGE_BITMAP, x, y, %LR_LOADFROMFILE)

        FUNCTION = 1

    CASE %WM_ERASEBKGND
        ' Select the bitmap into a memory DC and transfer it to the dialog
        hBmpDC = CreateCompatibleDC(CB.WPARAM)
        SelectObject hBmpDC, hBmp
        BitBlt CB.WPARAM, 0, 0, x, y, hBmpDC, 0, 0, %SRCCOPY
        DeleteDC hBmpDC

        FUNCTION = 1

    CASE %WM_DESTROY
        ' The dialog is being destroyed, so release the bitmap handle
        DeleteObject hBmp

    END SELECT

END FUNCTION


'------------------------------------------------------------------------------
' Callback function to process events for the Cancel Button
'
CALLBACK FUNCTION CancelButton () AS LONG

    IF CB.CTLMSG = %BN_CLICKED THEN DIALOG END CB.HNDL, 0

END FUNCTION


'------------------------------------------------------------------------------
' Callback function to process events for the Ok Button
'
CALLBACK FUNCTION OkButton () AS LONG

    IF CB.CTLMSG <> %BN_CLICKED THEN EXIT FUNCTION

    IF GetWindowTextLength(GetDlgItem(CB.HNDL, %IDC_SERVER)) = 0 OR _
       GetWindowTextLength(GetDlgItem(CB.HNDL, %IDC_FROM))   = 0 OR _
       GetWindowTextLength(GetDlgItem(CB.HNDL, %IDC_TO))     = 0 THEN
        BEEP
        MSGBOX "One or more of the required fields is empty.",,"Data Error!"
        CONTROL SET FOCUS CB.HNDL, %IDC_MESSAGE

    ELSEIF SendMail(CB.HNDL) THEN
        MSGBOX "Your email message was successfully sent.",,"Success!"
        DIALOG END CB.HNDL, 1
        FUNCTION = 1

    END IF

END FUNCTION


'------------------------------------------------------------------------------
' Callback function to process all child controls as they are enumerated
'
FUNCTION EnumColorsProc (BYVAL hCtrl AS DWORD, BYVAL lParam AS DWORD) AS LONG

    LOCAL szTxt AS ASCIIZ * 128

    GetClassName hCtrl, szTxt, SIZEOF(szTxt)

    SELECT CASE UCASE$(szTxt)
    CASE "STATIC"
        CONTROL SET COLOR lParam, GetDlgCtrlID(hCtrl), %YELLOW, -2&
    CASE "EDIT"
        CONTROL SET COLOR lParam, GetDlgCtrlID(hCtrl), %BLUE, %WHITE
    END SELECT

    FUNCTION = 1

END FUNCTION


'------------------------------------------------------------------------------
' Main application entry point...
'
FUNCTION PBMAIN () AS LONG

    LOCAL hDlg AS DWORD

    DIALOG FONT "Arial", 10
    DIALOG NEW 0, "Simple Mail Transfer Protocol (SMTP)", ,, 365, 250, 0, 0 TO hDlg

    CONTROL ADD LABEL, hDlg, 11,     "Ser&ver:", 17, 11, 40, 8, %SS_RIGHT, %WS_EX_TRANSPARENT
    CONTROL ADD TEXTBOX, hDlg, %IDC_SERVER,  "", 60,  9, 299,  12, %ES_AUTOHSCROLL OR %WS_TABSTOP, %WS_EX_CLIENTEDGE

    CONTROL ADD LABEL, hDlg, 12,       "&From:", 17, 24, 40, 8, %SS_RIGHT, %WS_EX_TRANSPARENT
    CONTROL ADD TEXTBOX, hDlg, %IDC_FROM,    "", 60, 22, 299,  12, %ES_AUTOHSCROLL OR %WS_TABSTOP, %WS_EX_CLIENTEDGE

    CONTROL ADD LABEL, hDlg, 13,         "&To:", 17, 36, 40, 8, %SS_RIGHT, %WS_EX_TRANSPARENT
    CONTROL ADD TEXTBOX, hDlg, %IDC_TO,      "", 60, 35, 299,  12, %ES_AUTOHSCROLL OR %WS_TABSTOP, %WS_EX_CLIENTEDGE

    CONTROL ADD LABEL, hDlg, 14,    "Su&bject:", 17, 50, 40, 8, %SS_RIGHT, %WS_EX_TRANSPARENT
    CONTROL ADD TEXTBOX, hDlg, %IDC_SUBJECT, "", 60, 48, 299,  12, %ES_AUTOHSCROLL OR %WS_TABSTOP, %WS_EX_CLIENTEDGE

    CONTROL ADD TEXTBOX, hDlg, %IDC_MESSAGE, "",  6, 66, 353, 161, %ES_AUTOHSCROLL OR %ES_AUTOVSCROLL OR %ES_MULTILINE OR %ES_WANTRETURN OR %WS_TABSTOP, %WS_EX_CLIENTEDGE

    CONTROL ADD BUTTON, hDlg, %IDOK,     "&Send",   275, 232, 40, 14, %BS_DEFPUSHBUTTON OR %WS_TABSTOP CALL OkButton
    CONTROL ADD BUTTON, hDlg, %IDCANCEL, "&Cancel", 319, 232, 40, 14, 0 CALL CancelButton

    ' Use an Enum callback to set the color for all control based on their classname
    ' The alternative is to use a CONTROL SET COLOR statement for every control
    EnumChildWindows hDlg, CODEPTR(EnumColorsProc), hDlg

    DIALOG SHOW MODAL hDlg CALL DlgProc

END FUNCTION
