'******************************************************************************
'
'                               BreakThru  1.0
'
'                               Tested on XP/ME
'                            Compiler - PB/Win 8.01
'
'                           by RValois, June 2005.
'                          email: pb@rvalois.com.br
'
'
'       This software is distributed in the hope that it will be useful,
'       but WITHOUT ANY WARRANTY; without even the implied warranty of
'       MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
'
'
'                           USE AT YOUR OWN RISK
'
'******************************************************************************
'
#COMPILE EXE
#DIM ALL

%WINAPI                                         = 1
%TRUE                                           = 1
%FALSE                                          = 0
%WM_USER                                        = &H400
%BLACK                                          = &H000000???
%BLUE                                           = &HFF0000???
%GREEN                                          = &H00FF00???
%CYAN                                           = &HFFFF00???
%MAGENTA                                        = &HFF00FF???
%YELLOW                                         = &H00FFFF???
%WHITE                                          = &HFFFFFF???
%VK_LEFT                                        = &H25
%VK_RIGHT                                       = &H27
%WM_CLOSE                                       = &H10
%WM_INITDIALOG                                  = &H110
%WS_CAPTION                                     = &H00C00000  ' WS_BORDER OR WS_DLGFRAME
%WS_SYSMENU                                     = &H00080000
%PM_REMOVE                                      = &H0001
%HWND_DESKTOP                                   = 0
%MB_OK                                          = &H00000000&
%SND_ASYNC                                      = &H1         ' play asynchronously
%TIME_PERIODIC                                  = 1  ' program for continuous periodic event


%MAX_PATH  = 260

TYPE RECT
  nLeft AS LONG
  nTop AS LONG
  nRight AS LONG
  nBottom AS LONG
END TYPE

TYPE POINTAPI
  x AS LONG
  y AS LONG
END TYPE

TYPE tagMSG
  hwnd AS DWORD
  message AS DWORD
  wParam AS LONG
  lParam AS LONG
  time AS DWORD
  pt AS POINTAPI
END TYPE

TYPE BITMAP
  bmType AS LONG
  bmWidth AS LONG
  bmHeight AS LONG
  bmWidthBytes AS LONG
  bmPlanes AS WORD
  bmBitsPixel AS WORD
  bmBits AS BYTE PTR
END TYPE

DECLARE FUNCTION GetAsyncKeyState LIB "USER32.DLL" ALIAS "GetAsyncKeyState" (BYVAL vKey AS LONG) AS INTEGER
DECLARE FUNCTION IntersectRect LIB "USER32.DLL" ALIAS "IntersectRect" (lpDestRect AS RECT, lpSrc1Rect AS RECT, lpSrc2Rect AS RECT) AS LONG
DECLARE FUNCTION PeekMessage LIB "USER32.DLL" ALIAS "PeekMessageA" (lpMsg AS tagMSG, BYVAL hWnd AS DWORD, BYVAL dwMsgFilterMin AS DWORD, BYVAL dwMsgFilterMax AS DWORD, BYVAL dwRemoveMsg AS DWORD) AS LONG
DECLARE FUNCTION PlaySound LIB "WINMM.DLL" ALIAS "PlaySoundA" (lpszName AS ASCIIZ, BYVAL hModule AS DWORD, BYVAL dwFlags AS DWORD) AS LONG
DECLARE FUNCTION PostMessage LIB "USER32.DLL" ALIAS "PostMessageA" (BYVAL hWnd AS DWORD, BYVAL dwMsg AS DWORD, BYVAL wParam AS DWORD, BYVAL lParam AS LONG) AS LONG
DECLARE FUNCTION timeKillEvent LIB "WINMM.DLL" ALIAS "timeKillEvent" (BYVAL uId AS DWORD) AS DWORD
DECLARE FUNCTION timeSetEvent LIB "WINMM.DLL" ALIAS "timeSetEvent" (BYVAL uDelay AS DWORD, BYVAL uResolution AS DWORD, BYVAL lpFunction AS DWORD, BYVAL dwUser AS DWORD, BYVAL uFlags AS DWORD) AS DWORD
DECLARE FUNCTION GetWindowsDirectory LIB "KERNEL32.DLL" ALIAS "GetWindowsDirectoryA" (lpBuffer AS ASCIIZ, BYVAL nSize AS DWORD) AS DWORD

%IDC_GRAPHIC = 100
%GRAPH_W = 320
%GRAPH_H = 240

%PADDLE_W = 35
%PADDLE_H = 10
%PADDLE_POS_Y = 210
%PADDLE_SPEED = 4
%PADDLE_INIT_POS_X = 160

%BALL_D = 8
%BALL_SPEED = 2

%BRICK_W = 20
%BRICK_H = 8
%MAX_BRICK_LINE = 10
%MAX_BRICK_COL  = 13

%TEXT_W = 70

GLOBAL hGBmpPaddle AS LONG
GLOBAL PaddleXPos AS LONG

GLOBAL hGBmpBall AS LONG
GLOBAL BallVX AS LONG
GLOBAL BallVY AS LONG
GLOBAL BallX AS LONG
GLOBAL BallY AS LONG
GLOBAL nBalls AS LONG

GLOBAL hGBmpBrick AS LONG
GLOBAL BrickFallSpeed AS LONG
GLOBAL BrickStatus() AS LONG
GLOBAL BricksYOffset AS LONG

GLOBAL nPoints AS LONG

GLOBAL hMMTimer AS DWORD

GLOBAL GameSpeed AS LONG

GLOBAL WinDir AS ASCIIZ * %MAX_PATH

MACRO PlayStart = playsound(WinDir + "\media\start.wav",0, %SND_ASYNC)
MACRO PlayChord = playsound(WinDir + "\media\chord.wav",0, %SND_ASYNC)

'******************************************************************************
SUB InitPaddle()
'******************************************************************************

  GRAPHIC BITMAP NEW %PADDLE_W, %PADDLE_H TO hGBmpPaddle
  GRAPHIC ATTACH hGBmpPaddle, 0
  GRAPHIC BOX (0, 0) - (%PADDLE_W, %PADDLE_H), 100,%CYAN, %CYAN, 0
  GRAPHIC BOX (2, 2) - (%PADDLE_W-2, %PADDLE_H-2), 100, %BLUE, %BLUE, 0
  PaddleXPos = %PADDLE_INIT_POS_X

END SUB

'******************************************************************************
SUB InitBall()
'******************************************************************************

  GRAPHIC BITMAP NEW %BALL_D , %BALL_D  TO hGBmpBall
  GRAPHIC ATTACH hGBmpBall, 0
  GRAPHIC ELLIPSE (0, 0) - (%BALL_D , %BALL_D ), %GREEN, %GREEN, 0
  GRAPHIC ELLIPSE (2, 2) - (%BALL_D-2 , %BALL_D-2 ), %WHITE, %WHITE, 0

  BallVX = %BALL_SPEED
  BallVY = %BALL_SPEED
  BallX = 80+RND(0,25)
  BallY = 120

END SUB

'******************************************************************************
SUB InitBrick()
'******************************************************************************
  REGISTER x AS LONG
  REGISTER y AS LONG
  REDIM BrickStatus(%MAX_BRICK_LINE,%MAX_BRICK_COL) AS GLOBAL LONG

  GRAPHIC BITMAP NEW %BRICK_W, %BRICK_H TO hGBmpBrick
  GRAPHIC ATTACH hGBmpBrick, 0
  GRAPHIC BOX (0, 0) - (%BRICK_W, %BRICK_H), 80,  %YELLOW, %YELLOW, 0
  GRAPHIC BOX (2, 2) - (%BRICK_W-2, %BRICK_H-2), 80, %MAGENTA, %MAGENTA, 0

  FOR y = 0 TO %MAX_BRICK_LINE
    FOR x = 0 TO %MAX_BRICK_COL
      BrickStatus(y,x)=%True
    NEXT x
  NEXT y

  BricksYOffset = 2

END SUB

'******************************************************************************
SUB InitGame (BYVAL hDlg AS DWORD)
'******************************************************************************

  RANDOMIZE
  GetWindowsDirectory(WinDir,%MAX_PATH)
  PlayStart
  PlayChord
  InitPaddle()
  InitBall()
  InitBrick()

  GRAPHIC ATTACH hDlg, %IDC_GRAPHIC, REDRAW

  hMMTimer = timeSetEvent (GameSpeed, GameSpeed, CODEPTR(MMTimerProc), hDlg, %TIME_PERIODIC)

END SUB

'******************************************************************************
SUB MMTimerProc  ( BYVAL uID AS LONG, BYVAL uMsg AS LONG, BYVAL hDlg AS DWORD, BYVAL lp1 AS LONG, BYVAL lp2 AS LONG )
'******************************************************************************

  PostMessage (hDlg,%WM_USER+999,0,0)

END SUB

'******************************************************************************
SUB CleanUp (BYVAL hDlg AS LONG)
'******************************************************************************
  LOCAL Message AS tagMSG

    IF hMMTimer THEN timeKillEvent(hMMTimer)
    hMMTimer = 0
    WHILE PeekMessage(Message,hDlg,%WM_USER+999,%WM_USER+999,%PM_REMOVE)
    WEND

END SUB

'******************************************************************************
SUB EndGame (BYVAL hDlg AS DWORD)
'******************************************************************************

  CleanUp(hDlg)
  GRAPHIC ATTACH hGBmpPaddle, 0
  GRAPHIC BITMAP END
  GRAPHIC ATTACH hGBmpBall, 0
  GRAPHIC BITMAP END
  GRAPHIC ATTACH hGBmpBrick, 0
  GRAPHIC BITMAP END

END SUB

'******************************************************************************
SUB UpdatePaddle()
'******************************************************************************
  LOCAL ks AS WORD

  ks = GetAsyncKeyState(%VK_LEFT)
  IF (ks AND &h8000) AND PaddleXPos>=%PADDLE_SPEED THEN PaddleXPos = PaddleXPos - %PADDLE_SPEED
  ks = GetAsyncKeyState(%VK_RIGHT)
  IF (ks AND &h8000) AND PaddleXPos<%GRAPH_W-%PADDLE_W-%PADDLE_SPEED THEN PaddleXPos = PaddleXPos + %PADDLE_SPEED

END SUB

'******************************************************************************
SUB UpdateBrick(BYVAL COUNT AS LONG)
'******************************************************************************

  IF ISFALSE (COUNT MOD BrickFallSpeed) THEN INCR BricksYOffset

END SUB

'******************************************************************************
SUB BallBorderCollision()
'******************************************************************************

  IF BallX<=0 THEN
    BallVX=%BALL_SPEED
    PlayStart
  ELSEIF BallX>=%GRAPH_W-%BALL_D THEN
    BallVX=-%BALL_SPEED
    PlayStart
  ELSEIF BallY<=0 THEN
    BallVY=%BALL_SPEED
    PlayStart
  ELSEIF BallY>=%GRAPH_H-%BALL_D THEN
    BallVY=-%BALL_SPEED
    PlayChord
    DECR nBalls
  END IF

END SUB

'******************************************************************************
SUB BallPaddleCollision(rBall AS RECT)
'******************************************************************************
  LOCAL rPaddle, rResult AS RECT

  rPaddle.nLeft   = PaddleXPos
  rPaddle.nTop    = %PADDLE_POS_Y
  rPaddle.nRight  = PaddleXPos + %PADDLE_W
  rPaddle.nBottom = %PADDLE_POS_Y + %PADDLE_H

  IF IntersectRect(rResult,rBall,rPaddle) THEN
    IF rResult.nLeft = rPaddle.nLeft THEN BallVX=-%BALL_SPEED
    IF rResult.nTop = rPaddle.nTop THEN BallVY=-%BALL_SPEED
    IF rResult.nRight = rPaddle.nRight THEN BallVX=%BALL_SPEED
    IF rResult.nBottom = rPaddle.nBottom THEN BallVY=%BALL_SPEED
    PlayStart
  END IF

END SUB

'******************************************************************************
SUB BallBrickCollision(rBall AS RECT)
'******************************************************************************
  REGISTER x AS LONG
  REGISTER y AS LONG
  LOCAL rBrick,rResult AS RECT
  LOCAL XIni,XEnd,YIni,YEnd AS LONG

  YIni = (rBall.nTop - BricksYOffset)\(%BRICK_H+2)
  XIni = (rBall.nLeft-8)\(%BRICK_W+2)
  XEnd = (rBall.nRight-8)\(%BRICK_W+2)
  yEnd = (rBall.nBottom - BricksYOffset)\(%BRICK_H+2)

  IF XIni<0 THEN XIni=0
  IF XEnd>%MAX_BRICK_COL THEN XEnd=%MAX_BRICK_COL
  IF YIni<0 THEN YIni=0
  IF YEnd>%MAX_BRICK_LINE THEN YEnd=%MAX_BRICK_LINE

  FOR y = YIni TO YEnd
    FOR x = XIni TO XEnd

      IF BrickStatus(y,x) THEN

        rBrick.nLeft    = 8 + x*(%BRICK_W+2)
        rBrick.nTop     = y*(%BRICK_H+2)+BricksYOffset
        rBrick.nRight   = rBrick.nLeft + %BRICK_W
        rBrick.nBottom  = rBrick.nTop + %BRICK_H

        IF IntersectRect(rResult,rBall,rBrick) THEN
          IF rResult.nLeft = rBrick.nLeft THEN BallVX=-%BALL_SPEED
          IF rResult.nTop = rBrick.nTop THEN BallVY=-%BALL_SPEED
          IF rResult.nRight = rBrick.nRight THEN BallVX=%BALL_SPEED
          IF rResult.nBottom = rBrick.nBottom THEN BallVY=%BALL_SPEED
          BrickStatus(y,x)=%False
          PlayStart
          nPoints = nPoints + 10
        END IF

      END IF

    NEXT x
  NEXT y

END SUB

'******************************************************************************
FUNCTION  DrawBrick() AS LONG
'******************************************************************************
  REGISTER x AS LONG
  REGISTER y AS LONG
  LOCAL Result AS LONG

  FOR y = 0 TO %MAX_BRICK_LINE
    FOR x = 0 TO %MAX_BRICK_COL
      IF BrickStatus(y,x) THEN
        GRAPHIC COPY hGBmpBrick, 0 TO (8+x*(%BRICK_W+2), y*(%BRICK_H+2)+BricksYOffset)
        INCR Result
        IF y*(%BRICK_H+2)+BricksYOffset+%BRICK_H>=%PADDLE_POS_Y THEN
          FUNCTION = -1
          EXIT FUNCTION
        END IF
      END IF
    NEXT x
  NEXT y

  FUNCTION = Result

END FUNCTION

'******************************************************************************
SUB UpdateBall()
'******************************************************************************

  BallX = BallX+BallVX
  BallY = BallY+BallVY

END SUB

'******************************************************************************
SUB WriteText()
'******************************************************************************

  GRAPHIC COLOR %YELLOW, %BLACK
  GRAPHIC FONT "Arial", 10, 1
  GRAPHIC SET POS (4, %PADDLE_POS_Y + %PADDLE_H + 2)
  GRAPHIC PRINT "Pts:";nPoints
  GRAPHIC SET POS (%GRAPH_W - %TEXT_W, %PADDLE_POS_Y + %PADDLE_H + 2)
  GRAPHIC PRINT "Balls: ";nBalls

END SUB

'******************************************************************************
SUB PlayerWon(BYVAL hDlg AS DWORD, BYREF COUNT AS LONG)
'******************************************************************************

  IF 63000-COUNT > 0 THEN nPoints = nPoints + (63000-COUNT)\100
  nPoints = nPoints + nBalls*100
  WriteText()
  GRAPHIC REDRAW
  MSGBOX " Good!" + $CRLF + STR$(nPoints) + " Points",%MB_OK,"BreakThru"
  BrickFallSpeed = BrickFallSpeed - 50
  nBalls = nBalls + nPoints\1000
  GameSpeed = GameSpeed - 2
  COUNT=0
  IF GameSpeed>0 THEN InitGame hDlg

END SUB

'******************************************************************************
SUB PlayerLoose(BYVAL hDlg AS DWORD, BYREF COUNT AS LONG)
'******************************************************************************

  WriteText()
  GRAPHIC REDRAW
  MSGBOX " End Game" + $CRLF + STR$(nPoints) + " Points",%MB_OK,"BreakThru"
  nPoints = 0
  BrickFallSpeed = 300
  nBalls = 10
  GameSpeed = 20
  COUNT=0
  InitGame hDlg

END SUB

'******************************************************************************
SUB PlayGame(BYVAL hDlg AS LONG)
'******************************************************************************
  LOCAL Result AS LONG
  LOCAL Txt AS STRING
  LOCAL rBall AS RECT
  STATIC COUNT AS LONG

  INCR COUNT
  GRAPHIC COLOR %BLACK, %BLACK
  GRAPHIC CLEAR
  UpdatePaddle()
  UpdateBrick(COUNT)
  UpdateBall()

  rBall.nLeft = BallX
  rBall.nTop = BallY
  rBall.nRight = rBall.nLeft +%BALL_D
  rBall.nBottom = rBall.nTop +%BALL_D

  BallBorderCollision()
  BallPaddleCollision(rBall)
  BallBrickCollision(rBall)

  Result = DrawBrick()
  WriteText()
  GRAPHIC COPY hGBmpBall, 0 TO (BallX, BallY)
  GRAPHIC COPY hGBmpPaddle, 0 TO (PaddleXPos, %PADDLE_POS_Y)

  GRAPHIC REDRAW

  IF Result = 0 THEN
    CleanUp(hDlg)
    PlayerWon(hDlg,COUNT)
  ELSEIF Result = -1 OR nBalls = 0 THEN
    CleanUp(hDlg)
    PlayerLoose(hDlg,COUNT)
  END IF


END SUB

'******************************************************************************
CALLBACK FUNCTION DlgProc () AS LONG
'******************************************************************************

  SELECT CASE CBMSG

    CASE %WM_INITDIALOG
      GameSpeed = 20
      BrickFallSpeed = 300
      nBalls = 10
      nPoints = 0
      InitGame CBHNDL

    CASE %WM_CLOSE
      EndGame CBHNDL

    CASE %WM_USER+999
      PlayGame(CBHNDL)

  END SELECT

END FUNCTION

'******************************************************************************
FUNCTION PBMAIN () AS LONG
'******************************************************************************
  LOCAL hDlg AS DWORD

  DIALOG NEW PIXELS, %HWND_DESKTOP, "BreakThru",,, %GRAPH_W, %GRAPH_H, %WS_CAPTION OR %WS_SYSMENU, 0 TO hDlg
  CONTROL ADD GRAPHIC, hDlg, %IDC_GRAPHIC, "", 0, 0, %GRAPH_W, %GRAPH_H

  DIALOG SHOW MODAL hDlg, CALL DlgProc

END FUNCTION

'******************************************************************************
'END
'******************************************************************************
