'-- INJECT.INC --------------------------------------------------------------
Declare Function Get_hModule(ByVal PID As Dword, DllPath$) As Dword
Declare Function Inject_DLL(ByVal PID As Dword, DllPath$) As Long
Declare Function Eject_DLL(ByVal PID As Dword, ByVal hModule As Dword) As Long
   
'-- Declares not found in WIN32API.INC
Declare Function EnumProcessModules Lib "PSAPI.DLL" Alias "EnumProcessModules" _
      (ByVal hProcess As Dword, hModule As Dword, _
       ByVal cb As Dword, cbNeeded As Dword) As Dword
   
Declare Function GetModuleFileNameEx Lib "PSAPI.DLL" Alias "GetModuleFileNameExA" _
      (ByVal hProcess As Dword, ByVal hModule As Dword, _
       Filename As Asciiz, ByVal nSize As Dword) As Dword
   
   
'====================
Function Get_hModule(ByVal PID As Dword, DllPath$) As Dword
'-- Returns handle to running module specified in DllPath$, or zero if not found
'-- PID = process ID of running process; DllPath$ = path+filename of DLL
Register i&, result&
Local  cb, cbNeeded, nModules As Long, hProcess, found, hModules() As Dword
Local Dll$, ModuleName As Asciiz * %MAX_PATH
   
hProcess = OpenProcess(%PROCESS_QUERY_INFORMATION Or %PROCESS_VM_READ, %FALSE, PID)
If hProcess Then
   cb = 100
   Do
      ReDim hModules(1 To cb \ 4)
      result = EnumProcessModules(hProcess, hModules(1), cb, cbNeeded)
      If result = 0 Then 'call failed
         cbNeeded = 0 : Exit Do
      End If
      If cb > cbNeeded Then Exit Do
      cb = cb * 2
   Loop
   nModules = cbNeeded \ 4
   Dll = UCase$(DllPath$)
   For i = 1 To nModules
      result = GetModuleFileNameEx(hProcess, hModules(i), _
                                   ModuleName, SizeOf(ModuleName))
      If result Then
         If UCase$(RTrim$(ModuleName,$Nul)) = Dll Then
            found = hModules(i) : Exit For
         End If
      End If
   Next i
   CloseHandle hProcess
End If 'hProcess
   
Function = found
End Function
   
'====================
Function Inject_DLL(ByVal PID As Dword, DllPath$) As Long
Register hProcess&, hThread&
Local ecode&, pLoadLibraryA, pRemoteBuffer As Dword
   
ecode = -1  'default to error
hProcess = OpenProcess(%PROCESS_CREATE_THREAD Or %PROCESS_QUERY_INFORMATION Or _
                       %PROCESS_VM_OPERATION  Or %PROCESS_VM_READ Or _
                       %PROCESS_VM_WRITE, %FALSE, PID)
If hProcess Then
   pLoadLibraryA = GetProcAddress(GetModuleHandle("Kernel32"), "LoadLibraryA")
   pRemoteBuffer = VirtualAllocEx(hProcess, ByVal %Null, Len(DllPath$), _
                                  %MEM_COMMIT, %PAGE_READWRITE)
   If pRemoteBuffer And pLoadLibraryA Then
      If WriteProcessMemory(ByVal hProcess, ByVal pRemoteBuffer, _
                            ByVal StrPtr(DllPath$), Len(DllPath$), %Null) Then
         hThread = CreateRemoteThread(ByVal hProcess, ByVal %Null, 0&, _
                                      ByVal pLoadLibraryA, ByVal pRemoteBuffer, _
                                      0, %Null)
         If hThread Then
            WaitForSingleObject hThread, %INFINITE
            CloseHandle hThread
            ecode = 0
         End If
      End If
      VirtualFreeEx hProcess, pRemoteBuffer, 0, %MEM_RELEASE
   End If 'pRemoteBuffer AND pLoadLibraryA
   CloseHandle hProcess
End If 'hProcess
   
Function = ecode
End Function
   
'====================
Function Eject_DLL(ByVal PID As Dword, ByVal hModule As Dword) As Long
Register hProcess&, hThread&
Local ecode&, pFreeLibrary, pRemoteBuffer As Dword
   
ecode = -1  'default to error
hProcess = OpenProcess(%PROCESS_CREATE_THREAD Or %PROCESS_QUERY_INFORMATION Or _
                       %PROCESS_VM_OPERATION  Or %PROCESS_VM_READ Or _
                       %PROCESS_VM_WRITE, %FALSE, PID)
If hProcess Then
   pFreeLibrary = GetProcAddress(GetModuleHandle("Kernel32"), "FreeLibrary")
   If pFreeLibrary Then
      hThread = CreateRemoteThread(ByVal hProcess, ByVal %Null, 0&, _
                                   ByVal pFreeLibrary, ByVal hModule, 0, %Null)
      If hThread Then
         WaitForSingleObject hThread, %INFINITE
         CloseHandle hThread
         ecode = 0
      End If
   End If
   CloseHandle hProcess
End If 'hProcess
   
Function = ecode
End Function
'-- END INJECT.INC ----------------------------------------------------------