Attribute VB_Name = "LASM"
Option Explicit

Private CodeLength() As Long
Private Labels() As String
Private code As String
Private Code_Hex As String

Private EQU_Name() As String
Private EQU_Value() As String

Public Declare Function IsCharAlphaNumeric Lib "user32.dll" Alias "IsCharAlphaNumericA" ( _
     ByVal cChar As Byte) As Long

Private Source() As String

Function PUSH_Code(ByVal RegisterName As String) As String
 RegisterName = UCase$(Trim$(RegisterName))
 Const BeginPush As Byte = &H50
 If Register_Code(RegisterName) <> 255 Then
    PUSH_Code = Chr$(BeginPush + Register_Code(RegisterName))
    Exit Function
 End If
 
 Select Case RegisterName
 Case "CS"
     PUSH_Code = Chr$(&HE): Exit Function
 Case "SS"
     PUSH_Code = Chr$(&H16): Exit Function
 Case "DS"
     PUSH_Code = Chr$(&H1E): Exit Function
 Case "ES"
     PUSH_Code = Chr$(&H6): Exit Function
 Case "FS"
     PUSH_Code = Chr$(&HF) & Chr$(&HA0): Exit Function
 Case "GS"
     PUSH_Code = Chr$(&HF) & Chr$(&HA8): Exit Function
 End Select
 
 Dim Op1_Type As String
 Op1_Type = Mnemonic_OperandType(RegisterName)
 Select Case Op1_Type
 Case "m8", "m16", "m32", "r8", "r16", "r32", "imm8", "imm16", "imm32"
  PUSH_Code = SingleOperand_Generator("PUSH", RegisterName)
  Exit Function
 End Select
 
End Function
Function PUSHAD_Code() As String
 PUSHAD_Code = Chr$(&H60)
End Function

Function PUSH_Label_Code(ByVal LabelAddr As Long, ByVal Curr_IP As Long, Optional ByVal AutoCreateProc As Boolean = True) As String
 If LabelAddr = -1 Then Exit Function
 
 Dim AfterPrepare As Byte ' Top part of COMPILER_CreateCodeProc
 If AutoCreateProc Then AfterPrepare = 6
 
 Mid$(code, Curr_IP + 2, 4) = TOOLS_Number2Machine(LabelAddr + AfterPrepare)
 PUSH_Label_Code = Mid$(code, Curr_IP + 1, 1) & TOOLS_Number2Machine(LabelAddr + AfterPrepare)
End Function

Function POP_Code(ByVal RegisterName As String) As String
 Const PopR32 As Byte = &H58
 If Register_Code(RegisterName) <> 255 Then
    POP_Code = Chr$(PopR32 + Register_Code(RegisterName))
    Exit Function
 End If

 Select Case RegisterName
 Case "SS"
     POP_Code = Chr$(&H17): Exit Function
 Case "DS"
     POP_Code = Chr$(&H1F): Exit Function
 Case "ES"
     POP_Code = Chr$(&H7): Exit Function
 Case "FS"
     POP_Code = Chr$(&HF) & Chr$(&HA1): Exit Function
 Case "GS"
     POP_Code = Chr$(&HF) & Chr$(&HA9): Exit Function
 End Select

 Dim Op1_Type As String
 Op1_Type = Mnemonic_OperandType(RegisterName)
 Select Case Op1_Type
 Case "m8", "m16", "m32", "r8", "r16", "r32", "imm8", "imm16", "imm32"
  POP_Code = SingleOperand_Generator("POP", RegisterName)
  Exit Function
 End Select

End Function

Function POP_OpCodes(ByVal Op1_Type As String, ByRef StrRet As String) As Byte
 
 Const Ext16 As Byte = &H66
 
 Select Case Op1_Type
 Case "m16"
    StrRet = Chr$(Ext16) & Chr$(&H8F)
    POP_OpCodes = &H0
 Case "m32"
    StrRet = Chr$(&H8F)
 Case "r16"
    StrRet = Chr$(Ext16)
    POP_OpCodes = &H58
 Case "r32"
    POP_OpCodes = &H58
 Case Else
    StrRet = "": POP_OpCodes = &H0
 End Select
End Function


Function POPAD_Code() As String
 POPAD_Code = Chr$(&H61)
End Function

Function Register_Code(ByVal RegisterName As String) As Byte
 RegisterName = Trim$(RegisterName)
 Register_Code = 255
 Select Case UCase$(RegisterName)
 Case "EAX"
  Register_Code = 0
 Case "ECX"
  Register_Code = 1
 Case "EDX"
  Register_Code = 2
 Case "EBX"
  Register_Code = 3
 Case "ESP"
  Register_Code = 4
 Case "EBP"
  Register_Code = 5
 Case "ESI"
  Register_Code = 6
 Case "EDI"
  Register_Code = 7
 End Select
End Function

Function Register16_Code(ByVal RegisterName As String) As Byte
 Register16_Code = 255
 Select Case UCase$(Trim$(RegisterName))
 Case "AX"
  Register16_Code = 0
 Case "CX"
  Register16_Code = 1
 Case "DX"
  Register16_Code = 2
 Case "BX"
  Register16_Code = 3
 Case "SP"
  Register16_Code = 4
 Case "BP"
  Register16_Code = 5
 Case "SI"
  Register16_Code = 6
 Case "DI"
  Register16_Code = 7
 End Select
End Function

Function Register8_Code(ByVal RegisterName As String) As Byte
 Register8_Code = 255
 Select Case UCase$(Trim$(RegisterName))
 Case "AL"
  Register8_Code = 0
 Case "CL"
  Register8_Code = 1
 Case "DL"
  Register8_Code = 2
 Case "BL"
  Register8_Code = 3
 Case "AH"
  Register8_Code = 4
 Case "CH"
  Register8_Code = 5
 Case "DH"
  Register8_Code = 6
 Case "BH"
  Register8_Code = 7
 End Select
End Function

Function Mov_OpCodes(ByVal Op1_Type As String, ByVal Op2_Type As String, ByRef StrRet As String) As Byte
 
 Dim OperatorOffset As Byte
 OperatorOffset = 0
 
 Dim Ext16 As String
  Ext16 = Chr$(&H66)
 
 Const R_Offset As Byte = &HC0
 
 Const m8r8 As Byte = &H88 '&H0
 'Const r8r8 As Byte = m8r8 '&HC0
 Const r8m8 As Byte = &H8A '&H0
 Const r8r8 As Byte = r8m8 '&HC0
 
 Const m32r32 As Byte = &H89 '&H0
 Const r32m32 As Byte = &H8B '&H0
 Const r32r32 As Byte = m32r32 '&HC0
 'Const r32r32 As Byte = r32m32 '&HC0
 
 Const m8imm8 As Byte = &HC6
 Const r8imm8 As Byte = &HB0
 
 Const m32imm32 As Byte = &HC7
 Const r32imm32 As Byte = &HB8
 
 'Const S_m32imm8 As Byte = &H83 '&H0 /sign-extended
 'Const S_r32imm8 As Byte = S_m32imm8 '&HC0 /sign-extended

 'Const ALimm8 As Byte = &H4
 'Const EAXimm32 As Byte = &H5

 Select Case Op1_Type & Op2_Type
 Case "m8r8"
  StrRet = Chr$(m8r8 + OperatorOffset)
 Case "r8r8"
  StrRet = Chr$(r8r8 + OperatorOffset)
  Mov_OpCodes = R_Offset
 Case "m16r16"
  StrRet = Ext16 & Chr$(m32r32 + OperatorOffset)
 Case "r16r16"
  StrRet = Ext16 & Chr$(r32r32 + OperatorOffset)
  Mov_OpCodes = R_Offset
 Case "m32r32"
  StrRet = Chr$(m32r32 + OperatorOffset)
 Case "r32r32"
  StrRet = Chr$(r32r32 + OperatorOffset)
  Mov_OpCodes = R_Offset
 Case "r8m8"
  StrRet = Chr$(r8m8 + OperatorOffset)
  Case "r16m16"
  StrRet = Ext16 & Chr$(r32m32 + OperatorOffset)
  Case "r32m32"
  StrRet = Chr$(r32m32 + OperatorOffset)
 Case "m8imm8"
  StrRet = Chr$(m8imm8)
  Mov_OpCodes = OperatorOffset
 Case "r8imm8"
  Mov_OpCodes = r8imm8
 Case "m16imm16"
  StrRet = Ext16 & Chr$(m32imm32)
  Mov_OpCodes = OperatorOffset
 Case "m32imm32"
  StrRet = Chr$(m32imm32)
  Mov_OpCodes = OperatorOffset
 Case "r16imm16"
  StrRet = Ext16
  Mov_OpCodes = r32imm32
 Case "r32imm32"
  Mov_OpCodes = r32imm32
 Case "ALimm8"
  Mov_OpCodes = r8imm8
 Case "AXimm16", "AXimm8"
  StrRet = Ext16
  Mov_OpCodes = r32imm32
 Case "EAXimm32", "EAXimm16", "EAXimm8"
  Mov_OpCodes = r32imm32 ' + R_Offset + OperatorOffset
 Case Else
  MsgBox "Invalid operand(s)" & vbCr & "MOV " & Op1_Type & "," & Op2_Type
 End Select
End Function


Function MOV_Code(ByVal Operand1 As String, ByVal Operand2 As String) As String
 MOV_Code = Mnemonic_Common_Generator("MOV", Operand1, Operand2)
End Function

Function MOV_Label_Code(ByVal LabelAddr As Long, ByVal Curr_IP As Long, Optional ByVal AutoCreateProc As Boolean = True)
 If LabelAddr = -1 Then Exit Function
  
 Dim AfterPrepare As Byte ' Top part of COMPILER_CreateCodeProc
 If AutoCreateProc Then AfterPrepare = 6
 
 Mid$(code, Curr_IP + 2, 4) = TOOLS_Number2Machine(LabelAddr + AfterPrepare)
 MOV_Label_Code = Mid$(code, Curr_IP + 1, 1) & TOOLS_Number2Machine(LabelAddr + AfterPrepare)
End Function

Function COMPILER_CheckOperand(ByVal Operand As String, ByRef Operand_Flag As Integer, ByRef Operand_AddValue As String) As String
 Operand = Trim$(Operand)
 Dim Operand_Value As String
 If Left$(Operand, 1) = "[" And Right$(Operand, 1) = "]" Then
    Operand_Value = Mid$(Operand, 2, Len(Operand) - 2)
    Operand_Flag = 1
    Dim IsAddValue() As String, IsAddValue_Pos As Integer, Sign As String
    IsAddValue_Pos = InStr(1, Operand_Value, "+")
    If IsAddValue_Pos > 0 Then
        Sign = "+"
    Else
        IsAddValue_Pos = InStr(1, Operand_Value, "-")
        If IsAddValue_Pos > 0 Then Sign = "-"
    End If
    If Len(Sign) > 0 Then
        IsAddValue = Split(Operand_Value, Sign)
        If UBound(IsAddValue) > 0 Then
            Operand_Value = IsAddValue(0)
            Operand_AddValue = IsAddValue(1)
            If Sign = "-" Then Operand_AddValue = "-" & Operand_AddValue
            Operand_Flag = 2
        End If
    End If
 Else
    Operand_Value = Operand
    Operand_Flag = 0
 End If

 COMPILER_CheckOperand = Operand_Value
End Function
Function JMP_Short_Label_Code(ByVal JMP_Type As String, ByVal LabelName As String, ByVal Curr_IP As Long) As String
 'Deleted in 0.2.1 (see: JMP_Near_Label_Code)
 
End Function

Function JMP_Short_Code(ByVal JMP_Type As String) As String
 'Deleted in 0.2.1 (see: JMP_Near_Code)
End Function


Function JMP_Code(ByVal Addr As String) As String
 If IsLabel(Addr) Then
    JMP_Code = JMP_Near_Code("JMP") & TOOLS_Number2Machine("0")
 Else
    Dim Op1_Type As String
    Op1_Type = Mnemonic_OperandType(Addr)
    Select Case Op1_Type
    Case "m8", "m16", "m32", "r8", "r16", "r32", "imm8", "imm16", "imm32"
        JMP_Code = SingleOperand_Generator("JMP", Addr)
    Exit Function
    End Select
 End If
End Function
Function JMP_Near_Code(ByVal JMP_Type As String) As String
Dim RetFunc As Byte, NotFound As Boolean
'0F + J_CODE+(0+0+0+0)
Dim FirstByte As String: FirstByte = Chr$(&HF)

Select Case UCase$(JMP_Type)
Case "JO"
    RetFunc = &H80
Case "JNO"
    RetFunc = &H81
Case "JB", "JC", "JNAE"
    RetFunc = &H82
Case "JAE", "JNB", "JNC"
    RetFunc = &H83
Case "JE", "JZ"
    RetFunc = &H84
Case "JNE", "JNZ"
    RetFunc = &H85
Case "JBE", "JNA"
    RetFunc = &H86
Case "JA", "JNBE"
    RetFunc = &H87
Case "JS"
    RetFunc = &H88
Case "JNS"
    RetFunc = &H89
Case "JP", "JPE"
    RetFunc = &H8A
Case "JPO", "JNP"
    RetFunc = &H8B
Case "JL", "JNGE"
    RetFunc = &H8C
Case "JGE", "JNL"
    RetFunc = &H8D
Case "JLE", "JNG"
    RetFunc = &H8E
Case "JG", "JNLE"
    RetFunc = &H8F
Case "JMP"
    'RetFunc = &HEB
    FirstByte = ""
    RetFunc = &HE9
Case Else
    NotFound = True
End Select

If NotFound Then JMP_Near_Code = "" Else JMP_Near_Code = FirstByte & Chr$(RetFunc)

End Function
Function TOOLS_Number2Machine(ByVal Value As String) As String
 'Convert dword (32 bit) value to reversed array of bytes (format of x86 CPU).
 'This need to write imm32
 Value = Tools_Bin2HexDec(Value)
 Dim IsHex As Boolean
 If Left$(UCase$(Value), 2) = "&H" Then
    IsHex = True
    Value = Right$(Value, Len(Value) - 2)
 End If
 If Not IsHex Then
    Value = Hex$(Val(Value))
 End If
 If Len(Value) < 8 Then Value = String$(8 - Len(Value), "0") & Value
 
 Dim NextByte As String * 2, NewValue As String
 Dim RebuildValue As Integer
 For RebuildValue = Len(Value) - 1 To 1 Step -2
    NextByte = Mid$(Value, RebuildValue, 2)
    NewValue = NewValue & Chr$(TOOLS_ToDEC_Byte(16, NextByte))
 Next RebuildValue
TOOLS_Number2Machine = NewValue
End Function

Function TOOLS_ToDEC_Byte(NumSystem As Integer, Number$) As Byte
' Convert from any number system to decimal
Number$ = UCase$(Number$)
Dim DecNum As Long
DecNum = 0
Dim Convert As Integer
For Convert = 1 To Len(Number$)
Dim SysNum$
SysNum$ = Mid$(Number$, Convert, 1)
If Asc(SysNum$) > 64 Then SysNum$ = LTrim$(Str$((Asc(SysNum$) - 65) + 10))
DecNum = DecNum + Val(SysNum$)
If Convert = Len(Number$) Then Exit For
DecNum = DecNum * NumSystem
Next Convert
TOOLS_ToDEC_Byte = DecNum
End Function

Function TOOLS_Number2Code(ByVal Value As String) As String
 Value = Tools_Bin2HexDec(Value)
 Dim IsHex As Boolean
 If Left$(UCase$(Value), 2) = "&H" Then
    IsHex = True
    Value = Right$(Value, Len(Value) - 2)
 End If
 If Not IsHex Then
    Value = Hex$(Val(Value))
 End If
 Select Case Len(Value)
 Case 1, 3, 5, 7
    Value = "0" & Value
 End Select
 Dim NextByte As String * 2, NewValue As String
 Dim RebuildValue As Integer
 For RebuildValue = Len(Value) - 1 To 1 Step -2
    NextByte = Mid$(Value, RebuildValue, 2)
    NewValue = NewValue & Chr$(TOOLS_ToDEC_Byte(16, NextByte))
 Next RebuildValue
TOOLS_Number2Code = NewValue
End Function

Function TOOLS_Number2Byte(ByVal Value As String) As String
 Dim NegVal As Boolean
 NegVal = IsNegative(Value)
 
 Value = Tools_Bin2HexDec(Value)
 
 If NegVal Then
    Value = LTrim$(Str$(256 - Val(Value)))
    If Val(Value) < 0 Then MsgBox "Conversion error" & vbCr & vbCr & Value & " is out of byte.": Exit Function
 End If
 TOOLS_Number2Byte = TOOLS_Number2Code(Value)
End Function

Function TOOLS_Number2Word(ByVal Value As String) As String
 
 Dim NegVal As Boolean
 NegVal = IsNegative(Value)
 
 Value = Tools_Bin2HexDec(Value)
 
 If NegVal Then
    Value = LTrim$(Str$(65536 - Val(Value)))
    If Val(Value) < 0 Then MsgBox "Conversion error" & vbCr & vbCr & Value & " is out of word.": Exit Function
 End If
 
 Dim IsHex As Boolean
 If Left$(UCase$(Value), 2) = "&H" Then
    IsHex = True
    Value = Right$(Value, Len(Value) - 2)
 End If
 If Not IsHex Then
    
    Value = Hex$(Val(Value))
 End If
 If Len(Value) < 4 Then Value = String(4 - Len(Value), "0") & Value
 
 Dim NextByte As String * 2, NewValue As String
 Dim RebuildValue As Integer
 For RebuildValue = Len(Value) - 1 To 1 Step -2
    NextByte = Mid$(Value, RebuildValue, 2)
    NewValue = NewValue & Chr$(TOOLS_ToDEC_Byte(16, NextByte))
 Next RebuildValue
TOOLS_Number2Word = NewValue
End Function

Function RET_Code(ByVal Value As String) As String
 Value = Trim$(Value)
 If Len(Value) = 0 Then RET_Code = Chr$(&HC3): Exit Function
 
 Dim Imm_Type As String
 Imm_Type = Tools_ImmTypeID(Value)
 If Len(Imm_Type) = 0 Then
    Imm_Type = Mnemonic_OperandType(Value)
 End If
 
 Select Case Imm_Type
 Case "imm8"
    If IsByte(Value) Then RET_Code = Chr$(&HC2) & TOOLS_Number2Word(Value) Else MsgBox "Out of Byte in Ret imm8"
 Case "imm16"
    If IsWord(Value) Then RET_Code = Chr$(&HC2) & TOOLS_Number2Word(Value) Else MsgBox "Out of Word in Ret imm16"
 Case "imm32"
    MsgBox "Not a valid imm type: imm32" & vbCr & vbCr & vbTab & "USAGE:" & vbCr & "RET imm16." & vbCr & vbCr & "imm8 will converted automaticaly."
 End Select
End Function

Function RETNF_Code(ByVal Mnm As String) As String
 Mnm = UCase$(Trim$(Mnm))
 Select Case Mnm
 Case "RETN"
  RETNF_Code = Chr$(&HC3)
 Case "RETF"
  RETNF_Code = Chr$(&HCB)
 End Select
End Function

Sub COMPILER_AddCodeLen(ByVal Length As String, Optional ByVal AddLabel As Boolean)
 If Not AddLabel Then
    If Len(Labels(UBound(Labels))) > 0 And CodeLength(UBound(CodeLength)) = 0 Then
        CodeLength(UBound(CodeLength)) = Val(Length)
        Exit Sub
    Else
        ReDim Preserve CodeLength(UBound(CodeLength) + 1)
        ReDim Preserve Labels(UBound(Labels) + 1)
        CodeLength(UBound(CodeLength)) = Val(Length)
        Exit Sub
    End If
 Else
    ReDim Preserve CodeLength(UBound(CodeLength) + 1)
    ReDim Preserve Labels(UBound(Labels) + 1)
    Labels(UBound(Labels)) = UCase$(Trim$(Length))
 End If
End Sub

Function COMPILER_FindLabelAddr(ByVal LabelName As String) As Long
    Dim AddrCounter As Long
    LabelName = Trim$(UCase$(LabelName))
    Dim EnumLabels As Long
    For EnumLabels = 1 To UBound(Labels)
        If LabelName = Labels(EnumLabels) Then COMPILER_FindLabelAddr = AddrCounter: Exit Function
        AddrCounter = AddrCounter + CodeLength(EnumLabels)
    Next EnumLabels
    COMPILER_FindLabelAddr = -1
End Function

Sub COMPILER_ClearCodeBuffer()
    code = ""
    ReDim CodeLength(0)
    ReDim Labels(0)

    ReDim EQU_Name(0)
    ReDim EQU_Value(0)
End Sub
Sub COMPILER_AddCode(ByVal CodeString As String)
    code = code & CodeString
End Sub

Function COMPILER_GetCode(ByVal CodePos As Long, ByVal CodeLen As Long) As String
    COMPILER_GetCode = Mid$(code, CodePos, CodeLen)
End Function

Function GetCodeLen(ByVal Array_IP As Long) As Long
    If Array_IP > UBound(CodeLength) Then Exit Function
    GetCodeLen = CodeLength(Array_IP)
End Function

Function Code_Export()
 On Error GoTo ErrKill
 If Len(Dir$(App.Path & "\LASMIDE.BIN")) > 0 Then Kill App.Path & "\LASMIDE.BIN"
 Open App.Path & "\LASMIDE.BIN" For Binary As #1
 Put #1, 1, code
 Close 1
 Exit Function
 
ErrKill:
 MsgBox Error$(Err), 16, "SAVE TO FILE: LASMIDE.BIN"
 Resume Next
End Function

Function IsByte(ByVal Value As String) As Boolean
 Value = Trim$(Value)
 Value = Tools_Bin2HexDec(Value)
 Call IsNegative(Value)
 If Left$(Value, 2) = "&H" Then
    Value = Right$(Value, Len(Value) - 2)
    If Len(Value) > 2 Then IsByte = False Else IsByte = True
 Else
    If Len(Value) > 3 Then
     IsByte = False
    Else
     If Val(Value) > 255 Then IsByte = False Else IsByte = True
    End If
 End If
End Function
Function IsWord(ByVal Value As String) As Boolean
 Value = Trim$(Value)
 Value = Tools_Bin2HexDec(Value)
 Call IsNegative(Value)
 If Left$(Value, 2) = "&H" Then
    Value = Right$(Value, Len(Value) - 2)
    If Len(Value) > 4 Then IsWord = False Else IsWord = True
 Else
    If Len(Value) > 5 Then
     IsWord = False
    Else
     Dim lng As Long
     If Val(Value) > 65535 Then IsWord = False Else IsWord = True
    End If
 End If
End Function

Function COMPILER_CallExecutor(ByVal p1 As Long, ByVal p2 As Long, ByVal p3 As Long, ByVal p4 As Long) As Long
 COMPILER_CallExecutor = ExecuteCode(code, p1, p2, p3, p4)
End Function

Function CALL_Code(ByVal RegisterName As String) As String
 RegisterName = UCase$(Trim$(RegisterName))
 
 Const Call_Register As Byte = &HFF
 Dim RegisterCode As String * 1
 
 Select Case RegisterName
 Case "EAX"
  RegisterCode = Chr$(&HD0)
 Case "ECX"
  RegisterCode = Chr$(&HD1)
 Case "EDX"
  RegisterCode = Chr$(&HD2)
 Case "EBX"
  RegisterCode = Chr$(&HD3)
 Case "ESP"
  RegisterCode = Chr$(&HD4)
 Case "EBP"
  RegisterCode = Chr$(&HD5)
 Case "ESI"
  RegisterCode = Chr$(&HD6)
 Case "EDI"
  RegisterCode = Chr$(&HD7)
 End Select
If Asc(RegisterCode) > 0 Then CALL_Code = Chr$(Call_Register) & RegisterCode: Exit Function

 Dim Op1_Type As String
 Op1_Type = Mnemonic_OperandType(RegisterName)
 Select Case Op1_Type
 Case "m8", "m16", "m32", "r8", "r16", "r32", "imm8", "imm16", "imm32"
  CALL_Code = SingleOperand_Generator("CALL", RegisterName)
  Exit Function
 Case Else
  MsgBox "Error in CALL." & vbCr & vbCr & "USAGE: CALL Register32/imm" & vbCr & "   Register32 - EAX,ECX,EDX,EBX,ESP,EBP,ESI,EDI." & vbCr & "   imm - imm8,imm16,imm32": CALL_Code = "": Exit Function
 End Select

End Function

Public Function Called(ByVal ValueToShow As Long) As Long
 MsgBox "DEC=" & ValueToShow & vbCr & "HEX=&H" & Hex$(ValueToShow), , "LASM IDE"
End Function


Function JMP_Near_Label_Code(ByVal JMP_Type As String, ByVal LabelName As String, ByVal Curr_IP As Long) As String
 JMP_Type = UCase$(Trim$(JMP_Type))
 
 If JMP_Type = "JMP" Or JMP_Type = "CALL" Then
    If Not IsLabel(LabelName) Then Exit Function
 End If
 
'0F + J_CODE+(0+0+0+0)
 Dim LabelAddr As Long
 LabelAddr = COMPILER_FindLabelAddr(LabelName)
 If LabelAddr = -1 Then MsgBox "Label not found: " & LabelName, 16, "JUMP error (" & JMP_Type & ")": JMP_Near_Label_Code = "": Exit Function
 Dim JMP_From_Addr As Long, Target_Addr As Long
 Target_Addr = LabelAddr + 1
 JMP_From_Addr = Curr_IP + 1
 
 Dim BytesToJump As Long
 BytesToJump = Target_Addr - JMP_From_Addr
 If JMP_From_Addr > Target_Addr Then
    'Backward
    BytesToJump = BytesToJump - 6
    If UCase$(Trim$(JMP_Type)) = "JMP" Or UCase$(Trim$(JMP_Type)) = "CALL" Then BytesToJump = BytesToJump + 1
 ElseIf JMP_From_Addr < Target_Addr Then
    'Foreward
    BytesToJump = BytesToJump - 6
    If UCase$(Trim$(JMP_Type)) = "JMP" Or UCase$(Trim$(JMP_Type)) = "CALL" Then BytesToJump = BytesToJump + 1
 Else
    'Error
    MsgBox "Error calculating label address"
    JMP_Near_Label_Code = ""
    Exit Function
 End If
 
 Select Case UCase$(Trim$(JMP_Type))
 Case "JMP", "CALL"
    Mid$(code, JMP_From_Addr + 1, 4) = TOOLS_Number2Machine(BytesToJump)
    JMP_Near_Label_Code = Mid$(code, JMP_From_Addr, 1) & TOOLS_Number2Machine(BytesToJump)
 Case Else
    Mid$(code, JMP_From_Addr + 2, 4) = TOOLS_Number2Machine(BytesToJump)
    JMP_Near_Label_Code = Mid$(code, JMP_From_Addr, 2) & TOOLS_Number2Machine(BytesToJump)
 End Select
 
End Function

Function DIRECT_CODE(ByVal CodeLen As String, ByVal Value As String) As String
 Dim TmpValueArray() As String, TmpValue As String, TmpValue2 As String, TmpEnumValues As Integer, StringToChars As Integer
 ReDim TmpValueArray(0)
 Tools_SplitMultiString Value, TmpValueArray
 
 For TmpEnumValues = 0 To UBound(TmpValueArray)
  If Left$(TmpValueArray(TmpEnumValues), 1) = Chr$(34) And Right$(TmpValueArray(TmpEnumValues), 1) = Chr$(34) And Len(TmpValueArray(TmpEnumValues)) > 3 Then
   TmpValue2 = ""
   TmpValueArray(TmpEnumValues) = Left$(TmpValueArray(TmpEnumValues), Len(TmpValueArray(TmpEnumValues)) - 1): TmpValueArray(TmpEnumValues) = Right$(TmpValueArray(TmpEnumValues), Len(TmpValueArray(TmpEnumValues)) - 1)
   For StringToChars = 1 To Len(TmpValueArray(TmpEnumValues))
    TmpValue2 = TmpValue2 & Chr$(34) & Mid$(TmpValueArray(TmpEnumValues), StringToChars, 1) & Chr$(34) & ","
   Next StringToChars
   If Right$(TmpValue2, 1) = "," Then TmpValue2 = Left$(TmpValue2, Len(TmpValue2) - 1)
   TmpValueArray(TmpEnumValues) = TmpValue2
  End If
  TmpValue = TmpValue & TmpValueArray(TmpEnumValues) & ","
 Next TmpEnumValues
 If Right$(TmpValue, 1) = "," Then TmpValue = Left$(TmpValue, Len(TmpValue) - 1)
 If Len(TmpValue) > Len(Value) Then Value = TmpValue
 
 Dim ValueArray() As String, NextValue As String
 ReDim ValueArray(0)
 Tools_SplitMultiString Value, ValueArray
 
 CodeLen = UCase$(Trim$(CodeLen))
Dim EnumValues As Integer
For EnumValues = 0 To UBound(ValueArray)
 NextValue = Trim$(ValueArray(EnumValues))
 If Left$(NextValue, 1) = Chr$(34) And Right$(NextValue, 1) = Chr$(34) Then
  NextValue = Left$(NextValue, Len(NextValue) - 1)
  NextValue = Right$(NextValue, Len(NextValue) - 1)
  NextValue = Trim$(Str$(Asc(NextValue)))
 End If
 Select Case CodeLen
 Case "DB"
  Dim ByteToAdd As Byte
  If IsByte(NextValue) = False Then MsgBox "Error in DB:" & vbCr & vbTab & "Out of range" & vbCr & vbCr & "Syntax:" & vbCr & vbTab & "DB Value(0-255)": DIRECT_CODE = "": Exit Function
  DIRECT_CODE = DIRECT_CODE & TOOLS_Number2Byte(NextValue)
 Case "DW"
  If IsWord(NextValue) = False Then MsgBox "Error in DW:" & vbCr & vbTab & "Out of range" & vbCr & vbCr & "Syntax:" & vbCr & vbTab & "DW Value(0-65535)": DIRECT_CODE = "": Exit Function
  DIRECT_CODE = DIRECT_CODE & TOOLS_Number2Word(NextValue)
 Case "DD"
  DIRECT_CODE = DIRECT_CODE & TOOLS_Number2Machine(NextValue)
End Select
Next EnumValues
End Function

Sub Tools_SplitMultiString(ByRef StrToSrch As String, ByRef ArrayToSave() As String)
 Dim NextSymbol As String * 1, EnumSymbols As Integer
 Dim BracketsOpened As Boolean
 For EnumSymbols = 1 To Len(StrToSrch)
  NextSymbol = Mid$(StrToSrch, EnumSymbols, 1)
  If NextSymbol = Chr$(34) Then
    If BracketsOpened = False Then BracketsOpened = True Else BracketsOpened = False
  End If
  If NextSymbol = "," Then
   If BracketsOpened Then
    ArrayToSave(UBound(ArrayToSave)) = ArrayToSave(UBound(ArrayToSave)) & NextSymbol
   Else
    ReDim Preserve ArrayToSave(UBound(ArrayToSave) + 1)
   End If
  Else
   ArrayToSave(UBound(ArrayToSave)) = ArrayToSave(UBound(ArrayToSave)) & NextSymbol
  End If
 Next EnumSymbols
End Sub
Function DIRECT_WLABELS_Code(ByVal Text As String) As String
 Dim CodeLen As String, Value As String
 CodeLen = Left$(Text, 2)
 Value = Right$(Text, Len(Text) - 2)
 DIRECT_WLABELS_Code = DIRECT_CODE(CodeLen, Trim$(Value))
End Function
Function REP_Code(ByVal Rep As String, ByVal RepLn As String)
 Const FrstByte As Byte = &HF3
 Dim ScndByte As String
 Rep = UCase$(Trim$(Rep))
 RepLn = UCase$(Trim$(RepLn))
Select Case Rep
Case "REP"
  Select Case RepLn
  Case "INSB"
   ScndByte = Chr$(&H6C)
  Case "INSW", "INSD"
   ScndByte = Chr$(&H6D)
  Case "MOVSB"
   ScndByte = Chr$(&HA4)
  Case "MOVSW", "MOVSD"
   ScndByte = Chr$(&HA5)
  Case "OUTSB"
   ScndByte = Chr$(&H6E)
  Case "OUTSW", "OUTSD"
   ScndByte = Chr$(&H6F)
  Case "LODSB"
   ScndByte = Chr$(&HAC)
  Case "LODSW", "LODSD"
   ScndByte = Chr$(&HAD)
  Case "STOSB"
   ScndByte = Chr$(&HAA)
  Case "STOSW", "STOSD"
   ScndByte = Chr$(&HAB)
  Case Else
   MsgBox "Error in REP:" & vbCr & vbTab & "Not supported: " & RepLn & vbCr & vbCr & "Syntax:" & vbCr & vbTab & "REP StringOperation(B/W/D)" & vbCr & " StringOperation - INS, MOVS, OUTS, LODS, STOS"
   Exit Function
  End Select
Case "REPE", "REPZ"
  Select Case RepLn
  Case "CMPSB"
   ScndByte = Chr$(&HA6)
  Case "CMPSW", "CMPSD"
   ScndByte = Chr$(&HA7)
  Case "SCASB"
   ScndByte = Chr$(&HAE)
  Case "SCASW", "SCASD"
   ScndByte = Chr$(&HAF)
  Case Else
   MsgBox "Error in " & Rep & ":" & vbCr & vbTab & "Not supported: " & RepLn & vbCr & vbCr & "Syntax:" & vbCr & vbTab & Rep & " StringOperation(B/W/D)" & vbCr & " StringOperation - CMPS, SCAS"
   Exit Function
  End Select
Case "REPNE", "REPNZ"
  Const FrstB2 As Byte = &HF2
  Select Case RepLn
  Case "CMPSB"
   ScndByte = Chr$(&HA6)
  Case "CMPSW", "CMPSD"
   ScndByte = Chr$(&HA7)
  Case "SCASB"
   ScndByte = Chr$(&HAE)
  Case "SCASW", "SCASD"
   ScndByte = Chr$(&HAF)
  Case Else
   MsgBox "Error in " & Rep & ":" & vbCr & vbTab & "Not supported: " & RepLn & vbCr & vbCr & "Syntax:" & vbCr & vbTab & Rep & " StringOperation(B/W/D)" & vbCr & " StringOperation - CMPS, SCAS"
   Exit Function
  End Select
  REP_Code = Chr$(FrstB2) & ScndByte: Exit Function
End Select
 
REP_Code = Chr$(FrstByte) & ScndByte
End Function

Function FLAGS_Code(ByVal Operation As String) As String
Operation = UCase$(Trim$(Operation))
Select Case Operation
Case "CLC"
 FLAGS_Code = Chr$(&HF8)
Case "STC"
 FLAGS_Code = Chr$(&HF9)
Case "CMC"
 FLAGS_Code = Chr$(&HF5)
Case "CLD"
 FLAGS_Code = Chr$(&HFC)
Case "STD"
 FLAGS_Code = Chr$(&HFD)
Case "CLI"
 FLAGS_Code = Chr$(&HFA)
Case "STI"
 FLAGS_Code = Chr$(&HFB)
Case "LAHF"
 FLAGS_Code = Chr$(&H9F)
Case "SAHF"
 FLAGS_Code = Chr$(&H9E)
Case "PUSHF"
 FLAGS_Code = Chr$(&H66) & Chr$(&H9C)
Case "PUSHFD"
 FLAGS_Code = Chr$(&H9C)
Case "POPF"
 FLAGS_Code = Chr$(&H66) & Chr$(&H9D)
Case "POPFD"
 FLAGS_Code = Chr$(&H9D)
End Select
End Function

Sub COMPILER_CreateCodeProc()
 Dim Push_EBP, Mov_EBPESP, Push_EBX, Push_ESI, Push_EDI
 Push_EBP = Chr$(&H55): Mov_EBPESP = Chr$(&H89) & Chr$(&HE5)
 Push_EBX = Chr$(&H53): Push_ESI = Chr$(&H56): Push_EDI = Chr$(&H57)
  Dim Proc_Begin As String
 Proc_Begin = Push_EBP & _
              Mov_EBPESP & _
              Push_EBX & _
              Push_ESI & _
              Push_EDI
    
 Dim Pop_EDI, Pop_ESI, Pop_EBX, Mov_ESPEBP, Pop_EBP, Ret_10
 Pop_EDI = Chr$(&H5F): Pop_ESI = Chr$(&H5E): Pop_EBX = Chr$(&H5B)
 Mov_ESPEBP = Chr$(&H89) & Chr$(&HEC): Pop_EBP = Chr$(&H5D)
 Ret_10 = Chr$(&HC2) & Chr$(&H10) & Chr$(&H0)
  Dim Proc_End As String
 Proc_End = Pop_EDI & _
            Pop_ESI & _
            Pop_EBX & _
            Mov_ESPEBP & _
            Pop_EBP & _
            Ret_10

code = Proc_Begin & code & Proc_End
End Sub

Function EXITFUNCTION_Code(Optional ByVal BytesToPop As String = "")
 BytesToPop = UCase$(Trim$(BytesToPop))
 If BytesToPop = "" Then BytesToPop = "0"
 If (Not IsNumber(BytesToPop)) Or (Not IsByte(BytesToPop)) Then MsgBox "Error in END/EXIT FUNCTION" & vbCr & vbCr & "USAGE: RET(or EXIT FUNCTION) imm8" & vbCr & "(imm8 will convert to imm16 automaticaly).": Exit Function
 BytesToPop = Tools_Bin2HexDec(BytesToPop)
 If IsNegative(BytesToPop) Then MsgBox "Error in END/EXIT FUNCTION" & vbCr & vbCr & "Signed numbers not supported.": Exit Function
 
  Dim Pop_EDI, Pop_ESI, Pop_EBX, Mov_ESPEBP, Pop_EBP, Ret_imm
 Pop_EDI = Chr$(&H5F): Pop_ESI = Chr$(&H5E): Pop_EBX = Chr$(&H5B)
 Mov_ESPEBP = Chr$(&H89) & Chr$(&HEC): Pop_EBP = Chr$(&H5D)
 'Ret_imm = Chr$(&HC2) & Chr$(&H10) & Chr$(&H0)
 
 'dimMkRet As String
 If BytesToPop = 0 Then
    Ret_imm = Chr$(&HC3)
 Else
    Ret_imm = Chr$(&HC2) & Chr$(Val(BytesToPop)) & Chr$(&H0)
 End If
 
 EXITFUNCTION_Code = Pop_EDI & _
                     Pop_ESI & _
                     Pop_EBX & _
                     Mov_ESPEBP & _
                     Pop_EBP & _
                     Ret_imm
End Function

Function IsNumber(ByVal Value As String) As Boolean
 Value = UCase$(Trim$(Value))
 Value = Tools_Bin2HexDec(Value)
 Call IsNegative(Value)
 If Len(Value) = 0 Then IsNumber = False: Exit Function
 If Left$(Value, 2) = "&H" Then IsNumber = True: Exit Function
 Select Case Asc(Left$(Value, 1))
 Case Asc("0") To Asc("9")
    IsNumber = True
 Case Else
    IsNumber = False
 End Select
End Function

Function INS_Code(ByVal Value As String) As String
 Value = UCase$(Trim$(Value))
 Select Case Value
 Case "INSB"
  INS_Code = Chr$(&H6C)
 Case "INSW"
  INS_Code = Chr$(&H66) & Chr$(&H6D)
 Case "INSD"
  INS_Code = Chr$(&H6D)
 End Select
End Function

Function OUTS_Code(ByVal Value As String) As String
 Value = UCase$(Trim$(Value))
 Select Case Value
 Case "OUTSB"
  OUTS_Code = Chr$(&H6E)
 Case "OUTSW"
  OUTS_Code = Chr$(&H66) & Chr$(&H6F)
 Case "OUTSD"
  OUTS_Code = Chr$(&H6F)
 End Select
End Function

Function LODS_Code(ByVal Value As String) As String
 Value = UCase$(Trim$(Value))
 Select Case Value
 Case "LODSB"
  LODS_Code = Chr$(&HAC)
 Case "LODSW"
  LODS_Code = Chr$(&H66) & Chr$(&HAD)
 Case "LODSD"
  LODS_Code = Chr$(&HAD)
 End Select
End Function

Function MOVS_Code(ByVal Value As String) As String
 Value = UCase$(Trim$(Value))
 Select Case Value
 Case "MOVSB"
  MOVS_Code = Chr$(&HA4)
 Case "MOVSW"
  MOVS_Code = Chr$(&H66) & Chr$(&HA5)
 Case "MOVSD"
  MOVS_Code = Chr$(&HA5)
 End Select
End Function

Function STOS_Code(ByVal Value As String) As String
 Value = UCase$(Trim$(Value))
 Select Case Value
 Case "STOSB"
  STOS_Code = Chr$(&HAA)
 Case "STOSW"
  STOS_Code = Chr$(&H66) & Chr$(&HAB)
 Case "STOSD"
  STOS_Code = Chr$(&HAB)
 End Select
End Function

Function CMPS_Code(ByVal Value As String) As String
 Value = UCase$(Trim$(Value))
 Select Case Value
 Case "CMPSB"
  CMPS_Code = Chr$(&HA6)
 Case "CMPSW"
  CMPS_Code = Chr$(&H66) & Chr$(&HA7)
 Case "CMPSD"
  CMPS_Code = Chr$(&HA7)
 End Select
End Function

Function SCAS_Code(ByVal Value As String) As String
 Value = UCase$(Trim$(Value))
 Select Case Value
 Case "SCASB"
  SCAS_Code = Chr$(&HAE)
 Case "SCASW"
  SCAS_Code = Chr$(&H66) & Chr$(&HAF)
 Case "SCASD"
  SCAS_Code = Chr$(&HAF)
 End Select
End Function

Function Reg8Reg8_Code(ByVal Operand1 As String, ByVal Operand2 As String) As Byte
 '255-Error
 Dim Operand1_Code As Byte, Operand2_Code As Byte
 Operand1_Code = Register8_Code(Operand1)
 Operand2_Code = Register8_Code(Operand2)
 If Operand1_Code = 255 Or Operand2_Code = 255 Then Reg8Reg8_Code = 255: Exit Function
 Reg8Reg8_Code = Operand1_Code * 8 + Operand2_Code
End Function

Function Reg16Reg16_Code(ByVal Operand1 As String, ByVal Operand2 As String) As Byte
 '255-Error
 Dim Operand1_Code As Byte, Operand2_Code As Byte
 Operand1_Code = Register16_Code(Operand1)
 Operand2_Code = Register16_Code(Operand2)
 If Operand1_Code = 255 Or Operand2_Code = 255 Then Reg16Reg16_Code = 255: Exit Function
 Reg16Reg16_Code = Operand1_Code * 8 + Operand2_Code
End Function

Function Reg8Reg32_Code(ByVal Operand1 As String, ByVal Operand2 As String) As Byte
 '255-Error
 Dim Operand1_Code As Byte, Operand2_Code As Byte
 Operand1_Code = Register8_Code(Operand1)
 Operand2_Code = Register_Code(Operand2)
 If Operand1_Code = 255 Or Operand2_Code = 255 Then Reg8Reg32_Code = 255: Exit Function
 Reg8Reg32_Code = Operand1_Code * 8 + Operand2_Code
End Function

Function Reg16Reg32_Code(ByVal Operand1 As String, ByVal Operand2 As String) As Byte
 '255-Error
 Dim Operand1_Code As Byte, Operand2_Code As Byte
 Operand1_Code = Register16_Code(Operand1)
 Operand2_Code = Register_Code(Operand2)
 If Operand1_Code = 255 Or Operand2_Code = 255 Then Reg16Reg32_Code = 255: Exit Function
 Reg16Reg32_Code = Operand1_Code * 8 + Operand2_Code
End Function

Function IsPtr(ByRef Text As String) As Integer
 Text = Trim$(Text)
 
 Dim PtrLength As Integer
 If Left$(UCase$(Text), 8) = "BYTE PTR" Then
    IsPtr = 1
    PtrLength = Len("BYTE PTR")
 ElseIf Left$(UCase$(Text), 8) = "WORD PTR" Then
    IsPtr = 2
    PtrLength = Len("WORD PTR")
 ElseIf Left$(UCase$(Text), 9) = "DWORD PTR" Then
    IsPtr = 3
    PtrLength = Len("DWORD PTR")
 ElseIf Left$(Text, 1) = "[" Then
    IsPtr = 3
    PtrLength = 0
 Else
    IsPtr = 0: Exit Function
 End If
    
 If PtrLength > 0 Then Text = Right$(Text, Len(Text) - PtrLength)
 Text = Trim$(Text)
End Function

Function Reg32PtrReg32_Code(ByVal Operand1 As String, ByVal Operand2 As String) As Byte
 '255-Error
 Dim Operand1_Code As Byte, Operand2_Code As Byte
 Operand1_Code = Register_Code(Operand1)
 Operand2_Code = Register_Code(Operand2)
 If Operand1_Code = 255 Or Operand2_Code = 255 Then Reg32PtrReg32_Code = 255: Exit Function
 Reg32PtrReg32_Code = Operand1_Code + Operand2_Code * 8
End Function

Function Reg32Reg32_Code(ByVal Operand1 As String, ByVal Operand2 As String) As Byte
 '255-Error
 Dim Operand1_Code As Byte, Operand2_Code As Byte
 Operand1_Code = Register_Code(Operand1)
 Operand2_Code = Register_Code(Operand2)
 If Operand1_Code = 255 Or Operand2_Code = 255 Then Reg32Reg32_Code = 255: Exit Function
 Reg32Reg32_Code = Operand1_Code * 8 + Operand2_Code
End Function

Function Reg32Reg32Ptr_Code(ByVal Operand1 As String, ByVal Operand2 As String) As Byte
 '255-Error
 Dim Operand1_Code As Byte, Operand2_Code As Byte
 Operand1_Code = Register_Code(Operand1)
 Operand2_Code = Register_Code(Operand2)
 If Operand1_Code = 255 Or Operand2_Code = 255 Then Reg32Reg32Ptr_Code = 255: Exit Function
 Reg32Reg32Ptr_Code = Operand1_Code + Operand2_Code * 8
End Function

Function Reg32PtrReg8_Code(ByVal Operand1 As String, ByVal Operand2 As String) As Byte
 '255-Error
 Dim Operand1_Code As Byte, Operand2_Code As Byte
 Operand1_Code = Register_Code(Operand1)
 Operand2_Code = Register8_Code(Operand2)
 If Operand1_Code = 255 Or Operand2_Code = 255 Then Reg32PtrReg8_Code = 255: Exit Function
 Reg32PtrReg8_Code = Operand1_Code + Operand2_Code * 8
End Function

Function Reg32PtrReg16_Code(ByVal Operand1 As String, ByVal Operand2 As String) As Byte
 '255-Error
 Dim Operand1_Code As Byte, Operand2_Code As Byte
 Operand1_Code = Register_Code(Operand1)
 Operand2_Code = Register16_Code(Operand2)
 If Operand1_Code = 255 Or Operand2_Code = 255 Then Reg32PtrReg16_Code = 255: Exit Function
 Reg32PtrReg16_Code = Operand1_Code + Operand2_Code * 8
End Function

Public Function IsLabel(ByVal Text As String) As Boolean
 Text = UCase$(Trim$(Text))
 If Len(Text) = 0 Then IsLabel = False: Exit Function
 
 Text = Tools_Bin2HexDec(Text)
 Call IsNegative(Text)
 
 If IsPtr(Text) Then IsLabel = False: Exit Function
 
 If Left$(Text, 2) = "&H" Then IsLabel = False: Exit Function
 If Register8_Code(Text) < 255 Then IsLabel = False: Exit Function
 If Register16_Code(Text) < 255 Then IsLabel = False: Exit Function
 If Register_Code(Text) < 255 Then IsLabel = False: Exit Function
 
 Select Case Asc(Left$(Text, 1))
 Case Asc("A") To Asc("Z")
  IsLabel = True
 Case Else
  IsLabel = False
 End Select
End Function

Function BT_OperatorStep(ByVal Mnemonic As String) As Byte
 BT_OperatorStep = 255
 Mnemonic = UCase$(Trim$(Mnemonic))
 
 Select Case Mnemonic
 Case "BT"
    BT_OperatorStep = &H20
 Case "BTS"
    BT_OperatorStep = &H28
 Case "BTR"
    BT_OperatorStep = &H30
 Case "BTC"
    BT_OperatorStep = &H38
 End Select
End Function

Function BT_OpCodes(ByVal Mnemonic As String, ByVal Op1_Type As String, ByVal Op2_Type As String, ByRef StrRet As String) As Byte
 Mnemonic = UCase$(Trim$(Mnemonic))
 
 Dim OperatorOffset As Byte
 OperatorOffset = BT_OperatorStep(Mnemonic)
 If OperatorOffset = 255 Then MsgBox "Invalid operator: " & Mnemonic: Exit Function

 Dim FirstByte As String * 1
 FirstByte = Chr$(&HF)
 
 Dim Ext16 As String
  Ext16 = Chr$(&H66)
 
 Const R_Offset As Byte = &HC0

 Select Case Op1_Type
 Case "m8", "r8"
    MsgBox "Error in " & Mnemonic & vbCr & "Destination operand to small: " & Op1_Type & vbCr & vbCr & vbTab & "USAGE:" & vbCr & Mnemonic & " r/m16(32),r16(32)": Exit Function
 End Select
 Select Case Op2_Type
 Case "imm16", "imm32"
    MsgBox "Error in " & Mnemonic & vbCr & "Source operand to big: " & Op2_Type & vbCr & vbCr & vbTab & "USAGE:" & vbCr & Mnemonic & " r/m16(32),imm8": Exit Function
 End Select
 
 Const rmr_Start As Byte = &HA3
 Const rmr_ZOffs As Byte = &H20
 Dim rmr_Offset As Byte
 rmr_Offset = OperatorOffset - rmr_ZOffs

 Select Case Op1_Type & Op2_Type
 Case "m16r16"
    StrRet = Ext16 & FirstByte & Chr$(rmr_Start + rmr_Offset)
 Case "r16r16"
    StrRet = Ext16 & FirstByte & Chr$(rmr_Start + rmr_Offset)
    BT_OpCodes = R_Offset
 Case "m32r32"
    StrRet = FirstByte & Chr$(rmr_Start + rmr_Offset)
 Case "r32r32"
    StrRet = FirstByte & Chr$(rmr_Start + rmr_Offset)
    BT_OpCodes = R_Offset
 Case "r16imm8", "m16imm8"
    StrRet = Ext16 & FirstByte & Chr$(&HBA)
    BT_OpCodes = OperatorOffset
 Case "r32imm8", "m32imm8"
    StrRet = FirstByte & Chr$(&HBA)
    BT_OpCodes = OperatorOffset
 Case Else
    MsgBox "Invalid operand(s) in " & Mnemonic & vbCr & vbTab & Op1_Type & "," & Op1_Type & vbCr & vbCr & vbTab & "USAGE:" & vbCr & Mnemonic & " r/m16(32),r16(32)" & vbCr & Mnemonic & " r/m16(32),imm8"
 End Select
End Function
Function Mnemonic_Common_GetOffset(ByVal Operand1 As String, ByVal Operand2 As String) As Byte
 'Different way to know when need to use offset &HC0
 'This function not used and reserved for future
 
 Dim Op1_Type As String, Op2_Type As String
 Op1_Type = Mnemonic_OperandType(Operand1)
 Op2_Type = Mnemonic_OperandType(Operand2)
 
 Select Case Op1_Type & Op2_Type
 Case "m8imm8", "m16imm16", "m32imm32", "r8m8", "r16m16", "r32m32", "m8r8", "m16r16", "m32r32"
    Mnemonic_Common_GetOffset = &H0
 Case "r8imm8", "r16imm16", "r32imm32", "r8r8", "r16r16", "r32r32"
    Mnemonic_Common_GetOffset = &HC0
 End Select
End Function
Function Mnemonic_Common_GetOffset_PtrPlusImm(ByVal Operand As String) As Byte
 Const PtrPlusImm8 = &H40 '[r32+imm8]
 Const PtrPlusImm32 = &H80 '[r32+imm32]
 
 Dim ClearedOperand As String, CO_Flag As Integer, PlusImm As String
 ClearedOperand = COMPILER_CheckOperand(Operand, CO_Flag, PlusImm)
 
 If CO_Flag = 2 Then
    If IsByte(PlusImm) Then
       Mnemonic_Common_GetOffset_PtrPlusImm = PtrPlusImm8
    Else
       Mnemonic_Common_GetOffset_PtrPlusImm = PtrPlusImm32
    End If
 End If
 
End Function

Function Mnemonic_Common_Generator(ByVal Mnemonic As String, ByVal Operand1 As String, ByVal Operand2 As String) As String
 On Error GoTo Rt_err
 
 ' Change label name to imm32
 If IsLabel(Operand2) Then
    Operand2 = "0&"
 End If
 
 Dim PtrPlusImm_Offset As Byte
 
 Dim Op1_Type As String, Op2_Type As String
 Op1_Type = Mnemonic_OperandType(Operand1)
 Op2_Type = Mnemonic_OperandType(Operand2)
 
 Select Case Mnemonic
 Case "BT", "BTS", "BTR", "BTC"
  Dim ImmZ_Type As String
  ImmZ_Type = Tools_ImmTypeID(Operand2)
  If Len(ImmZ_Type) > 0 Then
   Select Case ImmZ_Type
   Case "imm16", "imm32"
    MsgBox "Error in " & Mnemonic & vbCr & "Invalid immediate identifier" & vbCr & vbCr & vbTab & "USAGE:" & vbCr & Mnemonic & " r/m16(32),imm8": Exit Function
   End Select
  End If
 Case "IN", "BSF", "BSR", "BOUND", "CMPXCHG", "XCHG", "LAR"
 Case Else
  Op2_Type = Mnemonic_Common_CorrectImm(Op1_Type, Op2_Type, Operand2)
 End Select
 
 Select Case Mnemonic
 Case "MOVZX", "MOVSX"
 Case Else
    Mnemonic_Common_CorrectMem Op1_Type, Op2_Type
 End Select
 
 Dim IsBWDPTR1 As Integer, IsBWDPTR2 As Integer
 'IsBWDPTR: 0-Nothing, 1-Byte Ptr, 2-Word Ptr, 3-Dword Ptr
 IsBWDPTR1 = IsPtr(Operand1): IsBWDPTR2 = IsPtr(Operand2)
 If IsBWDPTR1 > 0 And IsBWDPTR2 > 0 Then
    MsgBox vbTab & "Not Supported:" & vbCr & Mnemonic & " " & Op1_Type & ", " & Op2_Type
    Mnemonic_Common_Generator = "": Exit Function
 End If
 
 Dim Operand1_Flag As Integer, Operand1_Value As String, Operand1_AddValue As String
 Dim Operand2_Flag As Integer, Operand2_Value As String, Operand2_AddValue As String
 Operand1_Value = COMPILER_CheckOperand(Operand1, Operand1_Flag, Operand1_AddValue)
 Operand2_Value = COMPILER_CheckOperand(Operand2, Operand2_Flag, Operand2_AddValue)
 
 If IsBWDPTR1 > 0 Then
    PtrPlusImm_Offset = Mnemonic_Common_GetOffset_PtrPlusImm(Operand1)
    HiLevel_Correct_PtrPlusImm PtrPlusImm_Offset, Operand1_AddValue
 ElseIf IsBWDPTR2 > 0 Then
    PtrPlusImm_Offset = Mnemonic_Common_GetOffset_PtrPlusImm(Operand2)
    HiLevel_Correct_PtrPlusImm PtrPlusImm_Offset, Operand2_AddValue
 End If

 Const PtrPlusImm8 = &H40 '[r32+imm8]
 Const PtrPlusImm32 = &H80 '[r32+imm32]
 Dim PtrPlusImm As String
 If IsBWDPTR1 > 0 And PtrPlusImm_Offset > 0 Then
    If PtrPlusImm_Offset = PtrPlusImm8 Then
        PtrPlusImm = TOOLS_Number2Byte(Operand1_AddValue)
    ElseIf PtrPlusImm_Offset = PtrPlusImm32 Then
        PtrPlusImm = TOOLS_Number2Machine(Operand1_AddValue)
    End If
 ElseIf IsBWDPTR2 > 0 And PtrPlusImm_Offset > 0 Then
    If PtrPlusImm_Offset = PtrPlusImm8 Then
        PtrPlusImm = TOOLS_Number2Byte(Operand2_AddValue)
    ElseIf PtrPlusImm_Offset = PtrPlusImm32 Then
        PtrPlusImm = TOOLS_Number2Machine(Operand2_AddValue)
    End If
 End If

 Dim Local_Offset As Byte
 Local_Offset = Mnemonic_Common_LocalOffset(Op1_Type, Op2_Type, Operand1_Value, Operand2_Value)
 Select Case Mnemonic
 Case "MOV"
  If Op1_Type & Op2_Type = "r32r32" Then Local_Offset = Reg32PtrReg32_Code(Operand1_Value, Operand2_Value)
 End Select
 '
 
 Dim Op3_Type As String, Operand3_Value As String
 Dim Imm As String
 If Left$(Op1_Type, 3) = "imm" Then
    Op3_Type = Op1_Type
    Operand3_Value = Operand1_Value
 ElseIf Left$(Op2_Type, 3) = "imm" Then
    Op3_Type = Op2_Type
    Operand3_Value = Operand2_Value
 End If
 If Op3_Type = "imm8" And IsByte(Operand3_Value) Then
    Imm = TOOLS_Number2Byte(Operand3_Value)
 ElseIf Op3_Type = "imm8" And Not IsByte(Operand3_Value) Then
    MsgBox "imm8 is out of range", 48, Mnemonic & " " & Operand1 & "," & Operand2: Mnemonic_Common_Generator = "": Exit Function
 ElseIf Op3_Type = "imm16" And IsWord(Operand3_Value) Then
    Imm = TOOLS_Number2Word(Operand3_Value)
 ElseIf Op3_Type = "imm16" And Not IsWord(Operand3_Value) Then
    MsgBox "imm16 is out of range", 48, Mnemonic & " " & Operand1 & "," & Operand2: Mnemonic_Common_Generator = "": Exit Function
 ElseIf Op3_Type = "imm32" And IsNumber(Operand3_Value) Then
    Imm = TOOLS_Number2Machine(Operand3_Value)
 ElseIf Op3_Type = "imm32" And Not IsNumber(Operand3_Value) Then
    MsgBox "Not a valid imm32", 48, Mnemonic & " " & Operand1 & "," & Operand2: Mnemonic_Common_Generator = "": Exit Function
 End If

 'AL,AX,EAX have different opcodes for imm then other register's
 If IsBWDPTR1 = 0 And Operand1_Flag = 0 Then
    If Op2_Type = "imm8" Or Op2_Type = "imm16" Or Op2_Type = "imm32" Then
     If Register8_Code(Operand1) = 0 Then
        Op1_Type = "AL"
     ElseIf Register16_Code(Operand1) = 0 Then
        Op1_Type = "AX"
     ElseIf Register_Code(Operand1) = 0 Then
        Op1_Type = "EAX"
     End If
    End If
 End If
 
 'In present time i bad know what is mod/rm. When you use ESP as pointer, you must add byte with value &H24
 'Pointer to EBP - it is pointer to imm32. [imm32] not currently supported. [EBP] must be changed to [EBP+00]
 Dim Const_mESP As String
 If Op1_Type = "m8" Or Op1_Type = "m16" Or Op1_Type = "m32" Then
    If Register_Code(Operand1_Value) = 4 Then Const_mESP = Chr$(&H24)
    If Register_Code(Operand1_Value) = 5 And Operand1_AddValue = "" Then
        PtrPlusImm_Offset = PtrPlusImm8
        Operand1_AddValue = "0"
        PtrPlusImm = TOOLS_Number2Byte(Operand1_AddValue)
    End If
 End If
 If Op2_Type = "m8" Or Op2_Type = "m16" Or Op2_Type = "m32" Then
    If Register_Code(Operand2_Value) = 4 Then Const_mESP = Chr$(&H24)
    If Register_Code(Operand2_Value) = 5 And Operand2_AddValue = "" Then
        PtrPlusImm_Offset = PtrPlusImm8
        Operand2_AddValue = "0"
        PtrPlusImm = TOOLS_Number2Byte(Operand2_AddValue)
    End If
 End If
 
 Dim Const_Opcodes As String, Variable_Opcodes As Byte
 
 ' Warning !!!
 'Function Mnemonic_Common_OpCodes returns Error 6 (Overflow) when:
 ' "Compile to Native Code" with "Optimize for Fast Code" or "Optimize for Small Code"
 'For compile to 'Native Code' use "No Optimization" option.
 
 Select Case Mnemonic
 Case "ADD", "OR", "ADC", "SBB", "AND", "SUB", "XOR", "CMP"
  Variable_Opcodes = Mnemonic_Common_OpCodes(Mnemonic, Op1_Type, Op2_Type, Const_Opcodes)
 Case "MOV"
  Variable_Opcodes = Mov_OpCodes(Op1_Type, Op2_Type, Const_Opcodes)
 Case "BT", "BTS", "BTR", "BTC"
  Variable_Opcodes = BT_OpCodes(Mnemonic, Op1_Type, Op2_Type, Const_Opcodes)
  Select Case Op1_Type & Op2_Type
  Case "m32r32", "r32r32"
   Local_Offset = Reg32Reg32Ptr_Code(Operand1_Value, Operand2_Value)
  Case "m32imm8", "m16imm8"
   Local_Offset = Register_Code(Operand1_Value)
  End Select
 Case "IN"
  Variable_Opcodes = IN_OpCodes(Op1_Type, Op2_Type, Const_Opcodes)
  Mnemonic_Common_Generator = Const_Opcodes & Imm
  Exit Function
 Case "OUT"
  Variable_Opcodes = OUT_OpCodes(Op1_Type, Op2_Type, Const_Opcodes)
  Mnemonic_Common_Generator = Const_Opcodes & Imm
  Exit Function
 Case "LEA"
  Variable_Opcodes = LEA_OpCodes(Op1_Type, Op2_Type, Const_Opcodes)
  If Local_Offset = 0 Then
     If Register16_Code(Operand1_Value) > 0 Or Register16_Code(Operand2_Value) > 0 Or Register_Code(Operand1_Value) > 0 Or Register_Code(Operand2_Value) > 0 Then
        If Len(Const_Opcodes) = 0 Then MsgBox "Error in LEA." & vbCr & vbCr & " Invalid pointer: " & Op2_Type: Exit Function
     End If
  End If
 Case "TEST"
  Variable_Opcodes = TEST_OpCodes(Op1_Type, Op2_Type, Const_Opcodes)
 Case "MOVZX", "MOVSX"
  Variable_Opcodes = MOVZXSX_OpCodes(Mnemonic, Op1_Type, Op2_Type, Const_Opcodes, Operand1_Value, Operand2_Value)
 Case "BSF", "BSR"
  Local_Offset = 0
  Variable_Opcodes = BSFR_OpCodes(Mnemonic, Op1_Type, Op2_Type, Const_Opcodes, Operand1_Value, Operand2_Value)
 Case "BOUND"
  Variable_Opcodes = BOUND_OpCodes(Op1_Type, Op2_Type, Const_Opcodes)
 Case "CMPXCHG"
  Variable_Opcodes = CMPXCHG_OpCodes(Op1_Type, Op2_Type, Const_Opcodes)
 Case "XCHG"
  Variable_Opcodes = XCHG_OpCodes(Op1_Type, Op2_Type, Const_Opcodes)
 Case "LAR"
  Variable_Opcodes = LAR_OpCodes(Op1_Type, Op2_Type, Const_Opcodes)
 End Select
 Mnemonic_Common_Generator = Const_Opcodes & Chr$(Variable_Opcodes + Local_Offset + PtrPlusImm_Offset) & Const_mESP & PtrPlusImm & Imm
 Exit Function
 
Rt_err:
 MsgBox Error$(Err) & vbCr & vbCr & Mnemonic & " " & Operand1 & "," & Operand2, , Err
 Resume Next
End Function

Function Mnemonic_Common_LocalOffset(ByVal Op1_Type As String, ByVal Op2_Type As String, ByVal Operand1_Value As String, ByVal Operand2_Value As String) As Byte
 Select Case Op1_Type & Op2_Type
 Case "r8imm8"
  Mnemonic_Common_LocalOffset = Register8_Code(Operand1_Value)
 Case "r16imm16", "r16imm8"
  Mnemonic_Common_LocalOffset = Register16_Code(Operand1_Value)
 Case "r32imm32", "r32imm8", "r32imm16"
  Mnemonic_Common_LocalOffset = Register_Code(Operand1_Value)
 Case "m8imm8", "m16imm16", "m32imm32"
  Mnemonic_Common_LocalOffset = Register_Code(Operand1_Value)
 Case "m8r8"
  Mnemonic_Common_LocalOffset = Reg32PtrReg8_Code(Operand1_Value, Operand2_Value)
 Case "m16r16"
  Mnemonic_Common_LocalOffset = Reg32PtrReg16_Code(Operand1_Value, Operand2_Value)
 Case "m32r32"
  Mnemonic_Common_LocalOffset = Reg32PtrReg32_Code(Operand1_Value, Operand2_Value)
 Case "r8r8"
  Mnemonic_Common_LocalOffset = Reg8Reg8_Code(Operand1_Value, Operand2_Value)
 Case "r16r16"
  Mnemonic_Common_LocalOffset = Reg16Reg16_Code(Operand1_Value, Operand2_Value)
 Case "r32r32"
  Mnemonic_Common_LocalOffset = Reg32Reg32_Code(Operand1_Value, Operand2_Value)
 Case "r8m8"
  Mnemonic_Common_LocalOffset = Reg8Reg32_Code(Operand1_Value, Operand2_Value)
 Case "r16m16"
  Mnemonic_Common_LocalOffset = Reg16Reg32_Code(Operand1_Value, Operand2_Value)
 Case "r32m32"
  Mnemonic_Common_LocalOffset = Reg32Reg32_Code(Operand1_Value, Operand2_Value)
 'Case Else
 ' MsgBox "Invalid Operand" & vbCr & "Operator " & Op1_Type & "," & Op2_Type, , "Mnemonic_Common_LocalOffset"
 End Select
End Function
Function Mnemonic_Common_OperatorStep(ByVal Operator As String) As Byte
 '255 - Error
 Mnemonic_Common_OperatorStep = 255
 Operator = UCase$(Trim$(Operator))
 
 Select Case Operator
 Case "ADD", "MOV"
  Mnemonic_Common_OperatorStep = &H0
 Case "OR"
  Mnemonic_Common_OperatorStep = &H8
 Case "ADC"
  Mnemonic_Common_OperatorStep = &H10
 Case "SBB"
  Mnemonic_Common_OperatorStep = &H18
 Case "AND"
  Mnemonic_Common_OperatorStep = &H20
 Case "SUB"
  Mnemonic_Common_OperatorStep = &H28
 Case "XOR"
  Mnemonic_Common_OperatorStep = &H30
 Case "CMP"
  Mnemonic_Common_OperatorStep = &H38
 Case "BT", "BTS", "BTR", "BTC"
  Mnemonic_Common_OperatorStep = BT_OperatorStep(Operator)
 End Select
End Function
Function Mnemonic_OperandType(ByVal Operand As String) As String
 Operand = UCase$(Trim$(Operand))
 
 Dim Operand1_Flag As Integer, Operand1_Value As String, Operand1_AddValue As String
 
 Dim IsBWDPTR1 As Integer
 'IsBWDPTR: 0-Nothing, 1-Byte Ptr, 2-Word Ptr, 3-Dword Ptr
 If Left$(Operand, 8) = "BYTE PTR" Then
    IsBWDPTR1 = IsPtr(Operand)
    Operand1_Value = COMPILER_CheckOperand(Operand, Operand1_Flag, Operand1_AddValue)
    If Register_Code(Operand1_Value) < 255 Then Mnemonic_OperandType = "m8"
    Exit Function
 ElseIf Left$(Operand, 8) = "WORD PTR" Then
    IsBWDPTR1 = IsPtr(Operand)
    Operand1_Value = COMPILER_CheckOperand(Operand, Operand1_Flag, Operand1_AddValue)
    If Register_Code(Operand1_Value) < 255 Then Mnemonic_OperandType = "m16"
    Exit Function
 ElseIf Left$(Operand, 9) = "DWORD PTR" Or Left$(Operand, 1) = "[" Then
    IsBWDPTR1 = IsPtr(Operand)
    Operand1_Value = COMPILER_CheckOperand(Operand, Operand1_Flag, Operand1_AddValue)
    If Register_Code(Operand1_Value) < 255 Then Mnemonic_OperandType = "m32"
    Exit Function
 End If
 
 If Register8_Code(Operand) < 255 Then Mnemonic_OperandType = "r8": Exit Function
 If Register16_Code(Operand) < 255 Then Mnemonic_OperandType = "r16": Exit Function
 If Register_Code(Operand) < 255 Then Mnemonic_OperandType = "r32": Exit Function
 
 If IsNumber(Operand) Then
    If IsByte(Operand) Then Mnemonic_OperandType = "imm8": Exit Function
    If IsWord(Operand) Then Mnemonic_OperandType = "imm16": Exit Function
    Mnemonic_OperandType = "imm32": Exit Function
 End If
 
 If IsLabel(Operand) Then Mnemonic_OperandType = "imm32": Exit Function
End Function

Function Mnemonic_Common_OpCodes(ByVal Mnemonic As String, ByVal Op1_Type As String, ByVal Op2_Type As String, ByRef StrRet As String) As Byte
 'ADD,OR,ADC,SBB,AND,SUB,XOR,CMP
 
 Dim OperatorOffset As Byte
 OperatorOffset = Mnemonic_Common_OperatorStep(Mnemonic)
 If OperatorOffset = 255 Then MsgBox "Invalid operator: " & Mnemonic: Exit Function
 
 Dim Ext16 As String
  Ext16 = Chr$(&H66)
 
 Const R_Offset As Byte = &HC0
 
 Const m8r8 As Byte = &H0 '&H0
 'Const r8r8 As Byte = m8r8 '&HC0
 Const r8m8 As Byte = &H2 '&H0
 Const r8r8 As Byte = r8m8 '&HC0
 
 Const m32r32 As Byte = &H1 '&H0
 Const r32m32 As Byte = &H3 '&H0
 'Const r32r32 As Byte = m32r32 '&HC0
 Const r32r32 As Byte = r32m32 '&HC0
 
 Const m8imm8 As Byte = &H80 '&H0
 Const r8imm8 As Byte = m8imm8 '&HC0
 
 Const m32imm32 As Byte = &H81 '&H0
 Const r32imm32 As Byte = m32imm32 '&HC0
 
 Const S_m32imm8 As Byte = &H83 '&H0 /sign-extended
 Const S_r32imm8 As Byte = S_m32imm8 '&HC0 /sign-extended

 Const ALimm8 As Byte = &H4
 Const EAXimm32 As Byte = &H5

 Select Case Op1_Type & Op2_Type
 Case "m8r8"
  StrRet = Chr$(m8r8 + OperatorOffset)
 Case "r8r8"
  StrRet = Chr$(r8r8 + OperatorOffset)
  Mnemonic_Common_OpCodes = R_Offset
 Case "m16r16"
  StrRet = Ext16 & Chr$(m32r32 + OperatorOffset)
 Case "r16r16"
  StrRet = Ext16 & Chr$(r32r32 + OperatorOffset)
  Mnemonic_Common_OpCodes = R_Offset
 Case "m32r32"
  StrRet = Chr$(m32r32 + OperatorOffset)
 Case "r32r32"
  StrRet = Chr$(r32r32 + OperatorOffset)
  Mnemonic_Common_OpCodes = R_Offset
 Case "r8m8"
  StrRet = Chr$(r8m8 + OperatorOffset)
  Case "r16m16"
  StrRet = Ext16 & Chr$(r32m32 + OperatorOffset)
  Case "r32m32"
  StrRet = Chr$(r32m32 + OperatorOffset)
 Case "m8imm8"
  StrRet = Chr$(m8imm8)
  Mnemonic_Common_OpCodes = OperatorOffset
 Case "r8imm8"
  StrRet = Chr$(r8imm8)
  Mnemonic_Common_OpCodes = R_Offset + OperatorOffset
 Case "m16imm16"
  StrRet = Ext16 & Chr$(m32imm32)
  Mnemonic_Common_OpCodes = OperatorOffset
 Case "m32imm32"
  StrRet = Chr$(m32imm32)
  Mnemonic_Common_OpCodes = OperatorOffset
 Case "r16imm16"
  StrRet = Ext16 & Chr$(r32imm32)
  Mnemonic_Common_OpCodes = R_Offset + OperatorOffset
 Case "r32imm32"
  StrRet = Chr$(r32imm32)
  Mnemonic_Common_OpCodes = R_Offset + OperatorOffset
 Case "ALimm8"
  Mnemonic_Common_OpCodes = ALimm8 + OperatorOffset
 Case "AXimm16", "AXimm8"
  StrRet = Ext16
  Mnemonic_Common_OpCodes = EAXimm32 + OperatorOffset
 Case "EAXimm32", "EAXimm16", "EAXimm8"
  Mnemonic_Common_OpCodes = EAXimm32 + OperatorOffset
 Case Else
  MsgBox "Invalid operand(s)" & vbCr & Mnemonic & " " & Op1_Type & "," & Op2_Type
 End Select
End Function

Function Mnemonic_Common_CorrectImm(Op1_Type, Op2_Type, ByVal Operand2 As String) As String
Mnemonic_Common_CorrectImm = Op2_Type
 
 Dim NeedCorrect As Boolean
 Select Case Op2_Type
 Case "imm8", "imm16", "imm32"
  NeedCorrect = True
 End Select
If Not NeedCorrect Then Exit Function
 
 Dim Imm_Type As String
 Imm_Type = Tools_ImmTypeID(Operand2)
 If Len(Imm_Type) > 0 Then
  Select Case Imm_Type
  Case "imm8"
   If Left$(Op1_Type, 1) = "m" Then Op1_Type = "m8": Mnemonic_Common_CorrectImm = "imm8": Exit Function
  Case "imm16"
   If Left$(Op1_Type, 1) = "m" Then Op1_Type = "m16": Mnemonic_Common_CorrectImm = "imm16": Exit Function
  Case "imm32"
   If Left$(Op1_Type, 1) = "m" Then Op1_Type = "m32": Mnemonic_Common_CorrectImm = "imm32": Exit Function
  End Select
 End If
 
 Select Case Op1_Type
 Case "m16", "r16"
    Mnemonic_Common_CorrectImm = "imm16"
 Case "m32", "r32"
    Mnemonic_Common_CorrectImm = "imm32"
 End Select
End Function
Function Mnemonic_Common_CorrectMem(Op1_Type, Op2_Type) As String
 Select Case Op1_Type
 Case "r8", "r16", "r32"
    If Left$(Op2_Type, 1) = "m" Then
        Op2_Type = "m" & Right$(Op1_Type, Len(Op1_Type) - 1)
        Exit Function
    End If
 End Select
 Select Case Op2_Type
 Case "r8", "r16", "r32"
    If Left$(Op1_Type, 1) = "m" Then
        Op1_Type = "m" & Right$(Op2_Type, Len(Op2_Type) - 1)
        Exit Function
    End If
 End Select
 
End Function

Function Mnemonic_IsCommon(ByVal CmdLine As String) As Boolean
 'ADD,OR,ADC,SBB,AND,SUB,XOR,CMP
 CmdLine = UCase$(Trim$(CmdLine))
 Select Case Left$(CmdLine, 4)
 Case "ADD ", "ADC ", "SBB ", "AND ", "SUB ", "XOR ", "CMP "
  Mnemonic_IsCommon = True
 Case Else
  If Left$(CmdLine, 3) = "OR " Then Mnemonic_IsCommon = True
 End Select
End Function

Function Mnemonic_Common_Lbl2Addr(ByVal CmdLine, ByVal Curr_IP As Long, Optional ByVal AutoCreateProc As Boolean = True) As String
 CmdLine = Trim$(CmdLine)
 
 Dim MnmEnd_Pos As Integer: MnmEnd_Pos = InStr(1, CmdLine, " ")
 If MnmEnd_Pos = 0 Then MsgBox "Syntax error:" & vbCr & vbTab & CmdLine, 16, "Label addres": Exit Function
 
 Dim tmp_CmdLine As String
 tmp_CmdLine = Right$(CmdLine, Len(CmdLine) - MnmEnd_Pos): tmp_CmdLine = Trim$(tmp_CmdLine)
 
 Dim Operands() As String
 Operands = Split(tmp_CmdLine, ",")
 If UBound(Operands) < 1 Then MsgBox "Syntax error:" & vbCr & vbTab & CmdLine, 16, "Label addres": Exit Function
 
 Operands(1) = UCase$(Trim$(Operands(1)))
 If Not IsLabel(Operands(1)) Then Exit Function
 
 Dim LabelAddr As Long
 LabelAddr = COMPILER_FindLabelAddr(Operands(1))
 If LabelAddr = -1 Then MsgBox "Label not found: " & Operands(1): Exit Function
 
 Dim MnemoCode As String, Mnemonic As String
 Mnemonic = Left$(CmdLine, MnmEnd_Pos): Mnemonic = UCase$(Trim$(Mnemonic))
 MnemoCode = Mnemonic_Common_Generator(Mnemonic, Operands(0), "0")
 If Len(MnemoCode) = 0 Then MsgBox "Syntax error:" & vbCr & vbTab & CmdLine, 16, "Label addres": Exit Function
 
 If Len(MnemoCode) - 1 < 4 Then MsgBox "Invalid use of label:" & vbCr & vbTab & CmdLine, 16, "Label addres": Exit Function

 Dim Op1_Type As String
 Op1_Type = Mnemonic_OperandType(Operands(0))
 
 Select Case Op1_Type
 Case "m8", "m16", "r8", "r16", "imm8", "imm16"
  MsgBox "Invalid usage of label:" & vbCr & vbTab & CmdLine & vbCr & vbCr & "Destination too short:" & vbCr & vbTab & Op1_Type, 16, "Label addres": Exit Function
 End Select
 
 Dim AfterPrepare As Byte ' length of top part of COMPILER_CreateCodeProc
 If AutoCreateProc Then AfterPrepare = 6
 
 Mid$(code, (Curr_IP + (Len(MnemoCode) - 4)) + 1, 4) = TOOLS_Number2Machine(LabelAddr + AfterPrepare)
 Dim MnmLen As Integer
 MnmLen = Len(MnemoCode) - 4
 Mnemonic_Common_Lbl2Addr = Mid$(code, (Curr_IP + 1), MnmLen) & TOOLS_Number2Machine(LabelAddr + AfterPrepare)

End Function

Function Mnemonic_PtrPlusImm_Create(ByVal PtrPlusImm_Offset, ByVal Operand1_AddValue) As String
 Const PtrPlusImm8 = &H40 '[r32+imm8]
 Const PtrPlusImm32 = &H80 '[r32+imm32]
    If PtrPlusImm_Offset = PtrPlusImm8 Then
        Mnemonic_PtrPlusImm_Create = TOOLS_Number2Byte(Operand1_AddValue)
    ElseIf PtrPlusImm_Offset = PtrPlusImm32 Then
        Mnemonic_PtrPlusImm_Create = TOOLS_Number2Machine(Operand1_AddValue)
    End If
End Function
Function SingleOperand_Generator(ByVal Mnemonic As String, ByVal Operand1 As String, Optional ByVal Operand2 As String) As String
 Dim Op1_Type As String
 Op1_Type = Mnemonic_OperandType(Operand1)
 
 Select Case Op1_Type
 Case "imm8", "imm16", "imm32"
  SingleOperand_Generator = SingleOperand_Generator_Imm(Mnemonic, Operand1)
  Exit Function
 End Select
 
 'IsBWDPTR: 0-Nothing, 1-Byte Ptr, 2-Word Ptr, 3-Dword Ptr
 Dim IsBWDPTR1 As Integer: IsBWDPTR1 = IsPtr(Operand1)

 Dim PtrPlusImm_Offset As Byte
 If IsBWDPTR1 > 0 Then PtrPlusImm_Offset = Mnemonic_Common_GetOffset_PtrPlusImm(Operand1)

 Dim Operand1_Flag As Integer, Operand1_Value As String, Operand1_AddValue As String
 Operand1_Value = COMPILER_CheckOperand(Operand1, Operand1_Flag, Operand1_AddValue)

 Const PtrPlusImm8 = &H40 '[r32+imm8]
 Const PtrPlusImm32 = &H80 '[r32+imm32]
 Dim PtrPlusImm As String
 If IsBWDPTR1 > 0 And PtrPlusImm_Offset > 0 Then
  HiLevel_Correct_PtrPlusImm PtrPlusImm_Offset, Operand1_AddValue
  PtrPlusImm = Mnemonic_PtrPlusImm_Create(PtrPlusImm_Offset, Operand1_AddValue)
 End If
 
 Dim Const_mESP As String
 If Op1_Type = "m8" Or Op1_Type = "m16" Or Op1_Type = "m32" Then
    If Register_Code(Operand1_Value) = 4 Then Const_mESP = Chr$(&H24) 'Add byte Mod/Rm
    If Register_Code(Operand1_Value) = 5 And Operand1_AddValue = "" Then
        PtrPlusImm_Offset = PtrPlusImm8 'Change [EBP] to [EBP+00]
        Operand1_AddValue = "0"
        PtrPlusImm = TOOLS_Number2Byte(Operand1_AddValue)
    End If
 End If

 Dim Local_Offset As Byte
 Select Case Op1_Type
 Case "r8"
  Local_Offset = Register8_Code(Operand1_Value)
 Case "r16"
  Local_Offset = Register16_Code(Operand1_Value)
 Case "m8", "m16", "m32", "r32"
  Local_Offset = Register_Code(Operand1_Value)
 Case Else
  MsgBox "Invalid operand: " & Operand1_Value & "(" & Op1_Type & ")" & vbCr & vbCr & "Supported: " & vbCr & vbTab & Mnemonic & " r/m8(16,32)"
  SingleOperand_Generator = "": Exit Function
 End Select
 If Local_Offset = 255 Then MsgBox "Invalid operand: " & Operand1_Value, , Mnemonic: SingleOperand_Generator = "": Exit Function
 
 Dim Const_Opcodes As String, Variable_Opcodes As Byte
 Select Case Mnemonic
 Case "NOT", "NEG", "MUL", "IMUL", "DIV", "IDIV"
  Variable_Opcodes = SingleOperand_OpCodes(Mnemonic, Op1_Type, Const_Opcodes)
 Case "INC", "DEC", "CALL", "JMP", "PUSH"
  Variable_Opcodes = SingleOperand2_OpCodes(Mnemonic, Op1_Type, Const_Opcodes)
 Case "ROL", "ROR", "RCL", "RCR", "SHL", "SAL", "SHR", "SAR"
  Variable_Opcodes = SingleOperand3_OpCodes(Mnemonic, Op1_Type, Operand2, Const_Opcodes)
 Case "VERR", "VERW"
  Variable_Opcodes = VERRW_OpCodes(Mnemonic, Op1_Type, Const_Opcodes)
 Case SET_IsSet(Mnemonic)
  Variable_Opcodes = SET_OpCodes(Mnemonic, Op1_Type, Const_Opcodes)
 Case "POP"
  Variable_Opcodes = POP_OpCodes(Op1_Type, Const_Opcodes)
 End Select
 If Len(Const_Opcodes) = 0 And Variable_Opcodes = 0 Then SingleOperand_Generator = "": Exit Function
 SingleOperand_Generator = Const_Opcodes & Chr$(Variable_Opcodes + Local_Offset + PtrPlusImm_Offset) & Const_mESP & PtrPlusImm '& Imm - no imm
End Function

Function SingleOperand3_Generator(ByVal Operand2 As String) As String
 If Len(Operand2) = 0 Then SingleOperand3_Generator = "1": Exit Function
 
 Dim Op2_Type As String
 Op2_Type = Mnemonic_OperandType(Operand2)
 Select Case Op2_Type
 Case "imm8"
  If Val(Operand2) = 1 Then
    SingleOperand3_Generator = "1"
  Else
    SingleOperand3_Generator = "imm8"
  End If
 Case "r8"
  If Register8_Code(Operand2) = 1 Then SingleOperand3_Generator = "CL"
 End Select
End Function
Function SingleOperand30_Generator(ByVal Mnemonic As String, ByVal Operand1 As String, ByVal Operand2 As String) As String
 Mnemonic = UCase$(Trim$(Mnemonic))
 
 Dim CmnSingle As String
 CmnSingle = SingleOperand_Generator(Mnemonic, Operand1, Operand2)
 If CmnSingle = "" Then Exit Function
 
 Dim Operand1_Ext As String
 Operand1_Ext = SingleOperand3_Generator(Operand2)
 If Operand1_Ext = "imm8" Then CmnSingle = CmnSingle & TOOLS_Number2Byte(Operand2)
 
 SingleOperand30_Generator = CmnSingle
End Function

Function INT_Code(ByVal Number As String)
 
 Dim Imm_Type As String
 Imm_Type = Tools_ImmTypeID(Number)
 If Len(Imm_Type) > 0 Then
    If Imm_Type <> "imm8" Then MsgBox "Invalid type identifier" & vbCr & vbCr & vbTab & "Usage:" & vbCr & "INT imm8": Exit Function
    If Imm_Type = "imm8" And Not IsByte(Number) Then MsgBox "Out of Byte", , "INT " & Number: Exit Function
 End If
 
 If Len(Imm_Type) = 0 Then Imm_Type = Mnemonic_OperandType(Number)
 If Imm_Type <> "imm8" Then MsgBox "Invalid operand: " & Number & vbCr & vbCr & vbTab & "Usage:" & vbCr & "INT imm8": Exit Function
 
 If Val(Number) = 3 Then
    INT_Code = Chr$(&HCC)
 Else
    INT_Code = Chr$(&HCD) & TOOLS_Number2Byte(Number)
 End If
 
End Function

Function BSWAP_Code(ByVal RegisterName As String)
 RegisterName = UCase$(Trim$(RegisterName))
 Const Byte1BSWAP As Byte = &HF
 Const BeginBSWAP As Byte = &HC8
 If Register_Code(RegisterName) <> 255 Then
    BSWAP_Code = Chr$(Byte1BSWAP) & Chr$(BeginBSWAP + Register_Code(RegisterName))
 End If
End Function

Function SingleOperand_Generator_Imm(ByVal Mnemonic As String, ByVal Value As String) As String
 If IsLabel(Value) Then Value = "0&"
 
 Dim Imm_Type As String
 Imm_Type = Tools_ImmAutoType(Value)
 
 Dim Imm2_Type As String
 Imm2_Type = Tools_ImmTypeID(Value) 'Check for type identifier (?-Byte/imm8,%-Word/imm16,&-Dword/imm32)
 If Len(Imm2_Type) > 0 Then Imm_Type = Imm2_Type
 
 Dim Const_OpCode As String
 Const_OpCode = SingleOperand_Imm_Opcode(Mnemonic, Imm_Type)
 If Len(Const_OpCode) = 0 Then SingleOperand_Generator_Imm = "": Exit Function
 
 Dim Imm_Code As String
 Select Case Imm_Type
 Case "imm8"
    If Not IsByte(Value) Then MsgBox "Out of Byte", , Mnemonic & " " & Value: SingleOperand_Generator_Imm = "": Exit Function
    Imm_Code = TOOLS_Number2Byte(Value)
 Case "imm16"
    If Not IsWord(Value) Then MsgBox "Out of Word", , Mnemonic & " " & Value: SingleOperand_Generator_Imm = "": Exit Function
    Imm_Code = TOOLS_Number2Word(Value)
 Case "imm32"
    If Not IsNumber(Value) Then MsgBox "Out of Dword", , Mnemonic & " " & Value: SingleOperand_Generator_Imm = "": Exit Function
    Imm_Code = TOOLS_Number2Machine(Value)
 End Select
 
 SingleOperand_Generator_Imm = Const_OpCode & Imm_Code
End Function
Function SingleOperand_Imm_Opcode(ByVal Mnemonic As String, ByVal Imm_Type As String) As String
 Dim Ext16 As String * 1: Ext16 = Chr$(&H66)
 
 Select Case Mnemonic
 Case "JMP"
  Select Case Imm_Type
  Case "imm8"
    SingleOperand_Imm_Opcode = Chr$(&HEB)
  Case "imm16"
    SingleOperand_Imm_Opcode = Ext16 & Chr$(&HE9)
  Case "imm32"
    SingleOperand_Imm_Opcode = Chr$(&HE9)
  End Select
 Case "CALL"
  Select Case Imm_Type
  Case "imm8"
    MsgBox "Not supported:" & vbCr & vbTab & "CALL rel8"
    SingleOperand_Imm_Opcode = ""
  Case "imm16"
    SingleOperand_Imm_Opcode = Ext16 & Chr$(&HE8) 'near, relative
  Case "imm32"
    SingleOperand_Imm_Opcode = Chr$(&HE8) 'near, relative
  End Select
 Case "PUSH"
  Select Case Imm_Type
  Case "imm8"
    SingleOperand_Imm_Opcode = Chr$(&H6A)
  Case "imm16"
    SingleOperand_Imm_Opcode = Ext16 & Chr$(&H68)
  Case "imm32"
    SingleOperand_Imm_Opcode = Chr$(&H68)
  End Select
 End Select
End Function

Function SingleOperand_OpCodes(ByVal Mnemonic As String, ByVal Op1_Type As String, ByRef StrRet As String) As Byte
 'NOT,NEG,MUL,IMUL,DIV,IDIV - r/m8(16,32)
 
 Const Mem_Offset = &H0
 Const R_Offset = &HC0

 Const m8 As Byte = &HF6, r8 As Byte = m8
 Const m32 As Byte = &HF7, r32 As Byte = m32
 
 Dim Ext16 As String
 Ext16 = Chr$(&H66)
 
 Dim OperatorOffset As Byte
 OperatorOffset = SingleOperand_OperatorStep(Mnemonic)
 If OperatorOffset = 255 Then MsgBox "Syntax error: " & vbCr & Mnemonic, , "Opcode for: " & Mnemonic: Exit Function

 Select Case Op1_Type
 Case "m8"
  StrRet = Chr$(m8): SingleOperand_OpCodes = Mem_Offset + OperatorOffset
 Case "r8"
  StrRet = Chr$(r8): SingleOperand_OpCodes = R_Offset + OperatorOffset
 Case "m16"
  StrRet = Ext16 & Chr$(m32): SingleOperand_OpCodes = Mem_Offset + OperatorOffset
 Case "r16"
  StrRet = Ext16 & Chr$(r32): SingleOperand_OpCodes = R_Offset + OperatorOffset
 Case "m32"
  StrRet = Chr$(m32): SingleOperand_OpCodes = Mem_Offset + OperatorOffset
 Case "r32"
  StrRet = Chr$(r32): SingleOperand_OpCodes = R_Offset + OperatorOffset
 End Select
End Function

Function SingleOperand2_OpCodes(ByVal Mnemonic As String, ByVal Op1_Type As String, ByRef StrRet As String) As Byte
'INC,DEC,CALL,CALL,JMP,JMP,PUSH
 Const Mem_Offset = &H0
 Const R_Offset = &HC0

 Const m8 As Byte = &HFE, r8 As Byte = m8
 Const m32 As Byte = &HFF, r32 As Byte = m32
 
 Dim Ext16 As String
 Ext16 = Chr$(&H66)
 
 Dim OperatorOffset As Byte
 OperatorOffset = SingleOperand2_OperatorStep(Mnemonic)
 If OperatorOffset = 255 Then MsgBox "Syntax error: " & vbCr & Mnemonic, , "Opcode for: " & Mnemonic: Exit Function

 Select Case Op1_Type
 Case "m8"
  StrRet = Chr$(m8): SingleOperand2_OpCodes = Mem_Offset + OperatorOffset
 Case "r8"
  StrRet = Chr$(r8): SingleOperand2_OpCodes = R_Offset + OperatorOffset
 Case "m16"
  StrRet = Ext16 & Chr$(m32): SingleOperand2_OpCodes = Mem_Offset + OperatorOffset
 Case "r16"
  StrRet = Ext16 & Chr$(r32): SingleOperand2_OpCodes = R_Offset + OperatorOffset
 Case "m32"
  StrRet = Chr$(m32): SingleOperand2_OpCodes = Mem_Offset + OperatorOffset
 Case "r32"
  StrRet = Chr$(r32): SingleOperand2_OpCodes = R_Offset + OperatorOffset
 End Select

End Function

Function SingleOperand3_OpCodes(ByVal Mnemonic As String, ByVal Op1_Type As String, ByVal Operand2 As String, ByRef StrRet As String) As String
 'ROL,ROR,RCL,RCR,SAL/SHL,SHR,SAR
 
 Dim Operand1_Ext As String
 Operand1_Ext = SingleOperand3_Generator(Operand2)
 If Operand1_Ext = "" Then
    If Operand2 = "" Then Operand2 = "1"
    MsgBox "Invalid 2-nd operand in " & Mnemonic & " " & Op1_Type & "," & Operand2 & vbCr & vbCr & vbTab & "Syntax:" & vbCr & Mnemonic & "r/m8(16/32)" & vbCr & Mnemonic & "r/m8(16/32),1(CL,imm8)"
    Exit Function
 End If
 
 Const Mem_Offset = &H0
 Const R_Offset = &HC0

 Dim m8 As Byte, r8 As Byte
 Dim m32 As Byte, r32 As Byte
 Select Case Operand1_Ext
 Case "1"
  m8 = &HD0
  m32 = &HD1
 Case "CL"
  m8 = &HD2
  m32 = &HD3
 Case "imm8"
  m8 = &HC0
  m32 = &HC1
 End Select
  r8 = m8: r32 = m32
 
 Dim Ext16 As String
 Ext16 = Chr$(&H66)
 
 Dim OperatorOffset As Byte
 OperatorOffset = SingleOperand3_OperatorStep(Mnemonic)
 If OperatorOffset = 255 Then MsgBox "Syntax error: " & vbCr & Mnemonic, , "Opcode for: " & Mnemonic: Exit Function

 Select Case Op1_Type
 Case "m8"
  StrRet = Chr$(m8): SingleOperand3_OpCodes = Mem_Offset + OperatorOffset
 Case "r8"
  StrRet = Chr$(r8): SingleOperand3_OpCodes = R_Offset + OperatorOffset
 Case "m16"
  StrRet = Ext16 & Chr$(m32): SingleOperand3_OpCodes = Mem_Offset + OperatorOffset
 Case "r16"
  StrRet = Ext16 & Chr$(r32): SingleOperand3_OpCodes = R_Offset + OperatorOffset
 Case "m32"
  StrRet = Chr$(m32): SingleOperand3_OpCodes = Mem_Offset + OperatorOffset
 Case "r32"
  StrRet = Chr$(r32): SingleOperand3_OpCodes = R_Offset + OperatorOffset
 End Select
 
End Function


Function SingleOperand_OperatorStep(ByVal Operator As String) As Byte
 'NOT,NEG,MUL,IMUL,DIV,IDIV
 
 '255 - Error
 SingleOperand_OperatorStep = 255
 Operator = UCase$(Trim$(Operator))
 
 Select Case Operator
 Case "NOT"
  SingleOperand_OperatorStep = &H10
 Case "NEG"
  SingleOperand_OperatorStep = &H18
 Case "MUL"
  SingleOperand_OperatorStep = &H20
 Case "IMUL"
  SingleOperand_OperatorStep = &H28
 Case "DIV"
  SingleOperand_OperatorStep = &H30
 Case "IDIV"
  SingleOperand_OperatorStep = &H38
 End Select
End Function
Function SingleOperand2_OperatorStep(ByVal Operator As String) As Byte
'INC,DEC,CALL,CALL,JMP,PUSH
 SingleOperand2_OperatorStep = 255
 Operator = UCase$(Trim$(Operator))
 Select Case Operator
 Case "INC"
  SingleOperand2_OperatorStep = &H0
 Case "DEC"
  SingleOperand2_OperatorStep = &H8
 Case "CALL"
  SingleOperand2_OperatorStep = &H10
' Case "CALL"
'  SingleOperand2_OperatorStep = &H18
 Case "JMP"
  SingleOperand2_OperatorStep = &H20
' Case "JMP"
'  SingleOperand2_OperatorStep = &H28
 Case "PUSH"
  SingleOperand2_OperatorStep = &H30
 End Select
End Function

Function SingleOperand3_OperatorStep(ByVal Operator As String) As Byte
 'ROL,ROR,RCL,RCR,SAL/SHL,SHR,SAR
 
 SingleOperand3_OperatorStep = 255
 Operator = UCase$(Trim$(Operator))

 Select Case Operator
 Case "ROL"
  SingleOperand3_OperatorStep = &H0
 Case "ROR"
  SingleOperand3_OperatorStep = &H8
 Case "RCL"
  SingleOperand3_OperatorStep = &H10
 Case "RCR"
  SingleOperand3_OperatorStep = &H18
 Case "SAL", "SHL"
  SingleOperand3_OperatorStep = &H20
 Case "SHR"
  SingleOperand3_OperatorStep = &H28
 Case "SAR"
  SingleOperand3_OperatorStep = &H38
 End Select

End Function

Function LOOP_Code(ByVal Mnemonic As String)
 Mnemonic = UCase$(Trim$(Mnemonic))
 Select Case Mnemonic
 Case "LOOP"
  LOOP_Code = Chr$(&HE2) & Chr$(0)
 Case "LOOPE", "LOOPZ"
  LOOP_Code = Chr$(&HE1) & Chr$(0)
 Case "LOOPNE", "LOOPNZ"
  LOOP_Code = Chr$(&HE0) & Chr$(0)
 Case "JCXZ"
  LOOP_Code = Chr$(&H66) & Chr$(&HE3) & Chr$(0)
 Case "JECXZ"
  LOOP_Code = Chr$(&HE3) & Chr$(0)
 End Select
End Function

Function LOOP_Label_Code(ByVal Mnemonic As String, ByVal LabelName As String, ByVal Curr_IP As Long)
 Dim LabelAddr As Long
 LabelAddr = COMPILER_FindLabelAddr(LabelName)
 If LabelAddr = -1 Then MsgBox "Label not found: " & LabelName, 16, Mnemonic & " " & LabelName: Exit Function
 
 Dim Ext16_Length As Byte
 If Mnemonic = "JCXZ" Then Ext16_Length = 1 Else Ext16_Length = 0
 
 Dim JMP_From_Addr As Long, Target_Addr As Long, ShortJump As Long
 Target_Addr = LabelAddr + 1
 JMP_From_Addr = Curr_IP + 1
 If JMP_From_Addr > Target_Addr Then
    '(255+Target)-CurrAddr
    ShortJump = (255 + Target_Addr) - (JMP_From_Addr + 1 + Ext16_Length)
    Mid$(code, JMP_From_Addr + 1 + Ext16_Length, 1) = Chr$(ShortJump)
    LOOP_Label_Code = Mid$(code, JMP_From_Addr + Ext16_Length, 1) & Chr$(ShortJump)
 ElseIf JMP_From_Addr < Target_Addr Then
    Const Jump_CodeLen = 2
    ShortJump = (Target_Addr - JMP_From_Addr) - Jump_CodeLen - Ext16_Length
    Mid$(code, JMP_From_Addr + 1 + Ext16_Length, 1) = Chr$(ShortJump)
    LOOP_Label_Code = Mid$(code, JMP_From_Addr + Ext16_Length, 1) & Chr$(ShortJump)
 End If
End Function

Function Loop_Label_True(ByVal Mnemonic As String) As Boolean
 Mnemonic = UCase$(Trim$(Mnemonic))
 Select Case Mnemonic
 Case "LOOP", "LOOPE", "LOOPZ", "LOOPNE", "LOOPNZ", "JCXZ", "JECXZ"
  Loop_Label_True = True
 End Select
End Function

Sub CONST_Save(ByVal ConstLine As String)
 ConstLine = Trim$(ConstLine)
 Dim ConstName As String, ConstName_EndPos As Integer: Dim EquLen As Integer
 ConstName_EndPos = InStr(1, UCase$(ConstLine), " EQU "): EquLen = 5
 If ConstName_EndPos = 0 Then ConstName_EndPos = InStr(1, ConstLine, "="): EquLen = 1
 If ConstName_EndPos = 0 Then MsgBox "Error in CONST" & vbCr & vbCr & vbTab & "USAGE:" & vbCr & "CONST ConstName=Expression" & vbCr & "CONST ConstName EQU Expression", , "CONST " & ConstLine: Exit Sub
 ConstName = UCase$(Trim$(Left$(ConstLine, ConstName_EndPos - 1)))
 If Register_Code(ConstName) < 255 Or Register8_Code(ConstName) < 255 Or Register16_Code(ConstName) < 255 Then MsgBox vbTab & "Error in Const:" & vbCr & "Register is not a valid name of constant.", , ConstLine: Exit Sub

 Dim ConstValue As String
 ConstValue = Right$(ConstLine, Len(ConstLine) - (ConstName_EndPos + EquLen - 1))
 
 ReDim Preserve EQU_Name(UBound(EQU_Name) + 1)
 ReDim Preserve EQU_Value(UBound(EQU_Value) + 1)
 EQU_Name(UBound(EQU_Name)) = ConstName
 EQU_Value(UBound(EQU_Value)) = ConstValue
End Sub
Sub CONST_Replace(ByRef CmdLine As String)
 If UBound(EQU_Name) < 1 Then Exit Sub
 If Len(CmdLine) < 1 Then Exit Sub
 
 CmdLine = Trim$(CmdLine)
 Dim IsFound As Integer, SrchConst As Integer
 Dim Left_Ok As Boolean, Right_Ok As Boolean
 Dim LeftByte As Byte, RightByte As Byte
 
 For SrchConst = 1 To UBound(EQU_Name)
 IsFound = 0
MultiSearch:
  IsFound = InStr(IsFound + 1, UCase$(CmdLine), UCase$(EQU_Name(SrchConst)))
  If IsFound > 0 Then
    If IsFound = 1 Then
        Left_Ok = True
    Else
        LeftByte = Asc(Mid$(CmdLine, IsFound - 1, 1))
        If IsCharAlphaNumeric(LeftByte) <> 0 Then Left_Ok = False Else Left_Ok = True
    End If
    If Len(CmdLine) = IsFound + (Len(EQU_Name(SrchConst)) - 1) Then
        Right_Ok = True
    Else
        RightByte = Asc(Mid$(CmdLine, IsFound + (Len(EQU_Name(SrchConst)) - 1) + 1, 1))
        If IsCharAlphaNumeric(RightByte) <> 0 Then Right_Ok = False Else Right_Ok = True
    End If
    If Left_Ok And Right_Ok Then
     CmdLine = Replace(CmdLine, EQU_Name(SrchConst), EQU_Value(SrchConst), 1, 1, vbTextCompare)
     GoTo MultiSearch
    End If
  End If
 Next SrchConst
End Sub

Function Tools_ImmTypeID(ByRef Value As String) As String
 Value = RTrim$(Value)
 
 Dim TypeId As String * 1
 TypeId = Right$(Value, 1)
 
 Select Case TypeId
 Case "?"
    Value = Left$(Value, Len(Value) - 1)
    Tools_ImmTypeID = "imm8"
 Case "%"
    Value = Left$(Value, Len(Value) - 1)
    Tools_ImmTypeID = "imm16"
 Case "&"
    Value = Left$(Value, Len(Value) - 1)
    Tools_ImmTypeID = "imm32"
 End Select
End Function

Sub HiLevel_Correct_PtrPlusImm(ByRef PtrPlusImm_Offset As Byte, ByRef Operand_AddValue As String)
 Const PtrPlusImm8 = &H40 '[r32+imm8]
 Const PtrPlusImm32 = &H80 '[r32+imm32]
 
 Dim Imm_Type As String
 Imm_Type = Tools_ImmTypeID(Operand_AddValue)
 Select Case Imm_Type
 Case "imm8"
  PtrPlusImm_Offset = PtrPlusImm8
 Case "imm16", "imm32"
  PtrPlusImm_Offset = PtrPlusImm32
 End Select
End Sub

Function Compiler_SplitCmdLine(ByVal CmdLine As String, ByRef Operand1 As String, ByRef Operand2 As String) As String
 Operand1 = "": Operand2 = ""
 CmdLine = Trim$(CmdLine)
 
 Dim Mnemonic_Pos As Integer, CmdWoMnm As String, Operand2_Pos As Integer
 Mnemonic_Pos = InStr(1, CmdLine, " ")
 If Mnemonic_Pos = 0 Then Compiler_SplitCmdLine = CmdLine: Exit Function
 
 Compiler_SplitCmdLine = UCase$(Trim$(Left$(CmdLine, Mnemonic_Pos - 1)))
 CmdWoMnm = Trim$(Right$(CmdLine, Len(CmdLine) - Mnemonic_Pos))
 Operand2_Pos = InStr(1, CmdWoMnm, ",")
 If Operand2_Pos = 0 Then
    Operand1 = CmdWoMnm: Operand2 = ""
 Else
    Operand1 = Left$(CmdWoMnm, Operand2_Pos - 1)
    Operand2 = Right$(CmdWoMnm, Len(CmdWoMnm) - Operand2_Pos)
 End If
End Function

Function Tools_ImmAutoType(ByVal ImmValue As String) As String
 If IsLabel(ImmValue) Then
    Tools_ImmAutoType = "imm32"
 ElseIf IsByte(ImmValue) Then
    Tools_ImmAutoType = "imm8"
 ElseIf IsWord(ImmValue) Then
    Tools_ImmAutoType = "imm16"
 ElseIf IsNumber(ImmValue) Then
     Tools_ImmAutoType = "imm32"
 End If
End Function

Function MnemonicOnly_Opcode(ByVal Mnemonic As String) As String
 Mnemonic = UCase$(Trim$(Mnemonic))

 Select Case Mnemonic
 Case "AAA"
    MnemonicOnly_Opcode = Chr$(&H37)
 Case "AAD"
    MnemonicOnly_Opcode = Chr$(&HD5) & Chr$(&HA)
 Case "AAM"
    MnemonicOnly_Opcode = Chr$(&HD4) & Chr$(&HA)
 Case "AAS"
    MnemonicOnly_Opcode = Chr$(&H3F)
 Case "CBW"
    MnemonicOnly_Opcode = Chr$(&H66) & Chr$(&H98)
 Case "CWDE"
    MnemonicOnly_Opcode = Chr$(&H98)
 Case "CWD"
    MnemonicOnly_Opcode = Chr$(&H66) & Chr$(&H99)
 Case "CDQ"
    MnemonicOnly_Opcode = Chr$(&H99)
 Case "DAA"
    MnemonicOnly_Opcode = Chr$(&H27)
 Case "DAS"
    MnemonicOnly_Opcode = Chr$(&H2F)
 Case "INTO"
    MnemonicOnly_Opcode = Chr$(&HCE)
 Case "LEAVE"
    MnemonicOnly_Opcode = Chr$(&HC9)
 Case "NOP"
    MnemonicOnly_Opcode = Chr$(&H90)
 Case "WAIT", "FWAIT"
    MnemonicOnly_Opcode = Chr$(&H9B)
 Case "HLT"
    MnemonicOnly_Opcode = Chr$(&HF4)
 Case "IRET"
    MnemonicOnly_Opcode = Chr$(&H66) & Chr$(&HCF)
 Case "IRETD"
    MnemonicOnly_Opcode = Chr$(&HCF)
 Case "XLAT", "XLATB"
    MnemonicOnly_Opcode = Chr$(&HD7)
 Case "LOCK"
    MnemonicOnly_Opcode = Chr$(&HF0)
 End Select
 
End Function

Function SET_Code(ByVal Mnemonic As String, ByVal Operand1 As String) As String
 Mnemonic = UCase$(Trim$(Mnemonic))
 
 Dim Op1_Type As String
 Op1_Type = Mnemonic_OperandType(Operand1)
 
 Select Case Op1_Type
 Case "r8", "m8"
 Case Else
    MsgBox "Error in " & Mnemonic & ":" & vbCr & vbTab & "Invalid operand: " & Op1_Type & vbCr & vbCr & "USAGE: " & Mnemonic & " r/m8"
    Exit Function
 End Select
 
 SET_Code = SingleOperand_Generator(Mnemonic, Operand1)

End Function
Function SET_IsSet(ByVal Mnemonic As String) As String
Mnemonic = UCase$(Trim$(Mnemonic))

 Select Case Mnemonic
 Case "SETO", "SETNO", "SETB", "SETNAE", "SETC", "SETNC", "SETNB", "SETAE", "SETE", "SETZ", "SETNE", "SETNZ", "SETBE", "SETNA", "SETA", "SETS", "SETNS", "SETP", "SETPE", "SETNP", "SETPO", "SETL", "SETNGE", "SETGE", "SETNL", "SETLE", "SETNG", "SETG", "SETNLE"
  SET_IsSet = Mnemonic
 Case Else
  SET_IsSet = "SET_Error"
 End Select
End Function

Function SET_OpCodes(ByVal Mnemonic As String, ByVal Op1_Type As String, ByRef StrRet As String) As Byte

Dim Byte1 As String, Byte2_ASC As Byte
Byte1 = Chr$(&HF)

Select Case Mnemonic
Case "SETO"
 Byte2_ASC = &H90
Case "SETNO"
 Byte2_ASC = &H91
Case "SETB", "SETNAE", "SETC"
 Byte2_ASC = &H92
Case "SETNC", "SETAE", "SETNB"
 Byte2_ASC = &H93
Case "SETE", "SETZ"
 Byte2_ASC = &H94
Case "SETNE", "SETNZ"
 Byte2_ASC = &H95
Case "SETBE", "SETNA"
 Byte2_ASC = &H96
Case "SETA"
 Byte2_ASC = &H97
Case "SETS"
 Byte2_ASC = &H98
Case "SETNS"
 Byte2_ASC = &H99
Case "SETP", "SETPE"
 Byte2_ASC = &H9A
Case "SETNP", "SETPO"
 Byte2_ASC = &H9B
Case "SETL", "SETNGE"
 Byte2_ASC = &H9C
Case "SETGE", "SETNL"
 Byte2_ASC = &H9D
Case "SETLE", "SETNG"
 Byte2_ASC = &H9E
Case "SETG", "SETNLE"
 Byte2_ASC = &H9F
Case Else
 Exit Function
End Select

Const Reg_Offset As Byte = &HC0

Select Case Op1_Type
Case "m8"
    StrRet = Byte1 & Chr$(Byte2_ASC)
Case "r8"
    StrRet = Byte1 & Chr$(Byte2_ASC)
    SET_OpCodes = Reg_Offset
End Select

End Function

Function IN_Code(ByVal Operand1 As String, ByVal Operand2 As String) As String

 Dim Operand1_Flag As Integer, Operand1_Value As String, Operand1_AddValue As String
 Dim Operand2_Flag As Integer, Operand2_Value As String, Operand2_AddValue As String
 Operand1_Value = COMPILER_CheckOperand(Operand1, Operand1_Flag, Operand1_AddValue)
 Operand2_Value = COMPILER_CheckOperand(Operand2, Operand2_Flag, Operand2_AddValue)
 
 Dim Op1_Type As String
 Op1_Type = Mnemonic_OperandType(Operand1)

 Dim Valid As Boolean
 Select Case Op1_Type
 Case "r8"
  If Register8_Code(Operand1_Value) = 0 Then Valid = True
 Case "r16"
  If Register16_Code(Operand1_Value) = 0 Then Valid = True
 Case "r32"
  If Register_Code(Operand1_Value) = 0 Then Valid = True
 End Select
 If Not Valid Then MsgBox "Error in IN" & vbCr & " invalid destination operand." & vbCr & vbCr & "Must be:" & vbCr & vbTab & "AL or AX or EAX.": Exit Function
 
 Valid = False

 Dim Op2_Type As String
 Op2_Type = Mnemonic_OperandType(Operand2)

 Select Case Op2_Type
 Case "imm8"
  Valid = True
 Case "r16"
  If Register16_Code(Operand2_Value) = 2 Then Valid = True
 End Select
 If Not Valid Then MsgBox "Error in IN" & vbCr & " invalid source operand." & vbCr & vbCr & "Must be:" & vbCr & vbTab & "imm8 or DX.": Exit Function

 IN_Code = Mnemonic_Common_Generator("IN", Operand1, Operand2)
End Function

Function IN_OpCodes(ByVal Op1_Type As String, ByVal Op2_Type As String, ByRef StrRet As String) As Byte
 
 Select Case Op1_Type & Op2_Type
 Case "ALimm8"
    StrRet = Chr$(&HE4)
 Case "AXimm8"
    StrRet = Chr$(&H66) & Chr$(&HE5)
 Case "EAXimm8"
    StrRet = Chr$(&HE5)
 Case "r8r16"
    StrRet = Chr$(&HEC)
 Case "r16r16"
    StrRet = Chr$(&H66) & Chr$(&HED)
 Case "r32r16"
    StrRet = Chr$(&HED)
 End Select
End Function

Function OUT_Code(ByVal Operand1 As String, ByVal Operand2 As String) As String

 Dim Op1_Type As String
 Op1_Type = Mnemonic_OperandType(Operand1)

 Dim Valid As Boolean
 Select Case Op1_Type
 Case "r16"
  If Register16_Code(Operand1) = 2 Then Valid = True
 Case "imm8"
  Valid = True
 End Select
 If Not Valid Then MsgBox "Error in OUT" & vbCr & " invalid destination operand." & vbCr & vbCr & "Must be:" & vbCr & vbTab & "DX or imm8.": Exit Function
 
 Valid = False

 Dim Op2_Type As String
 Op2_Type = Mnemonic_OperandType(Operand2)

 Select Case Op2_Type
 Case "r8"
  If Register8_Code(Operand2) = 0 Then Valid = True
 Case "r16"
  If Register16_Code(Operand2) = 0 Then Valid = True
 Case "r32"
  If Register_Code(Operand2) = 0 Then Valid = True
 End Select
 If Not Valid Then MsgBox "Error in OUT" & vbCr & " invalid source operand." & vbCr & vbCr & "Must be:" & vbCr & vbTab & "AL or AX or EAX.": Exit Function

 OUT_Code = Mnemonic_Common_Generator("OUT", Operand1, Operand2)
End Function

Function OUT_OpCodes(ByVal Op1_Type As String, ByVal Op2_Type As String, ByRef StrRet As String) As Byte
 Select Case Op1_Type & Op2_Type
 Case "imm8r8"
    StrRet = Chr$(&HE6)
 Case "imm8r16"
    StrRet = Chr$(&H66) & Chr$(&HE7)
 Case "imm8r32"
    StrRet = Chr$(&HE7)
 Case "r16r8"
    StrRet = Chr$(&HEE)
 Case "r16r16"
    StrRet = Chr$(&H66) & Chr$(&HEF)
 Case "r16r32"
    StrRet = Chr$(&HEF)
 End Select

End Function

Function LEA_Code(ByVal Operand1 As String, ByVal Operand2 As String) As String
 Dim Op1_Type As String
 Op1_Type = Mnemonic_OperandType(Operand1)

 Dim Valid As Boolean
 Select Case Op1_Type
 Case "r16", "r32"
  Valid = True
 End Select
 If Not Valid Then MsgBox "Error in LEA" & vbCr & " invalid destination operand." & vbCr & vbCr & "Must be:" & vbCr & vbTab & "r16 or r32.": Exit Function
 
 Valid = False
 Op1_Type = Mnemonic_OperandType(Operand2)
 Select Case Op1_Type
 Case "imm8", "imm16", "imm32"
  Valid = False
 Case Else
  Valid = True
 End Select
 If Not Valid Then MsgBox "Error in LEA" & vbCr & " invalid source operand." & vbCr & vbCr & "Not supported:" & vbCr & vbTab & "imm8 or imm16 or imm32.": Exit Function
 
 LEA_Code = Mnemonic_Common_Generator("LEA", Operand1, Operand2)
 
End Function

Function LEA_OpCodes(ByVal Op1_Type As String, ByVal Op2_Type As String, ByRef StrRet As String) As Byte
 Dim Ext16 As String: Ext16 = Chr$(&H66)
 Const Reg_Offset As Byte = &HC0
 
 StrRet = Chr$(&H8D)
 
 If Op1_Type = "r16" Then StrRet = Ext16 & StrRet
 Select Case Op1_Type & Op2_Type
 Case "r16r16", "r32r32"
    LEA_OpCodes = Reg_Offset
 End Select
End Function

Function IsNegative(ByRef Value As String) As Boolean
 Value = Trim$(Value)
 If Left$(Value, 1) = "-" Then Value = LTrim$(Right$(Value, Len(Value) - 1)): IsNegative = True
End Function

Function TEST_OpCodes(ByVal Op1_Type As String, ByVal Op2_Type As String, ByRef StrRet As String) As Byte
 
 Const ALimm8 As Byte = &HA8
 Const EAXimm32 As Byte = &HA9
 Const AXimm16 As Byte = EAXimm32
 
 Const m8imm8 As Byte = &HF6, r8imm8 As Byte = m8imm8
 Const m32imm32 As Byte = &HF7, r32imm32 As Byte = m32imm32
 Const m16imm16 As Byte = m32imm32, r16imm16 As Byte = m16imm16

 Const m8r8 As Byte = &H84, r8r8 As Byte = m8r8
 Const m32r32 As Byte = &H85, r32r32 As Byte = m32r32
 Const m16r16 As Byte = m32r32, r16r16 As Byte = m16r16

 Const Ext16 As Byte = &H66
 Const Reg_Offset As Byte = &HC0
 
 Select Case Op1_Type & Op2_Type
 Case "ALimm8"
    TEST_OpCodes = ALimm8
 Case "AXimm16"
    StrRet = Chr$(Ext16)
    TEST_OpCodes = AXimm16
 Case "EAXimm32"
    TEST_OpCodes = EAXimm32
 Case "m8imm8"
    StrRet = Chr$(m8imm8)
 Case "r8imm8"
    StrRet = Chr$(r8imm8)
    TEST_OpCodes = Reg_Offset
 Case "m16imm16"
    StrRet = Chr$(Ext16) & Chr$(m16imm16)
 Case "r16imm16"
    StrRet = Chr$(Ext16) & Chr$(r16imm16)
    TEST_OpCodes = Reg_Offset
 Case "m32imm32"
    StrRet = Chr$(m32imm32)
 Case "r32imm32"
    StrRet = Chr$(r32imm32)
    TEST_OpCodes = Reg_Offset
 Case "m8r8"
    StrRet = Chr$(m8r8)
 Case "r8r8"
    StrRet = Chr$(r8r8)
    TEST_OpCodes = Reg_Offset
 Case "m16r16"
    StrRet = Chr$(Ext16) & Chr$(m16r16)
 Case "r16r16"
    StrRet = Chr$(Ext16) & Chr$(r16r16)
    TEST_OpCodes = Reg_Offset
 Case "m32r32"
    StrRet = Chr$(m32r32)
 Case "r32r32"
    StrRet = Chr$(r32r32)
    TEST_OpCodes = Reg_Offset
 Case Else
    MsgBox "Error in TEST." & vbCr & vbCr & vbTab & "Not supported:" & vbCr & "TEST " & Op1_Type & "," & Op2_Type, 48
 End Select
 

End Function

Function MOVZXSX_Code(ByVal Mnemonic As String, ByVal Operand1 As String, ByVal Operand2 As String) As String
 Mnemonic = UCase$(Trim$(Mnemonic))
 
 Dim Op1_Type As String, Op2_Type As String
 Op1_Type = Mnemonic_OperandType(Operand1)
 Op2_Type = Mnemonic_OperandType(Operand2)

 Select Case Op1_Type & Op2_Type
 Case "r16r8", "r16m8", "r32r8", "r32m8", "r32r16", "r32m16"
 Case Else
    MsgBox "Error in " & Mnemonic & vbCr & vbCr & vbTab & "USAGE:" & vbCr & Mnemonic & " r16,r/m8 or r32,r/m8 or r32,r/m16": Exit Function
 End Select
  
 MOVZXSX_Code = Mnemonic_Common_Generator(Mnemonic, Operand1, Operand2)
 
End Function
Function MOVZXSX_OpCodes(ByVal Mnemonic As String, ByVal Op1_Type As String, ByVal Op2_Type As String, ByRef StrRet As String, ByVal Operand1_Value As String, ByVal Operand2_Value As String) As Byte
 Mnemonic = UCase$(Trim$(Mnemonic))
 
 Const Ext16 As Byte = &H66
 Const Reg_Offset As Byte = &HC0

 Const Cmn_Offset As Byte = &HB0
 Dim Operator_Offset As Byte
 Select Case Mnemonic
 Case "MOVSX"
    'BE-r16/r32,r/m8; BF-r32,r/m16
    Operator_Offset = &HE
 Case "MOVZX"
    'B6-r16/r32,r/m8; B7-r32,r/m16
    Operator_Offset = &H6
 End Select
    
 Select Case Op2_Type
 Case "r8", "r16"
    MOVZXSX_OpCodes = Reg_Offset
 End Select
 
 If Op1_Type = "r16" Then StrRet = Chr$(Ext16)
 StrRet = StrRet & Chr$(&HF)
 
 Dim Reg_Offset1_Local As Byte
 Select Case Op1_Type
 Case "r16"
    Reg_Offset1_Local = Register16_Code(Operand1_Value)
 Case "r32"
    Reg_Offset1_Local = Register_Code(Operand1_Value)
 End Select
 Dim Reg_Offset2_Local As Byte
 Select Case Op2_Type
 Case "r8"
    Reg_Offset2_Local = Register8_Code(Operand2_Value)
 Case "r16"
    Reg_Offset2_Local = Register16_Code(Operand2_Value)
 Case "m8", "m16"
    Reg_Offset2_Local = Register_Code(Operand2_Value)
 End Select
 
 Dim Reg_Offset3_Local As Byte
 Select Case Op2_Type
 Case "m8", "m16"
    Reg_Offset3_Local = Reg_Offset1_Local + Reg_Offset2_Local * 8
 Case "r8", "r16"
    Reg_Offset3_Local = Reg_Offset1_Local * 8 + Reg_Offset2_Local
 End Select

 Select Case Op1_Type & Op2_Type
 Case "r16r8", "r16m8", "r32r8", "r32m8"
    StrRet = StrRet & Chr$(Cmn_Offset + Operator_Offset)
    MOVZXSX_OpCodes = MOVZXSX_OpCodes + Reg_Offset3_Local
 Case "r32r16", "r32m16"
    StrRet = StrRet & Chr$(Cmn_Offset + Operator_Offset + 1)
    MOVZXSX_OpCodes = MOVZXSX_OpCodes + Reg_Offset3_Local
 Case Else
    StrRet = "": MOVZXSX_OpCodes = 0
    MsgBox "Not supported:" & vbCr & vbTab & Mnemonic & " " & Op1_Type & "," & Op2_Type
 End Select
End Function

Function Tools_Bin2HexDec(ByVal Value As String, Optional ByVal ToDec As Boolean) As String
 On Error GoTo Ntb
 
 Value = UCase$(Trim$(Value))
 If Left$(Value, 2) = "&B" Then
    Value = LTrim$(Right$(Value, Len(Value) - 2))
 Else
    Tools_Bin2HexDec = Value: Exit Function
 End If
 
 If Len(Value) < 4 Then Value = String$(4 - Len(Value), "0") & Value
 
 Dim CorrectLen As Integer
 CorrectLen = Len(Value) Mod 4
 If CorrectLen > 0 Then Value = String$(4 - CorrectLen, "0") & Value

 Dim RetHex As String, RetHexByte As String, EnumBinBytes As Byte
 For EnumBinBytes = 1 To Len(Value) Step 4
    RetHexByte = Hex$(TOOLS_ToDEC_Byte(2, Mid$(Value, EnumBinBytes, 4)))
    RetHex = RetHex & RetHexByte
 Next EnumBinBytes
 If ToDec Then
    Tools_Bin2HexDec = LTrim$(Str$(Val("&H" & RetHex)))
 Else
    Tools_Bin2HexDec = "&H" & RetHex
 End If
 
 Exit Function
 
Ntb:
 MsgBox "Number too big: " & Value, , Error$(Err)
 Tools_Bin2HexDec = ""
 Exit Function
End Function

Function BSFR_Code(ByVal Mnemonic As String, ByVal Operand1 As String, ByVal Operand2 As String) As String
 Mnemonic = UCase$(Trim$(Mnemonic))
 
 Dim Op1_Type As String, Op2_Type As String
 Op1_Type = Mnemonic_OperandType(Operand1)
 Op2_Type = Mnemonic_OperandType(Operand2)

 Call Mnemonic_Common_CorrectMem(Op1_Type, Op2_Type)
 Select Case Op1_Type & Op2_Type
 Case "r16r16", "r16m16", "r32r32", "r32m32"
 Case Else
    MsgBox "Error in " & Mnemonic & vbCr & vbCr & vbTab & "USAGE:" & vbCr & Mnemonic & " r16,r/m16 or r32,r/m32": Exit Function
 End Select
  
 BSFR_Code = Mnemonic_Common_Generator(Mnemonic, Operand1, Operand2)
 
End Function

Function BSFR_OpCodes(ByVal Mnemonic As String, ByVal Op1_Type As String, ByVal Op2_Type As String, ByRef StrRet As String, ByVal Operand1_Value As String, ByVal Operand2_Value As String) As Byte

 Mnemonic = UCase$(Trim$(Mnemonic))
 
 Const Ext16 As Byte = &H66
 Const Reg_Offset As Byte = &HC0

 Const Cmn_Offset As Byte = &HB0
 Dim Operator_Offset As Byte
 Select Case Mnemonic
 Case "BSF"
    Operator_Offset = &HC
 Case "BSR"
    Operator_Offset = &HD
 End Select
    
 Select Case Op2_Type
 Case "r16", "r32"
    BSFR_OpCodes = Reg_Offset
 End Select
 
 If Op1_Type = "r16" Then StrRet = Chr$(Ext16)
 StrRet = StrRet & Chr$(&HF)
 
 Dim Reg_Offset1_Local As Byte
 Select Case Op1_Type
 Case "r16"
    Reg_Offset1_Local = Register16_Code(Operand1_Value)
 Case "r32"
    Reg_Offset1_Local = Register_Code(Operand1_Value)
 End Select
 Dim Reg_Offset2_Local As Byte
 Select Case Op2_Type
 Case "r16"
    Reg_Offset2_Local = Register16_Code(Operand2_Value)
 Case "m16", "m32", "r32"
    Reg_Offset2_Local = Register_Code(Operand2_Value)
 End Select
 
 Dim Reg_Offset3_Local As Byte
 Select Case Op2_Type
 Case "m16", "m32"
    Reg_Offset3_Local = Reg_Offset1_Local + Reg_Offset2_Local * 8
 Case "r16", "r32"
    Reg_Offset3_Local = Reg_Offset1_Local * 8 + Reg_Offset2_Local
 End Select

 Select Case Op1_Type & Op2_Type
 Case "r16r16", "r16m16", "r32r32", "r32m32"
    StrRet = StrRet & Chr$(Cmn_Offset + Operator_Offset)
    BSFR_OpCodes = BSFR_OpCodes + Reg_Offset3_Local
 Case Else
    StrRet = "": BSFR_OpCodes = 0
    MsgBox "Not supported:" & vbCr & vbTab & Mnemonic & " " & Op1_Type & "," & Op2_Type
 End Select
End Function

Function BOUND_Code(ByVal Operand1 As String, ByVal Operand2 As String) As String
 
 Dim Op1_Type As String, Op2_Type As String
 Op1_Type = Mnemonic_OperandType(Operand1)
 Op2_Type = Mnemonic_OperandType(Operand2)

 Call Mnemonic_Common_CorrectMem(Op1_Type, Op2_Type)
 Select Case Op1_Type & Op2_Type
 Case "r16m16", "r32m32", "r16r16", "r32r32"
 Case Else
    MsgBox "Error in BOUND" & vbCr & vbCr & vbTab & "USAGE:" & vbCr & "BOUND r16,m16&16 or r32,m32&32 or r16/32,r16/32": Exit Function
 End Select
  
 BOUND_Code = Mnemonic_Common_Generator("BOUND", Operand1, Operand2)

End Function

Function BOUND_OpCodes(ByVal Op1_Type As String, ByVal Op2_Type As String, ByRef StrRet As String) As Byte
 Const Ext16 As Byte = &H66
 Const Reg_Offset As Byte = &HC0

 Const r32m32 As Byte = &H62, r16m16 As Byte = r32m32
 
 Select Case Op1_Type & Op2_Type
 Case "r16m16"
    StrRet = Chr$(Ext16) & Chr$(r16m16)
 Case "r16r16"
    StrRet = Chr$(Ext16) & Chr$(r16m16)
    BOUND_OpCodes = Reg_Offset
 Case "r32m32"
    StrRet = Chr$(r32m32)
 Case "r32r32"
    StrRet = Chr$(r32m32)
    BOUND_OpCodes = Reg_Offset
 End Select

End Function

Function CMPXCHG_Code(ByVal Operand1 As String, ByVal Operand2 As String) As String

 Dim Op1_Type As String, Op2_Type As String
 Op1_Type = Mnemonic_OperandType(Operand1)
 Op2_Type = Mnemonic_OperandType(Operand2)

 Call Mnemonic_Common_CorrectMem(Op1_Type, Op2_Type)
 Select Case Op1_Type & Op2_Type
 Case "r8r8", "m8r8", "r16r16", "m16r16", "r32r32", "m32r32"
 Case Else
    MsgBox "Error in CMPXCHG" & vbCr & vbCr & vbTab & "USAGE:" & vbCr & "CMPXCHG r/m8(16/32),r8(16/32)": Exit Function
 End Select

 CMPXCHG_Code = Mnemonic_Common_Generator("CMPXCHG", Operand1, Operand2)

End Function
Function CMPXCHG_OpCodes(ByVal Op1_Type As String, ByVal Op2_Type As String, ByRef StrRet As String) As Byte

 Const Ext16 As Byte = &H66
 Const Reg_Offset As Byte = &HC0

 Const m8r8 As Byte = &HB0, r8r8 As Byte = m8r8
 Const m32r32 As Byte = &HB1, r32r32 As Byte = m32r32
 
 StrRet = Chr$(&HF)
 
 Select Case Op1_Type & Op2_Type
 Case "m8r8"
    StrRet = StrRet & Chr$(m8r8)
 Case "r8r8"
    StrRet = StrRet & Chr$(r8r8)
    CMPXCHG_OpCodes = Reg_Offset
 Case "m16r16"
    StrRet = Chr$(Ext16) & StrRet & Chr$(m32r32)
 Case "r16r16"
    StrRet = Chr$(Ext16) & StrRet & Chr$(m32r32)
    CMPXCHG_OpCodes = Reg_Offset
 Case "m32r32"
    StrRet = StrRet & Chr$(m32r32)
 Case "r32r32"
    StrRet = StrRet & Chr$(m32r32)
    CMPXCHG_OpCodes = Reg_Offset
 Case Else
    StrRet = ""
 End Select

End Function

Function XCHG_Code(ByVal Operand1 As String, ByVal Operand2 As String) As String

 Dim Op1_Type As String, Op2_Type As String
 Op1_Type = Mnemonic_OperandType(Operand1)
 Op2_Type = Mnemonic_OperandType(Operand2)

 Call Mnemonic_Common_CorrectMem(Op1_Type, Op2_Type)
 Select Case Op1_Type & Op2_Type
 Case "r8r8", "m8r8", "r8m8", "r16r16", "m16r16", "r16m16", "r32r32", "m32r32", "r32m32"
 Case Else
    MsgBox "Error in CMPXCHG" & vbCr & vbCr & vbTab & "USAGE:" & vbCr & "CMPXCHG r/m8(16/32),r8(16/32)": Exit Function
 End Select

 XCHG_Code = Mnemonic_Common_Generator("XCHG", Operand1, Operand2)
End Function
Function XCHG_OpCodes(ByVal Op1_Type As String, ByVal Op2_Type As String, ByRef StrRet As String) As Byte
 Const Ext16 As Byte = &H66
 Const Reg_Offset As Byte = &HC0

 'Const EAXr32 As Byte = &H90, r32EAX As Byte = EAXr32
 Const r8r8 As Byte = &H86, r8m8 As Byte = r8r8, m8r8 As Byte = r8r8
 Const r32r32 As Byte = &H87, r32m32 As Byte = r32r32, m32r32 As Byte = r32r32
 
 Select Case Op1_Type & Op2_Type
 Case "r8r8"
    StrRet = Chr$(r8r8)
    XCHG_OpCodes = Reg_Offset
 Case "m8r8", "r8m8"
    StrRet = Chr$(r8r8)
 Case "r16r16"
    StrRet = Chr$(Ext16) & Chr$(r32r32)
    XCHG_OpCodes = Reg_Offset
 Case "m16r16", "r16m16"
    StrRet = Chr$(Ext16) & Chr$(r32r32)
 Case "r32r32"
    StrRet = Chr$(r32r32)
    XCHG_OpCodes = Reg_Offset
 Case "m32r32", "r32m32"
    StrRet = Chr$(r32r32)
 End Select
 
End Function

Function ENTER_Code(ByVal Operand1 As String, ByVal Operand2 As String) As String
 Dim Imm1_Type As String, Imm2_Type As String
 Imm1_Type = Tools_ImmTypeID(Operand1)
 If Len(Imm1_Type) = 0 Then
    Imm1_Type = Mnemonic_OperandType(Operand1)
 End If
 Imm2_Type = Tools_ImmTypeID(Operand2)
 If Len(Imm2_Type) = 0 Then
    Imm2_Type = Mnemonic_OperandType(Operand2)
 End If

 If Imm1_Type = "imm8" Then Imm1_Type = "imm16"
 If Imm1_Type & Imm2_Type = "imm16imm8" Then
    If IsWord(Operand1) And IsByte(Operand2) Then
        ENTER_Code = Chr$(&HC8) & TOOLS_Number2Word(Operand1) & TOOLS_Number2Byte(Operand2)
    Else
        MsgBox "Out of range"
    End If
 Else
    MsgBox "Invalid operands:" & vbCr & vbCr & "ENTER " & Imm1_Type & "," & Imm2_Type
 End If
End Function

Function LAR_Code(ByVal Operand1 As String, ByVal Operand2 As String) As String
 Dim Op1_Type As String, Op2_Type As String
 Op1_Type = Mnemonic_OperandType(Operand1)
 Op2_Type = Mnemonic_OperandType(Operand2)

 Call Mnemonic_Common_CorrectMem(Op1_Type, Op2_Type)
 Select Case Op1_Type & Op2_Type
 Case "r16r16", "r16m16", "r32r32", "r32m32"
 Case Else
    MsgBox "Error in LAR" & vbCr & vbCr & vbTab & "USAGE:" & vbCr & "LAR r16/(32),r/m16(32)": Exit Function
 End Select

 LAR_Code = Mnemonic_Common_Generator("LAR", Operand1, Operand2)

End Function
Function LAR_OpCodes(ByVal Op1_Type As String, ByVal Op2_Type As String, ByRef StrRet As String) As Byte
 Const Ext16 As Byte = &H66
 Const Reg_Offset As Byte = &HC0
 
 StrRet = Chr$(&HF) & Chr$(&H2)
 Select Case Op1_Type & Op2_Type
 Case "r16r16"
    StrRet = Chr$(Ext16) & StrRet
    LAR_OpCodes = Reg_Offset
 Case "r16m16"
    StrRet = Chr$(Ext16) & StrRet
 Case "r32r32"
    LAR_OpCodes = Reg_Offset
 Case "r32m32"
 Case Else
    StrRet = ""
 End Select
End Function

Function VERRW_Code(ByVal Mnemonic As String, ByVal Operand1 As String) As String
 Mnemonic = UCase$(Trim$(Mnemonic))
 
 Dim Op1_Type As String
 Op1_Type = Mnemonic_OperandType(Operand1)
 
 Select Case Op1_Type
 Case "r16", "m16", "r32", "m32"
 Case Else
    MsgBox "Error in " & Mnemonic & ":" & vbCr & vbTab & "Invalid operand: " & Op1_Type & vbCr & vbCr & "USAGE: " & Mnemonic & " r/m16(32)"
    Exit Function
 End Select
 
 VERRW_Code = SingleOperand_Generator(Mnemonic, Operand1)
End Function
Function VERRW_OpCodes(ByVal Mnemonic As String, ByVal Op1_Type As String, ByRef StrRet As String) As Byte
 Const Operator_Step As Byte = 8
 Dim Operator_Offset As Byte
 Select Case Mnemonic
 Case "VERR"
    Operator_Offset = 4 * Operator_Step
 Case "VERW"
    Operator_Offset = 5 * Operator_Step
 End Select
 
 Const R_Offset = &HC0

 StrRet = Chr$(&HF) & Chr$(0)
 VERRW_OpCodes = Operator_Offset
 
 Const Ext16 As Byte = &H66
 
 Select Case Op1_Type
 Case "m16"
    StrRet = Chr$(Ext16) & StrRet
 Case "r16"
    StrRet = Chr$(Ext16) & StrRet
    VERRW_OpCodes = VERRW_OpCodes + R_Offset
 Case "m32"
 Case "r32"
    VERRW_OpCodes = VERRW_OpCodes + R_Offset
 Case Else
    StrRet = "": VERRW_OpCodes = 0
 End Select
End Function

Public Function Compile(ByRef SourceCode As String, Optional ByVal AutoCreateProc As Boolean = True) As Boolean
 COMPILER_ClearCodeBuffer
 
 Source = Split(SourceCode, vbCrLf)
 
 Compiler_Constants2Mnemonics
 If Not Compiler_Mnmemonics2OpCodes Then Compile = False: Exit Function
 If Not Compiler_CalculateLabels(AutoCreateProc) Then Compile = False: Exit Function
 If AutoCreateProc Then COMPILER_CreateCodeProc
 
 'Code_Export
 Compiler_SaveToFile App.Path & "\LASM.BIN"
 Compile = True
End Function

Sub Compiler_Constants2Mnemonics()
Dim ClearNonCode As Long, CmdLine As String, Operand1 As String, Operand2 As String, Mnemonic As String

For ClearNonCode = 0 To UBound(Source)
    CmdLine = Trim$(Source(ClearNonCode))
    Mnemonic = Compiler_SplitCmdLine(CmdLine, Operand1, Operand2)
    If Left$(CmdLine, 1) = "'" Or Left$(CmdLine, 1) = ";" Or Left$(UCase$(CmdLine), 4) = "REM " Then
        CmdLine = "": Source(ClearNonCode) = ""
        Mnemonic = "": Operand1 = "": Operand2 = ""
    End If
    If Mnemonic = "CONST" Then
        CONST_Save Right$(CmdLine, Len(CmdLine) - Len("CONST "))
        CmdLine = "": Source(ClearNonCode) = ""
    End If
Next ClearNonCode
End Sub

Function Compiler_Mnmemonics2OpCodes() As Boolean
    Dim Mnemonic As String, Operand1 As String, Operand2 As String
    Dim Mnemonic_Pos As Long, Operands() As String, CmdLine As String
    Dim MnemoCode As String, MnemoSubCode As String
    Dim IsLabel As Long
    Dim Operand2_Pos As Integer


Dim LabelNotValid As Integer
Dim EnumLines As Long
For EnumLines = 0 To UBound(Source)
    MnemoCode = ""
    IsLabel = 0
    CONST_Replace Source(EnumLines)
    CmdLine = Trim$(Source(EnumLines))
    IsLabel = InStr(1, CmdLine, ":")
    If IsLabel > 0 Then
        LabelNotValid = InStr(1, CmdLine, " "): If LabelNotValid > 0 And LabelNotValid < IsLabel Then MsgBox "Invalid LABEL:" & vbCr & vbTab & CmdLine, , "LINE: " & EnumLines: Exit Function
        GoTo SkipWork
    End If
    If Len(CmdLine) = 0 Then GoTo SkipWork
    Mnemonic_Pos = InStr(1, CmdLine, " ")
    If Mnemonic_Pos > 0 Then
        Mnemonic = Left$(CmdLine, Mnemonic_Pos - 1)
        CmdLine = Right$(CmdLine, Len(CmdLine) - Len(Mnemonic))
        CmdLine = Trim$(CmdLine)
            Operand2_Pos = InStr(1, CmdLine, ",")
            If Operand2_Pos = 0 Then
                Operand1 = CmdLine: Operand2 = ""
            Else
                Operand1 = Left$(CmdLine, Operand2_Pos - 1)
                Operand2 = Right$(CmdLine, Len(CmdLine) - Operand2_Pos)
            End If
    Else
        Mnemonic = CmdLine
        Operand1 = "": Operand2 = ""
    End If
    
    Select Case UCase$(Trim$(Mnemonic))
    Case "MOV"
        MnemoCode = MOV_Code(Operand1, Operand2)
    Case "MOVZX", "MOVSX"
        MnemoCode = MOVZXSX_Code(Mnemonic, Operand1, Operand2)
    Case "BSF", "BSR"
        MnemoCode = BSFR_Code(Mnemonic, Operand1, Operand2)
    Case "PUSH"
        MnemoCode = PUSH_Code(CmdLine)
    Case "PUSHAD"
        MnemoCode = PUSHAD_Code
    Case "POP"
        MnemoCode = POP_Code(CmdLine)
    Case "POPAD"
        MnemoCode = POPAD_Code
    Case "CALL"
        MnemoCode = CALL_Code(CmdLine)
    Case "RET"
        MnemoCode = RET_Code(Operand1)
    Case "RETN", "RETF"
        MnemoCode = RETNF_Code(Mnemonic)
    Case "DB", "DW", "DD"
        MnemoCode = DIRECT_CODE(UCase$(Trim$(Mnemonic)), CmdLine)
    Case "REP", "REPE", "REPZ", "REPNE", "REPNZ"
        MnemoCode = REP_Code(UCase$(Trim$(Mnemonic)), CmdLine)
    Case "CLC", "STC", "CMC", "CLD", "STD", "CLI", "STI", "LAHF", "SAHF", "PUSHF", "PUSHFD", "POPF", "POPFD"
        MnemoCode = FLAGS_Code(CmdLine)
    Case "EXIT FUNCTION", "END"
        MnemoCode = EXITFUNCTION_Code(Operand1)
    Case "OR", "ADC", "SBB", "AND", "XOR", "CMP", "ADD", "SUB", "BT", "BTS", "BTR", "BTC", "TEST"
        MnemoCode = Mnemonic_Common_Generator(UCase$(Trim$(Mnemonic)), Operand1, Operand2)
    Case "NOT", "NEG", "MUL", "IMUL", "DIV", "IDIV", "INC", "DEC"
        MnemoCode = SingleOperand_Generator(UCase$(Trim$(Mnemonic)), CmdLine)
    Case "LOOP", "LOOPE", "LOOPZ", "LOOPNE", "LOOPNZ", "JCXZ", "JECXZ"
        MnemoCode = LOOP_Code(Mnemonic)
    Case "CMPSB", "CMPSW", "CMPSD"
        MnemoCode = CMPS_Code(Mnemonic)
    Case "INSB", "INSW", "INSD"
        MnemoCode = INS_Code(Mnemonic)
    Case "LODSB", "LODSW", "LODSD"
        MnemoCode = LODS_Code(Mnemonic)
    Case "MOVSB", "MOVSW", "MOVSD"
        MnemoCode = MOVS_Code(Mnemonic)
    Case "OUTSB", "OUTSW", "OUTSD"
        MnemoCode = OUTS_Code(Mnemonic)
    Case "SCASB", "SCASW", "SCASD"
        MnemoCode = SCAS_Code(Mnemonic)
    Case "STOSB", "STOSW", "STOSD"
        MnemoCode = STOS_Code(Mnemonic)
    Case "JMP"
        MnemoCode = JMP_Code(Operand1)
    Case "ROL", "ROR", "RCL", "RCR", "SAL", "SHL", "SHR", "SAR"
        MnemoCode = SingleOperand30_Generator(Mnemonic, Operand1, Operand2)
    Case "AAA", "AAD", "AAM", "AAS", "CBW", "CWDE", "CWD", "CDQ", "DAA", "DAS", "INTO", "LEAVE", "NOP", "WAIT", "FWAIT", "HLT", "IRET", "IRETD", "XLAT", "XLATB", "LOCK"
        MnemoCode = MnemonicOnly_Opcode(Mnemonic)
    Case "INT"
        MnemoCode = INT_Code(Operand1)
    Case "BSWAP"
        MnemoCode = BSWAP_Code(Operand1)
    Case "IN"
        MnemoCode = IN_Code(Operand1, Operand2)
    Case "OUT"
        MnemoCode = OUT_Code(Operand1, Operand2)
    Case "LEA"
        MnemoCode = LEA_Code(Operand1, Operand2)
    Case "BOUND"
        MnemoCode = BOUND_Code(Operand1, Operand2)
    Case "CMPXCHG"
        MnemoCode = CMPXCHG_Code(Operand1, Operand2)
    Case "XCHG"
        MnemoCode = XCHG_Code(Operand1, Operand2)
    Case "ENTER"
        MnemoCode = ENTER_Code(Operand1, Operand2)
    Case "LAR"
        MnemoCode = LAR_Code(Operand1, Operand2)
    Case "VERR", "VERW"
        MnemoCode = VERRW_Code(Mnemonic, Operand1)
    Case SET_IsSet(Mnemonic)
        MnemoCode = SET_Code(Mnemonic, Operand1)
    Case Else
        If Left$(UCase$(CmdLine), 3) = "DB " Or Left$(UCase$(CmdLine), 3) = "DW " Or Left$(UCase$(CmdLine), 3) = "DD " Then
         COMPILER_AddCodeLen UCase$(Trim$(Mnemonic)), True
         MnemoCode = DIRECT_WLABELS_Code(CmdLine)
        End If
    End Select
    If Left$(UCase$(Trim$(Mnemonic)), 1) = "J" And UCase$(Trim$(Mnemonic)) <> "JMP" And UCase$(Trim$(Mnemonic)) <> "JCXZ" And UCase$(Trim$(Mnemonic)) <> "JECXZ" Then MnemoCode = JMP_Near_Code(Mnemonic) & Chr$(0) & Chr$(0) & Chr$(0) & Chr$(0)
    'If Left$(UCase$(Trim$(Mnemonic)), 1) = "J" Then MnemoCode = JMP_Near_Label_Code(Mnemonic, CmdLine)
    If MnemoCode = "" Then
        MsgBox "Syntax Error" & vbCr & Source(EnumLines), 16, "LINE: " & EnumLines + 1
        Exit Function
    End If
    COMPILER_AddCode MnemoCode
    COMPILER_AddCodeLen Len(MnemoCode), False
SkipWork:
    If IsLabel > 0 Then
        CmdLine = Left$(CmdLine, IsLabel - 1)
        COMPILER_AddCodeLen CmdLine, True
    End If
Next EnumLines
Compiler_Mnmemonics2OpCodes = True
End Function

Function Compiler_CalculateLabels(Optional ByVal AutoCreateProc As Boolean = True) As Boolean
Dim Array_IP As Long, Curr_IP As Long, LabelName As String, LabelNamePos As Long
 Dim Mnemonic_Addr As String, Operand1_Addr As String, Operand2_Addr As String, CmdWoMnm As String
 Dim Mnemonic_Addr_Pos As Integer, Operand2_Addr_Pos As Integer

Dim Scnd_EnumLines As Long, CmdLine As String, IsLabel_Pos As Integer
For Scnd_EnumLines = 0 To UBound(Source)
    CmdLine = Trim$(Source(Scnd_EnumLines))
    IsLabel_Pos = 0
    IsLabel_Pos = InStr(1, CmdLine, ":")
    If IsLabel_Pos > 0 Then GoTo SkipWork2
    If Len(CmdLine) = 0 Then GoTo SkipWork2
    Mnemonic_Addr_Pos = InStr(1, CmdLine, " "): If Mnemonic_Addr_Pos = 0 Then GoTo SkipWork21
    Mnemonic_Addr = UCase$(Trim$(Left$(CmdLine, Mnemonic_Addr_Pos - 1)))
    CmdWoMnm = Trim$(Right$(CmdLine, Len(CmdLine) - Mnemonic_Addr_Pos))
    Operand2_Addr_Pos = InStr(1, CmdWoMnm, ",")
    If Operand2_Addr_Pos = 0 Then
        Operand1_Addr = CmdWoMnm: Operand2_Addr = ""
    Else
        Operand1_Addr = Left$(CmdWoMnm, Operand2_Addr_Pos - 1)
        Operand2_Addr = Right$(CmdWoMnm, Len(CmdWoMnm) - Operand2_Addr_Pos)
    End If
    ' Mnemonic_Addr, Operand1_Addr, Operand2_Addr
    
    If Left$(Mnemonic_Addr, 1) = "J" Then
       Select Case Mnemonic_Addr
       Case "JCXZ", "JECXZ"
        LOOP_Label_Code Mnemonic_Addr, Operand1_Addr, Curr_IP
       Case Else
        Call JMP_Near_Label_Code(Mnemonic_Addr, Operand1_Addr, Curr_IP)
       End Select
    ElseIf Mnemonic_Addr = "MOV" Then ''Or Left$(UCase$(Trim$(CmdLine)), 4) = "ADD " Or Left$(UCase$(Trim$(CmdLine)), 4) = "SUB " Or Left$(UCase$(Trim$(CmdLine)), 4) = "CMP "
       If Register_Code(UCase$(Trim$(Operand1_Addr))) <> 255 Then MOV_Label_Code COMPILER_FindLabelAddr(UCase$(Trim$(Operand2_Addr))), Curr_IP, AutoCreateProc
    ElseIf Mnemonic_Addr = "PUSH" Then
     PUSH_Label_Code COMPILER_FindLabelAddr(UCase$(Trim$(Operand1_Addr))), Curr_IP, AutoCreateProc
    ElseIf Mnemonic_IsCommon(CmdLine) Then
      Mnemonic_Common_Lbl2Addr CmdLine, Curr_IP, AutoCreateProc
    ElseIf Loop_Label_True(Mnemonic_Addr) Then
      LOOP_Label_Code Mnemonic_Addr, Operand1_Addr, Curr_IP
      'Mnemonic_Common_Lbl2Addr CmdLine, Curr_IP
    ElseIf Mnemonic_Addr = "CALL" Then
        MsgBox "CALL"
        Call JMP_Near_Label_Code(Mnemonic_Addr, Operand1_Addr, Curr_IP)
    ElseIf IsLabel(Operand2_Addr) Then
      MsgBox "Label not supported for this operation", , Source(Scnd_EnumLines)
      Compiler_CalculateLabels = False
      Exit Function
    End If
SkipWork21:
    Array_IP = Array_IP + 1
    Curr_IP = Curr_IP + GetCodeLen(Array_IP)
SkipWork2:
Next Scnd_EnumLines
Compiler_CalculateLabels = True
End Function

Sub Compiler_SaveToFile(ByVal FileName As String, Optional ByVal SaveAsHex As Boolean = False)
 Dim CopyOfCode As String
 If Not SaveAsHex Then
    CopyOfCode = code
 Else
    CopyOfCode = Compiler_SaveToFile_Bin2Hex(code)
 End If
 
 On Error GoTo ErrKill
 If Len(Dir$(FileName)) > 0 Then Kill FileName
 Dim fChnl As Long
 fChnl = FreeFile
 Open FileName For Binary As #fChnl
 Put #fChnl, 1, CopyOfCode
 Close fChnl
 Exit Sub
 
ErrKill:
 MsgBox Error$(Err), 16, "Save: " & FileName
 Resume Next

End Sub

Function Compiler_SaveToFile_Bin2Hex(ByRef Source As String) As String
 Dim RetFunc As String, NextByte As String
 Dim Convert As Long
 For Convert = 1 To Len(Source)
  NextByte = Hex$(Asc(Mid$(Source, Convert, 1)))
  If Len(NextByte) < 2 Then NextByte = "0" & NextByte
  RetFunc = RetFunc & NextByte
 Next Convert
 Compiler_SaveToFile_Bin2Hex = RetFunc
End Function

Function GetCode() As String
 GetCode = code
End Function

