VERSION 5.00
Begin VB.Form LASMIDE 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "IDE: Local Assembler"
   ClientHeight    =   6945
   ClientLeft      =   45
   ClientTop       =   330
   ClientWidth     =   9285
   ForeColor       =   &H80000008&
   Icon            =   "LASMIDE.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   6945
   ScaleWidth      =   9285
   StartUpPosition =   2  'CenterScreen
   WhatsThisButton =   -1  'True
   WhatsThisHelp   =   -1  'True
   Begin VB.Timer Timer_SyntaxHiLight 
      Left            =   2040
      Top             =   1080
   End
   Begin VB.PictureBox Picture1 
      AutoSize        =   -1  'True
      BorderStyle     =   0  'None
      Height          =   255
      Left            =   3840
      Picture         =   "LASMIDE.frx":030A
      ScaleHeight     =   255
      ScaleWidth      =   1200
      TabIndex        =   14
      Top             =   0
      Visible         =   0   'False
      Width           =   1200
   End
   Begin VB.CheckBox CheckStack 
      Caption         =   "Auto save/restore stack"
      Height          =   195
      Left            =   7200
      TabIndex        =   13
      ToolTipText     =   "See COMPILER_CreateCodeProc function"
      Top             =   6675
      Value           =   1  'Checked
      WhatsThisHelpID =   12
      Width           =   2055
   End
   Begin VB.TextBox TxtPreCode 
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   204
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   5895
      Left            =   7320
      Locked          =   -1  'True
      MultiLine       =   -1  'True
      ScrollBars      =   3  'Both
      TabIndex        =   11
      Top             =   720
      WhatsThisHelpID =   6
      Width           =   1935
   End
   Begin VB.TextBox Text7 
      Height          =   285
      Left            =   2880
      TabIndex        =   10
      Text            =   "0"
      Top             =   6645
      WhatsThisHelpID =   9
      Width           =   975
   End
   Begin VB.TextBox Text6 
      Height          =   285
      Left            =   1920
      TabIndex        =   9
      Text            =   "0"
      Top             =   6645
      WhatsThisHelpID =   9
      Width           =   975
   End
   Begin VB.TextBox Text5 
      Height          =   285
      Left            =   960
      TabIndex        =   8
      Text            =   "0"
      Top             =   6645
      WhatsThisHelpID =   9
      Width           =   975
   End
   Begin VB.TextBox Text4 
      Height          =   285
      Left            =   0
      TabIndex        =   6
      Text            =   "0"
      Top             =   6645
      WhatsThisHelpID =   9
      Width           =   975
   End
   Begin VB.ListBox List2 
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   204
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   5580
      Left            =   720
      TabIndex        =   4
      Top             =   720
      WhatsThisHelpID =   2
      Width           =   735
   End
   Begin VB.ListBox List1 
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   204
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   5580
      Left            =   0
      TabIndex        =   3
      Top             =   720
      WhatsThisHelpID =   2
      Width           =   735
   End
   Begin VB.TextBox Text3 
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   204
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   5895
      Left            =   5400
      Locked          =   -1  'True
      MultiLine       =   -1  'True
      ScrollBars      =   3  'Both
      TabIndex        =   1
      Text            =   "LASMIDE.frx":0634
      Top             =   720
      WhatsThisHelpID =   5
      Width           =   1935
   End
   Begin VB.Label Label4 
      Alignment       =   2  'Center
      Appearance      =   0  'Flat
      BackStyle       =   0  'Transparent
      BorderStyle     =   1  'Fixed Single
      Caption         =   " Line: 1"
      BeginProperty Font 
         Name            =   "Microsoft Sans Serif"
         Size            =   11.25
         Charset         =   204
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H80000008&
      Height          =   300
      Left            =   4095
      TabIndex        =   15
      Top             =   6645
      Width           =   1215
   End
   Begin VB.Label Label3 
      BackColor       =   &H8000000D&
      BorderStyle     =   1  'Fixed Single
      Caption         =   " CONST/REM free"
      ForeColor       =   &H8000000E&
      Height          =   255
      Left            =   7320
      TabIndex        =   12
      Top             =   435
      WhatsThisHelpID =   6
      Width           =   1935
   End
   Begin VB.Label Label2 
      Alignment       =   2  'Center
      BackColor       =   &H8000000D&
      Caption         =   "Arguments"
      ForeColor       =   &H8000000E&
      Height          =   255
      Left            =   0
      TabIndex        =   7
      Top             =   6360
      WhatsThisHelpID =   9
      Width           =   1455
   End
   Begin VB.Label Label1 
      BackColor       =   &H8000000D&
      BorderStyle     =   1  'Fixed Single
      Caption         =   " Addr DEC/HEX"
      ForeColor       =   &H8000000E&
      Height          =   255
      Left            =   0
      TabIndex        =   5
      Top             =   435
      WhatsThisHelpID =   2
      Width           =   1455
   End
   Begin VB.Label Label8 
      BackColor       =   &H8000000D&
      BorderStyle     =   1  'Fixed Single
      Caption         =   " HEX"
      ForeColor       =   &H8000000E&
      Height          =   255
      Left            =   5400
      TabIndex        =   2
      Top             =   435
      WhatsThisHelpID =   5
      Width           =   1935
   End
   Begin VB.Label Label7 
      BackColor       =   &H8000000D&
      BorderStyle     =   1  'Fixed Single
      Caption         =   " EDITOR"
      ForeColor       =   &H8000000E&
      Height          =   255
      Left            =   1440
      TabIndex        =   0
      Top             =   435
      WhatsThisHelpID =   3
      Width           =   3975
   End
End
Attribute VB_Name = "LASMIDE"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Private Declare Function WinHelp Lib "user32" Alias "WinHelpA" (ByVal hwnd As Long, ByVal lpHelpFile As String, ByVal wCommand As Long, ByVal dwData As Long) As Long

Private Const HELP_CONTEXTPOPUP = &H8&
Private Const HELP_CONTEXT = &H1

Private Declare Function SendMessage Lib "user32.dll" Alias "SendMessageA" ( _
     ByVal hwnd As Long, _
     ByVal wMsg As Long, _
     ByVal wParam As Long, _
     ByRef lParam As Any) As Long

Private Declare Function UpdateWindow Lib "user32.dll" ( _
     ByVal hwnd As Long) As Long

Private Declare Function GetLastError Lib "kernel32.dll" () As Long

Public WithEvents rEdit As cRichEdit
Attribute rEdit.VB_VarHelpID = -1
Private Declare Function MoveWindow Lib "user32.dll" (ByVal hwnd As Long, ByVal x As Long, ByVal y As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal bRepaint As Long) As Long

Private hTB2 As Long

Private Type CHARRANGE
    cpMin           As Long
    cpMax           As Long
End Type

Private rEdit_ScrollAction As Boolean

Private Sub LASMIDE_COMPILE()
List1.Clear: List2.Clear
COMPILER_ClearCodeBuffer
Text3.Text = "": TxtPreCode = ""
Dim Text3_Lines() As String: ReDim Text3_Lines(0)
Dim LinesToCompile() As String
LinesToCompile = Split(rEdit.Text(False), vbCrLf)
    Dim Mnemonic As String, Operand1 As String, Operand2 As String
    Dim Mnemonic_Pos As Long, Operands() As String, CmdLine As String
    Dim MnemoCode As String, MnemoSubCode As String
    Dim IsLabel As Long
    Dim Operand2_Pos As Integer

Dim AutoProc As Boolean
If CheckStack.Value = 1 Then AutoProc = True Else AutoProc = False

For ClearNonCode = 0 To UBound(LinesToCompile)
    CmdLine = Trim$(LinesToCompile(ClearNonCode))
    Mnemonic = Compiler_SplitCmdLine(CmdLine, Operand1, Operand2)
    If Left$(CmdLine, 1) = "'" Or Left$(CmdLine, 1) = ";" Or Left$(UCase$(CmdLine), 4) = "REM " Then
        CmdLine = "": LinesToCompile(ClearNonCode) = ""
        Mnemonic = "": Operand1 = "": Operand2 = ""
    End If
    If Mnemonic = "CONST" Then
        CONST_Save Right$(CmdLine, Len(CmdLine) - Len("CONST "))
        CmdLine = "": LinesToCompile(ClearNonCode) = ""
    End If
Next ClearNonCode

Dim LabelNotValid As Integer
For EnumLines = 0 To UBound(LinesToCompile)
    MnemoCode = ""
    IsLabel = 0
    CONST_Replace LinesToCompile(EnumLines)
    CmdLine = Trim$(LinesToCompile(EnumLines))
    TxtPreCode.Text = TxtPreCode.Text & CmdLine & vbCrLf
    IsLabel = InStr(1, CmdLine, ":")
    If IsLabel > 0 Then
        LabelNotValid = InStr(1, CmdLine, " "): If LabelNotValid > 0 And LabelNotValid < IsLabel Then MsgBox "Invalid LABEL:" & vbCr & vbTab & CmdLine, , "LINE: " & EnumLines: Exit Sub
        GoTo SkipWork
    End If
    If Len(CmdLine) = 0 Then
        Text3_Lines(UBound(Text3_Lines)) = "": ReDim Preserve Text3_Lines(UBound(Text3_Lines) + 1)
        GoTo SkipWork
    End If
    Mnemonic_Pos = InStr(1, CmdLine, " ")
    If Mnemonic_Pos > 0 Then
        Mnemonic = Left$(CmdLine, Mnemonic_Pos - 1)
        CmdLine = Right$(CmdLine, Len(CmdLine) - Len(Mnemonic))
        CmdLine = Trim$(CmdLine)
            Operand2_Pos = InStr(1, CmdLine, ",")
            If Operand2_Pos = 0 Then
                Operand1 = CmdLine: Operand2 = ""
            Else
                Operand1 = Left$(CmdLine, Operand2_Pos - 1)
                Operand2 = Right$(CmdLine, Len(CmdLine) - Operand2_Pos)
            End If
    Else
        Mnemonic = CmdLine
        Operand1 = "": Operand2 = ""
    End If
    
    Select Case UCase$(Trim$(Mnemonic))
    Case "MOV"
        MnemoCode = MOV_Code(Operand1, Operand2)
    Case "MOVZX", "MOVSX"
        MnemoCode = MOVZXSX_Code(Mnemonic, Operand1, Operand2)
    Case "BSF", "BSR"
        MnemoCode = BSFR_Code(Mnemonic, Operand1, Operand2)
    Case "PUSH"
        MnemoCode = PUSH_Code(CmdLine)
    Case "PUSHAD"
        MnemoCode = PUSHAD_Code
    Case "POP"
        MnemoCode = POP_Code(CmdLine)
    Case "POPAD"
        MnemoCode = POPAD_Code
    Case "CALL"
        MnemoCode = CALL_Code(CmdLine)
    Case "RET"
        MnemoCode = RET_Code(Operand1)
    Case "RETN", "RETF"
        MnemoCode = RETNF_Code(Mnemonic)
    Case "DB", "DW", "DD"
        MnemoCode = DIRECT_CODE(UCase$(Trim$(Mnemonic)), CmdLine)
    Case "REP", "REPE", "REPZ", "REPNE", "REPNZ"
        MnemoCode = REP_Code(UCase$(Trim$(Mnemonic)), CmdLine)
    Case "CLC", "STC", "CMC", "CLD", "STD", "CLI", "STI", "LAHF", "SAHF", "PUSHF", "PUSHFD", "POPF", "POPFD"
        MnemoCode = FLAGS_Code(CmdLine)
    Case "EXIT FUNCTION", "END"
        MnemoCode = EXITFUNCTION_Code(Operand1)
    Case "OR", "ADC", "SBB", "AND", "XOR", "CMP", "ADD", "SUB", "BT", "BTS", "BTR", "BTC", "TEST"
        MnemoCode = Mnemonic_Common_Generator(UCase$(Trim$(Mnemonic)), Operand1, Operand2)
    Case "NOT", "NEG", "MUL", "IMUL", "DIV", "IDIV", "INC", "DEC"
        MnemoCode = SingleOperand_Generator(UCase$(Trim$(Mnemonic)), CmdLine)
    Case "LOOP", "LOOPE", "LOOPZ", "LOOPNE", "LOOPNZ", "JCXZ", "JECXZ"
        MnemoCode = LOOP_Code(Mnemonic)
    Case "CMPSB", "CMPSW", "CMPSD"
        MnemoCode = CMPS_Code(Mnemonic)
    Case "INSB", "INSW", "INSD"
        MnemoCode = INS_Code(Mnemonic)
    Case "LODSB", "LODSW", "LODSD"
        MnemoCode = LODS_Code(Mnemonic)
    Case "MOVSB", "MOVSW", "MOVSD"
        MnemoCode = MOVS_Code(Mnemonic)
    Case "OUTSB", "OUTSW", "OUTSD"
        MnemoCode = OUTS_Code(Mnemonic)
    Case "SCASB", "SCASW", "SCASD"
        MnemoCode = SCAS_Code(Mnemonic)
    Case "STOSB", "STOSW", "STOSD"
        MnemoCode = STOS_Code(Mnemonic)
    Case "JMP"
        MnemoCode = JMP_Code(Operand1)
    Case "ROL", "ROR", "RCL", "RCR", "SAL", "SHL", "SHR", "SAR"
        MnemoCode = SingleOperand30_Generator(Mnemonic, Operand1, Operand2)
    Case "AAA", "AAD", "AAM", "AAS", "CBW", "CWDE", "CWD", "CDQ", "DAA", "DAS", "INTO", "LEAVE", "NOP", "WAIT", "FWAIT", "HLT", "IRET", "IRETD", "XLAT", "XLATB", "LOCK"
        MnemoCode = MnemonicOnly_Opcode(Mnemonic)
    Case "INT"
        MnemoCode = INT_Code(Operand1)
    Case "BSWAP"
        MnemoCode = BSWAP_Code(Operand1)
    Case "IN"
        MnemoCode = IN_Code(Operand1, Operand2)
    Case "OUT"
        MnemoCode = OUT_Code(Operand1, Operand2)
    Case "LEA"
        MnemoCode = LEA_Code(Operand1, Operand2)
    Case "BOUND"
        MnemoCode = BOUND_Code(Operand1, Operand2)
    Case "CMPXCHG"
        MnemoCode = CMPXCHG_Code(Operand1, Operand2)
    Case "XCHG"
        MnemoCode = XCHG_Code(Operand1, Operand2)
    Case "ENTER"
        MnemoCode = ENTER_Code(Operand1, Operand2)
    Case "LAR"
        MnemoCode = LAR_Code(Operand1, Operand2)
    Case "VERR", "VERW"
        MnemoCode = VERRW_Code(Mnemonic, Operand1)
    Case SET_IsSet(Mnemonic)
        MnemoCode = SET_Code(Mnemonic, Operand1)
    Case Else
        If Left$(UCase$(CmdLine), 3) = "DB " Or Left$(UCase$(CmdLine), 3) = "DW " Or Left$(UCase$(CmdLine), 3) = "DD " Then
         COMPILER_AddCodeLen UCase$(Trim$(Mnemonic)), True
         MnemoCode = DIRECT_WLABELS_Code(CmdLine)
        End If
    End Select
    If Left$(UCase$(Trim$(Mnemonic)), 1) = "J" And UCase$(Trim$(Mnemonic)) <> "JMP" And UCase$(Trim$(Mnemonic)) <> "JCXZ" And UCase$(Trim$(Mnemonic)) <> "JECXZ" Then MnemoCode = JMP_Near_Code(Mnemonic) & Chr$(0) & Chr$(0) & Chr$(0) & Chr$(0)
    'If Left$(UCase$(Trim$(Mnemonic)), 1) = "J" Then MnemoCode = JMP_Near_Label_Code(Mnemonic, CmdLine)
    MnemoSubCode = ""
    For TranslToCode = 1 To Len(MnemoCode)
     MnemoSubCode = MnemoSubCode & Hex$(Asc(Mid$(MnemoCode, TranslToCode, 1))) & "/"
    Next TranslToCode
    If Right$(MnemoSubCode, 1) = "/" Then MnemoSubCode = Left$(MnemoSubCode, Len(MnemoSubCode) - 1)
    Text3_Lines(UBound(Text3_Lines)) = MnemoSubCode: ReDim Preserve Text3_Lines(UBound(Text3_Lines) + 1)
    COMPILER_AddCode MnemoCode
    If MnemoCode = "" Then
        RetMsgBox = MsgBox("Syntax Error:" & vbCr & LinesToCompile(EnumLines) & vbCr & vbCr & "Show help?", 16 + vbYesNo, "LINE: " & EnumLines + 1)
        If RetMsgBox = vbYes Then Call WinHelp(Me.hwnd, App.Path & "\LASM.HLP", HELP_CONTEXT, 3)
        COMPILER_ClearCodeBuffer
        Exit Sub
    End If
    COMPILER_AddCodeLen Len(MnemoCode), False
SkipWork:
    If IsLabel > 0 Then
        CmdLine = Left$(CmdLine, IsLabel - 1)
        COMPILER_AddCodeLen CmdLine, True
        Text3_Lines(UBound(Text3_Lines)) = "": ReDim Preserve Text3_Lines(UBound(Text3_Lines) + 1)
    End If
Next EnumLines

Dim Array_IP As Long, Curr_IP As Long, Curr_IP_Offset As Long, LabelName As String, LabelNamePos As Long
 Dim Mnemonic_Addr As String, Operand1_Addr As String, Operand2_Addr As String, CmdWoMnm As String
 Dim Mnemonic_Addr_Pos As Integer, Operand2_Addr_Pos As Integer
 Dim LblAddrShow As String
If AutoProc Then Curr_IP_Offset = 6
For Scnd_EnumLines = 0 To UBound(LinesToCompile)
    CmdLine = Trim$(LinesToCompile(Scnd_EnumLines))
    IsLabel = 0
    IsLabel = InStr(1, CmdLine, ":")
    If IsLabel > 0 Then List1.AddItem "": List2.AddItem "": GoTo SkipWork2
    If Len(CmdLine) = 0 Then List1.AddItem "": List2.AddItem "": GoTo SkipWork2
    Mnemonic_Addr_Pos = InStr(1, CmdLine, " "): If Mnemonic_Addr_Pos = 0 Then GoTo SkipWork21
    Mnemonic_Addr = UCase$(Trim$(Left$(CmdLine, Mnemonic_Addr_Pos - 1)))
    CmdWoMnm = Trim$(Right$(CmdLine, Len(CmdLine) - Mnemonic_Addr_Pos))
    Operand2_Addr_Pos = InStr(1, CmdWoMnm, ",")
    If Operand2_Addr_Pos = 0 Then
        Operand1_Addr = CmdWoMnm: Operand2_Addr = ""
    Else
        Operand1_Addr = Left$(CmdWoMnm, Operand2_Addr_Pos - 1)
        Operand2_Addr = Right$(CmdWoMnm, Len(CmdWoMnm) - Operand2_Addr_Pos)
    End If
    ' Mnemonic_Addr, Operand1_Addr, Operand2_Addr
    
    If Left$(Mnemonic_Addr, 1) = "J" Then
       Select Case Mnemonic_Addr
       Case "JCXZ", "JECXZ"
        LblAddrShow = ViewOpCodes_Bin2Hex(LOOP_Label_Code(Mnemonic_Addr, Operand1_Addr, Curr_IP))
        If Len(LblAddrShow) > 0 Then Text3_Lines(Scnd_EnumLines) = ViewOpCodes_Bin2Hex(LblAddrShow)
       Case Else
        LblAddrShow = JMP_Near_Label_Code(Mnemonic_Addr, Operand1_Addr, Curr_IP)
        If Len(LblAddrShow) > 0 Then Text3_Lines(Scnd_EnumLines) = ViewOpCodes_Bin2Hex(LblAddrShow)
       End Select
    ElseIf Mnemonic_Addr = "MOV" Then
      If Register_Code(UCase$(Trim$(Operand1_Addr))) <> 255 Then
        LblAddrShow = MOV_Label_Code(COMPILER_FindLabelAddr(UCase$(Trim$(Operand2_Addr))), Curr_IP, AutoProc)
        If Len(LblAddrShow) > 0 Then Text3_Lines(Scnd_EnumLines) = ViewOpCodes_Bin2Hex(LblAddrShow)
      End If
    ElseIf Mnemonic_Addr = "PUSH" Then
      LblAddrShow = PUSH_Label_Code(COMPILER_FindLabelAddr(UCase$(Trim$(Operand1_Addr))), Curr_IP, AutoProc)
      If Len(LblAddrShow) > 0 Then Text3_Lines(Scnd_EnumLines) = ViewOpCodes_Bin2Hex(LblAddrShow)
    ElseIf Mnemonic_IsCommon(CmdLine) And LASM.IsLabel(Operand2_Addr) Then
      LblAddrShow = Mnemonic_Common_Lbl2Addr(CmdLine, Curr_IP, AutoProc)
      If Len(LblAddrShow) > 0 Then Text3_Lines(Scnd_EnumLines) = ViewOpCodes_Bin2Hex(LblAddrShow)
    ElseIf Loop_Label_True(Mnemonic_Addr) Then
      LblAddrShow = LOOP_Label_Code(Mnemonic_Addr, Operand1_Addr, Curr_IP)
      If Len(LblAddrShow) > 0 Then Text3_Lines(Scnd_EnumLines) = ViewOpCodes_Bin2Hex(LblAddrShow)
    ElseIf Mnemonic_Addr = "CALL" Then
        LblAddrShow = JMP_Near_Label_Code(Mnemonic_Addr, Operand1_Addr, Curr_IP)
        If Len(LblAddrShow) > 0 Then Text3_Lines(Scnd_EnumLines) = ViewOpCodes_Bin2Hex(LblAddrShow)
    End If
SkipWork21:
    Array_IP = Array_IP + 1
    List1.AddItem Curr_IP + Curr_IP_Offset
    List2.AddItem Hex$(Curr_IP + Curr_IP_Offset)
    Curr_IP = Curr_IP + GetCodeLen(Array_IP)
SkipWork2:
 Text3 = Text3 & Text3_Lines(Scnd_EnumLines) & vbCrLf
Next Scnd_EnumLines

If Right$(Text3.Text, 2) = vbCrLf Then Text3.Text = Left$(Text3, Len(Text3) - 2)
If Right$(TxtPreCode.Text, 2) = vbCrLf Then TxtPreCode.Text = Left$(TxtPreCode, Len(TxtPreCode) - 2)

If AutoProc Then COMPILER_CreateCodeProc
Code_Export
 
    Const TB_ENABLEBUTTON = (WM_USER + 1)
    SendMessage hTB2, TB_ENABLEBUTTON, 202, ByVal 1
    SendMessage hTB2, TB_ENABLEBUTTON, 203, ByVal 1
    SendMessage hTB2, TB_ENABLEBUTTON, 204, ByVal 1

End Sub



Private Sub LASMIDE_RUN()
 If Len(GetCode) = 0 Then MsgBox "Nothing to execute." & vbCr & "Press 'Compile' button to generate machine code.", 48: Exit Sub
 On Error GoTo ErrASM
    Dim p1 As Long, p2 As Long, p3 As Long, p4 As Long
    p1 = Val(LASMIDE.Text4): p2 = Val(LASMIDE.Text5): p3 = Val(LASMIDE.Text6): p4 = Val(LASMIDE.Text7)
 MsgBox "FUNCTION RETURN: " & COMPILER_CallExecutor(p1, p2, p3, p4)
 Exit Sub
ErrASM:
 MsgBox "Error in machine code", 16, "LASM IDE"
 Resume Next
End Sub

Private Sub Form_Load()
 
 CreateToolBar Me
 MoveWindow hToolBar, 2, 0, 235, 28, 1
 
 hTB2 = NewToolBar(Me, Picture1, 200, 16, 5)
 MoveWindow hTB2, 495, 0, 120, 28, 1
    Const TB_ENABLEBUTTON = (WM_USER + 1)
    SendMessage hTB2, TB_ENABLEBUTTON, 202, ByVal 0
    SendMessage hTB2, TB_ENABLEBUTTON, 203, ByVal 0
    SendMessage hTB2, TB_ENABLEBUTTON, 204, ByVal 0
 
 
 IsFirstStart
 Text4 = CODEPTR(AddressOf Called)
 
 Set rEdit = New cRichEdit
 
 'Text1_OldProc = SetWindowLong(rEdit.hwnd, GWL_WNDPROC, AddressOf TextBox_CallBack)
 Text3_OldProc = SetWindowLong(Text3.hwnd, GWL_WNDPROC, AddressOf TextBox_CallBack)
 TxtPreCode_OldProc = SetWindowLong(TxtPreCode.hwnd, GWL_WNDPROC, AddressOf TextBox_CallBack)
 MessageThread = SetWindowLong(Me.hwnd, GWL_WNDPROC, AddressOf WindowProcCB)

    Const WS_BORDER = &H800000
    Const WS_TABSTOP = &H10000
    Call rEdit.Create(Me.hwnd, WS_BORDER Or rhES_AUTOHSCROLL Or rhES_AUTOVSCROLL Or rhES_DISABLENOSCROLL Or rhES_LEFT Or rhES_MULTILINE Or rhES_NOHIDESEL Or rhES_WANTRETURN Or rhWS_HSCROLL Or rhWS_VSCROLL, _
                      97, 47, 260, 395)
    
    Call rEdit.SetUndoLim(&H400)
    rEdit.ParagraphOffsets(rhNewParagraph) = 50

    Dim tmpFont As Font
    Set tmpFont = Me.Font

    
    rEdit.Font(rhSCF_DEFAULT) = Me.Font
    rEdit.FontColor(rhSCF_DEFAULT) = Me.ForeColor
    
    Me.Font.Name = Me.Font.Name
    Me.Font.Size = 10

    rEdit.Font(rhSCF_DEFAULT) = Me.Font
    rEdit.WordWrap = False
    
    rEdit.Text(False) = Text3
    Text3 = ""
    Timer_SyntaxHiLight.Interval = 1
  
  With MkBAS_Options
    .BasFile = "MyLasm.BAS"
    .CreateProject = 1
    .IncludeASM = 1
    .UseMsgbox = 1
  End With
  

End Sub

Private Sub Form_Unload(Cancel As Integer)
 'SetWindowLong Text1.hwnd, GWL_WNDPROC, Text1_OldProc
 SetWindowLong Text3.hwnd, GWL_WNDPROC, Text3_OldProc
 SetWindowLong TxtPreCode.hwnd, GWL_WNDPROC, TxtPreCode_OldProc
End Sub

Private Sub List1_Scroll()
 'SetWindowLong LASMIDE.Text1.hwnd, GWL_WNDPROC, Text1_OldProc
 SetWindowLong LASMIDE.Text3.hwnd, GWL_WNDPROC, Text3_OldProc
 SetWindowLong LASMIDE.TxtPreCode.hwnd, GWL_WNDPROC, TxtPreCode_OldProc
 
 Dim AlignedTopLine As Long
 AlignedTopLine = List1.TopIndex
 
 'Text_Scroll Text1.hwnd, AlignedTopLine
 Text_Scroll Text3.hwnd, AlignedTopLine
 Text_Scroll TxtPreCode.hwnd, AlignedTopLine
 
 Const LB_SETTOPINDEX = &H197
 List2.Visible = False
 SendMessage List2.hwnd, LB_SETTOPINDEX, AlignedTopLine, 0
 List2.Visible = True
 
 'Text1_OldProc = SetWindowLong(Text1.hwnd, GWL_WNDPROC, AddressOf TextBox_CallBack)
 Text3_OldProc = SetWindowLong(Text3.hwnd, GWL_WNDPROC, AddressOf TextBox_CallBack)
 TxtPreCode_OldProc = SetWindowLong(TxtPreCode.hwnd, GWL_WNDPROC, AddressOf TextBox_CallBack)
End Sub

Private Sub List2_Scroll()
 'SetWindowLong LASMIDE.Text1.hwnd, GWL_WNDPROC, Text1_OldProc
 SetWindowLong LASMIDE.Text3.hwnd, GWL_WNDPROC, Text3_OldProc
 SetWindowLong LASMIDE.TxtPreCode.hwnd, GWL_WNDPROC, TxtPreCode_OldProc
 
 Dim AlignedTopLine As Long
 AlignedTopLine = List2.TopIndex
 
 'Text_Scroll Text1.hwnd, AlignedTopLine
 Text_Scroll Text3.hwnd, AlignedTopLine
 Text_Scroll TxtPreCode.hwnd, AlignedTopLine
 
 Const LB_SETTOPINDEX = &H197
 List1.Visible = False
 SendMessage List1.hwnd, LB_SETTOPINDEX, AlignedTopLine, 0
 List1.Visible = True
 
 'Text1_OldProc = SetWindowLong(Text1.hwnd, GWL_WNDPROC, AddressOf TextBox_CallBack)
 Text3_OldProc = SetWindowLong(Text3.hwnd, GWL_WNDPROC, AddressOf TextBox_CallBack)
 TxtPreCode_OldProc = SetWindowLong(TxtPreCode.hwnd, GWL_WNDPROC, AddressOf TextBox_CallBack)

End Sub

Private Sub rEdit_KeyDown(KeyCode As Integer, Shift As Integer)
 If KeyCode = vbKeyF3 Then ToolBar_Click 9
 
 If KeyCode = vbKeyUp Or KeyCode = vbKeyDown Then
    Const SW_SHOW = 5
    Const SW_HIDE = 0
    ShowWindow rEdit.hwnd, SW_HIDE
    ASM_ColorLine rEdit.CurrentLine, True, True
    ShowWindow rEdit.hwnd, SW_SHOW
    Call rEdit.SetFocus
 End If
End Sub

Private Sub rEdit_KeyPress(KeyAscii As Integer)
 If KeyAscii = 13 Then
    If rEdit.CurrentLine + 1 = rEdit.LinesCount Then
        Timer_SyntaxHiLight.Interval = 1
    Else
        ASM_ColorLine rEdit.CurrentLine - 1, True, True
    End If
 End If
 If KeyAscii = 32 Or KeyAscii = Asc(",") Then ASM_ColorLine rEdit.CurrentLine, True, True
End Sub

Private Sub rEdit_MenuClick(ByVal MnuID As Long)
 Select Case MnuID
 Case 1
    If rEdit.CanUndo Then rEdit.Undo
 Case 2
    If rEdit.CanRedo Then rEdit.CanRedo
 Case 4
    If rEdit.CanCopy Then rEdit.Cut
 Case 5
    If rEdit.CanCopy Then rEdit.Copy
 Case 6
  If rEdit.CanPaste Then rEdit.Paste
 Case 7
    If rEdit.CanCopy Then rEdit.Clear
 Case 9
    rEdit.SelectAll
 End Select
End Sub

Private Sub rEdit_SelectionChange(ByVal lMin As Long, ByVal lMax As Long, ByVal SelType As gbRichEditSelTp)
  Label4.Caption = "Line: " & rEdit.CurrentLine + 1
End Sub

Function ViewOpCodes_Bin2Hex(ByVal OpCodes As String) As String
 Dim RetFunc As String
 For ConvertToHex = 1 To Len(OpCodes)
    RetFunc = RetFunc & Hex$(Asc(Mid$(OpCodes, ConvertToHex, 1))) & "/"
 Next ConvertToHex
 If Right$(RetFunc, 1) = "/" Then RetFunc = Left$(RetFunc, Len(RetFunc) - 1)
 ViewOpCodes_Bin2Hex = RetFunc
End Function

Function Load_Source(ByVal FileName As String) As Boolean
 On Error GoTo Cant_Open
 
 Dim fChanell As Long
 fChanell = FreeFile
 Dim strBuff As String
 Open FileName For Binary As #fChanell
 strBuff = Space$(LOF(fChanell))
 Get #fChanell, 1, strBuff
 Close #fChanell
 rEdit.Text(False) = strBuff
 
 Const SW_SHOW = 5
 Const SW_HIDE = 0
 Dim ClrLines As Long
 ShowWindow rEdit.hwnd, SW_HIDE
 For ClrLines = 0 To rEdit.LinesCount - 1
  ASM_ColorLine ClrLines, False
 Next ClrLines
 ShowWindow rEdit.hwnd, SW_SHOW
 Text3.Text = "": TxtPreCode.Text = "": List1.Clear: List2.Clear
 COMPILER_ClearCodeBuffer
 Me.Caption = Left$(FileName, InStr(1, FileName, Chr$(0)) - 1) & " - LASM IDE"
    Const TB_ENABLEBUTTON = (WM_USER + 1)
    SendMessage hTB2, TB_ENABLEBUTTON, 202, ByVal 0
    SendMessage hTB2, TB_ENABLEBUTTON, 203, ByVal 0
    SendMessage hTB2, TB_ENABLEBUTTON, 204, ByVal 0
 Exit Function

Cant_Open:
 MsgBox "Error opening: " & FileName, 16, Error$(Err)
 Exit Function
End Function

Function Save_Source(ByVal FileName As String) As Boolean
 On Error GoTo Cant_Open
 
 If Len(Dir$(FileName)) > 0 Then Kill FileName
 
 Dim fChanell As Long
 fChanell = FreeFile
 Dim strBuff As String
 Open FileName For Binary As #fChanell
 Put #fChanell, 1, rEdit.Text(False)
 Close #fChanell
 Me.Caption = Me.Caption = Left$(FileName, InStr(1, FileName, Chr$(0)) - 1) & " - LASM IDE"
 Exit Function

Cant_Open:
 MsgBox "Error opening: " & FileName, 16, Error$(Err)
 Exit Function
End Function

Sub IsFirstStart()
 If Dir$(App.Path & "\lasmide.GID", vbHidden) = "" Then Call WinHelp(Me.hwnd, App.Path & "\lasmide.HLP", HELP_CONTEXT, 1)
End Sub

Function Text_TopLine(ByVal hwnd As Long) As Long
 Const EM_GETFIRSTVISIBLELINE = &HCE
 Text_TopLine = SendMessage(hwnd, EM_GETFIRSTVISIBLELINE, 0, ByVal 0)
End Function

Sub Text_AlignTopLines(ByVal hWnd_Action As Long, SB_Action As Long)
 SendMessage hWnd_Action, WM_VSCROLL, SB_Action, 0
 
 Dim AlignedTopLine As Long
 AlignedTopLine = Text_TopLine(hWnd_Action)
 
 'If hWnd_Action <> Text1.hwnd Then Text_Scroll Text1.hwnd, AlignedTopLine
 If hWnd_Action <> Text3.hwnd Then Text_Scroll Text3.hwnd, AlignedTopLine
 If hWnd_Action <> TxtPreCode.hwnd Then Text_Scroll TxtPreCode.hwnd, AlignedTopLine
  rEdit_ScrollAction = True
 Text_Scroll rEdit.hwnd, AlignedTopLine
  rEdit_ScrollAction = False
 
 Const LB_SETTOPINDEX = &H197
 List1.Visible = False: List2.Visible = False
 SendMessage List1.hwnd, LB_SETTOPINDEX, AlignedTopLine, 0
 SendMessage List2.hwnd, LB_SETTOPINDEX, AlignedTopLine, 0
 List1.Visible = True: List2.Visible = True
 
 'Text1_OldProc = SetWindowLong(Text1.hwnd, GWL_WNDPROC, AddressOf TextBox_CallBack)
 Text3_OldProc = SetWindowLong(Text3.hwnd, GWL_WNDPROC, AddressOf TextBox_CallBack)
 TxtPreCode_OldProc = SetWindowLong(TxtPreCode.hwnd, GWL_WNDPROC, AddressOf TextBox_CallBack)
 
End Sub

Sub Text_AlignTopLines_Wheel(ByVal hWnd_Action As Long, ByVal wParam As Long, ByVal lParam As Long)
 'SendMessage hWnd_Action, WM_MOUSEWHEEL, wParam, lParam
 
 Const WHEEL_ForeWard As Integer = 120, WHEEL_BackWard As Integer = -120
 Const SB_LINEDOWN = 1, SB_LINEUP = 0
 Dim SB_Action As Long
 Select Case HiWord(wParam)
 Case WHEEL_ForeWard
    SendMessage hWnd_Action, WM_VSCROLL, SB_LINEUP, 0
 Case WHEEL_BackWard
    SendMessage hWnd_Action, WM_VSCROLL, SB_LINEDOWN, 0
 End Select
 
 Dim AlignedTopLine As Long
 AlignedTopLine = Text_TopLine(hWnd_Action)
 
 'If hWnd_Action <> Text1.hwnd Then Text_Scroll Text1.hwnd, AlignedTopLine
 If hWnd_Action <> Text3.hwnd Then Text_Scroll Text3.hwnd, AlignedTopLine
 If hWnd_Action <> TxtPreCode.hwnd Then Text_Scroll TxtPreCode.hwnd, AlignedTopLine
  rEdit_ScrollAction = True
 Text_Scroll rEdit.hwnd, AlignedTopLine
  rEdit_ScrollAction = False
 
 Const LB_SETTOPINDEX = &H197
 List1.Visible = False: List2.Visible = False
 SendMessage List1.hwnd, LB_SETTOPINDEX, AlignedTopLine, 0
 SendMessage List2.hwnd, LB_SETTOPINDEX, AlignedTopLine, 0
 List1.Visible = True: List2.Visible = True
 
 'Text1_OldProc = SetWindowLong(Text1.hwnd, GWL_WNDPROC, AddressOf TextBox_CallBack)
 Text3_OldProc = SetWindowLong(Text3.hwnd, GWL_WNDPROC, AddressOf TextBox_CallBack)
 TxtPreCode_OldProc = SetWindowLong(TxtPreCode.hwnd, GWL_WNDPROC, AddressOf TextBox_CallBack)

End Sub

Sub List_TopLines(ByVal NewTopLine As Long)
 Const LB_SETTOPINDEX = &H197
 SendMessage List1.hwnd, LB_SETTOPINDEX, NewTopLine, 0
 SendMessage List2.hwnd, LB_SETTOPINDEX, NewTopLine, 0
End Sub

Sub Text_Scroll(ByVal hwnd As Long, ByVal NewTopLine As Long)
 Dim Text_CurrLine As Long
 Text_CurrLine = Text_TopLine(hwnd)
 If Text_CurrLine = NewTopLine Then Exit Sub
 
 Const EM_SCROLL = &HB5
 Const SB_LINEDOWN = 1
 Const SB_LINEUP = 0
 
 Dim ScrollMsg As Long, ScrollCount As Long
 If Text_CurrLine < NewTopLine Then
    ScrollMsg = SB_LINEDOWN
    ScrollCount = NewTopLine - Text_CurrLine
 ElseIf Text_CurrLine > NewTopLine Then
    ScrollMsg = SB_LINEUP
    ScrollCount = Text_CurrLine - NewTopLine
 End If
 Dim Scrolling As Long
 Const WM_VSCROLL = &H115
 For Scrolling = 1 To ScrollCount
    SendMessage hwnd, WM_VSCROLL, ScrollMsg, 0
 Next Scrolling
End Sub

Sub ASM_ColorLine(LineNumber As Long, ByVal Redraw As Boolean, Optional ByVal RestoreSel As Boolean = True)
 rEdit.FontColor(rhSCF_DEFAULT) = Me.ForeColor
 
 Const EM_LINEINDEX = &HBB
 Dim PrevX As Long, PrevY As Long
    PrevX = rEdit.SelStart
    PrevY = rEdit.SelLength
 
 Dim LineText As String, LineText_Len As Long
 LineText = rEdit.LineText(LineNumber)
 LineText_Len = Len(LineText) - Len(LTrim$(LineText))
 LineText = LTrim$(LineText)
 
 Dim LinePos_Start As Long
 LinePos_Start = SendMessage(rEdit.hwnd, EM_LINEINDEX, LineNumber, 0)
 If LinePos_Start < 0 Then Exit Sub
 
 LinePos_Start = LinePos_Start + LineText_Len
 
 Dim Start_Pos As Long, End_Pos As Long
 RichEdit_SetSel LinePos_Start, rEdit.LineLength(LineNumber)
 rEdit.FontColor(rhSCF_SELECTION) = Me.ForeColor
 rEdit.FontBold(rhSCF_SELECTION) = False
 
 Start_Pos = LinePos_Start
 Dim IsCmd As String
 IsRemark = UCase$(Trim$(LineText))
 If Left$(IsRemark, 1) = ";" Or Left$(IsRemark, 1) = "'" Or Left$(IsRemark, 4) = "REM " Then
     RichEdit_SetSel Start_Pos, rEdit.LineLength(LineNumber), Redraw
     rEdit.FontColor(rhSCF_SELECTION) = QBColor(2)
     GoTo RestorePrevSel_Exit
 End If
 
 SelWrdPos = InStr(1, LineText, ":")
 If SelWrdPos > 0 Then
    RichEdit_SetSel Start_Pos, SelWrdPos, Redraw
    rEdit.FontColor(rhSCF_SELECTION) = Me.ForeColor
    rEdit.FontBold(rhSCF_SELECTION) = True
    GoTo RestorePrevSel_Exit
 End If
 
 SelWrdPos = InStr(1, LineText, " ")
 If SelWrdPos = 0 Then SelWrdPos = rEdit.LineLength(LineNumber)
 IsCmd = Left$(LineText, SelWrdPos)
 RichEdit_SetSel Start_Pos, SelWrdPos, Redraw
 Dim CmdName As String: CmdName = IsCmdValid(IsCmd)
 If Len(CmdName) > 0 Then
    rEdit.FontColor(rhSCF_SELECTION) = QBColor(1)
    If CmdName = "CONST" Then ASM_ColorConst rEdit.SelStart + rEdit.SelLength, 0, LineText: GoTo RestorePrevSel_Exit
 Else
    RichEdit_SetSel Start_Pos, rEdit.LineLength(LineNumber), Redraw
    rEdit.FontColor(rhSCF_SELECTION) = Me.ForeColor
    GoTo RestorePrevSel_Exit
 End If
 
 If SelWrdPos = rEdit.LineLength(LineNumber) Then GoTo RestorePrevSel_Exit
 
 Start_Pos = rEdit.SelStart + SelWrdPos
 
 Dim SrcBegin As Long
 SrcBegin = SelWrdPos
 SelWrdPos = InStr(SelWrdPos + 1, LineText, ",")
 If SelWrdPos = 0 Then SelWrdPos = rEdit.LineLength(LineNumber)
 IsCmd = Left$(LineText, SelWrdPos)
 RichEdit_SetSel Start_Pos, SelWrdPos - SrcBegin, Redraw
 rEdit.FontColor(rhSCF_SELECTION) = QBColor(4)
 
 If SelWrdPos = rEdit.LineLength(LineNumber) Then GoTo RestorePrevSel_Exit
 
 Dim LastPos As Long
 LastPos = LinePos_Start + rEdit.LineLength(LineNumber)
 RichEdit_SetSel rEdit.SelStart + rEdit.SelLength, LastPos - (rEdit.SelStart + rEdit.SelLength), Redraw
 rEdit.FontColor(rhSCF_SELECTION) = QBColor(6)
 
RestorePrevSel_Exit:
    If RestoreSel Then RichEdit_SetSel PrevX, PrevY, Redraw
    rEdit.FontColor(rhSCF_SELECTION) = Me.ForeColor
End Sub

Function IsCmdValid(ByVal Cmd As String) As String
Select Case UCase$(Trim$(Cmd))
Case "AAA", "AAD", "AAM", "AAS", "ADC", "ADD", "AND", "BOUND", _
     "BSF", "BSR", "BSWAP", "BT", "BTS", "BTR", "BTC", "CALL", _
     "CBW", "CDQ", "CMPSB", "CMPSW", "CMPSD", "CMPXCHG", "CONST", _
     "CMP", "CWD", "CWDE", "DAA", "DAS", "DB", "DD", "DEC", _
     "DIV", "DW", "EXIT FUNCTION", "END", "ENTER", "CLC", "STC", _
     "CMC", "CLD", "STD", "CLI", "STI", "LAHF", "SAHF", "PUSHF", _
     "PUSHFD", "POPF", "POPFD", "FWAIT", "HLT", "IMUL", "IDIV", _
     "IN", "INC", "INSB", "INSW", "INSD", "INT", "INTO", "IRET", _
     "IRETD", "JMP", "JO", "JNO", "JB", "JC", "JNAE", "JAE", "JNB", _
     "JNC", "JE", "JZ", "JNE", "JNZ", "JBE", "JNA", "JA", "JNBE", _
     "JS", "JNS", "JP", "JPE", "JPO", "JNP", "JL", "JNGE", "JGE", _
     "JNL", "JLE", "JNG", "JG", "JNLE", "JCXZ", "JECXZ", "LAR", _
     "LEA", "LEAVE", "LOCK", "LODSB", "LODSW", "LODSD", "LOOP", _
     "LOOPNE", "LOOPNZ", "LOOPE", "LOOPZ", "MOV", "MOVSB", "MOVSW", _
     "MOVSD", "MOVSX", "MOVZX", "MUL", "NEG", "NOP", "NOT", "OR", _
     "OUT", "OUTSB", "OUTSW", "OUTSD", "POP", "POPAD", "PUSH", _
     "PUSHAD", "RCL", "RCR", "REP", "REPE", "REPZ", "REPNE", "REPNZ", _
     "RET", "RETF", "RETN", "ROL", "ROR", "SAL", "SAR", "SBB", _
     "SCASB", "SCASW", "SCASD", "SETO", "SETNO", "SETB", "SETNAE", _
     "SETC", "SETNC", "SETNB", "SETAE", "SETE", "SETZ", "SETNE", _
     "SETNZ", "SETBE", "SETNA", "SETA", "SETS", "SETNS", "SETP", _
     "SETPE", "SETNP", "SETPO", "SETL", "SETNGE", "SETGE", "SETNL", _
     "SETLE", "SETNG", "SETG", "SETNLE", "SHL", "SHR", "STOSB", _
     "STOSW", "STOSD", "SUB", "TEST", "VERR", "VERW", "WAIT", "XCHG", _
     "XLAT", "XLATB", "XOR"
        IsCmdValid = UCase$(Trim$(Cmd))
End Select
End Function

Sub ASM_ColorConst(ByVal Start As Long, ByVal Length As Long, ByVal Text As String)
 Text = UCase$(Text)
 If Left$(Text, 6) = "CONST " Then
    Text = Right$(Text, Len(Text) - Len("CONST "))
 End If
 
 Dim EQU_Pos As Long, IsEqu As Boolean
 IsEqu = True
 EQU_Pos = InStr(1, Text, " EQU ")
 If EQU_Pos = 0 Then EQU_Pos = InStr(1, Text, "="): IsEqu = False
 If EQU_Pos = 0 Then Exit Sub
 
 RichEdit_SetSel Start, EQU_Pos - 1
 rEdit.FontColor(rhSCF_SELECTION) = QBColor(4)
 
 Dim EquLen As Long
 If IsEqu Then EquLen = Len(" EQU ") Else EquLen = 1
 RichEdit_SetSel rEdit.SelStart + rEdit.SelLength, EquLen
 rEdit.FontColor(rhSCF_SELECTION) = QBColor(1)
 
 Dim LastPos As Long
 LastPos = rEdit.SelStart + rEdit.SelLength
 RichEdit_SetSel LastPos, Len(Text) - (EQU_Pos + EquLen - 1)
 rEdit.FontColor(rhSCF_SELECTION) = QBColor(6)
 
End Sub

Sub ToolBar_Click(ByVal ButtonNumber As Long)
 Static strFind As String
 
 Select Case ButtonNumber
 Case 1
    rEdit.SelectAll
    rEdit.Text(False) = ""
    Text3.Text = "": TxtPreCode.Text = "": List1.Clear: List2.Clear
    COMPILER_ClearCodeBuffer
    Me.Caption = "IDE: Local Assembler"
    Const TB_ENABLEBUTTON = (WM_USER + 1)
    SendMessage hTB2, TB_ENABLEBUTTON, 202, ByVal 0
    SendMessage hTB2, TB_ENABLEBUTTON, 203, ByVal 0
    SendMessage hTB2, TB_ENABLEBUTTON, 204, ByVal 0
 Case 2
    Dim FileToOpen As String
    FileToOpen = GetFileName(Me.hwnd, 1)
    If Len(FileToOpen) > 0 Then
        Load_Source FileToOpen
    End If
    Call rEdit.SetFocus
 Case 3
  Dim FileToSave As String
  FileToSave = GetFileName(Me.hwnd, 2)
  If Len(FileToSave) > 0 Then Save_Source FileToSave
 Case 4
  If rEdit.CanCopy Then rEdit.Cut
 Case 5
  If rEdit.CanCopy Then rEdit.Copy
 Case 6
  If rEdit.CanPaste Then rEdit.Paste
 Case 7
  If rEdit.CanUndo Then rEdit.Undo
 Case 8
  If rEdit.CanRedo Then rEdit.Redo
 Case 9
  Dim strtmpFind As String, FndSel As Long
  Dim FndPos As Long
  strtmpFind = InputBox("Text to search", "Search", strFind)
  If Len(strtmpFind) > 0 Then
    strFind = strtmpFind
    FndPos = rEdit.FindText(strFind, rhFR_DOWN, rEdit.SelStart + 1, Len(rEdit.Text))
    If FndPos = -1 Then FndPos = rEdit.FindText(strFind, rhFR_DEFAULT, rEdit.SelStart + 1, Len(rEdit.Text))
    RichEdit_SetSel FndPos, Len(strFind), True
    Call rEdit.SetFocus
  End If
 Case 10
    LASMIDE_COMPILE
 Case 11
    LASMIDE_RUN
 Case 12
    If Len(GetCode) = 0 Then MsgBox "Nothing to export." & vbCr & "You must compile source before this operation", 48: Exit Sub
     Call GetFileName(Me.hwnd, 3)
 Case 13
    If Len(GetCode) = 0 Then MsgBox "Nothing to export." & vbCr & "You must compile source before this operation", 48: Exit Sub
    LASMIDE_GenerateBAS
 Case 14
     lReturn = WinHelp(Me.hwnd, App.Path & "\LASM.HLP", HELP_CONTEXT, 1)
 End Select
End Sub

Sub RichEdit_SetSel(ByVal SelStart As Long, ByVal SelLength As Long, Optional ByVal Redraw As Boolean = False)
    Dim cData As CHARRANGE
    Const WM_USER               As Long = &H400
    Const EM_EXSETSEL           As Long = (WM_USER + 55)
    cData.cpMin = SelStart: cData.cpMax = SelStart + SelLength
    Call SendMessage(rEdit.hwnd, EM_EXSETSEL, vbcNull, cData)
    
    If Redraw Then Call rEdit.Redraw(True)
End Sub

Sub RichEdit_RedrawSyntax()
 Timer_SyntaxHiLight.Interval = 100
End Sub

Private Sub rEdit_VScroll()
 If rEdit_ScrollAction Then Exit Sub
 Dim rEdit_TopLine As Long
 rEdit_TopLine = Text_TopLine(rEdit.hwnd)
 Text_Scroll Text3.hwnd, rEdit_TopLine
 Text_Scroll TxtPreCode.hwnd, rEdit_TopLine
 List_TopLines rEdit_TopLine
End Sub

Private Sub Timer_SyntaxHiLight_Timer()
 Timer_SyntaxHiLight.Interval = 0
 Const SW_SHOW = 5
 Const SW_HIDE = 0
 Dim ClrLines As Long
 ShowWindow rEdit.hwnd, SW_HIDE
 For ClrLines = 0 To rEdit.LinesCount - 1
  ASM_ColorLine ClrLines, False
 Next ClrLines
 ShowWindow rEdit.hwnd, SW_SHOW
 Call rEdit.SetFocus

End Sub

Sub GenerateMenu()

    Dim fglMenu(8) As mnuApInsmnu
    
    If rEdit.CanUndo Then
        fglMenu(0) = MF_ENABLED
    ElseIf Not rEdit.CanUndo Then
        fglMenu(0) = MF_DISABLED Or MF_GRAYED
    End If
 
    If rEdit.CanRedo Then
        fglMenu(1) = MF_ENABLED
    ElseIf Not rEdit.CanRedo Then
        fglMenu(1) = MF_DISABLED Or MF_GRAYED
    End If
 
    fglMenu(2) = 0
    
    If rEdit.CanCopy Then
        fglMenu(3) = MF_ENABLED
        fglMenu(4) = MF_ENABLED
        fglMenu(6) = MF_ENABLED
    ElseIf Not rEdit.CanCopy Then
        fglMenu(3) = MF_DISABLED Or MF_GRAYED
        fglMenu(4) = MF_ENABLED Or MF_GRAYED
        fglMenu(6) = MF_ENABLED Or MF_GRAYED
    End If
    
    If rEdit.CanPaste Then
        fglMenu(5) = MF_ENABLED
    ElseIf Not rEdit.CanPaste Then
        fglMenu(5) = MF_DISABLED Or MF_GRAYED
    End If
    
    fglMenu(7) = 0
    
    If Len(rEdit.Text) > 0 Then
        fglMenu(8) = MF_ENABLED
    ElseIf Len(rEdit.Text) = 0 Then
        fglMenu(8) = MF_DISABLED Or MF_GRAYED
    End If
    
    rEdit.RichEditMenu2 Array("Undo", "Redo", "", "Cut", "Copy", "Paste", "Delete", "", "Select all"), fglMenu

End Sub

Sub LASMIDE_GenerateBAS()
 MkBas.Show 1
End Sub
