VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "cRichEdit"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

'********************************************************************
'*             29.02.2004  (Team HomeWork)              *
'*                   e-mail: sne_pro@mail.ru                        *
'********************************************************************

Private Declare Sub InitCommonControls Lib "Comctl32.dll" ()

Private Declare Function CreateWindowEx Lib "user32.dll" Alias "CreateWindowExA" (ByVal dwExStyle As Long, ByVal lpClassName As String, ByVal lpWindowName As String, ByVal dwStyle As Long, ByVal x As Long, ByVal y As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal hWndParent As Long, ByVal hMenu As Long, ByVal hInstance As Long, lpParam As Any) As Long
Private Declare Function DestroyWindow Lib "user32.dll" (ByVal hwnd As Long) As Long

Private Declare Function OpenFile Lib "kernel32.dll" (ByVal lpFilename As String, lpReOpenBuff As OFSTRUCT, ByVal wStyle As Long) As Long
Private Declare Function CloseHandle Lib "kernel32.dll" (ByVal hObject As Long) As Long

Private Declare Function SetFocusAPI Lib "user32.dll" Alias "SetFocus" (ByVal hwnd As Long) As Long
Private Declare Function GetParent Lib "user32.dll" (ByVal hwnd As Long) As Long
Private Declare Function UpdateWindow Lib "user32.dll" (ByVal hwnd As Long) As Long
Private Declare Function GetCursorPos Lib "user32.dll" (lpPoint As POINTAPI) As Long
Private Declare Function ScreenToClient Lib "user32.dll" (ByVal hwnd As Long, lpPoint As POINTAPI) As Long
Private Declare Function ClientToScreen Lib "user32.dll" (ByVal hwnd As Long, lpPoint As POINTAPI) As Long
Private Declare Function GetClientRect Lib "user32.dll" (ByVal hwnd As Long, lpRect As RECT) As Long
Private Declare Function MoveWindow Lib "user32.dll" (ByVal hwnd As Long, ByVal x As Long, ByVal y As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal bRepaint As Long) As Long
Private Declare Function InvalidateRect Lib "user32" (ByVal hwnd As Long, lpRect As Any, ByVal bErase As Long) As Long
Private Declare Function SetCursor Lib "user32.dll" (ByVal hCursor As Long) As Long
Private Declare Function LoadCursor Lib "user32.dll" Alias "LoadCursorA" (ByVal hInstance As Long, ByVal lpCursorName As Long) As Long
Private Declare Function GetCaretPosition Lib "user32.dll" Alias "GetCaretPos" (lpPoint As POINTAPI) As Long

Private Declare Function LoadLibrary Lib "kernel32.dll" Alias "LoadLibraryA" (ByVal lpLibFileName As String) As Long
Private Declare Function FreeLibrary Lib "kernel32.dll" (ByVal hLibModule As Long) As Long

Private Declare Function CreatePopupMenu Lib "user32.dll" () As Long
Private Declare Function DestroyMenu Lib "user32.dll" (ByVal hMenu As Long) As Long
Private Declare Function DeleteMenu Lib "user32" (ByVal hMenu As Long, ByVal nPosition As Long, ByVal nPos As mnuApInsmnu) As Long
Private Declare Function GetMenuItemCount Lib "user32" (ByVal hMenu As Long) As Long
Private Declare Function InsertMenu Lib "user32" Alias "InsertMenuA" (ByVal hMenu As Long, ByVal nPosition As Long, ByVal nPos As mnuApInsmnu, ByVal wIDNewItem As Long, ByVal lpNewItem As Any) As Long
Private Declare Function TrackPopupMenu Lib "user32" (ByVal hMenu As Long, ByVal wFlags As Long, ByVal x As Long, ByVal y As Long, ByVal nReserved As Long, ByVal hwnd As Long, lprc As Long) As Long

Private Declare Function SendMessage Lib "user32.dll" Alias "SendMessageA" (ByVal hwnd As Long, ByVal wMsg As Long, ByVal wParam As Long, lParam As Any) As Long
Private Declare Function OleTranslateColor Lib "oleaut32.dll" (ByVal lOleColor As Long, ByVal lHPalette As Long, lColorRef As Long) As Long
Private Declare Function GetAsyncKeyState Lib "user32.dll" (ByVal vKey As Long) As Integer
Private Declare Sub CopyMemory Lib "kernel32.dll" Alias "RtlMoveMemory" (Destination As Any, Source As Any, ByVal Length As Long)

Private Declare Function GetWindowLong Lib "user32.dll" Alias "GetWindowLongA" (ByVal hwnd As Long, ByVal nIndex As Long) As Long
Private Declare Function SetWindowLong Lib "user32.dll" Alias "SetWindowLongA" (ByVal hwnd As Long, ByVal nIndex As Long, ByVal dwNewLong As Long) As Long
Private Declare Function CallWindowProc Lib "user32.dll" Alias "CallWindowProcA" (ByVal lpPrevWndFunc As Long, ByVal hwnd As Long, ByVal msg As Long, ByVal wParam As Long, ByVal lParam As Long) As Long

Public Enum gbRichEditStyles
    rhES_DISABLENOSCROLL = &H2000
    rhES_EX_NOCALLOLEINIT = &H1000000
    rhES_NOIME = &H80000
    rhES_SELFIME = &H40000
    rhES_SUNKEN = &H4000
    rhES_VERTICAL = &H400000
    rhES_AUTOHSCROLL = &H80&
    rhES_AUTOVSCROLL = &H40&
    rhES_CENTER = &H1&
    rhES_LEFT = &H0&
    rhES_MULTILINE = &H4&
    rhES_NOHIDESEL = &H100&
    rhES_NUMBER = &H2000&
    rhES_PASSWORD = &H20&
    rhES_READONLY = &H800&
    rhES_RIGHT = &H2&
    rhES_WANTRETURN = &H1000&
    
    rhWS_VSCROLL = &H200000
    rhWS_HSCROLL = &H100000
End Enum
Public Enum gbRichEditOptions
   rhECO_AUTOWORDSELECTION = &H1&
   rhECO_AUTOVSCROLL = &H40&
   rhECO_AUTOHSCROLL = &H80&
   rhECO_NOHIDESEL = &H100&
   rhECO_READONLY = &H800&
   rhECO_WANTRETURN = &H1000&
   rhECO_SAVESEL = &H8000&
   rhECO_SELECTIONBAR = &H1000000
   rhECO_VERTICAL = &H400000                  ' /* FE specific */
End Enum
Public Enum gbFindOpt
    rhFR_DEFAULT = &H0
    rhFR_DOWN = &H1
    rhFR_WHOLEWORD = &H2
    rhFR_MATCHCASE = &H4&
End Enum
Public Enum gbChFrmtSt
    rhSCF_DEFAULT = &H0
    rhSCF_SELECTION = &H1
    rhSCF_WORD = &H2
End Enum
Public Enum gbChFrmt2Effects
    rhCFE_BOLD = &H1
    rhCFE_ITALIC = &H2
    rhCFE_UNDERLINE = &H4
    rhCFE_STRIKEOUT = &H8
    rhCFE_PROTECTED = &H10
    rhCFE_LINK = &H20
    rhCFE_SMALLCAPS = &H40
    rhCFE_ALLCAPS = &H80
    rhCFE_HIDDEN = &H100
    rhCFE_OUTLINE = &H200
    rhCFE_SHADOW = &H400
    rhCFE_EMBOSS = &H800
    rhCFE_DISABLED = &H2000
    rhCFE_IMPRINT = &H1000
    rhCFE_REVISED = &H4000
    rhCFE_SUBSCRIPT = &H10000
    rhCFE_SUPERSCRIPT = &H20000
    rhCFE_AUTOBACKCOLOR = &H4000000
    rhCFE_AUTOCOLOR = &H40000000
End Enum
Public Enum gbChFrmt2Others
    rhCFM_ANIMATION = &H40000
    rhCFM_BACKCOLOR = &H4000000
    rhCFM_CHARSET = &H8000000
    rhCFM_COLOR = &H40000000
    rhCFM_FACE = &H20000000
    rhCFM_KERNING = &H100000
    rhCFM_LCID = &H2000000
    rhCFM_OFFSET = &H10000000
    rhCFM_REVAUTHOR = &H8000
    rhCFM_SIZE = &H80000000
    rhCFM_SPACING = &H200000
    rhCFM_STYLE = &H80000
    rhCFM_UNDERLINETYPE = &H800000
    rhCFM_WEIGHT = &H400000
End Enum
Public Enum gbEditStyle
    rhSES_EMULATESYSEDIT = 1
    rhSES_BEEPONMAXTEXT = 2
    rhSES_EXTENDBACKCOLOR = 4
    rhSES_USEAIMM = 64
    rhSES_UPPERCASE = 512
    rhSES_LOWERCASE = 1024
    rhSES_NOINPUTSEQUENCECHK = 2048
End Enum
Public Enum gbRichEditParaNum
   rhParaNone = 0
   rhParaBullet = &H1
   rhParaArabicNumbers = &H2
   rhParaLowerCaseLetters = &H3
   rhParaUpperCaseLetters = &H4
   rhParaLowerCaseRoman = &H5
   rhParaUpperCaseRoman = &H6
   rhParaCustomNumber = &H7
End Enum
Public Enum gbRichEditParaWMask
    rhPFM_STARTINDENT = &H1
    rhPFM_RIGHTINDENT = &H2
    rhPFM_OFFSET = &H4
    rhPFM_ALIGNMENT = &H8
    rhPFM_TABSTOPS = &H10
    rhPFM_NUMBERING = &H20
    rhPFM_SPACEBEFORE = &H40
    rhPFM_SPACEAFTER = &H80
    rhPFM_LINESPACING = &H100
    rhPFM_STYLE = &H400
    rhPFM_BORDER = &H800&
    rhPFM_SHADING = &H1000
    rhPFM_NUMBERINGSTYLE = &H2000
    rhPFM_NUMBERINGTAB = &H4000
    rhPFM_NUMBERINGSTART = &H8000
    rhPFM_RTLPARA = &H10000
    rhPFM_KEEP = &H20000
    rhPFM_KEEPNEXT = &H40000
    rhPFM_PAGEBREAKBEFORE = &H80000
    rhPFM_NOLINENUMBER = &H100000
    rhPFM_NOWIDOWCONTROL = &H200000
    rhPFM_DONOTHYPHEN = &H400000
    rhPFM_SIDEBYSIDE = &H800000
    rhPFM_TABLE = &H40000000
    rhPFM_OFFSETINDENT = &H80000000
End Enum
Public Enum gbRichEditPFAligin
    rhPFA_LEFT = &H1
    rhPFA_RIGHT = &H2
    rhPFA_CENTER = &H3
    rhPFA_JUSTIFY = &H4
    'PFA_FULL_INTERWORD = PFA_JUSTIFY
End Enum
Public Enum gbRichEditPFOffsets
    rhNewParagraph = &H1
    rhLeftOffset = &H2
    rhRightOffset = &H3
End Enum
Public Enum gbRichEditPFLnSp
    rhSingle = 0
    rhOneAndAHalf = 1
    rhDouble = 2
    rhTwips = 3
    rhTwipsAnyMinimum = 4
    rhTwentiethLine = 5
End Enum
Public Enum gbRichEditUnReTypes
    rhUID_UNKNOWN = 0
    rhUID_TYPING = 1
    rhUID_DELETE = 2
    rhUID_DRAGDROP = 3
    rhUID_CUT = 4
    rhUID_PASTE = 5
End Enum
Public Enum mnuApInsmnu
    MF_DISABLED = &H2&
    MF_ENABLED = &H0&
    MF_GRAYED = &H1&
    MF_POPUP = &H10&
    MF_SEPARATOR = &H800&
    MF_STRING = &H0&
    
    MF_BYPOSITION = &H400&
    MF_BYCOMMAND = &H0&
End Enum
Public Enum gbRichEditSelTp
   SEL_EMPTY = &H0
   SEL_TEXT = &H1
   SEL_OBJECT = &H2
   SEL_MULTICHAR = &H4
   SEL_MULTIOBJECT = &H8
End Enum
Public Enum gbBtnsCnsts
    MK_LBUTTON = &H1
    MK_RBUTTON = &H2
    MK_MBUTTON = &H10
End Enum
Public Enum gbHWgetTextFlags
    GTL_DEFAULT = 0
    GTL_USECRLF = 1
    GTL_PRECISE = 2
    GTL_CLOSE = 4
    GTL_NUMCHARS = 8
    GTL_NUMBYTES = 16
End Enum
Public Enum gbHWRichEditTextPutFlags
    ST_DEFAULT = 0
    ST_KEEPUNDO = 1
    ST_SELECTION = 2
End Enum

Private Type CHARRANGE
    cpMin           As Long
    cpMax           As Long
End Type
Private Type FINDTEXTEX_A
    chrg            As CHARRANGE
    lpstrText       As Long
    chrgText        As CHARRANGE
End Type
Private Type CHARFORMAT2
    cbSize          As Integer
    wPad1           As Integer
    dwMask          As Long
    dwEffects       As Long
    yHeight         As Long
    yOffset         As Long
    crTextColor     As Long
    bCharSet        As Byte
    bPitchAndFamily As Byte
    szFaceName(31)  As Byte     ' 32 bytes (0 base)
    wPad2           As Integer

    wWeight         As Integer
    sSpacing        As Integer
    crBackColor     As Long
    lLCID           As Long
    dwReserved      As Long
    sStyle          As Integer
    wKerning        As Integer
    bUnderlineType  As Byte
    bAnimation      As Byte
    bRevAuthor      As Byte
    bReserved1      As Byte
End Type
Private Type PARAFORMAT2
    cbSize          As Integer
    wPad1           As Integer
    dwMask          As Long
    wNumbering      As Integer
    wReserved       As Integer
    dxStartIndent   As Long
    dxRightIndent   As Long
    dxOffset        As Long
    wAlignment      As Integer
    cTabCount       As Integer
    'rgxTabs(0 To MAX_TAB_STOPS - 1) As Byte
    'lPtrRgxTabs As Long
    lTabStops(31)   As Long
    dySpaceBefore   As Long
    dySpaceAfter    As Long
    dyLineSpacing   As Long
    sStyle          As Integer
    bLineSpacingRule As Byte
    bCRC            As Byte
    wShadingWeight  As Integer
    wShadingStyle   As Integer
    wNumberingStart As Integer
    wNumberingStyle As Integer
    wNumberingTab   As Integer
    wBorderSpace    As Integer
    wBorderWidth    As Integer
    wBorders        As Integer
End Type
Private Type TEXTRANGE
    chrg            As CHARRANGE
    lpstrText       As Long
End Type
Private Type EDITSTREAM
    dwCookie        As Long
    dwError         As Long
    pfnCallback     As Long
End Type
Private Type OFSTRUCT
    cBytes          As Byte
    fFixedDisk      As Byte
    nErrCode        As Integer
    Reserved1       As Integer
    Reserved2       As Integer
    szPathName(128) As Byte
End Type

Private Type NMHDR_RICHEDIT
    hwndFrom        As Long
    wPad1           As Integer
    idfrom          As Integer
    code            As Integer
    wPad2           As Integer
End Type
Private Type MSGFILTER
    NMHDR           As NMHDR_RICHEDIT
    msg             As Integer
    wPad1           As Integer
    wParam          As Integer
    wPad2           As Integer
    lParam          As Long
End Type
Private Type SelChange
    NMHDR           As NMHDR_RICHEDIT
    chrg            As CHARRANGE
    seltyp          As Long
End Type
Private Type ENLINK
    NMHDR           As NMHDR_RICHEDIT
    msg             As Integer
    wPad1           As Integer
    wParam          As Integer
    wPad2           As Integer
    lParam          As Integer
    chrg            As CHARRANGE
End Type
Private Type ENPROTECTED
    NMHDR           As NMHDR_RICHEDIT
    msg             As Long
    wPad1           As Integer
    wParam          As Long
    wPad2           As Integer
    lParam          As Long
    chrg            As CHARRANGE
End Type
Private Type GETTEXTLENGTHEX
    lFlags          As Long
    CodePage        As Long
End Type
Private Type GETTEXTEX
    cb              As Long
    Flags           As Long
    CodePage        As Long
    lpDefaultChar   As Long
    lpUsedDefChar   As Long
End Type
Private Type SETTEXTEX
    Flags           As Long
    CodePage        As Long
End Type

Private Type POINTAPI
    x               As Long
    y               As Long
End Type
Private Type RECT
    Left            As Long
    Top             As Long
    Right           As Long
    Bottom          As Long
End Type

Private Const vbcNull               As Long = &H0

Private Const WS_VISIBLE            As Long = &H10000000
Private Const WS_CHILD              As Long = &H40000000
Private Const WM_SETFONT            As Long = &H30
Private Const WM_GETFONT            As Long = &H31
Private Const WM_SETREDRAW          As Long = &HB

Private Const WM_USER               As Long = &H400
Private Const EM_AUTOURLDETECT      As Long = (WM_USER + 91)
Private Const EM_SETBKGNDCOLOR      As Long = (WM_USER + 67)
Private Const EM_CANPASTE           As Long = (WM_USER + 50)
Private Const EM_CANREDO            As Long = (WM_USER + 85)
Private Const EM_CANUNDO            As Long = &HC6
Private Const EM_REDO               As Long = (WM_USER + 84)
Private Const EM_UNDO               As Long = &HC7
Private Const EM_SETUNDOLIMIT       As Long = (WM_USER + 82)
Private Const EM_STOPGROUPTYPING    As Long = (WM_USER + 88)
Private Const EM_EMPTYUNDOBUFFER    As Long = &HCD
Private Const EM_EXGETSEL           As Long = (WM_USER + 52)
Private Const EM_EXSETSEL           As Long = (WM_USER + 55)
Private Const EM_EXLIMITTEXT        As Long = (WM_USER + 53)
Private Const EM_GETLIMITTEXT       As Long = (WM_USER + 37)
Private Const EM_EXLINEFROMCHAR     As Long = (WM_USER + 54)
Private Const EM_FINDTEXTEX         As Long = (WM_USER + 79)
Private Const EM_GETAUTOURLDETECT   As Long = (WM_USER + 92)
Private Const EM_GETCHARFORMAT      As Long = (WM_USER + 58)
Private Const EM_SETCHARFORMAT      As Long = (WM_USER + 68)
Private Const EM_GETEDITSTYLE       As Long = (WM_USER + 205)
Private Const EM_SETEDITSTYLE       As Long = (WM_USER + 204)
Private Const EM_GETOPTIONS         As Long = (WM_USER + 78)
Private Const EM_SETOPTIONS         As Long = (WM_USER + 77)
Private Const EM_GETPARAFORMAT      As Long = (WM_USER + 61)
Private Const EM_SETPARAFORMAT      As Long = (WM_USER + 71)
Private Const EM_GETTEXTEX          As Long = (WM_USER + 94)
Private Const EM_SETTEXTEX          As Long = (WM_USER + 97)
Private Const EM_GETTEXTLENGTHEX    As Long = (WM_USER + 95)

Private Const EM_GETLINE            As Long = &HC4
Private Const EM_GETLINECOUNT       As Long = &HBA
Private Const EM_LINELENGTH         As Long = &HC1
Private Const EM_LINEINDEX          As Long = &HBB
Private Const EM_GETMODIFY          As Long = &HB8
Private Const EM_SETMODIFY          As Long = &HB9
Private Const EM_GETSELTEXT         As Long = (WM_USER + 62)
Private Const EM_GETTEXTRANGE       As Long = (WM_USER + 75)
Private Const EM_SETREADONLY        As Long = &HCF
Private Const EM_CHARFROMPOS        As Long = &HD7
Private Const EM_POSFROMCHAR        As Long = (WM_USER + 38)
Private Const EM_GETREDONAME        As Long = (WM_USER + 87)
Private Const EM_GETUNDONAME        As Long = (WM_USER + 86)
Private Const EM_SETTARGETDEVICE    As Long = (WM_USER + 72)
Private Const EM_STREAMIN           As Long = (WM_USER + 73)
Private Const EM_STREAMOUT          As Long = (WM_USER + 74)
Private Const EM_HIDESELECTION      As Long = (WM_USER + 63)
Private Const EM_SETEVENTMASK       As Long = (WM_USER + 69)

Private Const ENM_SELCHANGE         As Long = &H80000
Private Const ENM_KEYEVENTS         As Long = &H10000
Private Const ENM_MOUSEEVENTS       As Long = &H20000
Private Const ENM_DROPFILES         As Long = &H100000
Private Const ENM_SCROLL            As Long = &H4
Private Const ENM_UPDATE            As Long = &H2
Private Const ENM_LINK              As Long = &H4000000
Private Const ENM_PROTECTED         As Long = &H200000

Private Const WM_VSCROLL As Long = &H115
Private Const WM_HSCROLL As Long = &H114
Private Const WM_CONTEXTMENU        As Long = &H7B
Private Const WM_MOUSEMOVE          As Long = &H200
Private Const WM_RBUTTONDBLCLK      As Long = &H206             ' Mouse
Private Const WM_LBUTTONDBLCLK      As Long = &H203
Private Const WM_MBUTTONDBLCLK      As Long = &H209
Private Const WM_RBUTTONDOWN        As Long = &H204
Private Const WM_LBUTTONDOWN        As Long = &H201
Private Const WM_MBUTTONDOWN        As Long = &H207
Private Const WM_RBUTTONUP          As Long = &H205
Private Const WM_LBUTTONUP          As Long = &H202
Private Const WM_MBUTTONUP          As Long = &H208
Private Const WM_KEYDOWN            As Long = &H100             ' Keys
Private Const WM_KEYUP              As Long = &H101
Private Const WM_CHAR               As Long = &H102

Private Const ZeroBase              As Long = &H1000            ' First menu

Public Event KeyPress(KeyAscii As Integer)
Public Event KeyDown(KeyCode As Integer, Shift As Integer)
Public Event KeyUp(KeyCode As Integer, Shift As Integer)

Public Event SelectionChange(ByVal lMin As Long, ByVal lMax As Long, ByVal SelType As gbRichEditSelTp)
Public Event LinkOver(ByVal iType As Integer, ByVal lMin As Long, ByVal lMax As Long)
Public Event ModifyProtected(ByRef bCancel As Long, ByVal lMin As Long, ByVal lMax As Long)
Public Event MenuClick(ByVal MnuID As Long)

Public Event MouseDown(Button As MouseButtonConstants, x As Long, y As Long, Shift As Integer)
Public Event MouseMove(x As Long, y As Long, Shift As Integer)
Public Event MouseUp(Button As MouseButtonConstants, x As Long, y As Long, Shift As Integer)
Public Event DblClick(Button As MouseButtonConstants, x As Long, y As Long, Shift As Integer)

Public Event VScroll()
Public Event HScroll()

Private hRichEdit                   As Long
Private hRichMnu                    As Long
Private hRichDll                    As Long

Private Type MENUITEMINFO
    cbSize As Long
    fMask As Long
    fType As Long
    fState As Long
    wID As Long
    hSubMenu As Long
    hbmpChecked As Long
    hbmpUnchecked As Long
    dwItemData As Long
    dwTypeData As String
    cch As Long
End Type

Private Declare Function InsertMenuItem Lib "user32.dll" Alias "InsertMenuItemA" ( _
     ByVal hMenu As Long, _
     ByVal un As Long, _
     ByVal bool As Boolean, _
     ByRef lpcMenuItemInfo As MENUITEMINFO) As Long


Public Function Create(ByVal hParent As Long, _
                       ByVal dwStyle As gbRichEditStyles, _
                       ByVal nLeft As Long, _
                       ByVal nTop As Long, _
                       ByVal nWidth As Long, _
                       ByVal nHeight As Long) As Long

    Call InitCommonControls
    hRichMnu = CreatePopupMenu()

    hRichEdit = CreateWindowEx(vbcNull, "RichEdit20a", vbNullString, WS_VISIBLE Or WS_CHILD Or dwStyle, nLeft, nTop, nWidth, nHeight, hParent, hRichMnu, App.hInstance, ByVal vbcNull)

    Call SendMessage(hRichEdit, WM_SETFONT, SendMessage(hParent, WM_GETFONT, vbcNull, vbcNull), ByVal vbcNull)
    Call SendMessage(hRichEdit, EM_SETEVENTMASK, 0, ByVal (ENM_KEYEVENTS Or ENM_MOUSEEVENTS Or ENM_SELCHANGE Or ENM_DROPFILES Or ENM_SCROLL Or ENM_UPDATE Or ENM_LINK Or ENM_PROTECTED))

    Call RichEditStartSubclass(Me)
    Create = hRichEdit
End Function

Public Function Destroy()
    Call RichEditStopSubclass(Me)
    Call DestroyWindow(hRichEdit):  hRichEdit = vbcNull
    Call DestroyMenu(hRichMnu):     hRichMnu = vbcNull
End Function

'  Events 

Public Function zRichEditCallBack(ByVal uMsg As Long, ByVal lParam As Long) As Long
    Dim tmp As POINTAPI, lLong As Long

    Dim tSC As SelChange
    Dim tEN As ENLINK
    Dim tPR As ENPROTECTED
    Dim tMF As MSGFILTER

    Select Case uMsg
        Case Is = &H702                                         ' EN_SELCHANGE
            Call CopyMemory(tSC, ByVal lParam, Len(tSC))
            RaiseEvent SelectionChange(tSC.chrg.cpMin, tSC.chrg.cpMax, tSC.seltyp)

        Case Is = &H70B                                        ' EN_LINK
            Call CopyMemory(tEN, ByVal lParam, Len(tEN))
            RaiseEvent LinkOver(tEN.msg, tEN.chrg.cpMin, tEN.chrg.cpMax)

        Case Is = &H704                                        ' EN_PROTECTED
            Call CopyMemory(tPR, ByVal lParam, Len(tPR))
            RaiseEvent ModifyProtected(zRichEditCallBack, tPR.chrg.cpMin, tPR.chrg.cpMax)

        Case Is = &H700                                         ' EN_MSGFILTER
            Call CopyMemory(tMF, ByVal lParam, Len(tMF))

            Select Case tMF.msg
                Case &H200 To &H209
                    Call GetCursorPos(tmp): Call ScreenToClient(hRichEdit, tmp)
            End Select

            Select Case tMF.msg
                Case Is = &H201: RaiseEvent MouseDown(vbLeftButton, tmp.x, tmp.y, giGetShiftState)
                Case Is = &H202: RaiseEvent MouseUp(vbLeftButton, tmp.x, tmp.y, giGetShiftState)
                Case Is = &H203: RaiseEvent DblClick(vbLeftButton, tmp.x, tmp.y, giGetShiftState)

                Case Is = &H204: RaiseEvent MouseDown(vbRightButton, tmp.x, tmp.y, giGetShiftState)
                Case Is = &H205: RaiseEvent MouseUp(vbRightButton, tmp.x, tmp.y, giGetShiftState)
                Case Is = &H206: RaiseEvent DblClick(vbRightButton, tmp.x, tmp.y, giGetShiftState)
                
                Case Is = &H207: RaiseEvent MouseDown(vbMiddleButton, tmp.x, tmp.y, giGetShiftState)
                Case Is = &H208: RaiseEvent MouseUp(vbMiddleButton, tmp.x, tmp.y, giGetShiftState)
                Case Is = &H209: RaiseEvent DblClick(vbMiddleButton, tmp.x, tmp.y, giGetShiftState)

                Case Is = &H200: RaiseEvent MouseMove(tmp.x, tmp.y, giGetShiftState)

                Case Is = &H100
                    RaiseEvent KeyDown(tMF.wParam, giGetShiftState)
                    If tMF.wParam = vbcNull Then zRichEditCallBack = vbNull
                Case Is = &H101
                    RaiseEvent KeyUp(tMF.wParam, giGetShiftState)
                    If tMF.wParam = vbcNull Then zRichEditCallBack = vbNull
                Case Is = &H102
                    RaiseEvent KeyPress(tMF.wParam)
                    If tMF.wParam = vbcNull Then zRichEditCallBack = vbNull
            End Select

        Case Is = WM_CONTEXTMENU
            Call GetCursorPos(tmp)
            LASMIDE.GenerateMenu
            lLong = TrackPopupMenu(hRichMnu, &H100&, tmp.x, tmp.y, 0, GetParent(hRichEdit), 0)
            If Not lLong = vbcNull Then RaiseEvent MenuClick(lLong - ZeroBase)
            
        Case Is = WM_VSCROLL:   RaiseEvent VScroll
        Case Is = WM_HSCROLL:   RaiseEvent HScroll
    End Select
End Function

'  Work with RichEdit's menu 

Public Property Let RichEditMenu(inMenuIttems As Variant)
    Dim i As Long

    For i = 0 To GetMenuItemCount(hRichMnu) - 1&
        Call DeleteMenu(hRichMnu, 0, MF_BYPOSITION)
    Next

    If UBound(inMenuIttems) = &HFFFF Then Exit Property

    For i = 0 To UBound(inMenuIttems)
        If IsMissing(inMenuIttems(i)) Then
            Call InsertMenu(hRichMnu, i, MF_BYPOSITION Or MF_SEPARATOR, ZeroBase + i + 1&, CStr(inMenuIttems(i)))
        Else
            Call InsertMenu(hRichMnu, i, MF_BYPOSITION Or MF_STRING, ZeroBase + i + 1&, CStr(inMenuIttems(i)))
        End If
    Next
End Property

Public Sub RichEditMenu2(inMenuIttems As Variant, Flags() As mnuApInsmnu)
    Dim i As Long

    For i = 0 To GetMenuItemCount(hRichMnu) - 1&
        Call DeleteMenu(hRichMnu, 0, MF_BYPOSITION)
    Next

    If UBound(inMenuIttems) = &HFFFF Then Exit Sub

    For i = 0 To UBound(inMenuIttems)
        If inMenuIttems(i) = "" Then
            Call InsertMenu(hRichMnu, i, MF_BYPOSITION Or MF_SEPARATOR, ZeroBase + i + 1&, CStr(inMenuIttems(i)))
        Else
            Call InsertMenu(hRichMnu, i, MF_BYPOSITION Or MF_STRING Or Flags(i), ZeroBase + i + 1&, CStr(inMenuIttems(i)))
        End If
    Next
End Sub


'  Property 

Public Property Get AutoURL() As Boolean
    Call SendMessage(hRichEdit, EM_GETAUTOURLDETECT, vbcNull, vbcNull)
End Property
Public Property Let AutoURL(ByVal bValue As Boolean)
    Call SendMessage(hRichEdit, EM_AUTOURLDETECT, Abs(bValue), ByVal vbcNull)
End Property

Public Property Let BackColor(ByVal lValue As Long)
    Call SendMessage(hRichEdit, EM_SETBKGNDCOLOR, vbcNull, ByVal TranslateColor(lValue))
End Property

Public Property Get SelStart() As Long
    SelStart = GetTextSel.cpMin
End Property
Public Property Let SelStart(ByVal lValue As Long)
    Call SetTextSel(lValue, GetTextSel.cpMax)
End Property

Public Property Get SelLength() As Long
    SelLength = GetTextSel.cpMax - GetTextSel.cpMin
End Property
Public Property Let SelLength(ByVal lValue As Long)
    Dim cpMin As Long
    cpMin = GetTextSel.cpMin

    Call SetTextSel(cpMin, cpMin + lValue)
End Property

Public Property Get MaxLength() As Long
    MaxLength = SendMessage(hRichEdit, EM_GETLIMITTEXT, vbcNull, vbcNull)
End Property
Public Property Let MaxLength(ByVal lValue As Long)
    Call SendMessage(hRichEdit, EM_EXLIMITTEXT, vbcNull, ByVal lValue)
End Property

Public Property Get FontBold(ByVal fOpt As gbChFrmtSt) As Boolean
    FontBold = ((prtGetFormat(fOpt, , rhCFE_BOLD).dwEffects And rhCFE_BOLD) = rhCFE_BOLD)
End Property
Public Property Let FontBold(ByVal fOpt As gbChFrmtSt, ByVal bValue As Boolean)
    Dim CF As CHARFORMAT2: CF.dwEffects = IIf(bValue, rhCFE_BOLD, vbcNull)
    Call prtSetFormat(CF, fOpt, , rhCFE_BOLD)
End Property

Public Property Get FontItalic(ByVal fOpt As gbChFrmtSt) As Boolean
    FontItalic = ((prtGetFormat(fOpt, , rhCFE_ITALIC).dwEffects And rhCFE_ITALIC) = rhCFE_ITALIC)
End Property
Public Property Let FontItalic(ByVal fOpt As gbChFrmtSt, ByVal bValue As Boolean)
    Dim CF As CHARFORMAT2: CF.dwEffects = IIf(bValue, rhCFE_ITALIC, vbcNull)
    Call prtSetFormat(CF, fOpt, , rhCFE_ITALIC)
End Property

Public Property Get FontUnderline(ByVal fOpt As gbChFrmtSt) As Boolean
    FontUnderline = ((prtGetFormat(fOpt, , rhCFE_UNDERLINE).dwEffects And rhCFE_UNDERLINE) = rhCFE_UNDERLINE)
End Property
Public Property Let FontUnderline(ByVal fOpt As gbChFrmtSt, ByVal bValue As Boolean)
    Dim CF As CHARFORMAT2: CF.dwEffects = IIf(bValue, rhCFE_UNDERLINE, vbcNull)
    Call prtSetFormat(CF, fOpt, , rhCFE_UNDERLINE)
End Property

Public Property Get FontStrikeOut(ByVal fOpt As gbChFrmtSt) As Boolean
    FontStrikeOut = ((prtGetFormat(fOpt, , rhCFE_STRIKEOUT).dwEffects And rhCFE_STRIKEOUT) = rhCFE_STRIKEOUT)
End Property
Public Property Let FontStrikeOut(ByVal fOpt As gbChFrmtSt, ByVal bValue As Boolean)
    Dim CF As CHARFORMAT2: CF.dwEffects = IIf(bValue, rhCFE_STRIKEOUT, vbcNull)
    Call prtSetFormat(CF, fOpt, , rhCFE_STRIKEOUT)
End Property

Public Property Get FontColor(ByVal fOpt As gbChFrmtSt) As Long
    FontColor = prtGetFormat(fOpt, rhCFM_COLOR).crTextColor
End Property
Public Property Let FontColor(ByVal fOpt As gbChFrmtSt, ByVal lValue As Long)
    Dim CF As CHARFORMAT2: CF.crTextColor = TranslateColor(lValue)
    Call prtSetFormat(CF, fOpt, rhCFM_COLOR)
End Property

Public Property Get FontBackColor(ByVal fOpt As gbChFrmtSt) As Long
    FontBackColor = prtGetFormat(fOpt, rhCFM_BACKCOLOR).crBackColor
End Property
Public Property Let FontBackColor(ByVal fOpt As gbChFrmtSt, ByVal lValue As Long)
    Dim CF As CHARFORMAT2: CF.crBackColor = TranslateColor(lValue)
    Call prtSetFormat(CF, fOpt, rhCFM_BACKCOLOR)
End Property

Public Property Get FontLink(ByVal fOpt As gbChFrmtSt) As Boolean
    FontLink = ((prtGetFormat(fOpt, , rhCFE_LINK).dwEffects And rhCFE_LINK) = rhCFE_LINK)
End Property
Public Property Let FontLink(ByVal fOpt As gbChFrmtSt, ByVal bValue As Boolean)
    Dim CF As CHARFORMAT2: CF.dwEffects = IIf(bValue, rhCFE_LINK, vbcNull)
    Call prtSetFormat(CF, fOpt, , rhCFE_LINK)
End Property

Public Property Get FontLocked(ByVal fOpt As gbChFrmtSt) As Boolean
    FontLocked = ((prtGetFormat(fOpt, , rhCFE_PROTECTED).dwEffects And rhCFE_PROTECTED) = rhCFE_PROTECTED)
End Property
Public Property Let FontLocked(ByVal fOpt As gbChFrmtSt, ByVal bValue As Boolean)
    Dim CF As CHARFORMAT2: CF.dwEffects = IIf(bValue, rhCFE_PROTECTED, vbcNull)
    Call prtSetFormat(CF, fOpt, , rhCFE_PROTECTED)
End Property

Public Property Get FontSuperScript(ByVal fOpt As gbChFrmtSt) As Boolean
    FontSuperScript = ((prtGetFormat(fOpt, , rhCFE_SUBSCRIPT Or rhCFE_SUPERSCRIPT).dwEffects And (rhCFE_SUBSCRIPT Or rhCFE_SUPERSCRIPT)) = (rhCFE_SUBSCRIPT Or rhCFE_SUPERSCRIPT))
End Property
Public Property Let FontSuperScript(ByVal fOpt As gbChFrmtSt, ByVal bValue As Boolean)
    Dim CF As CHARFORMAT2: CF.dwEffects = IIf(bValue, rhCFE_SUBSCRIPT Or rhCFE_SUPERSCRIPT, vbcNull)
    Call prtSetFormat(CF, fOpt, , rhCFE_SUBSCRIPT Or rhCFE_SUPERSCRIPT)
End Property

Public Property Get Font(ByVal fOpt As gbChFrmtSt) As StdFont
    Dim tFnt As New StdFont
    Dim CF As CHARFORMAT2

    CF = prtGetFormat(fOpt, , rhCFE_BOLD Or rhCFE_ITALIC Or rhCFE_STRIKEOUT Or rhCFE_UNDERLINE Or rhCFM_FACE Or rhCFM_SIZE)

    Call CopyMemory(ByVal tFnt.Name, CF.szFaceName(0), UBound(CF.szFaceName) + vbNull)

    tFnt.Size = CF.yHeight \ 20
    tFnt.Bold = ((CF.dwEffects And rhCFE_BOLD) = rhCFE_BOLD)
    tFnt.Italic = ((CF.dwEffects And rhCFE_ITALIC) = rhCFE_ITALIC)
    tFnt.Underline = ((CF.dwEffects And rhCFE_UNDERLINE) = rhCFE_UNDERLINE)
    tFnt.Strikethrough = ((CF.dwEffects And rhCFE_STRIKEOUT) = rhCFE_STRIKEOUT)

    Set Font = tFnt
End Property
Public Property Let Font(ByVal fOpt As gbChFrmtSt, ByRef inStdFont As StdFont)
    Dim CF As CHARFORMAT2

    If inStdFont.Bold Then CF.dwMask = rhCFE_BOLD: CF.dwEffects = rhCFE_BOLD
    If inStdFont.Italic Then CF.dwMask = rhCFE_ITALIC: CF.dwEffects = rhCFE_ITALIC
    If inStdFont.Strikethrough Then CF.dwMask = rhCFE_STRIKEOUT: CF.dwEffects = rhCFE_STRIKEOUT
    If inStdFont.Underline Then CF.dwMask = rhCFE_UNDERLINE: CF.dwEffects = rhCFE_UNDERLINE

    CF.dwMask = CF.dwMask Or rhCFM_FACE Or rhCFM_SIZE

    Call CopyMemory(CF.szFaceName(0), ByVal inStdFont.Name, Len(inStdFont.Name))    ' Name to byte array by pointer
    CF.yHeight = inStdFont.Size * 20

    Call prtSetFormat(CF, fOpt)
End Property

Public Property Get Style() As gbEditStyle                                          '
    Style = SendMessage(hRichEdit, EM_GETEDITSTYLE, vbcNull, vbcNull)
End Property
Public Property Let Style(ByVal inValue As gbEditStyle)
    Call SendMessage(hRichEdit, EM_SETEDITSTYLE, vbcNull, ByVal inValue)
End Property

Public Property Get Options(ByVal inOption As gbRichEditOptions) As Boolean         ' Several RichEdit's propertyes
   Options = ((SendMessage(hRichEdit, EM_GETOPTIONS, vbcNull, vbcNull) And inOption) = inOption)
End Property
Public Property Let Options(ByVal inOption As gbRichEditOptions, ByVal bValue As Boolean)
    Dim lOptions As Long

    lOptions = SendMessage(hRichEdit, EM_GETOPTIONS, vbcNull, vbcNull)
    lOptions = IIf(bValue, lOptions Or inOption, lOptions And Not inOption)
    Call SendMessage(hRichEdit, EM_SETOPTIONS, vbcNull, ByVal lOptions)
End Property

Public Property Get ParagraphNum() As gbRichEditParaNum                             '
    ParagraphNum = prtGetParagraph(rhPFM_NUMBERING).wNumbering
End Property
Public Property Let ParagraphNum(ByVal inValue As gbRichEditParaNum)
    Dim PF As PARAFORMAT2: PF.wNumbering = inValue
    Call prtSetParagraph(PF, rhPFM_NUMBERING)
End Property

Public Property Get ParagraphOffsets(ByVal iType As gbRichEditPFOffsets) As Long    '
    If iType = rhNewParagraph Then
        ParagraphOffsets = prtGetParagraph(rhPFM_STARTINDENT).dxStartIndent

    ElseIf iType = rhLeftOffset Then
        ParagraphOffsets = prtGetParagraph(rhPFM_OFFSET).dxOffset

    ElseIf iType = rhRightOffset Then
        ParagraphOffsets = prtGetParagraph(rhPFM_RIGHTINDENT).dxRightIndent
    End If
End Property
Public Property Let ParagraphOffsets(ByVal iType As gbRichEditPFOffsets, ByVal inValue As Long)
    Dim PF As PARAFORMAT2

    If iType > 3 Then Exit Property
    If iType = rhNewParagraph Then
        PF.dxStartIndent = inValue: PF.dwMask = rhPFM_STARTINDENT

    ElseIf iType = rhLeftOffset Then
        PF.dxOffset = inValue:      PF.dwMask = rhPFM_OFFSET

    ElseIf iType = rhRightOffset Then
        PF.dxRightIndent = inValue: PF.dwMask = rhPFM_RIGHTINDENT
    End If

    Call prtSetParagraph(PF)
End Property

Public Property Get ParagraphAlignment() As gbRichEditPFAligin                      '
    ParagraphAlignment = prtGetParagraph(rhPFM_ALIGNMENT).wAlignment
End Property
Public Property Let ParagraphAlignment(ByVal inValue As gbRichEditPFAligin)
    Dim PF As PARAFORMAT2: PF.wAlignment = inValue
    Call prtSetParagraph(PF, rhPFM_ALIGNMENT)
End Property

Public Property Get ParagraphSpacing(ByVal bBefore As Boolean) As Long           '
    If bBefore Then
        ParagraphSpacing = prtGetParagraph(rhPFM_SPACEBEFORE).dySpaceBefore
    Else
        ParagraphSpacing = prtGetParagraph(rhPFM_SPACEAFTER).dySpaceAfter
    End If
End Property
Public Property Let ParagraphSpacing(ByVal bBefore As Boolean, ByVal inValue As Long)
    Dim PF As PARAFORMAT2

    If bBefore Then
        PF.dySpaceBefore = inValue
        Call prtSetParagraph(PF, rhPFM_SPACEBEFORE)
    Else
        PF.dySpaceAfter = inValue
        Call prtSetParagraph(PF, rhPFM_SPACEAFTER)
    End If
End Property

Public Property Get Modified() As Boolean                                           '
    Modified = Not (SendMessage(hRichEdit, EM_GETMODIFY, vbcNull, vbcNull) = vbcNull)
End Property
Public Property Let Modified(ByVal bValue As Boolean)
    Call SendMessage(hRichEdit, EM_SETMODIFY, Abs(bValue), vbcNull)
End Property

Public Property Get Locked() As Boolean
      Locked = ((GetWindowLong(hRichEdit, &HFFF0) And rhES_READONLY) = rhES_READONLY)
End Property
Public Property Let Locked(ByVal bValue As Boolean)
   Call SendMessage(hRichEdit, EM_SETREADONLY, ByVal Abs(bValue), ByVal vbcNull)
End Property

Public Property Let WordWrap(ByVal bValue As Boolean)
    Call SendMessage(hRichEdit, EM_SETTARGETDEVICE, vbcNull, ByVal Abs(Not bValue))
End Property

Public Property Get hwnd() As Long
    hwnd = hRichEdit
End Property

Public Property Get Text(Optional ByVal IsRtf As Boolean) As String                 '
    Dim tStream As EDITSTREAM

    tStream.pfnCallback = plAddressOf(AddressOf LoadCallBackMem)
    Call SendMessage(hRichEdit, EM_STREAMOUT, IIf(IsRtf, 2&, 1&), tStream)

    Text = mRichEdit.StreamText
    mRichEdit.StreamText = vbNullString                                             '
End Property
Public Property Let Text(Optional ByVal IsRtf As Boolean, sText As String)
    Dim tStream As EDITSTREAM

    mRichEdit.StreamText = sText

    tStream.pfnCallback = plAddressOf(AddressOf SaveCallBackMem)
    Call SendMessage(hRichEdit, EM_STREAMIN, IIf(IsRtf, 2&, 1&), tStream)

    mRichEdit.StreamText = vbNullString                                             '
    Modified = False                                                                '
End Property

Public Property Let SelVisible(bValue As Boolean)
    Call SendMessage(hRichEdit, EM_HIDESELECTION, ByVal Not bValue, ByVal vbcNull)
End Property


'   

Public Function FindText(ByVal sText As String, _
                Optional ByVal fOptions As gbFindOpt = rhFR_DEFAULT, _
                Optional ByVal lStart As Long = vbcNull, _
                Optional ByVal lFinish As Long = &HFFFF) As Long

    Dim FT As FINDTEXTEX_A
    Dim bt() As Byte

    bt = StrConv(sText & vbNullChar, vbFromUnicode)

    FT.lpstrText = VarPtr(bt(0))  ' pointer
    FT.chrg.cpMin = lStart
    FT.chrg.cpMax = lFinish

    FindText = SendMessage(hRichEdit, EM_FINDTEXTEX, fOptions, FT)
End Function

Public Function LineLength(ByVal Index As Long) As Long
    LineLength = SendMessage(hRichEdit, EM_LINEINDEX, Index, ByVal vbcNull)
    LineLength = SendMessage(hRichEdit, EM_LINELENGTH, LineLength, ByVal vbcNull)
End Function

Public Function CanPaste() As Boolean
    CanPaste = SendMessage(hRichEdit, EM_CANPASTE, vbcNull, vbcNull)
End Function

Public Function CanRedo() As Boolean
    CanRedo = SendMessage(hRichEdit, EM_CANREDO, vbcNull, vbcNull)
End Function

Public Function CanUndo() As Boolean
    CanUndo = SendMessage(hRichEdit, EM_CANUNDO, vbcNull, vbcNull)
End Function

Public Function SetUndoLim(ByVal inValue As Long) As Boolean
    SetUndoLim = (SendMessage(hRichEdit, EM_SETUNDOLIMIT, inValue, ByVal vbcNull) = inValue)
End Function

Public Function CanCopy() As Boolean
   CanCopy = (GetTextSel.cpMax > GetTextSel.cpMin)
End Function

Public Function UndoType() As gbRichEditUnReTypes
    UndoType = SendMessage(hRichEdit, EM_GETUNDONAME, vbcNull, vbcNull)
End Function

Public Function RedoType() As gbRichEditUnReTypes
    RedoType = SendMessage(hRichEdit, EM_GETREDONAME, vbcNull, vbcNull)
End Function

Public Sub SetUndoPoint()
    Call SendMessage(hRichEdit, EM_STOPGROUPTYPING, vbcNull, vbcNull)
End Sub

Public Sub ClearUndo()
    Call SendMessage(hRichEdit, EM_EMPTYUNDOBUFFER, vbcNull, vbcNull)
End Sub

Public Sub Cut()
   Call SendMessage(hRichEdit, &H300, vbcNull, vbcNull)             ' WM_CUT
End Sub

Public Sub Copy()
   Call SendMessage(hRichEdit, &H301, vbcNull, vbcNull)             ' WM_COPY
End Sub

Public Sub Paste()
   Call SendMessage(hRichEdit, &H302, vbcNull, vbcNull)             ' WM_PASTE
End Sub

Public Sub PasteSpecial()
   Call SendMessage(hRichEdit, WM_USER + 64, vbcNull, vbcNull)      ' EM_PASTESPECIAL
End Sub

Public Sub Undo()
   Call SendMessage(hRichEdit, &HC7, vbcNull, vbcNull)              ' EM_UNDO
End Sub

Public Sub Redo()
    Call SendMessage(hRichEdit, WM_USER + 84, vbcNull, vbcNull)     ' EM_REDO
End Sub

Public Sub Clear()
 Const WM_CLEAR = &H303
 SendMessage hRichEdit, WM_CLEAR, vbcNull, vbcNull
End Sub


Public Function Border() As Boolean                                                 '
    Border = ((GetWindowLong(hRichEdit, &HFFF0) And rhES_SUNKEN) = rhES_SUNKEN)
End Function

Public Sub GetParagraphLineSpacing(Optional ByRef outLineSpacingStyle As gbRichEditPFLnSp, _
                                   Optional ByRef outYSpacing As Long)              '
    outLineSpacingStyle = prtGetParagraph(rhPFM_LINESPACING).bLineSpacingRule
    outYSpacing = prtGetParagraph(rhPFM_LINESPACING).dyLineSpacing
End Sub
Public Sub SetParagraphLineSpacing(Optional ByVal outLineSpacingStyle As gbRichEditPFLnSp, _
                                   Optional ByVal outYSpacing As Long)
    Dim PF As PARAFORMAT2

    PF.bLineSpacingRule = outLineSpacingStyle
    PF.dyLineSpacing = outYSpacing

    Call prtGetParagraph(rhPFM_LINESPACING)
End Sub

Public Sub Redraw(Optional ByVal bState As Boolean = True)
    If bState Then
        Call SendMessage(hRichEdit, WM_SETREDRAW, vbNull, ByVal vbcNull)
        Call InvalidateRect(hRichEdit, ByVal vbcNull, vbNull)
        Call UpdateWindow(hRichEdit)
    Else
        Call SendMessage(hRichEdit, WM_SETREDRAW, vbcNull, ByVal vbcNull)
    End If
End Sub

Public Function LineText(Optional ByVal lLine As Long = vbcNull) As String
    Dim lLen As Long

    lLen = SendMessage(hRichEdit, EM_LINEINDEX, lLine, ByVal vbcNull)
    lLen = SendMessage(hRichEdit, EM_LINELENGTH, lLen, ByVal vbcNull)

    If lLen < 2 Then lLen = 2
    LineText = String(lLen + vbNull, vbcNull)

    Mid$(LineText, 1&, vbNull) = Chr$(lLen And &HFF)
    Mid$(LineText, 2&, vbNull) = Chr$(lLen \ &H100)

    Call SendMessage(hRichEdit, EM_GETLINE, lLine, ByVal LineText)
    LineText = Left$(LineText, lLen)
End Function

Public Property Get CurrentLine() As Long                                               '
   CurrentLine = SendMessage(hRichEdit, EM_EXLINEFROMCHAR, vbcNull, ByVal GetTextSel.cpMin)
End Property

Public Property Get CurrentLineTextLength() As Long                                     '
   CurrentLineTextLength = SendMessage(hRichEdit, EM_LINELENGTH, &HFFFF, vbcNull)
End Property

Public Property Get LinesCount() As Long
   LinesCount = SendMessage(hRichEdit, EM_GETLINECOUNT, vbcNull, vbcNull)
End Property

Public Function TextInRange(ByVal lStart As Long, ByVal lEnd As Long) As String
    Dim TR As TEXTRANGE
    Dim bt() As Byte

    TextInRange = String$(lEnd - lStart + 2&, vbcNull)
    bt = StrConv(TextInRange, vbFromUnicode)

    TR.chrg.cpMin = lStart: TR.chrg.cpMax = lEnd
    TR.lpstrText = VarPtr(bt(0))

    lStart = SendMessage(hRichEdit, EM_GETTEXTRANGE, 0, TR) '
    If lStart > vbcNull Then TextInRange = StrConv(bt, vbUnicode): TextInRange = Left$(TextInRange, lStart) Else TextInRange = vbNullString
End Function

Public Function SelectedText() As String
    Dim sBuffer As String, lVar As Long

    lVar = GetTextSel.cpMax - GetTextSel.cpMin
    If lVar < vbcNull Then Exit Function

    sBuffer = String$(lVar + vbNull, vbcNull)
    lVar = SendMessage(hRichEdit, EM_GETSELTEXT, vbcNull, ByVal sBuffer)
    If lVar > vbcNull Then SelectedText = Left$(sBuffer, lVar)
End Function

Public Function GetTextLength(ByVal lFlags As gbHWgetTextFlags, Optional ByVal CodePage = vbcNull) As Long
    Dim wParam As GETTEXTLENGTHEX, lng As Long

    wParam.CodePage = CodePage
    wParam.lFlags = lFlags

    GetTextLength = SendMessage(hRichEdit, EM_GETTEXTLENGTHEX, VarPtr(wParam), ByVal vbcNull)
End Function

Public Function GetText(Optional UseCrLf As Boolean = False) As String
    Dim wParam As GETTEXTEX

    wParam.cb = GetTextLength(GTL_NUMCHARS Or Abs(UseCrLf))
    wParam.Flags = Abs(UseCrLf)

    GetText = String$(wParam.cb, vbcNull)
    Call SendMessage(hRichEdit, EM_GETTEXTEX, VarPtr(wParam), ByVal GetText)
End Function

Public Sub SetText(ByVal sText As String, Optional ByVal uFlags As gbHWRichEditTextPutFlags = ST_DEFAULT)
    Dim wParam As SETTEXTEX
    wParam.Flags = uFlags
    Call SendMessage(hRichEdit, EM_SETTEXTEX, VarPtr(wParam), ByVal sText)
End Sub

Public Function LineFromCharIndex(ByVal inCharNumber As Long) As Long           '
   LineFromCharIndex = SendMessage(hRichEdit, EM_EXLINEFROMCHAR, vbcNull, ByVal inCharNumber)
End Function

Public Function CharFromPos(ByVal xPixels As Long, ByVal yPixels As Long) As Long
    Dim pt As POINTAPI: pt.x = xPixels: pt.y = yPixels
    CharFromPos = SendMessage(hRichEdit, EM_CHARFROMPOS, vbcNull, pt)
End Function

Public Sub GetPosFromChar(ByVal lIndex As Long, ByRef xPixels As Long, ByRef yPixels As Long)
    Dim lxy As Long

    lxy = SendMessage(hRichEdit, EM_POSFROMCHAR, lIndex, vbcNull)
    xPixels = (lxy And &HFFFF&): yPixels = (lxy \ &H10000) And &HFFFF&
End Sub

Public Sub SelectAll()
   Call SetTextSel(vbcNull, &HFFFF)
End Sub

Public Sub Move(ByVal nLeft As Long, ByVal nTop As Long, _
                Optional ByVal nWidth As Long, Optional ByVal nHeight As Long)
    Dim hRect As RECT

    Call GetClientRect(hRichEdit, hRect)

    If nWidth = vbcNull Then nWidth = hRect.Right
    If nHeight = vbcNull Then nHeight = hRect.Bottom

    Call MoveWindow(hRichEdit, nLeft, nTop, nWidth, nHeight, 1&)
End Sub

Public Function LoadFile(ByVal sFileName As String, _
                         ByVal bIsRtf As Boolean) As String
    Dim tStream As EDITSTREAM
    Dim hFile   As Long, lpReOpenBuff As OFSTRUCT
    
    hFile = OpenFile(sFileName, lpReOpenBuff, vbcNull)

    If hFile = vbcNull Then Exit Function

    tStream.dwCookie = hFile
    tStream.pfnCallback = plAddressOf(AddressOf LoadCallBack)
    tStream.dwError = 0
    
    If SendMessage(hRichEdit, EM_STREAMIN, IIf(bIsRtf, &H2, &H1), tStream) Then _
        LoadFile = mRichEdit.StreamText: _
        mRichEdit.StreamText = vbNullString: _
        Modified = False

    Call CloseHandle(hFile)
End Function

Public Function SaveFile(ByVal sFileName As String, _
                         ByVal bIsRtf As Boolean) As Boolean
    Dim tStream As EDITSTREAM
    Dim hFile   As Long, lpReOpenBuff As OFSTRUCT

    hFile = OpenFile(sFileName, lpReOpenBuff, &H1000)

    If hFile = vbcNull Then Exit Function
    
    tStream.dwCookie = hFile
    tStream.pfnCallback = plAddressOf(AddressOf SaveCallBack)
    tStream.dwError = 0

    If SendMessage(hRichEdit, EM_STREAMOUT, IIf(bIsRtf, &H2, &H1), tStream) Then SaveFile = True
    Call CloseHandle(hFile)
End Function

Public Sub GetCaretPos(Optional ByRef x As Long, Optional ByRef y As Long, Optional ByVal ToScreen As Boolean)
    Dim pt As POINTAPI: Call GetCaretPosition(pt)

    If ToScreen Then Call ClientToScreen(hRichEdit, pt)
    x = pt.x: y = pt.y
End Sub

Public Sub SetFocus()
    Call SetFocusAPI(hRichEdit)
End Sub

'  ... 

Private Function TranslateColor(ByVal clr As Long, Optional hPal As Long = vbcNull) As Long
    If OleTranslateColor(clr, hPal, TranslateColor) Then TranslateColor = &HFFFF
End Function

Private Function GetTextSel() As CHARRANGE
    Call SendMessage(hRichEdit, EM_EXGETSEL, vbcNull, GetTextSel)
End Function

Private Function SetTextSel(ByVal cpMin As Long, ByVal cpMax As Long)
    Dim cData As CHARRANGE
    cData.cpMin = cpMin: cData.cpMax = cpMax

    Call SendMessage(hRichEdit, EM_EXSETSEL, vbcNull, cData)
End Function

Private Function prtGetFormat(Optional ByVal fOpt As gbChFrmtSt = rhSCF_SELECTION, _
                              Optional ByVal dwMskOther As gbChFrmt2Others, _
                              Optional ByVal dwMskEffects As gbChFrmt2Effects) As CHARFORMAT2
    prtGetFormat.cbSize = Len(prtGetFormat)
    prtGetFormat.dwMask = dwMskOther Or dwMskEffects

    Call SendMessage(hRichEdit, EM_GETCHARFORMAT, fOpt, prtGetFormat)
End Function
Private Sub prtSetFormat(ByRef inValue As CHARFORMAT2, _
                Optional ByVal fOpt As gbChFrmtSt = rhSCF_SELECTION, _
                Optional ByVal dwMskOther As gbChFrmt2Others, _
                Optional ByVal dwMskEffects As gbChFrmt2Effects)
    inValue.cbSize = Len(inValue)
    inValue.dwMask = inValue.dwMask Or dwMskOther Or dwMskEffects

    Call SendMessage(hRichEdit, EM_SETCHARFORMAT, fOpt, inValue)
End Sub

Private Function prtGetParagraph(dwMask As gbRichEditParaWMask) As PARAFORMAT2
    prtGetParagraph.cbSize = Len(prtGetParagraph)
    prtGetParagraph.dwMask = dwMask
    Call SendMessage(hRichEdit, EM_GETPARAFORMAT, vbcNull, prtGetParagraph)
End Function
Private Sub prtSetParagraph(ByRef inValue As PARAFORMAT2, _
                   Optional ByVal dwMask As gbRichEditParaWMask)
    inValue.cbSize = Len(inValue)
    inValue.dwMask = inValue.dwMask Or dwMask
    Call SendMessage(hRichEdit, EM_SETPARAFORMAT, vbcNull, inValue)
End Sub

Private Function plAddressOf(ByVal lAddr As Long) As Long
    plAddressOf = lAddr
End Function

Private Function LoWord(DWord As Long) As Integer
    LoWord = IIf(DWord And &H8000&, DWord Or &HFFFF0000, DWord And &HFFFF&)
End Function

Private Function HiWord(DWord As Long) As Integer
    HiWord = (DWord And &HFFFF0000) \ &H10000
End Function

Private Function giGetShiftState() As Integer                                   '
    giGetShiftState = (-vbShiftMask * gbKeyIsPressed(vbKeyShift))
    giGetShiftState = giGetShiftState Or (-vbAltMask * gbKeyIsPressed(vbKeyMenu))
    giGetShiftState = giGetShiftState Or (-vbCtrlMask * gbKeyIsPressed(vbKeyControl))
End Function

Private Function gbKeyIsPressed(ByVal nVirtKeyCode As KeyCodeConstants) As Boolean
    If (GetAsyncKeyState(nVirtKeyCode) And &H8000&) = &H8000& Then gbKeyIsPressed = True
End Function

'   

Private Sub Class_Initialize()
    hRichDll = LoadLibrary("RICHED20.DLL")
End Sub

Private Sub Class_Terminate()
    Call FreeLibrary(hRichDll)
End Sub
