Attribute VB_Name = "mRichEdit"
Option Explicit

Private Declare Function ReadFile Lib "kernel32.dll" (ByVal hFile As Long, lpBuffer As Any, ByVal nNumberOfBytesToRead As Long, lpNumberOfBytesRead As Long, lpOverlapped As Long) As Long
Private Declare Function WriteFile Lib "kernel32.dll" (ByVal hFile As Long, lpBuffer As Any, ByVal nNumberOfBytesToWrite As Long, lpNumberOfBytesWritten As Long, lpOverlapped As Long) As Long

Private Declare Sub CopyMemory Lib "kernel32.dll" Alias "RtlMoveMemory" (Destination As Any, Source As Any, ByVal Length As Long)
Private Declare Function GetParent Lib "user32.dll" (ByVal hwnd As Long) As Long

Private Declare Function GetDlgItem Lib "user32.dll" (ByVal hDlg As Long, ByVal nIDDlgItem As Long) As Long
Private Declare Function GetDlgCtrlID Lib "user32.dll" (ByVal hwnd As Long) As Long

Private Declare Function SetWindowLong Lib "user32" Alias "SetWindowLongA" (ByVal hwnd As Long, ByVal nIndex As Long, ByVal dwNewLong As Long) As Long
Private Declare Function CallWindowProc Lib "user32" Alias "CallWindowProcA" (ByVal lpPrevWndFunc As Long, ByVal hwnd As Long, ByVal msg As Long, ByVal wParam As Long, ByVal lParam As Long) As Long

Private Declare Function SetCursor Lib "user32.dll" (ByVal hCursor As Long) As Long
Private Declare Function LoadCursor Lib "user32.dll" Alias "LoadCursorA" (ByVal hInstance As Long, ByVal lpCursorName As Long) As Long

Private Type NMHDR_RICHEDIT
    hwndFrom    As Long
    wPad1       As Integer
    idfrom      As Integer
    code        As Integer
    wPad2       As Integer
End Type

Private Type gbHWSubclassFrmData        ' Several forms
    BaseProc    As Long
    hwnd        As Long
End Type
Private Type gbHWSubclassCtlData        ' Several controls
    BaseProc    As Long
    hwnd        As Long
    CtlID       As Long
    hWndPrnt    As Long
    mObj        As Long
End Type

Private Const WM_NOTIFY         As Long = &H4E
Private Const WM_CONTEXTMENU    As Long = &H7B
Private Const WM_SETCURSOR      As Long = &H20
Private Const WM_VSCROLL        As Long = &H115
Private Const WM_HSCROLL        As Long = &H114

Private ctlData() As gbHWSubclassCtlData
Private frmData() As gbHWSubclassFrmData

Private mStreamText As String, _
        mTxtCurrPos As Long, _
        mCntMnu As Boolean

Dim lOldProc As Long

'  Multi sublassing 

Public Sub RichEditStartSubclass(mObj As cRichEdit)
    Dim lng As Long
    If Not FindByKey(mObj.hwnd, False) = &HFFFF Then Exit Sub

    lng = UboundEx(False) + 1&
    ReDim Preserve ctlData(lng)

    ctlData(lng).hwnd = mObj.hwnd
    ctlData(lng).BaseProc = SetWindowLong(ctlData(lng).hwnd, &HFFFC, AddressOf RichCtlCallProc)
    ctlData(lng).CtlID = GetDlgCtrlID(ctlData(lng).hwnd)
    ctlData(lng).hWndPrnt = GetParent(ctlData(lng).hwnd)
    ctlData(lng).mObj = ObjPtr(mObj)

    If Not FindByKey(ctlData(lng).hWndPrnt, True) = &HFFFF Then Exit Sub
    lng = UboundEx(True) + 1&
    ReDim Preserve frmData(lng)

    frmData(lng).hwnd = GetParent(ctlData(lng).hwnd)
    frmData(lng).BaseProc = SetWindowLong(frmData(lng).hwnd, &HFFFC, AddressOf RichFrmCallProc)
End Sub

Public Sub RichEditStopSubclass(mObj As cRichEdit)
    Dim fk      As Long, nIndex As Long
    Dim tmpData As gbHWSubclassCtlData

    nIndex = FindByKey(mObj.hwnd, False)
    If nIndex = &HFFFF Then Exit Sub
    
    tmpData = ctlData(nIndex)

    For fk = 0 To UboundEx(False)                           ' Other controls present
        If Not nIndex = fk Then If ctlData(fk).hWndPrnt = tmpData.hWndPrnt Then Call RemoveCtl(nIndex, False): Exit Sub
    Next
    Call RemoveCtl(nIndex, False)

    nIndex = FindByKey(tmpData.hWndPrnt, True)              ' No more controls of this class. Sublassing now off
    Call RemoveCtl(nIndex, True)
End Sub

Private Function RichCtlCallProc(ByVal hwnd As Long, ByVal uMsg As Long, ByVal wParam As Long, ByVal lParam As Long) As Long
    Dim CtlID As Long, RTB As New cRichEdit
    CtlID = FindByKey(hwnd, False)

    Const WM_PASTE = &H302
    
    If uMsg = WM_VSCROLL Or uMsg = WM_HSCROLL Then
        If Not CtlID = &HFFFF Then
            Call CopyMemory(RTB, ctlData(CtlID).mObj, 4&)
                RichCtlCallProc = RTB.zRichEditCallBack(uMsg, lParam)
            Call CopyMemory(RTB, 0&, 4&)

            If RichCtlCallProc Then Exit Function
        End If
    ElseIf uMsg = WM_PASTE Then
        LASMIDE.RichEdit_RedrawSyntax
    End If

    RichCtlCallProc = CallWindowProc(ctlData(CtlID).BaseProc, hwnd, uMsg, wParam, lParam)
End Function

Private Function RichFrmCallProc(ByVal hwnd As Long, ByVal uMsg As Long, ByVal wParam As Long, ByVal lParam As Long) As Long
    Dim FrmID   As Long, CtlID As Long, RTB As New cRichEdit
    Dim tNMH    As NMHDR_RICHEDIT

    FrmID = FindByKey(hwnd, True)

    Select Case uMsg
        Case Is = WM_NOTIFY:        Call CopyMemory(tNMH, ByVal lParam, Len(tNMH))
        Case Is = WM_CONTEXTMENU:   tNMH.hwndFrom = wParam: tNMH.code = WM_CONTEXTMENU
    End Select

    Select Case uMsg
        Case Is = WM_NOTIFY, WM_CONTEXTMENU
            CtlID = FindByKey(tNMH.hwndFrom, False)

            If Not CtlID = &HFFFF Then
                Call CopyMemory(RTB, ctlData(CtlID).mObj, 4&)
                    RichFrmCallProc = RTB.zRichEditCallBack(tNMH.code, lParam)
                Call CopyMemory(RTB, 0&, 4&)

                If RichFrmCallProc Then Exit Function
            End If
    End Select

    RichFrmCallProc = CallWindowProc(frmData(FrmID).BaseProc, hwnd, uMsg, wParam, lParam)
End Function

'  Multi subclassing functions 

Private Function UboundEx(ByVal bIsFrm As Boolean) As Long
    On Error Resume Next
    UboundEx = &HFFFF: If bIsFrm Then UboundEx = UBound(frmData) Else UboundEx = UBound(ctlData)
End Function

Private Function FindByKey(ByVal hwnd As Long, ByVal bIsFrm As Boolean) As Long
    Dim fk As Long: FindByKey = &HFFFF

    For fk = 0 To UboundEx(bIsFrm)
        If bIsFrm Then
            If hwnd = frmData(fk).hwnd Then FindByKey = fk: Exit For
        Else
            If hwnd = ctlData(fk).hwnd Then FindByKey = fk: Exit For
        End If
    Next
End Function

Private Function RemoveCtl(ByVal nIndex As Long, ByVal bIsFrm As Boolean) As Integer
    Dim ub As Long: ub = UboundEx(bIsFrm)

    If bIsFrm Then
        Call SetWindowLong(frmData(nIndex).hwnd, &HFFFC, frmData(nIndex).BaseProc)

        If Not ub = 0 And Not ub = &HFFFF Then
            If Not ub = nIndex Then Call CopyMemory(frmData(nIndex), frmData(nIndex + 1), Len(frmData(nIndex)) * (ub - nIndex))
            ReDim Preserve frmData(ub - 1)
        Else
            Erase frmData
        End If
    Else
        Call SetWindowLong(ctlData(nIndex).hwnd, &HFFFC, ctlData(nIndex).BaseProc)

        If Not ub = 0 And Not ub = &HFFFF Then
            If Not ub = nIndex Then Call CopyMemory(ctlData(nIndex), ctlData(nIndex + 1), Len(ctlData(nIndex)) * (ub - nIndex))
            ReDim Preserve ctlData(ub - 1)
        Else
            Erase ctlData
        End If
    End If
End Function

'  Get text 

Public Property Get StreamText() As String
    StreamText = mStreamText
End Property

Public Property Let StreamText(ByVal inValue As String)
    mStreamText = inValue
    mTxtCurrPos = vbNull
End Property

'  CallBack Load/Save 

Public Function LoadCallBack(ByVal dwCookie As Long, ByVal lPtrPbBuff As Long, ByVal cb As Long, ByVal pcb As Long) As Long
    Call ReadFile(dwCookie, ByVal lPtrPbBuff, cb, ByVal pcb, ByVal 0&)
End Function

Public Function SaveCallBack(ByVal dwCookie As Long, ByVal lPtrPbBuff As Long, ByVal cb As Long, ByVal pcb As Long) As Long
    Call WriteFile(dwCookie, ByVal lPtrPbBuff, cb, ByVal pcb, ByVal 0&)
End Function

Public Function LoadCallBackMem(ByVal dwCookie As Long, ByVal lPtrPbBuff As Long, ByVal cb As Long, ByVal pcb As Long) As Long
    Dim sBuffer As String
    sBuffer = String$(cb, 0&)

    Call CopyMemory(ByVal sBuffer, ByVal lPtrPbBuff, cb)    ' Ptr to Ptr(Str)
    Call CopyMemory(ByVal pcb, cb, 4&)

    mStreamText = mStreamText & sBuffer
    LoadCallBackMem = 0&
End Function

Public Function SaveCallBackMem(ByVal dwCookie As Long, ByVal lPtrPbBuff As Long, ByVal cb As Long, ByVal pcb As Long) As Long
    Dim lLen As Long
    lLen = Len(mStreamText)

    If lLen > cb Then
        Dim strToCopy As String
        
        If mTxtCurrPos >= lLen Then
            Call CopyMemory(ByVal pcb, 0&, 4&)
            Exit Function

        ElseIf Not mTxtCurrPos + cb > lLen Then
            strToCopy = Mid$(mStreamText, mTxtCurrPos, cb)
            mTxtCurrPos = mTxtCurrPos + cb

        Else
            strToCopy = Mid$(mStreamText, mTxtCurrPos, cb)
            cb = lLen - mTxtCurrPos + 1&
            mTxtCurrPos = mTxtCurrPos + cb
        End If

        Call CopyMemory(ByVal lPtrPbBuff, ByVal strToCopy, cb)
        Call CopyMemory(ByVal pcb, cb, 4&)
    Else
        If mTxtCurrPos = vbNull Then
            Call CopyMemory(ByVal lPtrPbBuff, ByVal mStreamText, lLen)
            Call CopyMemory(ByVal pcb, lLen, 4&)

            mTxtCurrPos = 0&
        Else
            Call CopyMemory(ByVal pcb, 0&, 4&)
        End If
    End If
End Function

Private Function LoWord(DWord As Long) As Integer
    LoWord = IIf(DWord And &H8000&, DWord Or &HFFFF0000, DWord And &HFFFF&)
End Function

Private Function HiWord(DWord As Long) As Integer
    HiWord = (DWord And &HFFFF0000) \ &H10000
End Function

