%PLUGIN_VERSION = 108

%NM_NONAME      = &h00            '// Undefined name
%NM_ANYNAME     = &hFF            '// Name of any type
'// Names saved in the data file of module they appear.
%NM_PLUGCMD     = &h30            '// Plugin commands to execute at break
%NM_LABEL       = &h31            '// User-defined label
%NM_EXPORT      = &h32            '// Exported (global) name
%NM_IMPORT      = &h33            '// Imported name
%NM_LIBRARY     = &h34            '// Name from library or object file
%NM_CONST       = &h35            '// User-defined constant
%NM_COMMENT     = &h36            '// User-defined comment
%NM_LIBCOMM     = &h37            '// Comment from library or object file
%NM_BREAK       = &h38            '// Condition related with breakpoint
%NM_ARG         = &h39            '// Arguments decoded by analyzer
%NM_ANALYSE     = &h3A            '// Comment added by analyzer
%NM_BREAKEXPR   = &h3B            '// Expression related with breakpoint
%NM_BREAKEXPL   = &h3C            '// Explanation related with breakpoint
%NM_ASSUME      = &h3D            '// Assume function with known arguments
%NM_STRUCT      = &h3E            '// Code structure decoded by analyzer
%NM_CASE        = &h3F            '// Case description decoded by analyzer
'// Names saved in the data file of main module.
%NM_INSPECT     = &h40            '// Several last inspect expressions
%NM_WATCH       = &h41            '// Watch expressions
%NM_ASM         = &h42            '// Several last assembled strings
%NM_FINDASM     = &h43            '// Several last find assembler strings
%NM_LASTWATCH   = &h48            '// Several last watch expressions
%NM_SOURCE      = &h49            '// Several last source search strings
%NM_REFTXT      = &h4A            '// Several last ref text search strings
%NM_GOTO        = &h4B            '// Several last expressions to follow
%NM_GOTODUMP    = &h4C            '// Several expressions to follow in Dump
%NM_TRPAUSE     = &h4D            '// Several expressions to pause trace
'// Pseudonames.
%NM_IMCALL      = &hFE            '// Intermodular call
%NMHISTORY      = &h40            '// Converts NM_xxx to type of init list

%CPU_ASMHIST     = &h1    '// Add change to Disassembler history
%CPU_ASMCENTER   = &h4    '// Make address in the middle of window
%CPU_ASMFOCUS    = &h8    '// Move focus to Disassembler
%CPU_DUMPHIST    = &h10    '// Add change to Dump history
%CPU_DUMPFIRST   = &h20    '// Make address the first byte in Dump
%CPU_DUMPFOCUS   = &h80    '// Move focus to Dump
%CPU_REGAUTO     = &h100    '// Automatically switch to FPU/MMX/3DNow!
%CPU_RUNTRACE    = &h200    '// Show run trace data at offset asmaddr
%CPU_STACKFOCUS  = &h800    '// Move focus to Stack
%CPU_NOCREATE    = &h4000    '// Don't create CPU window if absent
%CPU_REDRAW      = &h8000    '// Redraw CPU window immediately
%CPU_NOFOCUS     = &h10000    '// Don't assign focus to main window

'////////////////////// EXPORTED PLUGIN CALLBACK FUNCTIONS //////////////////////
'// Origins of standard OllyDbg windows as passed to plugin. In parenthesis is
'// the type of item you get in ODBG_Pluginmenu(), ODBG_Pluginaction() and
'// ODBG_Pluginshortcut(). Note that this item can be NULL!
%PM_MAIN        = 0        '// Main window        (NULL)
%PM_DUMP        = 10       '// Any Dump window    (t_dump*)
%PM_MODULES     = 11       '// Modules window     (t_module*)
%PM_MEMORY      = 12       '// Memory window      (t_memory*)
%PM_THREADS     = 13       '// Threads window     (t_thread*)
%PM_BREAKPOINTS = 14       '// Breakpoints window (t_bpoint*)
%PM_REFERENCES  = 15       '// References window  (t_ref*)
%PM_RTRACE      = 16       '// Run trace window   (int*)
%PM_WATCHES     = 17       '// Watches window     (1-based index)
%PM_WINDOWS     = 18       '// Windows window     (t_window*)
%PM_DISASM      = 31       '// CPU Disassembler   (t_dump*)
%PM_CPUDUMP     = 32       '// CPU Dump           (t_dump*)
%PM_CPUSTACK    = 33       '// CPU Stack          (t_dump*)
%PM_CPUREGS     = 34       '// CPU Registers      (t_reg*)


'// Parameters of Plugingetvalue().
%VAL_HINST              = 1     '// Current program instance
%VAL_HWMAIN             = 2     '// Handle of the main window
%VAL_HWCLIENT           = 3     '// Handle of the MDI client window
%VAL_NCOLORS            = 4     '// Number of common colors
%VAL_COLORS             = 5     '// RGB values of common colors
%VAL_BRUSHES            = 6     '// Handles of common color brushes
%VAL_PENS               = 7     '// Handles of common color pens
%VAL_NFONTS             = 8     '// Number of common fonts
%VAL_FONTS              = 9     '// Handles of common fonts
%VAL_FONTNAMES          = 10    '// Internal font names
%VAL_FONTWIDTHS         = 11    '// Average widths of common fonts
%VAL_FONTHEIGHTS        = 12    '// Average heigths of common fonts
%VAL_NFIXFONTS          = 13    '// Actual number of fixed-pitch fonts
%VAL_DEFFONT            = 14    '// Index of default font
%VAL_NSCHEMES           = 15    '// Number of color schemes
%VAL_SCHEMES            = 16    '// Color schemes
%VAL_DEFSCHEME          = 17    '// Index of default colour scheme
%VAL_DEFHSCROLL         = 18    '// Default horizontal scroll
%VAL_RESTOREWINDOWPOS   = 19    '// Restore window positions from .ini
%VAL_HPROCESS           = 20    '// Handle of Debuggee
%VAL_PROCESSID          = 21    '// Process ID of Debuggee
%VAL_HMAINTHREAD        = 22    '// Handle of main thread
%VAL_MAINTHREADID       = 23    '// Thread ID of main thread
%VAL_MAINBASE           = 24    '// Base of main module in the process
%VAL_PROCESSNAME        = 25    '// Name of the active process
%VAL_EXEFILENAME        = 26    '// Name of the main debugged file
%VAL_CURRENTDIR         = 27    '// Current directory for debugged process
%VAL_SYSTEMDIR          = 28    '// Windows system directory
%VAL_DECODEANYIP        = 29    '// Decode registers dependless on EIP
%VAL_PASCALSTRINGS      = 30    '// Decode Pascal-style string constants
%VAL_ONLYASCII          = 31    '// Only printable ASCII chars in dump
%VAL_DIACRITICALS       = 32    '// Allow diacritical symbols in strings
%VAL_GLOBALSEARCH       = 33    '// Search from the beginning of block
%VAL_ALIGNEDSEARCH      = 34    '// Search aligned to item's size
%VAL_IGNORECASE         = 35    '// Ignore case in string search
%VAL_SEARCHMARGIN       = 36    '// Floating search allows error margin
%VAL_KEEPSELSIZE        = 37    '// Keep size of hex edit selection
%VAL_MMXDISPLAY         = 38    '// MMX display mode in dialog
%VAL_WINDOWFONT         = 39    '// Use calling window's font in dialog
%VAL_TABSTOPS           = 40    '// Distance between tab stops
%VAL_MODULES            = 41    '// Table of modules (.EXE and .DLL)
%VAL_MEMORY             = 42    '// Table of allocated memory blocks
%VAL_THREADS            = 43    '// Table of active threads
%VAL_BREAKPOINTS        = 44    '// Table of active breakpoints
%VAL_REFERENCES         = 45    '// Table with found references
%VAL_SOURCELIST         = 46    '// Table of source files
%VAL_WATCHES            = 47    '// Table of watches
%VAL_CPUFEATURES        = 50    '// CPU feature bits
%VAL_TRACEFILE          = 51    '// Handle of run trace log file
%VAL_ALIGNDIALOGS       = 52    '// Whether to align dialogs
%VAL_CPUDASM            = 53    '// Dump descriptor of CPU Disassembler
%VAL_CPUDDUMP           = 54    '// Dump descriptor of CPU Dump
%VAL_CPUDSTACK          = 55    '// Dump descriptor of CPU Stack
%VAL_APIHELP            = 56    '// Name of selected API help file
%VAL_HARDBP             = 57    '// Whether hardware breakpoints enabled




Type t_disasm               '// Results of disassembling
  ip As Dword                     '// (*) Instrucion pointer
  dump As String * 256            '// Hexadecimal dump of the command
  result As String * 256          '// Disassembled command
  comment As String * 256         '// Brief comment
  opinfo1 As String * 256         '// Comments to command's operands
  cmdtype As Long              '// (*) One of C_xxx
  memtype As Long              '// (*) Type of addressed variable in memory
  nprefix As Long              '// (*) Number of prefixes
  indexed As Long              '// Address contains register(s)
  jmpconst As Long             '// (*) Constant jump address
  jmptable As Long             '// (*) Possible address of switch table
  adrconst As Long             '// (*) Constant part of address
  immconst As Long             '// (*) Immediate constant
  zeroconst As Long            '// (*) Whether contains zero constant
  fixupoffset As Long          '// (*) Possible offset of 32-bit fixups
  fixupsize As Long            '// (*) Possible total size of fixups or 0
  jmpaddr As Long              '// Destination of jump/call/return
  condition As Long            '// 0xFF:unconditional, 0:false, 1:true
  dwerror As Long                '// (*) Error while disassembling command
  warnings As Long             '// (*) Combination of DAW_xxx
  optype(3) As Long            '// Type of operand (extended set DEC_xxx)
  opsize(3) As Long            '// Size of operand, bytes
  opgood(3) As Long            '// Whether address and data valid
  opaddr(3) As Long            '// Address if memory, index if register
  opdata(3) As Long            '// Actual value (only integer operands)
  t_operand(3) As Long      't_operand op[3];                '// Full description of operand
  regdata(8) As Long           '// Registers after command is executed
  regstatus(8) As Long         '// Status of registers, one of RST_xxx
  addrdata As Long             '// Traced memory address
  addrstatus As Long           '// Status of addrdata, one of RST_xxx
  dwregstack(32) As Long        'ulong regstack[NREGSTACK];  '// Stack tracing buffer
  dwrststatus(32) As Long       'int  rststatus[NREGSTACK];  '// Status of stack items
  dwnregstack As Long       'int  nregstack;             '// Number of items in stack trace buffer
  reserved(29) As Long         '// Reserved for plugin compatibility
End Type


Type t_bar
  nbar As Long                 '// Number of active columns
  lfont As Long                 '// Font used for bar segments
  dx(17) As Long        '// Actual widths of columns, pixels
  defdx(17) As Long          '// Default widths of columns, chars
  nameptr As Long  'char           *name[NBAR]          '// Column names (may be NULL)
  Mode As String * 17           '// Combination of BAR_xxx bits
  captured  As Long           '// One of CAPT_xxx, set to CAPT_FREE
  active   As Long            '// Info about how mouse is captured
  prevx As Long                '// Previous mouse coordinate
End Type


Type t_sorted                '// Descriptor of sorted table
  sName As String * 260      '// Name of table, as appears in error messages
  numentries As Long       '// Actual number of entries
  nmax As Long             '// Maximal number of entries
  selected As Long         '// Index of selected entry or -1
  seladdr As Long          '// Base address of selected entry
  itemsize As Long         '// Size of single entry
  version As Long          '// Unique version of table
  dwdata As Long            '// Elements, sorted by address
  dwSORTFUNC As Long  '   *sortfunc;        '// Function which sorts data or NULL
  dwDESTFUNC As Long  '  *destfunc;        '// Destructor function or NULL
  dwsort As Long             '// Sorting criterium (column)
  dwsorted As Long          '// Whether indexes are sorted
  index As Long  '// Indexes, sorted by criterium
  suppresser As Long      '// Suppress multiple overflow errors
End Type

Type t_memory              '// Memory block descriptor
  dwbase As Long             '// Base address of memory block
  dwsize As Long             '// Size of block
  dwtype As Long             '// Service information, TY_xxx
  dwowner As Long            '// Address of owner of the memory
  dwinitaccess As Long       '// Initial read/write access
  dwaccess As Long           '// Actual status and read/write access
  dwthreadid As Long         '// Block belongs to this thread or 0
  sModule As String * 8      '//char  sect[SHORTLEN];   '// Name of module section
  strCopy As Dword           '//char  *copy  '// Copy used in CPU window or NULL
  reserved(8) As Long     '// Reserved for plugin compatibility
End Type


Type t_table
    hWnd As Long
    sortdata As t_sorted
    bardata  As t_bar
    showbar As Long
    hscroll As Integer
    colsel As Integer
    lmode As Long
    lfont As Long
    scheme As Integer
    hilite As Integer
    offset As Long
    xshift As Long
    drawfunc As Long
End Type

Type t_dump                    '// Current STATUS OF dump WINDOW
  table As t_table               't_table             '// Treat dump WINDOW AS custom table
  dimmed As Long               '// DRAW IN lowcolor IF nonzero
  dwTHREADID As Dword          '// Use decoding AND registers IF NOT 0
  dumptype As Long         '// Current dump TYPE, DU_xxx+count+SIZE
  specdump As Dword   'SPECFUNC   *specdump         '// Decoder OF DU_SPEC dump types
  menutype As Long 'INT        menutype          '// Standard menus, MT_xxx
  itemwidth As Long  'INT        itemwidth         '// Length OF displayed item, characters
  showstackframes As Long 'INT        showstackframes   '// SHOW stack frames IN address dump
  showstacklocals As Long  'INT        showstacklocals   '// SHOW names OF locals IN stack
  showsource As Long  'INT        showsource        '// SHOW source AS comment IN disassembler
  szFilename As String * 260  '%MAX_PATH 'char       filename[MAXPATH] '// NAME OF displayed OR backup file
  lBase As Dword 'ulong      BASE              '// Start OF memory block OR file
  lSize As Dword 'ulong      SIZE              '// SIZE OF memory block OR file
  dwADDR As Dword              '// Address OF first displayed BYTE
  dwlastaddr As Dword          '// Address OF last displayed BYTE + 1
  sel0 As Dword              '// Address OF first selected BYTE
  sel1 As Dword              '// Last selected BYTE (NOT included!)
  startsel As Dword          '// Start OF last selection
  captured As Long          '// Mouse IS captured by dump
  reladdr As Dword           '// Addresses relative TO this
  relname As String * 8        'char       relname[SHORTLEN] '// Symbol FOR relative zero address BASE
  tFilecopy As Dword  'char       *FILECOPY         '// COPY OF the file OR NULL
  tbackup As Dword   'char       *backup           '// Old backup OF memory/file OR NULL
  runtraceoffset As Long   '// Offset back IN run TRACE
  reserved(8) As Dword  '    reserved[8]       '// Reserved FOR the future extentions
End Type

Type t_module
 dwBase As Dword     '// Base address of module
 dwSize As Dword     '// Size occupied by module
 dwType As Dword     '// Service information, TY_xxx
 dwCodebase As Dword '// Base address of module code block
 dwResbase As Dword  '// Base address of resources
 dwResSize As Dword  '// Size of resources
 t_stringtable As Dword '// Pointers to string resources or null
 nstringtable As Dword  '// Actual number of used stringtable
 maxstringtable As Dword '// Actual number of allocated stringtable
 entry As Dword         '// Address of <ModuleEntryPoint> or null
 sRest As String * 2048  '// ignore the rest of the structure
End Type

'// EXPORTS
Declare Function ODBG_Pluginclose CDecl Alias "_ODBG_Pluginclose" () As Long
Declare Function ODBG_Plugindata CDecl Alias "_ODBG_Plugindata"      (shortname As Asciiz * 32) As Long 'char shortname[32]
Declare Function ODBG_Plugininit CDecl Alias "_ODBG_Plugininit"      (ByVal ollydbgversion As Integer, ByVal hw As Long, features As Dword) As Long 'int ollydbgversion,HWND hw,ulong *features
Declare Function ODBG_Pluginmenu CDecl Alias "_ODBG_Pluginmenu"      (ByVal origin As Dword, xdata As Asciiz * 4096, ByVal Item As Dword) As Long  'int origin,char data[4096],void *item
Declare Sub      ODBG_Pluginaction  CDecl Alias "_ODBG_Pluginaction" (ByVal origin As Long, ByVal action As Long, ByVal Item As Dword Ptr) 'int origin,int action,void *item
Declare Sub      ODBG_Pluginreset   CDecl Alias "_ODBG_Pluginreset"   ()
Declare Sub      ODBG_Plugindestroy CDecl Alias "_ODBG_Plugindestroy" ()

'// IMPORTS
Declare Function ReadCommand(ByVal dwAddr As Long, ByVal sBufOutPtr As Dword) As Long
Declare Function Insertname(ByVal lAddr As Dword, ByVal lType As Long, szName As Asciiz) As Long
Declare Function Findmodule (ByVal dwAddr As Long) As Dword
Declare Sub      Addtolist(ByVal lLine As Long, ByVal lColor As Long, szText As Asciiz)
Declare Sub      Flash(szText As Asciiz)
Declare Function Plugingetvalue(ByVal lType As Long) As Long
Declare Function Findprocend(ByVal lAddr As Long) As Long
Declare Sub      Setcpu(ByVal lThreadID As Long, ByVal lASMaddr As Long, ByVal lCPUaddr As Long, ByVal lStackAddr As Long, ByVal Mode As Long)

'#####################################################################################################################################3
'// WIN32API ...

%DLL_PROCESS_ATTACH = 1
Declare Function GetProcAddress Lib "KERNEL32.DLL" Alias "GetProcAddress" (ByVal hModule As Dword, lpProcName As Asciiz) As Long
Declare Function GetModuleHandle Lib "KERNEL32.DLL" Alias "GetModuleHandleA" (lpModuleName As Asciiz) As Dword