#COMPILE DLL "c:\olly\skeleton.dll"  '// Change to your OllyDbg directory
#INCLUDE "win32api.inc"
#INCLUDE "ollydbg.inc"

GLOBAL hInst AS DWORD
GLOBAL ghWndOlly AS DWORD, gPID AS DWORD, ghProc AS DWORD, gModuleBase AS DWORD, gItemMain AS DWORD, gszExeFile AS DWORD '// Ollydbg.exe process information
GLOBAL hAddtolist AS DWORD, hPlugingetvalue AS DWORD, hInsertName AS DWORD, hProcEnd AS DWORD, hSetCPU AS DWORD, hFindModule AS DWORD, hReadCommand AS DWORD '// Exported Olly functions

SUB GetOllyInfo  '// Get info about the ollydbg.exe process
    CALL DWORD hPlugingetvalue USING Plugingetvalue(BYVAL %VAL_HWMAIN) TO ghWndOlly
    CALL DWORD hPlugingetvalue USING Plugingetvalue(BYVAL %VAL_PROCESSID) TO gPID
    CALL DWORD hPlugingetvalue USING Plugingetvalue(BYVAL %VAL_HPROCESS) TO ghProc
    CALL DWORD hPlugingetvalue USING Plugingetvalue(BYVAL %VAL_MAINBASE) TO gModuleBase
    CALL DWORD hPlugingetvalue USING Plugingetvalue(BYVAL %VAL_CPUDASM) TO gItemMain
    CALL DWORD hPlugingetvalue USING Plugingetvalue(BYVAL %VAL_EXEFILENAME) TO gszExefile
END SUB

SUB ODBG_GenericSub(szSubName AS ASCIIZ) '// Call any function exported by ollydbg.exe
LOCAL hProc AS LONG, hLib AS LONG
hLib = GetModuleHandle(BYVAL 0)
hProc = GetProcAddress(hLib, szSubName)
CALL DWORD hProc
END SUB

SUB AddComment(BYVAL dwAddr AS DWORD, szComment AS ASCIIZ) '// Add a comment to an address
    CALL DWORD hInsertName USING Insertname(BYVAL dwAddr, BYVAL %NM_COMMENT, szComment)
END SUB

SUB AddLabel(BYVAL dwAddr AS DWORD, szLabel AS ASCIIZ)     '// Define an address as a label
    CALL DWORD hInsertName USING Insertname(BYVAL dwAddr, BYVAL %NM_LABEL, szLabel)
END SUB

FUNCTION ODBG_Plugindata  ALIAS "ODBG_Plugindata" (shortname AS ASCIIZ * 32) EXPORT AS LONG
 shortname = "PowerBasic Plugin"
 FUNCTION = %PLUGIN_VERSION
END FUNCTION

FUNCTION ODBG_Plugininit (BYVAL ollydbgversion AS INTEGER, BYVAL hw AS LONG, features AS DWORD) EXPORT AS LONG
  CALL DWORD hAddtolist USING Addtolist(BYVAL 0, BYVAL 0, " ")
  CALL DWORD hAddtolist USING Addtolist(BYVAL 0, BYVAL 1, "PowerBasic Plugin skeleton for OllyDbg")   '1=red, 0=black, -1=gray
  CALL DWORD hAddtolist USING Addtolist(BYVAL 0, BYVAL -1, "by Wayne Diamond")
  CALL DWORD hAddtolist USING Addtolist(BYVAL 0, BYVAL 0, " ")
  FUNCTION = 0
END FUNCTION

FUNCTION ODBG_Pluginmenu (BYVAL origin AS DWORD, xdata AS ASCIIZ * 4096, BYVAL ITEM AS DWORD) EXPORT AS LONG
LOCAL pd AS t_dump
IF origin = %PM_MAIN THEN  '// Add to the Plugins menu
        xdata = "1&My 1st Menu Item,2&My 2nd Menu,|3&About"   '// use "|" as a bar seperator
        FUNCTION = 1:  EXIT FUNCTION
ELSEIF origin = %PM_DISASM THEN
        xData = "My Plugin{1&My right-click menu" '// Add to the right-click menu in the disassembly window pane
        FUNCTION = 1:  EXIT FUNCTION
END IF
END FUNCTION

SUB ODBG_Pluginaction (BYVAL origin AS LONG, BYVAL action AS LONG, BYVAL ITEM AS DWORD PTR) EXPORT
LOCAL lRet AS LONG
 IF origin = %PM_MAIN THEN
    SELECT CASE action
     CASE 1:
         MSGBOX "My 1st Menu Item pressed"
     CASE 2:
         MSGBOX "My 2nd Menu Item pressed"
     CASE 3:
         MSGBOX "Powerbasic Plugin skeleton for OllyDbg", %MB_ICONINFORMATION + %MB_OK, "About"
    END SELECT
 ELSEIF origin = %PM_DISASM THEN
     IF action = 1 THEN
         MSGBOX "My right-click menu pressed"
     END IF
 END IF
END SUB

FUNCTION ODBG_Pluginclose() EXPORT AS LONG
END FUNCTION

SUB ODBG_Pluginreset() EXPORT
END SUB

SUB ODBG_Plugindestroy() EXPORT
END SUB


FUNCTION LIBMAIN(BYVAL hInstance AS LONG, BYVAL fwdReason AS LONG, BYVAL lpvReserved AS LONG) EXPORT AS LONG
LOCAL hLib AS LONG
  IF fwdReason = %DLL_PROCESS_ATTACH THEN
      hInst = hInstance
      hLib = GetModuleHandle(BYVAL 0)
      hAddtolist = GetProcAddress(hLib, "_Addtolist")
      hPlugingetvalue = GetProcAddress(hLib, "_Plugingetvalue")
      hInsertName = GetProcAddress(hLib, "_Insertname")
      hProcEnd = GetProcAddress(hLib, "_Findprocend")
      hSetCPU = GetProcAddress(hLib, "_Setcpu")
      hFindModule = GetProcAddress(hLib, "_Findmodule")
      hReadCommand = GetProcAddress(hLib, "_Readcommand")
  END IF
  FUNCTION = 1
END FUNCTION
