#Compile Exe
#Dim All
#Include "WIN32API.INC"
'------------------------------------------------------------------------------------
Function MakeFont(ByVal fName As String, ByVal ptSize As Long, _
                  Opt ByVal attr As String) As Dword
   '--------------------------------------------------------------------
   ' Create a desired font and return its handle.
   ' attr = "biu" for bold, italic, and underlined (any order)
   '--------------------------------------------------------------------
   Local hDC As Dword, CharSet As Long, CyPixels As Long
   Local Bold, italic, uLine As Long
   If Len(attr) Then
      If InStr(LCase$(attr), "b") Then Bold = %FW_BOLD
      If InStr(LCase$(attr), "i") Then italic = 1
      If InStr(LCase$(attr), "u") Then uLine = 1
   End If
   hDC = GetDC(%HWND_DESKTOP)
   CyPixels  = GetDeviceCaps(hDC, %LOGPIXELSY)
   ReleaseDC %HWND_DESKTOP, hDC
   PtSize = 0 - (ptSize * CyPixels) \ 72
   Function = CreateFont(ptSize, 0, 0, 0, Bold, italic, uLine, _
             %FALSE, CharSet, %OUT_TT_PRECIS, _
             %CLIP_DEFAULT_PRECIS, %DEFAULT_QUALITY, _
             %FF_DONTCARE , ByCopy fName)
End Function

'-------------------------------------------------------------------------------
%idc_base_lab = 1004
%idc_ofs_lab  = 1005
%idc_cur_lab  = 1006
%idc_data_lab = 1001
%idc_prev_bn  = 1002
%idc_next_bn  = 1003
CallBack Function hexdumpCB As Long
    Local s As String
    Local Count, i, j As Long
    Static ppage, pbase, q As Byte Ptr
    Static startofchunk, maxlength As Long

    Select Case CbMsg
        Case %wm_initdialog
            Dialog Get User CbHndl, 0 To pbase
            ppage = pbase
            Dialog Get User CbHndl, 1 To maxlength
            GoSub displaye
        Case %wm_command
            Select Case CbCtl
                Case %idc_prev_bn  ' prev
                    ppage = ppage - 256
                    GoSub displaye
                Case 1003  ' next
                    ppage = ppage + 256
                    GoSub displaye
            End Select
    End Select
    Exit Function

displaye:
    s = String$(80 * 16, $Spc)
    For i = 0 To 15
        For j = 0 To 15
            'IF (i * 16) + j + startofchunk > maxlength THEN ITERATE
            q = ppage + (i*16) + j
            Mid$(s, (i * 80) + (j*3)+3, 2) = Hex$(@q,2)
            If InStr ( "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ!""$%^&*()_+{}[]:@~;'#,./<>?`",Chr$(@q)) <> 0 Then
                Mid$(s, (i * 80) + 52 + j, 1) = Chr$(@q)
            Else
                Mid$(s, (i * 80) + 52 + j, 1) = "."
            End If
        Next
        Mid$(s, ((i) * 80)+1, 1) = Hex$(i)
        Mid$(s, ((i+1) * 80) - 2, 2) = $CrLf
    Next
    s = "    0  1  2  3  4  5  6  7  8  9  A  B  C  D  E  F" + _
        $CrLf + String$(51,"-") + " " + String$(16,"-") + $CrLf + " " + s
    Control Set Text CbHndl, %idc_data_lab,  s
    If ppage <= pbase Then
        Control Disable CbHndl, %idc_prev_bn
    Else
        Control Enable CbHndl, %idc_prev_bn
    End If
    If ppage + 256 >= pbase + maxlength Then
        Control Disable CbHndl, 1003
    Else
        Control Enable CbHndl, 1003
    End If
    Control Set Text CbHndl, %idc_base_lab, "BASE ADDRESS: " + Hex$(pbase) + "(" + Str$(pbase) + ")"
    Control Set Text CbHndl, %idc_ofs_lab,  "MAX BYTES: " + Hex$(maxlength) + "(" + Str$(maxlength) + ")"
    Control Set Text CbHndl, %idc_cur_lab,  "PAGE OFFSET: " + Hex$(ppage - pbase) + "(" + Str$(ppage- pbase) + ")"
    Return

End Function
'-------------------------------------------------------------------------------
'display first 255 from a memory address as a block of hex digits with a character map on the right
' param 1 is byte ptr to memory to view,
' param 2 is max number of bytes to view
' return handle to dialog
Function hexdump ( ByVal pb As Byte Ptr, n As Long) As Dword
    Local hdlg As Dword
    Local hfont As Long

    Dialog New 0, "hex memory dump", 0, 0, 390, 230, %ws_popup Or %ws_border Or _
        %ws_dlgframe Or %ws_sysmenu Or %ws_clipsiblings Or %ws_visible Or %ds_modalframe Or %ds_3dlook Or %ds_nofailcreate Or _
        %ds_setfont, %ws_ex_controlparent Or %ws_ex_left Or %ws_ex_ltrreading Or %ws_ex_rightscrollbar, To hDlg
    Control Add Label, hdlg, %idc_data_lab, "",0, 20, 390, 180, %ws_child Or %ws_visible Or %ss_nowordwrap
    Control Add Label, hdlg, %idc_base_lab, "Base:",5,5, 130, 15, %ws_child Or %ws_visible Or %ss_nowordwrap
    Control Add Label, hdlg, %idc_ofs_lab, "Max Length:",145,5, 100,15, %ws_child Or %ws_visible Or %ss_nowordwrap
    Control Add Label, hdlg, %idc_cur_lab, "Curent ofs:",255,5, 100,15, %ws_child Or %ws_visible Or %ss_nowordwrap
    Control Add Button, hdlg, %idc_prev_bn, "<", 5, 210, 10, 15, _
            %ws_child Or %ws_visible Or %bs_pushbutton Or %bs_text Or %bs_center Or %bs_vcenter
    Control Add Button, hdlg, %idc_next_bn, ">", 25, 210, 10, 15, _
            %ws_child Or %ws_visible Or %bs_pushbutton Or %bs_text Or %bs_center Or %bs_vcenter
    Dialog Set User hdlg, 0, pb
    Dialog Set User hdlg, 1, n
    hfont = makefont ( "Courier New", 10)
    Control Send hDlg, 1001, %WM_SETFONT, hFont, 0
    Dialog Show Modal hdlg Call hexdumpCB
    DeleteObject hFont
End Function

'---------------------------------------------------------------
Function PBMain()
    Local s As String
    Local i As Long

    s = String$(1024,$Spc)
    For i = 1 To 1024
        Mid$(s,i,1) = Chr$(Rnd(0,255))
    Next
    hexdump( ByVal StrPtr(s), Len(s))
End Function
