#Dim All
#Register All
#Compile Exe
#Tools Off
%usemacros = 1
#Include "win32api.inc"
#Include "commctrl.inc"
#Include "comdlg32.inc"
$apptitle               = "MP3 Player"
$appinfo                = "a small mp3 player using the windows mci"
$appversion             = "1.20"
%idc_play               = 100
%idc_pause              = 101
%idc_stop               = 102
%idc_forward            = 103
%idc_backward           = 104
%idc_position           = 105
%idc_pitch              = 106
%idc_volume             = 107
%idc_timer              = 108
%idc_file               = 109
%idc_status             = 110
%idc_about              = 111
Macro player_textcolor  = getsyscolor(%color_captiontext)
Macro player_backcolor  = getsyscolor(%color_activecaption)
Global gzfile   As Asciiz * %max_path         ' path of current media file
Global giplay   As Long                       ' nonzero if file is playing/paused
Global gipause  As Long                       ' nonzero if file is paused


'------------------------------------------------------------------------------
' small macro for redrawing just the progress bar text
'------------------------------------------------------------------------------
Macro ctlvol_updatetext(hwnd)
  MacroTemp rc
  Local rc As rect
  getclientrect hwnd, rc
  rc.nleft = (rc.nright/2) - 50
  rc.nright = (rc.nleft + 100)
  rc.ntop = (rc.nbottom / 2) - 6
  rc.nbottom = (rc.ntop + 12)
  redrawwindow hwnd, rc, %false, %rdw_updatenow Or %rdw_invalidate Or %rdw_erase Or %rdw_updatenow
End Macro

'------------------------------------------------------------------------------
' subclass function for the control. uses the control class' userdata area.
'------------------------------------------------------------------------------
Function ctlvolctl(ByVal hwnd As Dword, ByVal wmsg As Dword, ByVal wparam As Dword, ByVal lparam As Long) As Long
  Local icurpos As Long, hdc As Dword, pt As pointapi, rc As rect, hfont As Dword
  Local ztext As Asciiz * 500, lr As Long, tr As Long, wmsgtype As Dword

  Select Case wmsg

         Case %wm_keydown
              ' trap control keys
              icurpos = sendmessage(hwnd, %pbm_getpos, 0, 0)
              lr = sendmessage(hwnd, %pbm_getrange, 1, 0)
              tr = sendmessage(hwnd, %pbm_getrange, 0, 0)
              ' track keys according to horizontal/vertical mode...
              If (getwindowlong(hwnd, %gwl_style) And %pbs_vertical) Then
                 Select Case wparam
                        Case %vk_up:     Incr icurpos
                        Case %vk_down:   Decr icurpos
                        Case %vk_home:   icurpos = tr
                        Case %vk_end:    icurpos = lr
                        Case %vk_pgdn:   icurpos = icurpos - 10
                        Case %vk_pgup:   icurpos = icurpos + 10
                        Case Else:       Exit Function
                 End Select
              Else
                 Select Case wparam
                        Case %vk_left:   Decr icurpos
                        Case %vk_right:  Incr icurpos
                        Case %vk_home:   icurpos = lr
                        Case %vk_end:    icurpos = tr
                        Case %vk_pgdn:   icurpos = icurpos + 10
                        Case %vk_pgup:   icurpos = icurpos - 10
                        Case Else:       Exit Function
                 End Select
              End If
              If (icurpos > tr) Then icurpos = tr Else If icurpos < lr Then icurpos = lr

              ' set new trackbar position...
              If (sendmessage(hwnd, %pbm_getpos, 0, 0) <> icurpos) Then sendmessage hwnd, %pbm_setpos, icurpos, 0
              Exit Function

         Case %wm_getdlgcode
              Function = %dlgc_wantarrows
              Exit Function

         Case %wm_lbuttondown, %wm_rbuttondown
              setfocus hwnd
              setcapture hwnd
              GoTo ctlvolsetvol:

         Case %wm_mousemove
              ' traps mouse movement
              If (getcapture = hwnd) Then
                 ctlvolsetvol:
                 lr = sendmessage(hwnd, %pbm_getrange, 1, 0)
                 tr = sendmessage(hwnd, %pbm_getrange, 0, 0)
                 getwindowrect hwnd, rc
                 getcursorpos pt
                 screentoclient hwnd, pt
                 ' change position according to horizontal/vertical mode...
                 If (getwindowlong(hwnd, %gwl_style) And %pbs_vertical) Then
                    icurpos = (pt.y / ((rc.nbottom-rc.ntop) / (tr - (lr-1))))'+1
                    icurpos = tr-icurpos
                 Else
                    icurpos = (pt.x / ((rc.nright-rc.nleft) / (tr - (lr-1))))'+1
                 End If
                 If (icurpos > tr) Then icurpos = tr Else If icurpos < lr Then icurpos = lr
                 ' set new trackbar position...
                 If (sendmessage(hwnd, %pbm_getpos, 0, 0) <> icurpos) Then sendmessage hwnd, %pbm_setpos, icurpos, 0
              End If

         Case %wm_lbuttonup, %wm_rbuttonup
              releasecapture

         Case %wm_setfocus, %wm_killfocus
              sendmessage hwnd, %pbm_setbkcolor, 0, IIf&(getfocus = hwnd, %black, %gray)
              redrawwindow hwnd, ByVal %null, 0, %rdw_erase Or %rdw_invalidate Or %rdw_updatenow
              Exit Function

         Case %wm_paint
              callwindowproc getwindowlong(hwnd, %gwl_userdata), hwnd, wmsg, wparam, lparam
              hdc = getdc(hwnd)
              getclientrect hwnd, rc
              setbkmode hdc, %transparent
              hfont = sendmessage(hwnd, %wm_getfont, 0, 0)
              If hfont = 0 Then hfont = getstockobject(%ansi_var_font)
              hfont = selectobject(hdc, hfont)
              settextcolor hdc, %white
              sendmessage hwnd, %wm_gettext, SizeOf(ztext), VarPtr(ztext)
              drawtext hdc, ztext, Len(ztext), rc, %dt_center Or %dt_vcenter Or %dt_singleline Or %dt_noprefix
              selectobject hdc, hfont
              releasedc hwnd, hdc
              Exit Function

         Case %pbm_setpos
              ' send notification message to parent (wm_hscroll or ws_vscroll)
              callwindowproc getwindowlong(hwnd, %gwl_userdata), hwnd, wmsg, wparam, lparam
              If (lparam = 0) Then
                 If (getwindowlong(hwnd, %gwl_style) And %pbs_vertical) Then wmsgtype = %wm_vscroll Else wmsgtype = %wm_hscroll
                 sendmessage getparent(hwnd), wmsgtype, MakDwd(wparam, 0), hwnd
              End If
              Exit Function

         Case %wm_destroy
              ' restore window procedure...
              callwindowproc getwindowlong(hwnd, %gwl_userdata), hwnd, wmsg, wparam, lparam
              setwindowlong hwnd, %gwl_wndproc, getwindowlong(hwnd, %gwl_userdata)
              Exit Function

  End Select

  Function = callwindowproc(getwindowlong(hwnd, %gwl_userdata), hwnd, wmsg, wparam, lparam)
End Function


'------------------------------------------------------------------------------
' main dialog callback
'------------------------------------------------------------------------------
CallBack Function dlgmain
  Local i As Long, ztext As Asciiz * 300, ztemp As Asciiz * 300, sfile As String

  Select Case CbMsg

         Case %wm_initdialog
              ' set timer and send an update for dialog shown...
              settimer CbHndl, %idc_timer, 100, %null
              sendmessage CbHndl, %wm_timer, 0, 0

         Case %wm_command
              Select Case CbCtl

                     Case %idc_play
                          Dialog DoEvents
                          If (gzfile <> "") And (giplay = %false) Then
                             ' load file...
                             mcisendstring "open " + $Dq + gzfile + $Dq, "", 0, 0
                             mcisendstring "set " + $Dq + gzfile + $Dq + " time format milliseconds", "", 0, 0
                             mcisendstring "status " + $Dq + gzfile + $Dq + " length", ztemp, SizeOf(ztemp), 0
                             Control Send CbHndl, %idc_position, %pbm_setrange32, 0, Val(ztemp)/10000
                             ' set speed and volume...
                             Control Send CbHndl, %idc_pitch, %pbm_getpos, 0, 0 To i
                             mcisendstring "set " + $Dq + gzfile + $Dq + " speed " + Format$(850+i), "", 0, 0
                             Control Send CbHndl, %idc_volume, %pbm_getpos, 0, 0 To i
                             mcisendstring "setaudio " + $Dq + gzfile + $Dq + " volume to " + Format$(i*10), "", 0, 0
                             ' play the file...
                             mcisendstring "play " + $Dq + gzfile + $Dq, "", 0, 0
                             gipause = %false: giplay = %true
                          ElseIf (giplay = %true) Then
                             gipause = %false
                             mcisendstring "play " + $Dq + gzfile + $Dq, "", 0, 0
                          ElseIf (gzfile = "") Then
                             Control Send CbHndl, %idc_file, %bm_click, 0, 0
                          End If

                     Case %idc_pause
                          Dialog DoEvents
                          If giplay Then
                             If gipause Then gipause = %false Else gipause = %true
                             mcisendstring IIf$(gipause, "pause ", "play ") + $Dq + gzfile + $Dq, "", 0, 0
                          End If

                     Case %idc_stop
                          If giplay Then
                             Dialog DoEvents
                             giplay = %false
                             gipause = %false
                             mcisendstring "stop " + $Dq + gzfile + $Dq, "", 0, 0
                             mcisendstring "close " + $Dq + gzfile + $Dq, "", 0, 0
                          End If

                     Case %idc_forward, %idc_backward
                          Dialog DoEvents
                          If giplay Then
                             mcisendstring "status " + $Dq + gzfile + $Dq + " position", ztemp, SizeOf(ztemp), 0
                             i = Val(ztemp)
                             ' seek back/forth 3 seconds...
                             If (CbCtl = %idc_forward) Then i = i + 3000 Else i = i - 3000
                             mcisendstring "seek " + $Dq + gzfile + $Dq + " to " + Format$(i), "", 0, 0
                             mcisendstring "play " + $Dq + gzfile + $Dq, "", 0, 0
                          End If

                     Case %idc_file
                          ' select a media file...
                          Dialog DoEvents
                          sfile = gzfile

                          If openfiledialog(CbHndl, "open", sfile, CurDir$, _
                          "music files (*.mp3; *.wav)|*.mp3;*.wav|all files (*.*)|*.*", _
                          "mp3", %ofn_filemustexist Or %ofn_hidereadonly) Then

                             If giplay Then
                                giplay = %false
                                gipause = %false
                                mcisendstring "stop " + $Dq + gzfile + $Dq, "", 0, 0
                                mcisendstring "close " + $Dq + gzfile + $Dq, "", 0, 0
                             End If
                             gzfile = sfile
                             Control Send CbHndl, %idc_play, %bm_click, 0, 0
                          End If

                     Case %idc_about


                     Case %idcancel
                          Dialog End CbHndl

              End Select

         Case %wm_timer
              ' get just the file name (no extension)...
              If Len(gzfile) Then
                 ztext = Mid$(gzfile, InStr(-1, gzfile, Any "\/")+1)
                 ztext = Left$(ztext, Len(ztext)-4)
              Else
                 ztext = "no media selected. press play to select..."
              End If

              ' don't redraw if text is the same...
              Control Get Text CbHndl, %idc_status To ztemp
              If ztext <> ztemp Then Control Set Text CbHndl, %idc_status, ztext

              If giplay Then
                 If gipause Then
                    ztext = "[paused]"
                 Else
                    mcisendstring "status " + $Dq + gzfile + $Dq + " length", ztext, SizeOf(ztext), 0
                    mcisendstring "status " + $Dq + gzfile + $Dq + " position", ztemp, SizeOf(ztemp), 0
                    Control Send CbHndl, %idc_position, %pbm_setpos, Val(ztemp)\10000, %true
                    ztemp = Format$((Val(ztemp)\1000) \ 60, "00") + ":" + Right$(Trim$(Str$(100 + ((Val(ztemp)\1000) Mod 60))),2)
                    ztext = Format$((Val(ztext)\1000) \ 60, "00") + ":" + Right$(Trim$(Str$(100 + ((Val(ztext)\1000) Mod 60))),2)
                    ztext = ztemp + "/" + ztext
                 End If
              Else
                 ztext = "[stopped]"
              End If

              Control Get Text CbHndl, %idc_position To ztemp
              If (ztext <> ztemp) Then
                 Control Set Text CbHndl, %idc_position, ztext
                 ctlvol_updatetext(getdlgitem(CbHndl, %idc_position))
              End If

         Case %wm_hscroll
              Select Case getdlgctrlid(CbLParam)

                     Case %idc_position
                          mcisendstring "seek " + $Dq + gzfile + $Dq + " to " + Format$(LoWrd(CbWParam)*10000), "", 0, 0
                          mcisendstring "play " + $Dq + gzfile + $Dq, "", 0, 0

                     Case %idc_pitch
                          If giplay Then mcisendstring "set " + $Dq + gzfile + $Dq + " speed " + Format$(850 + LoWrd(CbWParam)), "", 0, 0

                     Case %idc_volume
                          If giplay Then
                             mcisendstring "setaudio " + $Dq + gzfile + $Dq + " volume to " + Format$(LoWrd(CbWParam)*10), "", 0, 0
                             Control Set Text CbHndl, %idc_volume, "vol " + Format$(LoWrd(CbWParam)) + "%"
                             ctlvol_updatetext(getdlgitem(CbHndl, %idc_volume))
                          End If

              End Select

         Case %wm_destroy
              killtimer CbHndl, %idc_timer

  End Select

End Function


'------------------------------------------------------------------------------
' program start point
'------------------------------------------------------------------------------
Function PBMain
  Local hdlg As Dword, hfont As Dword

  initcommoncontrols

  ' create player interface...
  Dialog New 0, "simplemp3",,, 300, 72, %ws_dlgframe Or %ws_sysmenu Or %ws_caption Or %ws_minimizebox To hdlg
  Dialog Send hdlg, %wm_seticon, %icon_small, loadicon(%null, ByVal %idi_exclamation)
  Dialog Set Color hdlg, -1, player_backcolor

  Control Add $progress_class, hdlg, %idc_position, "", 10, 10, 280, 15, %ws_visible Or %ws_child Or %ws_tabstop Or %pbs_smooth
  setwindowlong getdlgitem(hdlg, %idc_position), %gwl_userdata, setwindowlong(getdlgitem(hdlg, %idc_position), %gwl_wndproc, CodePtr(ctlvolctl))
  Control Send hdlg, %idc_position, %pbm_setbarcolor, 0, %green
  Control Send hdlg, %idc_position, %pbm_setbkcolor, 0, %gray
  Control Send hdlg, %idc_position, %wm_setfont, getstockobject(%ansi_fixed_font), 0

  Control Add Label, hdlg, %idc_status, "choose a file to play...", 10, 30, 150, 20, %ws_child Or %ws_visible Or %ss_noprefix
  Control Set Color hdlg, %idc_status, player_textcolor, player_backcolor

  Control Add $progress_class, hdlg, %idc_pitch, "pitch", 165, 30, 60, 12, %ws_visible Or %ws_child Or %ws_tabstop Or %pbs_smooth
  setwindowlong getdlgitem(hdlg, %idc_pitch), %gwl_userdata, setwindowlong(getdlgitem(hdlg, %idc_pitch), %gwl_wndproc, CodePtr(ctlvolctl))
  Control Send hdlg, %idc_pitch, %pbm_setrange32, 0, 300
  Control Send hdlg, %idc_pitch, %pbm_setpos, 150, %true
  Control Send hdlg, %idc_pitch, %pbm_setbarcolor, 0, %ltgray
  Control Send hdlg, %idc_pitch, %pbm_setbkcolor, 0, %gray

  Control Add $progress_class, hdlg, %idc_volume, "vol 50%", 230, 30, 60, 12, %ws_visible Or %ws_child Or %ws_tabstop Or %pbs_smooth
  setwindowlong getdlgitem(hdlg, %idc_volume), %gwl_userdata, setwindowlong(getdlgitem(hdlg, %idc_volume), %gwl_wndproc, CodePtr(ctlvolctl))
  Control Send hdlg, %idc_volume, %pbm_setrange, 0, MakLng(0, 100)
  Control Send hdlg, %idc_volume, %pbm_setpos, 50, %true
  Control Send hdlg, %idc_volume, %pbm_setbarcolor, 0, %ltgray
  Control Send hdlg, %idc_volume, %pbm_setbkcolor, 0, %gray

  Control Add Button, hdlg, %idc_backward,    "7", 10, 50, 20, 15
  Control Add Button, hdlg, %idc_play,        "4", 30, 50, 20, 15
  Control Add Button, hdlg, %idc_pause,       ";", 50, 50, 20, 15
  Control Add Button, hdlg, %idc_stop,        "<", 70, 50, 20, 15
  Control Add Button, hdlg, %idc_forward,     "8", 90, 50, 20, 15
  Control Add Button, hdlg, %idc_file,        "n", 115, 50, 20, 15

  Control Add Button, hdlg, %idc_about,       "i", 230, 50, 20, 15
  Control Add Button, hdlg, %idcancel,        "~", 250, 50, 40, 15

  ' create display font
  hfont = createfont(-16,0,0,0,0,0,0,0,%symbol_charset,0,0,0,0,"webdings")
  Control Send hdlg, %idc_backward, %wm_setfont, hfont, 0
  Control Send hdlg, %idc_play,     %wm_setfont, hfont, 0
  Control Send hdlg, %idc_pause,    %wm_setfont, hfont, 0
  Control Send hdlg, %idc_stop,     %wm_setfont, hfont, 0
  Control Send hdlg, %idc_forward,  %wm_setfont, hfont, 0
  Control Send hdlg, %idc_file,     %wm_setfont, hfont, 0
  Control Send hdlg, %idc_about,    %wm_setfont, hfont, 0
  Control Send hdlg, %idcancel,     %wm_setfont, hfont, 0

  Dialog Show Modal hdlg Call dlgmain

  ' tidy up...
  If giplay Then
     mcisendstring "stop " + $Dq + gzfile + $Dq, "", 0, 0
     mcisendstring "close " + $Dq + gzfile + $Dq, "", 0, 0
  End If

  deleteobject hfont

End Function
