#Compile Exe

#Include "win32api.inc"
#Include "ComDlg32.Inc"

#Include "gdiplus.inc"

Global hinstance&

Declare Function wndproc(ByVal Long,ByVal Long,ByVal Long,ByVal Long) As Long

Declare Function getpicfilename(ByVal Long) As String
Declare Function savepicfilename(ByVal Long,ByVal String) As String

Function WinMain(ByVal hinst&,ByVal hprev&, _
                 ByVal szcmdline As Asciiz Ptr,ByVal cmdshow&) As Long

     hinstance&=hinst&

     Dim wmsg As tagmsg
     Dim wclass As wndclassex
     Dim wndrect As rect
     Dim szclassname As Asciiz*32
     Dim sztitle As Asciiz*256

     szclassname="TestPicViewer"

     wclass.cbsize=SizeOf(wclass)
     wclass.style=%cs_hredraw Or %cs_vredraw
     wclass.lpfnwndproc=CodePtr(wndproc)
     wclass.cbclsextra=0
     wclass.cbwndextra=0
     wclass.hinstance=hinstance&
     wclass.hicon=%null
     wclass.hcursor=loadcursor(%null,ByVal %idc_arrow)
     wclass.hbrbackground=getstockobject(%gray_brush)
     wclass.lpszmenuname=%null
     wclass.lpszclassname=VarPtr(szclassname)
     wclass.hiconsm=%null

     registerclassex wclass

     sztitle="Test Picture Viewer"

     systemparametersinfo %spi_getworkarea,0,wndrect,0

     xs&=wndrect.nleft
     ys&=wndrect.ntop
     xl&=(wndrect.nright-xs&)+1
     yl&=(wndrect.nbottom-ys&)+1

     style&=%ws_overlappedwindow Or %ws_clipchildren Or %ws_hscroll _
            Or %ws_vscroll

     hwnd&=createwindowex(0, _            ''advanced style
                          szclassname, _  ''window class name
                          sztitle, _      ''window title
                          style&, _       ''window style
                          xs&, _          ''initial x position
                          ys&, _          ''initial y position
                          xl&, _          ''initial x size
                          yl&, _          ''initial y size
                          %null, _        ''parent window handle
                          %null, _        ''window menu handle
                          hinstance&, _   ''program instance handle
                          ByVal %null)    ''creation parameters

     showwindow hwnd&,cmdshow&
     updatewindow hwnd&

     While getmessage(wmsg, %null, 0, 0)
       translatemessage wmsg
       dispatchmessage wmsg
     Wend

     Function=wmsg.wparam
End Function

Function wndproc(ByVal hwnd&,ByVal msg&,ByVal wparam&,ByVal lparam&) As Long

     Static hgdiplus&
     Static nohscroll&,novscroll&
     Static img&,imgwidth&,imgheight&
     Static xpos&,ypos&
     Static mult!,oldmult!

     Static imgname$

     Static six As scrollinfo
     Static siy As scrollinfo

     Dim ps As paintstruct
     Dim rc As rect
     Dim gpinput As gdiplusstartupinput

     Select Case Long msg&
       Case %wm_create

         ''create main menu

         hmainmenu&=createmenu

         hmenu&=createpopupmenu
         appendmenu hmenu&,%mf_string,201,"Open Picture File"
         appendmenu hmenu&,%mf_string,202,"Save As..."
         appendmenu hmenu&,%mf_separator,0,""
         appendmenu hmenu&,%mf_string,210,"Exit"

         appendmenu hmainmenu&,%mf_popup,hmenu&,"File"

         hmenu&=createpopupmenu

         hsubmenu&=createpopupmenu
         appendmenu hsubmenu&,%mf_string,301,"x .25"
         appendmenu hsubmenu&,%mf_string,302,"x .5"
         appendmenu hsubmenu&,%mf_string,303,"x .75"
         appendmenu hsubmenu&,%mf_string,304,"x 1 (Original)"
         appendmenu hsubmenu&,%mf_string,305,"x 1.25"
         appendmenu hsubmenu&,%mf_string,306,"x 1.5"
         appendmenu hsubmenu&,%mf_string,307,"x 1.75"
         appendmenu hsubmenu&,%mf_string,308,"x 2"
         appendmenu hsubmenu&,%mf_string,309,"x 2.25"
         appendmenu hsubmenu&,%mf_string,310,"x 2.5"
         appendmenu hsubmenu&,%mf_string,311,"x 2.75"
         appendmenu hsubmenu&,%mf_string,312,"x 3"

         appendmenu hmenu&,%mf_popup,hsubmenu&,"Resize"

         appendmenu hmainmenu&,%mf_popup,hmenu&,"View"

         setmenu hwnd&,hmainmenu&

         drawmenubar hwnd&

         ''create scrollbars

         six.cbsize=SizeOf(six)
         six.fmask=%sif_all Or %sif_disablenoscroll
         six.nmin=1
         six.nmax=1
         six.npage=1
         six.npos=1
         setscrollinfo hwnd&,%sb_horz,six,%true

         siy.cbsize=SizeOf(siy)
         siy.fmask=%sif_all Or %sif_disablenoscroll
         siy.nmin=1
         siy.nmax=1
         siy.npage=1
         siy.npos=1
         setscrollinfo hwnd&,%sb_vert,siy,%true

         nohscroll&=1
         novscroll&=1

         mult!=1
         oldmult!=0

         invalidaterect hwnd&,ByVal %null,%false
         showwindow hwnd&,%sw_show

       Case %wm_paint
         hdc&=beginpaint(hwnd&,ps)

         getclientrect hwnd&,rc

         xl&=imgwidth&*mult!
         yl&=imgheight&*mult!

         quality&=100

         ''test for scrollbars

         oldnohscroll&=nohscroll&
         oldnovscroll&=novscroll&

         xsize&=(rc.nright-rc.nleft)+1
         ysize&=(rc.nbottom-rc.ntop)+1

         If mult!<>oldmult! Then

           If xl&>xsize& Then  ''need horz scroll
             nohscroll&=0
             six.nmax=(xl&-xsize&)
             six.npage=1
           Else
             nohscroll&=1
             six.nmax=1
             six.npage=1
           End If

           six.cbsize=SizeOf(six)
           six.fmask=%sif_all Or %sif_disablenoscroll
           six.nmin=1
           six.npos=1
           setscrollinfo hwnd&,%sb_horz,six,%true

           If yl&>ysize& Then  ''need vert scroll
             novscroll&=0
             siy.nmax=(yl&-ysize&)
             siy.npage=1
           Else
             novscroll&=1
             siy.nmax=1
             siy.npage=1
           End If

           siy.cbsize=SizeOf(siy)
           siy.fmask=%sif_all Or %sif_disablenoscroll
           siy.nmin=1
           siy.npos=1
           setscrollinfo hwnd&,%sb_vert,siy,%true
         End If

         If (novscroll&=1 And nohscroll&=1 And mult!=oldmult!) _
         Or mult!<>oldmult! _
         Or (novscroll&<>oldnovscroll&) _
         Or (nohscroll&<>oldnohscroll&) Then
           fillrect hdc&,rc,getstockobject(%gray_brush)
         End If

         oldmult!=mult!

         If img&=0 Then
           endpaint hwnd&,ps
           Function=0
           Exit Function
         End If

         ''initialize graphics class
         If gdipcreatefromhdc(hdc&,graphics&) Then
           ''error
           endpaint hwnd&,ps
           Function=0
           Exit Function
         End If

         Call gdipsetinterpolationmode(graphics&,quality&)
         Call gdipdrawimagerecti(graphics&,img&,xpos&,ypos&,xl&,yl&)
         Call gdipdeletegraphics(graphics&)

         endpaint hwnd&,ps
         Function=0
         Exit Function
       Case %wm_vscroll
         getscrollinfo hwnd&,%sb_vert,siy

         oldsiynpos&=siy.npos

         Select Case LoWrd(wparam&)
           Case %sb_top
             siy.npos=siy.nmin
           Case %sb_bottom
             siy.npos=siy.nmax
           Case %sb_linedown
             siy.npos=siy.npos+1
             If siy.npos>siy.nmax Then siy.npos=siy.nmax
           Case %sb_lineup
             siy.npos=siy.npos-1
             If siy.npos<siy.nmin Then siy.npos=siy.nmin
           Case %sb_thumbtrack
             siy.npos=siy.ntrackpos
           Case %sb_thumbposition
             siy.npos=siy.ntrackpos
           Case %sb_endscroll
             siy.npos=siy.ntrackpos
           Case Else
             Exit Function
         End Select

         ypos&=-(siy.npos)

         If siy.npos<>oldsiynpos& Then
           setscrollinfo hwnd&,%sb_vert,siy,%true
           invalidaterect hwnd&,ByVal %null,%false
           showwindow hwnd&,%sw_show
         End If

         Exit Function
       Case %wm_hscroll
         getscrollinfo hwnd&,%sb_horz,six

         oldsixnpos&=six.npos

         Select Case LoWrd(wparam&)
           Case %sb_left,%sb_lineleft
             six.npos=six.npos-1
             If six.npos<six.nmin Then six.npos=six.nmin
           Case %sb_right,%sb_lineright
             six.npos=six.npos+1
             If six.npos>six.nmax Then six.npos=six.nmax
           Case %sb_thumbposition
             six.npos=six.ntrackpos
           Case %sb_endscroll
             six.npos=six.ntrackpos
           Case %sb_thumbtrack
             six.npos=six.ntrackpos
           Case Else
             Exit Function
         End Select

         xpos&=-(six.npos)

         If six.npos<>oldsixnpos& Then
           setscrollinfo hwnd&,%sb_horz,six,%true
           invalidaterect hwnd&,ByVal %null,%false
           showwindow hwnd&,%sw_show
         End If

         Exit Function
       Case %wm_syscommand
          If (wparam& And &hfff0)<>%sc_close Then Exit Select
         destroywindow hwnd&
         Function=1
         Exit Function
       Case %wm_command

         Select Case LoWrd(wparam&)
           Case 201  ''open
             b$=getpicfilename(hwnd&)
             If b$="" Then Exit Function

             imgname$=LCase$(b$)

             mult!=1
             oldmult!=0
             xpos&=0
             ypos&=0

             lnf&=Len(imgname$)
             i&=InStr(-1,imgname$,".")

             If i&>0 Then
               If Dir$(imgname$)="" Then i&=0
             End If

             If i&<=0 Then Exit Select

             extns$=".dib.emf.gif.jpg.jpeg.png.tif.tiff.wmf.bmp."

             imgtype$="."+Mid$(imgname$,(i&+1),(lnf&-i&))+"."
             imagetype&=InStr(extns$,imgtype$)

             If imagetype&=0 Then
               txt$="GDI+ is unable to read "+imgtype$+" files."
               title$="File Format"
               MsgBox txt$,%mb_ok,title$
               Exit Select
             End If

             gpinput.gdiplusversion=1
             gdiplusstartup hgdiplus&,gpinput,ByVal %null

             img&=0
             imgwidth&=0
             imgheight&=0

             If gdiploadimagefromfile(UCode$(imgname$),img&)=0 Then
               Call gdipgetimagewidth(img&,imgwidth&)
               Call gdipgetimageheight(img&,imgheight&)
             End If

             If imgwidth&=0 Or imgheight&=0 Then img&=0

             If img&=0 Then Exit Select

             invalidaterect hwnd&,ByVal 0,1
             updatewindow hwnd&
           Case 202  ''save as...
             defnamefile$=imgname$
             b$=savepicfilename(hwnd&,defnamefile$)
             If b$="" Then Exit Select

             imgname$=LCase$(b$)

             i&=InStr(-1,imgname$,".")

             If i&<=0 Then
               txt$="No format extension was given!"
               title$="Error"
               MsgBox txt$,%mb_ok,title$
               Exit Select
             End If

             lnf&=Len(imgname$)

             extns$=".bmp.jpg.jpeg.gif.tif.tiff."

             imgtype$="."+Mid$(imgname$,(i&+1),(lnf&-i&))+"."
             imagetype&=InStr(extns$,imgtype$)

             imgtype$=LTrim$(RTrim$(imgtype$,"."),".")

             If imagetype&=0 Then
               txt$="GDI+ is unable to save "+imgtype$+" files."
               title$="File Format"
               MsgBox txt$,%mb_ok,title$
               Exit Select
             End If

             Select Case imgtype$
               Case "jpg"
                 imgtype$="jpeg"
               Case "tif"
                 imgtype$="tiff"
             End Select

             frmt$="image/"+imgtype$

             saveimagetofile img&,imgname$,frmt$

             ''''to convert to different image type:
             ''convertimage fl1$,fl2$,frmt$

           Case 210  ''exit
             postmessage hwnd&,%wm_syscommand,%sc_close,0
           Case 301 To 312  ''resize
             lwa&=LoWrd(wparam&)-300
             mult!=lwa&*(.25)
             xpos&=0
             ypos&=0
             invalidaterect hwnd&,ByVal 0,1
             updatewindow hwnd&
         End Select

       Case %wm_destroy
         If img& Then Call gdipdisposeimage(img&)
         img&=0

         If hgdiplus& Then
           Call gdiplusshutdown(hgdiplus&)
           hgdiplus&=0
         End If

         postquitmessage 0
         Function=0
         Exit Function
     End Select

     Function=defwindowproc(hwnd&,msg&,wparam&,lparam&)
End Function

Function getpicfilename(ByVal hwnd&) As String

     Dim szcurdir1 As Asciiz*%max_path
     Dim szcurdir2 As Asciiz*%max_path
     Dim szfilename As Asciiz*%max_path
     Dim sztitle As Asciiz*%max_path

     Dim ofn As openfilename

     ofn.lstructsize=SizeOf(ofn)
     ofn.hwndowner=hwnd&
     ofn.hinstance=hinstance&

     filter$="Graphic files (*.bmp,*.jpg,*.jpeg,*.gif,*.tif,*.tiff)" _
            +Chr$(0)+"*.bmp;*.jpg;*.jpeg;*.gif;*.tif;*.tiff"+Chr$(0)

     sztitle="Open A Graphic File"

     ofn.lpstrfilter=StrPtr(filter$)
     ofn.lpstrfiletitle=VarPtr(szfilename)
     ofn.nmaxfiletitle=SizeOf(szfilename)
     ofn.lpstrtitle=VarPtr(sztitle)
     ofn.flags=%ofn_pathmustexist

     getcurrentdirectory SizeOf(szcurdir1),szcurdir1
     getopenfilename ofn
     getcurrentdirectory SizeOf(szcurdir2),szcurdir2

     If Right$(szcurdir2,1)<>"\" Then szcurdir2=szcurdir2+"\"

     If szfilename="" Then
       Function=""
     Else
       Function=szcurdir2+szfilename
     End If

     setcurrentdirectory szcurdir1
End Function

Function savepicfilename(ByVal hwnd&,ByVal defnamefile$) As String

     Dim szcurdir As Asciiz*%max_path
     Dim szfilename As Asciiz*%max_path
     Dim sztitle As Asciiz*%max_path

     Dim ofn As openfilename

     filter$="Graphic files (*.bmp,*.jpg,*.jpeg,*.gif,*.tif,*.tiff)" _
             +Chr$(0)+"*.bmp;*.jpg;*.jpeg;*.gif;*.tif;*.tiff"+Chr$(0)

     sztitle="Save Graphic File"
     szfilename=defnamefile$

     getcurrentdirectory SizeOf(szcurdir),szcurdir

     ofn.lstructsize=SizeOf(ofn)
     ofn.hwndowner=hwnd&
     ofn.hinstance=hinstance&
     ofn.lpstrfilter=StrPtr(filter$)
     ofn.lpstrfiletitle=VarPtr(szfilename)
     ofn.nmaxfiletitle=SizeOf(szfilename)
     ofn.lpstrtitle=VarPtr(sztitle)
     ofn.lpstrfile=VarPtr(szfilename)
     ofn.flags=%ofn_overwriteprompt
     ofn.lpstrcustomfilter=0&
     ofn.nmaxcustfilter=0
     ofn.nfilterindex=1
     ofn.nmaxfile=%max_path
     ofn.lpstrinitialdir=VarPtr(szcurdir)
     ofn.nfileoffset=0
     ofn.nfileextension=0&
     ofn.lcustdata=0&
     ofn.lpfnhook=0&
     ofn.lptemplatename=0&
     ofn.lpstrdefext=%null

     getsavefilename ofn

     If szfilename="" Then
       Function=""
     Else
       Function=szfilename
     End If

End Function
