''gdiplus.dll declares and functions:

%qualitymodehigh=2  ''best rendering quality
%unitpixel=2        ''each unit is one device pixel.

Type gdiplusstartupinput
  gdiplusversion As Dword           ''must be 1
  debugeventcallback As Dword       ''ignored on free builds
  suppressbackgroundthread As Long  ''FALSE unless you're prepared to call hook/unhook functions
  suppressexternalcodecs As Long    ''FALSE unless you want GDI+ only to use its internal image codecs
End Type

Type gdiplusstartupoutput
  notificationhook As Dword
  notificationunhook As Dword
End Type

Type imagecodecinfo
  classid As Guid             ''clsid codec identifier
  formatid As Guid            ''guid file format identifier
  codecname As Dword          ''pointer to asciiz string with codec name
  dllname As Dword            ''pointer to asciiz string with pathname of the dll where codec resides, or %null
  formatdescription As Dword  ''pointer to asciiz string with name of the format used by codec
  filenameextension As Dword  ''pointer to asciiz string with all filename extensions associated with the codec, separated with semicolons
  mimetype As Dword           ''pointer to asciiz string with mime type of codec
  flags As Dword              ''combination of flags from imagecodecflags
  version As Dword            ''integer with version of the codec
  sigcount As Dword           ''integer with no. of signatures used by file format associated with the codec
  sigsize As Dword            ''integer with no. of bytes of each signature
  sigpattern As Dword         ''pointer to array of bytes with the pattern for each signature
  sigmask As Dword            ''pointer to array of bytes with the mask for each signature
End Type

Declare Function gdiplusstartup Lib "gdiplus.dll" _
                 Alias "GdiplusStartup" _
                 (Dword,gdiplusstartupinput,gdiplusstartupoutput) _
                 As Long

Declare Sub gdiplusshutdown Lib "gdiplus.dll" _
            Alias "GdiplusShutdown" (ByVal Dword)

Declare Function gdiploadimagefromfile Lib "gdiplus.dll" _
                 Alias "GdipLoadImageFromFile" _
                 (ByVal String,Dword) As Long

Declare Function gdipdisposeimage Lib "gdiplus.dll" _
                 Alias "GdipDisposeImage" (ByVal Dword) As Long

Declare Function gdipgetimageencoderssize Lib "gdiplus.dll" _
                 Alias "GdipGetImageEncodersSize" _
                 (Dword,Dword) As Long

Declare Function gdipgetimageencoders Lib "gdiplus.dll" _
                 Alias "GdipGetImageEncoders" _
                 (ByVal Dword,ByVal Dword,ByVal Dword) As Long

Declare Function gdipsaveimagetofile Lib "gdiplus.dll" _
                 Alias "GdipSaveImageToFile" _
                 (ByVal Dword,ByVal String,Guid, _
                  Optional ByVal Dword) As Long

Declare Function gdipsetinterpolationmode Lib "gdiplus.dll" _
                 Alias "GdipSetInterpolationMode" _
                 (ByVal Long,ByVal Long) As Long

Declare Function gdipcreatebitmapfromhbitmap Lib "gdiplus.dll" _
                 Alias "GdipCreateBitmapFromHBITMAP" _
                 (ByVal Long,ByVal Long,Long) As Long

Declare Function gdipdrawimagerecti Lib "gdiplus.dll" _
                 Alias "GdipDrawImageRectI" _
                 (ByVal Long,ByVal Long,ByVal Long,ByVal Long, _
                  ByVal Long,ByVal Long) As Long

Declare Function gdipgetimagewidth Lib "gdiplus.dll" _
                 Alias "GdipGetImageWidth" _
                 (ByVal Long,Long) As Long

Declare Function gdipgetimageheight Lib "gdiplus.dll" _
                 Alias "GdipGetImageHeight" _
                 (ByVal Long,Long) As Long

Declare Function gdipdeletegraphics Lib "gdiplus.dll" _
                 Alias "GdipDeleteGraphics" _
                 (ByVal Long) As Long

Declare Function gdipgraphicsclear Lib "gdiplus.dll" _
                 Alias "GdipGraphicsClear" _
                 (ByVal Long,ByVal Long) As Long

Declare Function gdipcreatefromhwnd Lib "gdiplus.dll" _
                 Alias "GdipCreateFromHWND" _
                 (ByVal Long,Long) As Long

Declare Function gdipcreatefromhdc Lib "gdiplus.dll" _
                 Alias "GdipCreateFromHDC" _
                 (ByVal Long,Long) As Long

Declare Function gdipgetimagepixelformat Lib "gdiplus.dll" _
                 Alias "GdipGetImagePixelFormat" _
                 (ByVal Long,Long) As Long

Declare Function gdipgetimagedimension Lib "gdiplus.dll" _
                 Alias "GdipGetImageDimension" _
                 (ByVal Long,Single,Single) As Long

Declare Function gdipgetimagegraphicscontext Lib "gdiplus.dll" _
                 Alias "GdipGetImageGraphicsContext" _
                 (ByVal Long,Long) As Long

Declare Function gdipcreatebitmapfromscan0 Lib "gdiplus.dll" _
                 Alias "GdipCreateBitmapFromScan0" _
                 (ByVal Long,ByVal Long,ByVal Long,ByVal Long, _
                  Any,Long) As Long

Declare Function gdipgetinterpolationmode Lib "gdiplus.dll" _
                 Alias "GdipGetInterpolationMode" _
                 (ByVal Long,Long) As Long

Declare Function gdipdrawimagerectrecti Lib "gdiplus.dll" _
                 Alias "GdipDrawImageRectRectI" _
                 (ByVal Long,ByVal Long,ByVal Long,ByVal Long, _
                  ByVal Long,ByVal Long,ByVal Long,ByVal Long, _
                  ByVal Long,ByVal Long,ByVal Long, _
                  Optional ByVal Long,Optional ByVal Long, _
                  Optional ByVal Long) As Long

Declare Function gdipgetsmoothingmode Lib "gdiplus.dll" _
                 Alias "GdipGetSmoothingMode" _
                 (ByVal Long,Long) As Long

Declare Function readunicodestring(ByVal Dword) As String
Declare Function getencoderclsid(ByVal String) As String

Declare Function convertimage(ByVal String,ByVal String, _
                              ByVal String) As Long

Declare Function saveimagetofile(ByVal Dword,ByVal String, _
                                 ByVal String) As Long

Function readunicodestring(ByVal ucs???) As String

     Local p As Byte Ptr

     p=ucs???
     If p=%Null Then Exit Function

     b$=""

     Do Until Chr$(@p)=$Nul
       b$=b$+Chr$(@p)
       p=p+2  ''unicode strings have 2 bytes per char
     Loop

     Function=b$
End Function

Function getencoderclsid(ByVal smimetype$) As String

     Dim pimagecodecinfo As imagecodecinfo Ptr
     Dim p As Byte Ptr

     smimetype$=UCase$(smimetype$)

     gdipgetimageencoderssize(numencoders???,nsize???)

     ReDim buffer?(nsize???-1)

     pimagecodecinfo=VarPtr(buffer?(0))

     y&=gdipgetimageencoders(numencoders???,nsize???,pimagecodecinfo)
     If y&<>0 Then Exit Function

     For x???=1 To numencoders???

       If InStr(UCase$(readunicodestring(@pimagecodecinfo.mimetype)),smimetype$) Then
         Function=GuidTxt$(@pimagecodecinfo.classid)
         Exit For
       End If

       Incr pimagecodecinfo
     Next x???

End Function

Function convertimage(ByVal loadflname$,ByVal saveflname$, _
                      ByVal smimetype$) As Long

     Dim startupinput As gdiplusstartupinput
     Dim startupoutput As gdiplusstartupoutput
     Dim sencoderclsid As Guid

     If Trim$(loadflname$)="" Or Trim$(saveflname$)="" Then
       Exit Function
     End If

     startupinput.gdiplusversion=1

     If gdiplusstartup(token???,startupinput,ByVal %Null) Then
       MsgBox "Error initializing GDI+",%mb_ok,"GDI+ Error"
       Exit Function
     End If

     b$=getencoderclsid(smimetype$)

     If b$="" Then
       MsgBox "Encoder not installed",%mb_ok,"GDI+ Error"
       Exit Function
     End If

     sencoderclsid=Guid$(b$)

     ucflname$=UCode$(loadflname$)

     y&=gdiploadimagefromfile(ucflname$,lpimage???)

     If y& Then
       Function=y&
       Exit Function
     End If

     If lpimage??? Then
       ucflname$=UCode$(saveflname$)

       y&=gdipsaveimagetofile(lpimage???,ucflname$, _
                              sencoderclsid,encoderparams???)

       If y& Then
         Function=gdipdisposeimage(lpimage???)
         Exit Function
       End If

     End If

     gdipdisposeimage lpimage???
     gdiplusshutdown token???

     Function=y&
End Function

Function saveimagetofile(ByVal lpimage???,ByVal saveflname$, _
                         ByVal smimetype$) As Long

     Dim sencoderclsid As Guid

     b$=getencoderclsid(smimetype$)

     If b$="" Then
       MsgBox "Encoder not installed",%mb_ok,"GDI+ Error"
       Exit Function
     End If

     sencoderclsid=Guid$(b$)

     ucflname$=UCode$(saveflname$)

     Function=gdipsaveimagetofile(lpimage???,ucflname$,sencoderclsid)
End Function