#If 0
'########################################
'########################################
'###############  SE Script engine
'###############  2007 by Gus del Solar
'###############  GDSSIS software
'
'Language description:
'This is a demo for my rough, proof of concept script engine
'framework, or basic interprete, as you like.
'Supported dialect is a expandable powerbasic subset.
'Please see below for keywords detailed description.
'There are two variables types, numbers and strings.
'Numbers are internally stored as PB singles, strings
'are dynamic strings. There is not a predefined variables
'count limit. Loops and if/then can be nested to any deep,
'because they are managed by state machine not recursively.
'Variables must be declared prior use and are all 'globals'.
'No functions and subs yet. I have a version of this with them
'but more testing is need. Well...this one also needs more
'testing :)
'
'Application:
'Could be useful as didactic tool, configuration tool, etc.
'
'Internal description:
'The whole script is scanned byte by byte and tokenized using
'pointers, so quite fast. Built in functions tokens are
'loaded with a function definition code that includes argument
'count, argument types, return type, etc.
'Then a preprocessor does several pass to the tokenized code,
'I prefered a well formated code to allow fast execution later.
'All jumps and loops addresses are precalculated and set
'at preprocessor level. Variabled are dimmed in that stage also.
'Numeric expressions are converted to postfix while
'processed, then solved with the help of a little stack and
'pointers. No arrays or strings involved in math processing.
'Set %DEBUG_FLAG to 1 to see detailed debug information.
'
'Detailed description:
'
' VARIABLES TYPES SUPPORT
'  numbers (PB singles)
'  strings (PB dynamic strings)
'
' COMMENTS
' '
'
' NUMERIC OPERATORS SUPPORT
'  +, -, *, /, \, ^, =
'  <, >, =<, <=, >=, =>, <>, ><
'  not, istrue, isfalse
'  and, or, xor
'  imp, eqv, mod
'
' STRING OPERATORS SUPPORT
'  + , =, <, >, <=, =<, =>, >=
'
' FLOW CONTROL SUPPORT (any deep)
'  if <cond> then, elseif <cond> then, else, end if
'  exit, exit if, exit do/loop, exit for
'  for var = n/var/expr to n/var/expr [step n/var/expr], next
'  do, loop
'  do <cond>, loop
'  do, loop <cond>
'  do while/until <cond>, loop
'  do, loop while/until <cond>
'  while <cond>, wend
'  goto label
'
' STRING FUNCTIONS SUPPORT
'  left (st expr,n expr)
'  mid  (st expr,n expr,n expr)
'  right (st expr,n expr)
'  trim (st expr)
'  lcase (st expr)
'  ucase (st expr)
'  mcase (st expr)
'  hcase (st expr) ThIs iS HcAsE (very ugly)
'  str (n expr)
'  chr (n expr)
'  space (n expr)
'  string (n expr,n expr)
'  bin (n expr)
'  hex (n expr)
'  acode (st expr)
'  ucode (st expr)
'  nul (n expr)
'  date
'  time
'
' NUMERIC FUNCTIONS SUPPORT
'  asc (st expr)
'  instr (st expr, st expr)
'  len (st expr)
'  val (st expr)
'  rnd (n min, n max)
'  even (n expr)
'  prglines
'  timer
'  ceil (n expr)
'  int (n expr)
'  fix (n expr)
'  sqr (n expr), sin (n expr)
'  cos (n expr), tan (n expr), atn (n expr), exp2, exp10 (n expr)
'  exp (n expr), log10 (n expr), abs (n expr), log2 (n expr)
'  log (n expr), sgn (n expr), fac (n expr), pi
'
' MISC
'  randomize (no args, always uses timer as seed)
'
' LABELS
'  standard labels
'
' I/O SUPPORT (demos)
'  print, ? (will print to result textbox)
'  stdout (st expr)
'  stdin
'  waitkey
'  beep
'  msgbox (st text, n style, st tittle)
'
'Note:
' No optional arguments.
'
'Whishlist:
'  some script <-> caller communication
'  more data types, unsigned, ext, types
'  arrays
'  functions, subs (and private subs and functions)
'  objects ?
'  better type detect
'  asm math processing
'  static, locals (all globals now)
'  funny girls, money, cars, a timemachine
'
'  =====================================================
'  COPYRIGHT AND PERMISSION NOTICE (copied from elsewhere)
'  =====================================================
'  Copyright (c) 2007 - 2007, Gus del Solar
'  All rights reserved.
'  Permission to use and copy this software for non
'  commercial purpose always keeping this notice. For
'  commercial please contact the author at gds3k3 gmail com
'  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF
'  ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
'  TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
'  PARTICULAR PURPOSE AND NONINFRINGEMENT OF THIRD PARTY
'  RIGHTS. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
'  HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
'  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
'  OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
'  THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
'
#EndIf

%DEBUG_FLAG = 0                     'set this one to 1 to see debug info

%ASCII_NULL              =   0      '
%ASCII_TAB               =   9      'TAB
%ASCII_LINEFEED          =  10      'LF
%ASCII_ENTER             =  13      'CR
%ASCII_ESCAPE            =  27      'ESC
%ASCII_SPACE             =  32      '
%ASCII_DOUBLEQUOTE       =  34      '"
%ASCII_AMPER             =  38      '&
%ASCII_APOSTROPHE        =  39      ''
%ASCII_PARENTHESES_OPEN  =  40      '(
%ASCII_PARENTHESES_CLOSE =  41      ')
%ASCII_MUL               =  42      '*
%ASCII_PLUS              =  43      '-
%ASCII_COMMA             =  44      ',
%ASCII_MINUS             =  45      '+
%ASCII_PERIOD            =  46      '.
%ASCII_DIV               =  47      '/
%ASCII_NUM0              =  48      '0
%ASCII_NUM9              =  57      '9
%ASCII_COLON             =  58      ':
%ASCII_SEMICOLON         =  59      ';
%ASCII_LESS              =  60      '<
%ASCII_EQUAL             =  61      '=
%ASCII_MORE              =  62      '>
%ASCII_QUESTION          =  63      '?
%ASCII_UCASE_A           =  65      'A
%ASCII_UCASE_N           =  78      'N
%ASCII_UCASE_S           =  83      'S
%ASCII_UCASE_Z           =  90      'Z
%ASCII_INTDIV            =  92      '\
%ASCII_BRACKETOPEN       =  91      '[
%ASCII_BRACKETCLOSE      =  93      ']
%ASCII_CARET             =  94      '^
%ASCII_UNDERSCORE        =  95      '_
%ASCII_LCASE_A           =  97      'a
%ASCII_LCASE_B           =  98      'b
%ASCII_LCASE_C           =  99      'c
%ASCII_LCASE_E           = 101      'e
%ASCII_LCASE_F           = 102      'f
%ASCII_LCASE_I           = 105      'i
%ASCII_LCASE_M           = 109      'm
%ASCII_LCASE_X           = 120      'x
%ASCII_LCASE_Z           = 122      'z
%ASCII_TILDE             = 126      '~
%ASCII_OR                = 179      '|

%SE_TOKEN_UNDEFINED   =  0
%SE_TOKEN_DELIMITER   =  1
%SE_TOKEN_NUMBER      =  2
%SE_TOKEN_ALPHA       =  3
%SE_TOKEN_STRING      =  4
%SE_TOKEN_CRLF        =  5
%SE_TOKEN_COLON       =  6
%SE_TOKEN_EOL         = 13
%SE_TOKEN_CONDITION   =  8
%SE_TOKEN_NUMEXPR     =  9
%SE_TOKEN_STREXPR     = 10
%SE_TOKEN_ASSIGN      = 11
%SE_TOKEN_PRINT       = 14

%SE_MAXTOKENLEN       = 64        'max token lenght, tokens are text constants, numbers, labels and var names
%SE_MAXEXPRLEN        = 128       'max expression len
%SE_MAXTOKENS         = 512       '512 tokens should be enough for anyone...bill said that not me
%SE_MAXCODETOKENS     = 2048      'small codetokens buffer, use 8192 or more, no checking of this

'function definition flags
%SE_FDEF_USRSUB     = &h00800000  'user sub
%SE_FDEF_USRFUN     = &h00400000  'user function
%SE_FDEF_OPERATOR   = &h20000000  'operator
%SE_FDEF_FLOWCTRL   = &h00100000  'flow control
%SE_FDEF_RETNOT     = &h00200000  'no return
%SE_FDEF_BINFUN     = &h10000000  'built in function
%SE_FDEF_RETSNG     = &h01000000  'numeric return
%SE_FDEF_RETLNG     = &h02000000  'numeric return
%SE_FDEF_RETDWD     = &h04000000  'numeric return
%SE_FDEF_RETSTR     = &h08000000  'string return
%SE_FDEF_ARGS1      = &h00000100  'has 1 arg
%SE_FDEF_ARGS2      = &h00000200  'has 2 arg
%SE_FDEF_ARGS3      = &h00000300  'has 3 arg
%SE_FDEF_ARGS4      = &h00000400  'has 4 arg
%SE_FDEF_ARG1NUM    = &h00001000  'arg1 is number
%SE_FDEF_ARG1STR    = &h00002000  'arg1 is string
%SE_FDEF_ARG2NUM    = &h00004000  'arg2 is number
%SE_FDEF_ARG2STR    = &h00008000  'arg2 is string
%SE_FDEF_ARG3NUM    = &h00010000  'arg3 is number
%SE_FDEF_ARG3STR    = &h00020000  'arg3 is string
%SE_FDEF_ARG4NUM    = &h00040000  'arg4 is number
%SE_FDEF_ARG4STR    = &h00080000  'arg4 is string
%SE_FDEF_PARARGS    = &h00000800  'args are parenthised
%SE_FDEF_RETNUM     = %SE_FDEF_RETDWD Or %SE_FDEF_RETSNG Or %SE_FDEF_RETLNG  'any numeric return
'%SE_FDEF_ARG1OPT    = &h01000000  'arg1 is optional
'%SE_FDEF_ARG2OPT    = &h02000000  'arg2 is optional
'%SE_FDEF_ARG3OPT    = &h04000000  'arg3 is optional
'%SE_FDEF_ARG4OPT    = &h08000000  'arg4 is optional

%SE_FDEF_ARGMASK    = &h00000700???
%SE_FDEF_PARARGS    = &h00000800???
%SE_FDEF_RETMASK    = &h00f00000???
%SE_FDEF_ARGTYPE    = &h000ff000???
%SE_FDEF_SUBMASK    = &h00800000???
%SE_FDEF_FUNMASK    = &h00400000???

Macro funargs(fun) = (fun And %SE_FDEF_ARGMASK) \ 256                 'function arguments count
Macro parargs(fun) = IsTrue(fun And %SE_FDEF_PARARGS) '\ %SE_FDEF_PARARGS    'are arguments parenthised?
Macro isnumvar(xr) = IsTrue(xr And %SE_FDEF_RETNUM)

%SE_TOKENCMD_ABS      =   1 Or %SE_FDEF_RETNUM Or %SE_FDEF_ARGS1 Or %SE_FDEF_ARG1NUM Or %SE_FDEF_BINFUN Or %SE_FDEF_PARARGS
%SE_TOKENCMD_ACODE    =   2 Or %SE_FDEF_RETSTR Or %SE_FDEF_ARGS1 Or %SE_FDEF_ARG1STR Or %SE_FDEF_BINFUN Or %SE_FDEF_PARARGS
%SE_TOKENCMD_AND      =   3 Or %SE_FDEF_OPERATOR
%SE_TOKENCMD_AS       =   4 Or %SE_FDEF_RETNOT                                           Or %SE_FDEF_BINFUN
%SE_TOKENCMD_ASC      =   5 Or %SE_FDEF_RETNUM                                           Or %SE_FDEF_BINFUN Or %SE_FDEF_PARARGS
%SE_TOKENCMD_ATN      =   6 Or %SE_FDEF_RETNUM Or %SE_FDEF_ARGS1 Or %SE_FDEF_ARG1NUM Or %SE_FDEF_BINFUN Or %SE_FDEF_PARARGS
%SE_TOKENCMD_BEEP     =  11 Or %SE_FDEF_RETNOT                                           Or %SE_FDEF_BINFUN
%SE_TOKENCMD_BIN      =  10 Or %SE_FDEF_RETSTR Or %SE_FDEF_ARGS1 Or %SE_FDEF_ARG1NUM Or %SE_FDEF_BINFUN Or %SE_FDEF_PARARGS
%SE_TOKENCMD_CASE     =  12 Or %SE_FDEF_FLOWCTRL                                         Or %SE_FDEF_BINFUN
%SE_TOKENCMD_CMD      =  13 Or %SE_FDEF_RETSTR                                           Or %SE_FDEF_BINFUN
%SE_TOKENCMD_CEIL     =  15 Or %SE_FDEF_RETNUM Or %SE_FDEF_ARGS1 Or %SE_FDEF_ARG1NUM Or %SE_FDEF_BINFUN Or %SE_FDEF_PARARGS
%SE_TOKENCMD_CHR      =  18 Or %SE_FDEF_RETSTR Or %SE_FDEF_ARGS1 Or %SE_FDEF_ARG1NUM Or %SE_FDEF_BINFUN Or %SE_FDEF_PARARGS
%SE_TOKENCMD_CINT     =  16 Or %SE_FDEF_RETNUM Or %SE_FDEF_ARGS1 Or %SE_FDEF_ARG1NUM Or %SE_FDEF_BINFUN Or %SE_FDEF_PARARGS
%SE_TOKENCMD_COS      =  17 Or %SE_FDEF_RETNUM Or %SE_FDEF_ARGS1 Or %SE_FDEF_ARG1NUM Or %SE_FDEF_BINFUN Or %SE_FDEF_PARARGS
%SE_TOKENCMD_DATE     =  24 Or %SE_FDEF_RETSTR                                           Or %SE_FDEF_BINFUN
%SE_TOKENCMD_DECR     =  25 Or %SE_FDEF_RETNUM Or %SE_FDEF_ARGS1 Or %SE_FDEF_ARG1NUM Or %SE_FDEF_BINFUN
%SE_TOKENCMD_DO       =  26 Or %SE_FDEF_FLOWCTRL                                         Or %SE_FDEF_BINFUN
%SE_TOKENCMD_DWORD    =  27 Or %SE_FDEF_RETNOT                                           Or %SE_FDEF_BINFUN
%SE_TOKENCMD_ENVGET   =  28 Or %SE_FDEF_RETSTR Or %SE_FDEF_ARGS1 Or %SE_FDEF_ARG1STR Or %SE_FDEF_BINFUN Or %SE_FDEF_PARARGS
%SE_TOKENCMD_ENVSET   =  29 Or %SE_FDEF_RETNOT                                           Or %SE_FDEF_BINFUN
%SE_TOKENCMD_EXTRACT  =  30
%SE_TOKENCMD_END      =  31 Or %SE_FDEF_FLOWCTRL                                         Or %SE_FDEF_BINFUN
%SE_TOKENCMD_ELSE     =  32 Or %SE_FDEF_FLOWCTRL                                         Or %SE_FDEF_BINFUN
%SE_TOKENCMD_ELSEIF   =  33 Or %SE_FDEF_FLOWCTRL                                         Or %SE_FDEF_BINFUN
%SE_TOKENCMD_EQV      =  34 Or %SE_FDEF_OPERATOR
%SE_TOKENCMD_ERASE    =  35 Or %SE_FDEF_RETNOT                                           Or %SE_FDEF_BINFUN
%SE_TOKENCMD_EVEN     =  36 Or %SE_FDEF_RETNUM Or %SE_FDEF_ARGS1 Or %SE_FDEF_ARG1NUM Or %SE_FDEF_BINFUN Or %SE_FDEF_PARARGS
%SE_TOKENCMD_EXP      =  37 Or %SE_FDEF_RETNUM Or %SE_FDEF_ARGS1 Or %SE_FDEF_ARG1NUM Or %SE_FDEF_BINFUN Or %SE_FDEF_PARARGS
%SE_TOKENCMD_EXP2     =  38 Or %SE_FDEF_RETNUM Or %SE_FDEF_ARGS1 Or %SE_FDEF_ARG1NUM Or %SE_FDEF_BINFUN Or %SE_FDEF_PARARGS
%SE_TOKENCMD_EXP10    =  39 Or %SE_FDEF_RETNUM Or %SE_FDEF_ARGS1 Or %SE_FDEF_ARG1NUM Or %SE_FDEF_BINFUN Or %SE_FDEF_PARARGS
%SE_TOKENCMD_EXIT     =  40 Or %SE_FDEF_FLOWCTRL                                         Or %SE_FDEF_BINFUN
%SE_TOKENCMD_FAC      =  41 Or %SE_FDEF_RETNUM Or %SE_FDEF_ARGS1 Or %SE_FDEF_ARG1NUM Or %SE_FDEF_BINFUN Or %SE_FDEF_PARARGS
%SE_TOKENCMD_FIX      =  42 Or %SE_FDEF_RETNUM Or %SE_FDEF_ARGS1 Or %SE_FDEF_ARG1NUM Or %SE_FDEF_BINFUN Or %SE_FDEF_PARARGS
%SE_TOKENCMD_FOR      =  43 Or %SE_FDEF_FLOWCTRL                                         Or %SE_FDEF_BINFUN
%SE_TOKENCMD_FUNCTION =  44 Or %SE_FDEF_PARARGS
%SE_TOKENCMD_FRAC     =  45 Or %SE_FDEF_RETNUM Or %SE_FDEF_ARGS1 Or %SE_FDEF_ARG1NUM Or %SE_FDEF_BINFUN Or %SE_FDEF_PARARGS
%SE_TOKENCMD_FORMAT   =  46
%SE_TOKENCMD_FUNNAME  =  47 Or %SE_FDEF_RETSTR                                           Or %SE_FDEF_BINFUN
%SE_TOKENCMD_GOTO     =  50 Or %SE_FDEF_FLOWCTRL                                         Or %SE_FDEF_BINFUN
%SE_TOKENCMD_GOSUB    =  51 Or %SE_FDEF_FLOWCTRL                                         Or %SE_FDEF_BINFUN
%SE_TOKENCMD_HCASE    =  55 Or %SE_FDEF_RETSTR Or %SE_FDEF_ARGS1 Or %SE_FDEF_ARG1STR Or %SE_FDEF_BINFUN Or %SE_FDEF_PARARGS
%SE_TOKENCMD_HEX      =  56 Or %SE_FDEF_RETSTR Or %SE_FDEF_ARGS1 Or %SE_FDEF_ARG1NUM Or %SE_FDEF_BINFUN Or %SE_FDEF_PARARGS
%SE_TOKENCMD_IF       =  66 Or %SE_FDEF_FLOWCTRL                                         Or %SE_FDEF_BINFUN
%SE_TOKENCMD_IMP      =  63 Or %SE_FDEF_OPERATOR
%SE_TOKENCMD_INCR     =  65 Or %SE_FDEF_RETNUM Or %SE_FDEF_ARGS1 Or %SE_FDEF_ARG1NUM Or %SE_FDEF_BINFUN
%SE_TOKENCMD_INSTR    =  60 Or %SE_FDEF_RETNUM Or %SE_FDEF_ARGS3 Or %SE_FDEF_ARG1NUM Or %SE_FDEF_ARG2STR Or %SE_FDEF_ARG3STR Or %SE_FDEF_BINFUN
%SE_TOKENCMD_INT      =  64 Or %SE_FDEF_RETNUM Or %SE_FDEF_ARGS1 Or %SE_FDEF_ARG1NUM Or %SE_FDEF_BINFUN Or %SE_FDEF_PARARGS
%SE_TOKENCMD_ISTRUE   =  61 Or %SE_FDEF_RETNUM Or %SE_FDEF_ARGS1 Or %SE_FDEF_ARG1NUM Or %SE_FDEF_BINFUN Or %SE_FDEF_PARARGS
%SE_TOKENCMD_ISFALSE  =  62 Or %SE_FDEF_RETNUM Or %SE_FDEF_ARGS1 Or %SE_FDEF_ARG1NUM Or %SE_FDEF_BINFUN Or %SE_FDEF_PARARGS
%SE_TOKENCMD_JOIN     =  63
%SE_TOKENCMD_MAXS     =  66
%SE_TOKENCMD_MINS     =  67
%SE_TOKENCMD_MAX      =  70 Or %SE_FDEF_RETNUM Or %SE_FDEF_ARGS1 Or %SE_FDEF_ARG1NUM Or %SE_FDEF_BINFUN Or %SE_FDEF_PARARGS
%SE_TOKENCMD_MSGBOX   =  71 Or %SE_FDEF_RETNUM Or %SE_FDEF_ARGS3 Or %SE_FDEF_ARG1STR Or %SE_FDEF_ARG2NUM Or %SE_FDEF_ARG3STR Or %SE_FDEF_BINFUN Or %SE_FDEF_PARARGS
%SE_TOKENCMD_MCASE    =  72 Or %SE_FDEF_RETSTR Or %SE_FDEF_ARGS1 Or %SE_FDEF_ARG1STR Or %SE_FDEF_BINFUN Or %SE_FDEF_PARARGS
%SE_TOKENCMD_MID      =  73 Or %SE_FDEF_RETSTR Or %SE_FDEF_ARGS3 Or %SE_FDEF_ARG1STR Or %SE_FDEF_ARG2NUM Or %SE_FDEF_ARG3NUM Or %SE_FDEF_BINFUN Or %SE_FDEF_PARARGS
%SE_TOKENCMD_MIN      =  74 Or %SE_FDEF_RETNUM Or %SE_FDEF_ARGS1 Or %SE_FDEF_ARG1NUM Or %SE_FDEF_BINFUN Or %SE_FDEF_PARARGS
%SE_TOKENCMD_MOD      =  75 Or %SE_FDEF_OPERATOR
%SE_TOKENCMD_NEXT     =  76 Or %SE_FDEF_FLOWCTRL
%SE_TOKENCMD_NOT      =  77 Or %SE_FDEF_RETNUM Or %SE_FDEF_ARGS1 Or %SE_FDEF_ARG1NUM Or %SE_FDEF_BINFUN Or %SE_FDEF_PARARGS
%SE_TOKENCMD_NUMBERS  =  78 Or %SE_FDEF_RETNOT                                       Or %SE_FDEF_BINFUN
%SE_TOKENCMD_NUL      =  79 Or %SE_FDEF_RETSTR Or %SE_FDEF_ARGS1 Or %SE_FDEF_ARG1NUM Or %SE_FDEF_BINFUN
%SE_TOKENCMD_LCASE    =  80 Or %SE_FDEF_RETSTR Or %SE_FDEF_ARGS1 Or %SE_FDEF_ARG1STR Or %SE_FDEF_BINFUN Or %SE_FDEF_PARARGS
%SE_TOKENCMD_LEFT     =  81 Or %SE_FDEF_RETSTR Or %SE_FDEF_ARGS2 Or %SE_FDEF_ARG1STR Or %SE_FDEF_ARG2NUM Or %SE_FDEF_BINFUN Or %SE_FDEF_PARARGS
%SE_TOKENCMD_LEN      =  82 Or %SE_FDEF_RETNUM Or %SE_FDEF_ARGS1 Or %SE_FDEF_ARG1STR Or %SE_FDEF_BINFUN Or %SE_FDEF_PARARGS
%SE_TOKENCMD_LOG      =  83 Or %SE_FDEF_RETNUM Or %SE_FDEF_ARGS1 Or %SE_FDEF_ARG1NUM Or %SE_FDEF_BINFUN Or %SE_FDEF_PARARGS
%SE_TOKENCMD_LOG2     =  84 Or %SE_FDEF_RETNUM Or %SE_FDEF_ARGS1 Or %SE_FDEF_ARG1NUM Or %SE_FDEF_BINFUN Or %SE_FDEF_PARARGS
%SE_TOKENCMD_LOG10    =  85 Or %SE_FDEF_RETNUM Or %SE_FDEF_ARGS1 Or %SE_FDEF_ARG1NUM Or %SE_FDEF_BINFUN Or %SE_FDEF_PARARGS
%SE_TOKENCMD_LOOP     =  86 Or %SE_FDEF_FLOWCTRL                                         Or %SE_FDEF_BINFUN
%SE_TOKENCMD_LET      =  87 Or %SE_FDEF_RETNOT                                           Or %SE_FDEF_BINFUN
%SE_TOKENCMD_LONG     =  88 Or %SE_FDEF_RETNOT                                           Or %SE_FDEF_BINFUN
%SE_TOKENCMD_LTRIM    =  89 Or %SE_FDEF_RETSTR Or %SE_FDEF_ARGS1 Or %SE_FDEF_ARG1STR Or %SE_FDEF_BINFUN Or %SE_FDEF_PARARGS
%SE_TOKENCMD_OCT      =  94 Or %SE_FDEF_RETSTR Or %SE_FDEF_ARGS1 Or %SE_FDEF_ARG1NUM Or %SE_FDEF_BINFUN Or %SE_FDEF_PARARGS
%SE_TOKENCMD_OR       =  95 Or %SE_FDEF_OPERATOR
%SE_TOKENCMD_PRGLINES =  96 Or %SE_FDEF_RETNUM                                           Or %SE_FDEF_BINFUN
%SE_TOKENCMD_PI       =  97 Or %SE_FDEF_RETNUM                                           Or %SE_FDEF_BINFUN
%SE_TOKENCMD_RESET    = 100 Or %SE_FDEF_RETNOT                                           Or %SE_FDEF_BINFUN
%SE_TOKENCMD_RANDOM   = 101 Or %SE_FDEF_RETNOT                                           Or %SE_FDEF_BINFUN
%SE_TOKENCMD_RETURN   = 102 Or %SE_FDEF_FLOWCTRL                                         Or %SE_FDEF_BINFUN
%SE_TOKENCMD_RIGHT    = 103 Or %SE_FDEF_RETSTR Or %SE_FDEF_ARGS2 Or %SE_FDEF_ARG1STR Or %SE_FDEF_ARG2NUM Or %SE_FDEF_BINFUN Or %SE_FDEF_PARARGS
%SE_TOKENCMD_RND      = 104 Or %SE_FDEF_RETNUM Or %SE_FDEF_ARGS2 Or %SE_FDEF_ARG1NUM Or %SE_FDEF_ARG2NUM Or %SE_FDEF_BINFUN Or %SE_FDEF_PARARGS
%SE_TOKENCMD_ROUND    = 105 Or %SE_FDEF_RETNUM Or %SE_FDEF_ARGS1 Or %SE_FDEF_ARG1NUM Or %SE_FDEF_BINFUN Or %SE_FDEF_PARARGS
%SE_TOKENCMD_REMAIN   = 106
%SE_TOKENCMD_REMOVE   = 107
%SE_TOKENCMD_REPEAT   = 108
%SE_TOKENCMD_RETAIN   = 109
%SE_TOKENCMD_RTRIM    = 110 Or %SE_FDEF_RETSTR Or %SE_FDEF_ARGS1 Or %SE_FDEF_ARG1STR Or %SE_FDEF_BINFUN Or %SE_FDEF_PARARGS
%SE_TOKENCMD_SIN      = 114 Or %SE_FDEF_RETNUM Or %SE_FDEF_ARGS1 Or %SE_FDEF_ARG1NUM Or %SE_FDEF_BINFUN Or %SE_FDEF_PARARGS
%SE_TOKENCMD_SGN      = 115 Or %SE_FDEF_RETNUM Or %SE_FDEF_ARGS1 Or %SE_FDEF_ARG1NUM Or %SE_FDEF_BINFUN Or %SE_FDEF_PARARGS
%SE_TOKENCMD_SPACE    = 116 Or %SE_FDEF_RETSTR Or %SE_FDEF_ARGS1 Or %SE_FDEF_ARG1NUM Or %SE_FDEF_BINFUN Or %SE_FDEF_PARARGS
%SE_TOKENCMD_SQR      = 117 Or %SE_FDEF_RETNUM Or %SE_FDEF_ARGS1 Or %SE_FDEF_ARG1NUM Or %SE_FDEF_BINFUN Or %SE_FDEF_PARARGS
%SE_TOKENCMD_STDERR   = 118                                                              Or %SE_FDEF_BINFUN
%SE_TOKENCMD_STDIN    = 119 Or %SE_FDEF_RETSTR                                           Or %SE_FDEF_BINFUN
%SE_TOKENCMD_STDOUT   = 120 Or %SE_FDEF_RETNOT Or %SE_FDEF_ARGS1 Or %SE_FDEF_ARG1STR Or %SE_FDEF_BINFUN Or %SE_FDEF_PARARGS
%SE_TOKENCMD_STR      = 121 Or %SE_FDEF_RETSTR Or %SE_FDEF_ARGS1 Or %SE_FDEF_ARG1NUM Or %SE_FDEF_BINFUN Or %SE_FDEF_PARARGS
%SE_TOKENCMD_STRING   = 122 Or %SE_FDEF_RETSTR Or %SE_FDEF_ARGS2 Or %SE_FDEF_ARG1NUM Or %SE_FDEF_ARG2STR Or %SE_FDEF_BINFUN Or %SE_FDEF_PARARGS
%SE_TOKENCMD_STEP     = 123 Or %SE_FDEF_FLOWCTRL                                         Or %SE_FDEF_BINFUN
%SE_TOKENCMD_SUB      = 124 Or %SE_FDEF_RETNOT                                           Or %SE_FDEF_BINFUN
%SE_TOKENCMD_SELECT   = 125 Or %SE_FDEF_FLOWCTRL                                         Or %SE_FDEF_BINFUN
%SE_TOKENCMD_STRINGS  = 126 Or %SE_FDEF_RETNOT                                           Or %SE_FDEF_BINFUN
%SE_TOKENCMD_SINGLE   = 127 Or %SE_FDEF_RETNOT                                           Or %SE_FDEF_BINFUN
%SE_TOKENCMD_STRDEL   = 128
%SE_TOKENCMD_STRINS   = 129
%SE_TOKENCMD_STRREV   = 130
%SE_TOKENCMD_TAB      = 133 Or %SE_FDEF_RETSTR                                           Or %SE_FDEF_BINFUN Or %SE_FDEF_PARARGS
%SE_TOKENCMD_TAN      = 134 Or %SE_FDEF_RETNUM Or %SE_FDEF_ARGS1 Or %SE_FDEF_ARG1NUM Or %SE_FDEF_BINFUN Or %SE_FDEF_PARARGS
%SE_TOKENCMD_TIME     = 135 Or %SE_FDEF_RETSTR                                           Or %SE_FDEF_BINFUN
%SE_TOKENCMD_THEN     = 136 Or %SE_FDEF_FLOWCTRL                                         Or %SE_FDEF_BINFUN
%SE_TOKENCMD_TIMER    = 137 Or %SE_FDEF_RETNUM                                           Or %SE_FDEF_BINFUN
%SE_TOKENCMD_TO       = 138 Or %SE_FDEF_FLOWCTRL                                         Or %SE_FDEF_BINFUN
%SE_TOKENCMD_TRIM     = 139 Or %SE_FDEF_RETSTR Or %SE_FDEF_ARGS1 Or %SE_FDEF_ARG1STR Or %SE_FDEF_BINFUN Or %SE_FDEF_PARARGS
%SE_TOKENCMD_UCASE    = 143 Or %SE_FDEF_RETSTR Or %SE_FDEF_ARGS1 Or %SE_FDEF_ARG1STR Or %SE_FDEF_BINFUN Or %SE_FDEF_PARARGS
%SE_TOKENCMD_UCODE    = 144 Or %SE_FDEF_RETSTR Or %SE_FDEF_ARGS1 Or %SE_FDEF_ARG1STR Or %SE_FDEF_BINFUN Or %SE_FDEF_PARARGS
%SE_TOKENCMD_UNTIL    = 145 Or %SE_FDEF_FLOWCTRL                                         Or %SE_FDEF_BINFUN
%SE_TOKENCMD_VAL      = 146 Or %SE_FDEF_RETNUM Or %SE_FDEF_ARGS1 Or %SE_FDEF_ARG1STR Or %SE_FDEF_BINFUN Or %SE_FDEF_PARARGS
%SE_TOKENCMD_WEND     = 147 Or %SE_FDEF_FLOWCTRL                                         Or %SE_FDEF_BINFUN
%SE_TOKENCMD_WHILE    = 148 Or %SE_FDEF_FLOWCTRL                                         Or %SE_FDEF_BINFUN
%SE_TOKENCMD_WAITKEY  = 149 Or %SE_FDEF_RETNOT
%SE_TOKENCMD_XOR      = 150 Or %SE_FDEF_OPERATOR                                         Or %SE_FDEF_BINFUN
%SE_TOKENCMD_PRINT    = 151 Or %SE_FDEF_RETNOT Or %SE_FDEF_ARGS1 Or %SE_FDEF_ARG1STR Or %SE_FDEF_BINFUN

'misc internal use
%SE_TOKENCMD_ENDIF    = 201 Or %SE_FDEF_FLOWCTRL Or %SE_FDEF_BINFUN
%SE_TOKENCMD_DOW      = 202 Or %SE_FDEF_FLOWCTRL Or %SE_FDEF_BINFUN
%SE_TOKENCMD_DOU      = 203 Or %SE_FDEF_FLOWCTRL Or %SE_FDEF_BINFUN
%SE_TOKENCMD_ENDFUN   = 204 Or %SE_FDEF_FLOWCTRL Or %SE_FDEF_BINFUN
%SE_TOKENCMD_EXITIF   = 205 Or %SE_FDEF_FLOWCTRL Or %SE_FDEF_BINFUN
%SE_TOKENCMD_EXITDO   = 206 Or %SE_FDEF_FLOWCTRL Or %SE_FDEF_BINFUN
%SE_TOKENCMD_EXITWHI  = 207 Or %SE_FDEF_FLOWCTRL Or %SE_FDEF_BINFUN
%SE_TOKENCMD_EXITFOR  = 208 Or %SE_FDEF_FLOWCTRL Or %SE_FDEF_BINFUN
%SE_TOKENCMD_EXITFUN  = 209 Or %SE_FDEF_FLOWCTRL Or %SE_FDEF_BINFUN
%SE_TOKENCMD_EXITSUB  = 210 Or %SE_FDEF_FLOWCTRL Or %SE_FDEF_BINFUN
%SE_TOKENCMD_EXITSEL  = 211 Or %SE_FDEF_FLOWCTRL Or %SE_FDEF_BINFUN
%SE_TOKENCMD_LOOPW    = 212 Or %SE_FDEF_FLOWCTRL Or %SE_FDEF_BINFUN
%SE_TOKENCMD_LOOPU    = 213 Or %SE_FDEF_FLOWCTRL Or %SE_FDEF_BINFUN
%SE_TOKENCMD_GLETNUM  = 214 Or %SE_FDEF_RETNOT   Or %SE_FDEF_BINFUN
%SE_TOKENCMD_GLETSTR  = 215 Or %SE_FDEF_RETNOT   Or %SE_FDEF_BINFUN
%SE_TOKENCMD_RSTNUM   = 216 Or %SE_FDEF_RETNOT   Or %SE_FDEF_BINFUN
%SE_TOKENCMD_RSTSTR   = 217 Or %SE_FDEF_RETNOT   Or %SE_FDEF_BINFUN
%SE_TOKENCMD_ERNUM    = 218 Or %SE_FDEF_RETNOT   Or %SE_FDEF_BINFUN
%SE_TOKENCMD_ERSTR    = 219 Or %SE_FDEF_RETNOT   Or %SE_FDEF_BINFUN
%SE_TOKENCMD_LABEL    = 220 Or %SE_FDEF_FLOWCTRL Or %SE_FDEF_BINFUN
%SE_TOKENCMD_PRENUM   = 223 Or %SE_FDEF_RETNOT
%SE_TOKENCMD_PRESTR   = 224 Or %SE_FDEF_RETNOT
%SE_TOKENCMD_GNUMVAR  = 225 Or %SE_FDEF_RETNUM
%SE_TOKENCMD_GSTRVAR  = 226 Or %SE_FDEF_RETSTR
%SE_TOKENCMD_FUNNUM   = 227 Or %SE_FDEF_RETNUM Or %SE_FDEF_USRFUN Or %SE_FDEF_PARARGS 'numeric user function
%SE_TOKENCMD_ENDSUB   = 228 Or %SE_FDEF_FLOWCTRL Or %SE_FDEF_BINFUN
%SE_TOKENCMD_ENDSEL   = 229 Or %SE_FDEF_FLOWCTRL Or %SE_FDEF_BINFUN
%SE_TOKENCMD_ENDSCR   = 230 Or %SE_FDEF_FLOWCTRL Or %SE_FDEF_BINFUN
%SE_TOKENCMD_JUMPTO   = 231 Or %SE_FDEF_FLOWCTRL Or %SE_FDEF_BINFUN
%SE_TOKENCMD_FUNSTR   = 232 Or %SE_FDEF_RETSTR  Or %SE_FDEF_USRFUN Or %SE_FDEF_PARARGS 'string user function
%SE_TOKENCMD_OPERAT   = 0   Or %SE_FDEF_OPERATOR
%SE_TOKENCMD_NUMCONST = 0   Or %SE_FDEF_RETNUM
%SE_TOKENCMD_STRCONST = 0   Or %SE_FDEF_RETSTR
%SE_TOKENCMD_INCLUDE  = 233
%SE_TOKENCMD_IFS      = 234 Or %SE_FDEF_FLOWCTRL                                         Or %SE_FDEF_BINFUN
%SE_TOKENCMD_ELSEIFS  = 235 Or %SE_FDEF_FLOWCTRL                                         Or %SE_FDEF_BINFUN

'argument types
%SE_ARGTYPE_NUMMSK    = %SE_FDEF_ARG1NUM Or %SE_FDEF_ARG2NUM Or %SE_FDEF_ARG3NUM Or %SE_FDEF_ARG4NUM
%SE_ARGTYPE_STRMSK    = %SE_FDEF_ARG1STR Or %SE_FDEF_ARG2STR Or %SE_FDEF_ARG3STR Or %SE_FDEF_ARG4STR
%SE_ARGTYPE_VARNUM    = %SE_TOKENCMD_GNUMVAR Or %SE_ARGTYPE_NUMMSK
%SE_ARGTYPE_VARSTR    = %SE_TOKENCMD_GSTRVAR Or %SE_ARGTYPE_STRMSK
%SE_ARGTYPE_CONNUM    = %SE_FDEF_RETNUM Or %SE_ARGTYPE_NUMMSK
%SE_ARGTYPE_CONSTR    = %SE_FDEF_RETSTR Or %SE_ARGTYPE_STRMSK
%SE_ARGTYPE_BINNUM    = %SE_FDEF_RETNUM Or %SE_FDEF_BINFUN Or %SE_ARGTYPE_NUMMSK
%SE_ARGTYPE_BINSTR    = %SE_FDEF_RETSTR Or %SE_FDEF_BINFUN Or %SE_ARGTYPE_STRMSK
%SE_ARGTYPE_USRNUM    = %SE_FDEF_RETNUM Or %SE_FDEF_USRFUN Or %SE_ARGTYPE_NUMMSK
%SE_ARGTYPE_USRSTR    = %SE_FDEF_RETSTR Or %SE_FDEF_USRFUN Or %SE_ARGTYPE_STRMSK
%SE_ARGTYPE_EXPNUM    = %SE_FDEF_RETNUM Or %SE_FDEF_OPERATOR Or %SE_ARGTYPE_NUMMSK
%SE_ARGTYPE_EXPSTR    = %SE_FDEF_RETSTR Or %SE_FDEF_OPERATOR Or %SE_ARGTYPE_STRMSK

$ALLOWEDCHARS     = "0123456789_abcdefghijklmnopqrstuvwxyz"   'I hope I don't forget any letter
$ALLOWEDFIRSTCHAR = "_abcdefghijklmnopqrstuvwxyz"

'lookfor function calling flags
%SE_LOOK4_NUM         = %SE_TOKEN_NUMBER
%SE_LOOK4_ALPHA       = %SE_TOKEN_ALPHA
%SE_LOOK4_STRING      = %SE_TOKEN_STRING
%SE_LOOK4_EOL         = %SE_TOKEN_EOL

%SE_LOOK4_COMMA       = %ASCII_COMMA
%SE_LOOK4_EQUAL       = %ASCII_EQUAL
%SE_LOOK4_PAROPEN     = %ASCII_PARENTHESES_OPEN
%SE_LOOK4_PARCLOSE    = %ASCII_PARENTHESES_CLOSE
%SE_LOOK4_SEMICOLON   = %ASCII_SEMICOLON

%SE_LOOK4_IF          = 00000200
%SE_LOOK4_MATCHPAR    = 00000201
%SE_LOOK4_THEN        = %SE_TOKENCMD_THEN  '00000202
%SE_LOOK4_ELSEIF      = 00000208
%SE_LOOK4_ELSE        = 00000210
%SE_LOOK4_ENDIF       = 00000211
%SE_LOOK4_DO          = 00000212
%SE_LOOK4_LOOP        = 00000214
%SE_LOOK4_WHILE       = 00000215
%SE_LOOK4_WEND        = 00000216
%SE_LOOK4_FOR         = 00000217
%SE_LOOK4_NEXT        = 00000218
%SE_LOOK4_FUNCTION    = 00000219
%SE_LOOK4_ENDFUNC     = 00000220
%SE_LOOK4_ENDSEL      = 00000221
%SE_LOOK4_LABEL       = 00000222
%SE_LOOK4_DOWHILE     = %SE_TOKENCMD_WHILE '00000223
%SE_LOOK4_DOUNTIL     = %SE_TOKENCMD_UNTIL '00000224
%SE_LOOK4_TO          = %SE_TOKENCMD_TO
%SE_LOOK4_STEP        = %SE_TOKENCMD_STEP

'math stack constants
%SE_EVAL_STACK        = 0
%SE_EVAL_OUTPT        = 1
%SE_EVAL_PRECE        = 2
%SE_EVAL_OTYPE        = 3
%SE_EVAL_STYPE        = 4

Type se_token_type
     tktype     As Word
     token      As Asciiz * %SE_MAXTOKENLEN
     addrs      As Dword
End Type

Type se_codetoken
     token      As Dword               'token address, if any
     lncnt      As Word                'source code line number
     secnt      As Byte                'statement counter
     tktype     As Byte                '%SE_TOKEN_xxx or ascii delimiter
     cmd        As Dword               '%SE_TOKENCMD_xxx and function definition
     arg1       As Dword               'arguments by context
     arg2       As Dword               '
     arg3       As Dword               '
     arg4       As Dword               '
     pre        As Single              '
End Type

Union numbers_union
     dwd        As Dword               'used to convert types
     sng        As Single              '
     lng        As Long                '
End Union

Type ses_type                          'main program struct, this one carry all pointers
     tk         As se_token_type Ptr   'tokens ptr
     ct         As se_codetoken Ptr    'codetokens ptr
     tks        As Dword               'tokens count
     ctks       As Dword               'codetokens count
     pc         As Dword               'program counter
     msp        As Dword               'math stack address
     errcode    As Dword               'lasterror
     nvarsn     As Dword Ptr           'points to numeric vars names array
     svarsn     As Dword Ptr           'points to string vars names array
     nvars      As Single Ptr          'points to numeric vars contents array
     svars      As String Ptr          'points to string vars contents array
     ubn        As Long                'ubound numeric vars array
     ubs        As Long                'ubound string vars array
End Type

#Include "se_errors.inc"

Declare Function lookfor(ByVal ses As ses_type Ptr, ByVal start As Long, ByVal match As Dword) As Dword
Declare Function processnumber(ByVal ses As ses_type Ptr, ByVal start As Long, ByVal ends As Long) As Single
Declare Function processstring(ByVal ses As ses_type Ptr, ByVal start As Long, ByVal ends As Long) As String
Declare Function funtext(Code As Long) As String
Declare Function prtcode(ByVal ses As ses_type Ptr, ByVal start As Long, ByVal ends As Long) As Dword
Declare Function fundefs(Code As String) As Long
Declare Function argtypetext(Code As Dword) As String
Declare Function execfun(ByVal ses As ses_type Ptr) As Dword

'debug helper macro
Macro ifdbgx(x)
#If %DEBUG_FLAG
x
#EndIf
End Macro

'adds double quotes
Macro pdq(stext) = $Dq + stext + $Dq

'extracts double quotes
Function extdq(stext As String) As String
    Local stmp1 As String
    stmp1 = Trim$(stext)
    If Left$(stmp1, 1) = $Dq Then stmp1 = Mid$(stmp1, 2)
    If Right$(stmp1, 1) = $Dq Then stmp1 = Left$(stmp1, Len(stmp1) - 1)
    Function = stmp1
End Function

'takes an argument type code and returns a descriptive string, for debug
Function argtypetext2(Code As Dword) As String
         If IsTrue(Code And %SE_FDEF_RETNUM) Then
             Function = "%SE_ARGTYPE_RETNUM": Exit Function
         ElseIf IsTrue(Code And %SE_FDEF_RETSTR) Then
             Function = "%SE_ARGTYPE_RETSTR": Exit Function
         End If
End Function

'takes an argument type code and returns a descriptive string, for debug
Function argtypetext(Code As Dword) As String
         Local stmp1 As String
         If IsTrue(Code And %SE_FDEF_OPERATOR) Then
            If IsTrue(Code And %SE_FDEF_RETNUM) Then
                Function = "%SE_ARGTYPE_EXPNUM": Exit Function
            ElseIf IsTrue(Code And %SE_FDEF_RETSTR) Then
                Function = "%SE_ARGTYPE_EXPSTR": Exit Function
            End If
         End If
         If IsTrue(Code And %SE_ARGTYPE_VARNUM) Then
             Function = "%SE_ARGTYPE_VARNUM": Exit Function
         ElseIf IsTrue(Code And %SE_ARGTYPE_VARSTR) Then
             Function = "%SE_ARGTYPE_VARSTR": Exit Function
         End If
         If IsTrue(Code And %SE_ARGTYPE_CONNUM) Then
             Function = "%SE_ARGTYPE_CONNUM": Exit Function
         ElseIf IsTrue(Code And %SE_ARGTYPE_CONSTR) Then
             Function = "%SE_ARGTYPE_CONSTR": Exit Function
         End If
         If IsTrue(Code And %SE_ARGTYPE_BINNUM) Then
             Function = "%SE_ARGTYPE_BINNUM": Exit Function
         ElseIf IsTrue(Code And %SE_ARGTYPE_BINSTR) Then
             Function = "%SE_ARGTYPE_BINSTR": Exit Function
         End If
         If IsTrue(Code And %SE_ARGTYPE_USRNUM) Then
             Function = "%SE_ARGTYPE_USRNUM": Exit Function
         ElseIf IsTrue(Code And %SE_ARGTYPE_USRSTR) Then
             Function = "%SE_ARGTYPE_USRSTR": Exit Function
         End If
         If IsFalse(Len(stmp1)) Then Function = "%SE_ARGTYPE_UNKNOW"
End Function

'takes an argument type code and returns a descriptive string, for debug
Function typearg(ByVal fun As Dword) As Dword
      If ((fun And %SE_FDEF_RETNUM) = %SE_FDEF_RETNUM) Then
          Function = %SE_FDEF_RETNUM
      ElseIf ((fun And %SE_FDEF_RETSTR) = %SE_FDEF_RETSTR) Then
          Function = %SE_FDEF_RETSTR
      ElseIf ((fun And %SE_FDEF_RETNOT) = %SE_FDEF_RETNOT) Then
          Function = %SE_FDEF_RETNOT
      ElseIf isnumvar(fun) Then
          Function = %SE_FDEF_RETNUM
      End If
End Function

Function checkarg(ByVal ses As ses_type Ptr, ByVal startin As Long, ByVal arg As Long) As Dword
    Local Count, tmp1, tmp2, start As Long, result, parflag, alpha, level As Dword
    dbcprint("     CheckArg In : [" + Format$(startin) + "-" + Format$(arg) + "]")
    start = startin

    'I always get confussed with many stacked parenthessis...
    'fff[((2+4)+fun(2,5)), 3]     fun[(((((fun(x, fun(2)))))))]            nada str str
    '    ((2+4)+fun(2,5))              ((((fun(x, fun(2))))))              nada num num
    '     (2+4)+fun(2,5)                (((fun(x, fun(2)))))               num  num num
    '                                    ((fun(x, fun(2))))                num  str error
    '                                     (fun(x, fun(2)))                 str  num error
    '                                      fun(x, fun(2))                  str  str str

    Incr Count
    While (Count < arg)
          start = lookfor(ses, start + 1, %SE_LOOK4_COMMA)
          If start Then Incr Count Else Exit Do
    Wend
    start = IIf&(start, start, startin)

    Do
          Incr start
          Select Case @ses.@ct[start].tktype
                 Case %ASCII_PARENTHESES_OPEN
                      Incr parflag
                 Case %ASCII_PARENTHESES_CLOSE
                      Decr parflag
                      If (parflag < 0) Then
                         dbcprint("     CheckArg out: 1")
                         Exit Function   'syntax error
                      End If
                 Case %SE_TOKEN_STRING
                      If IsFalse(result) Then
                         result = %SE_ARGTYPE_EXPSTR
                      ElseIf (typearg(result) <> %SE_FDEF_RETSTR) Then
                         dbcprint("     CheckArg out: 2")
                         Exit Function   'type mismatch
                      End If
                 Case %SE_TOKEN_NUMBER
                      If IsFalse(result) Then
                         result = %SE_ARGTYPE_EXPNUM
                      ElseIf (typearg(result) <> %SE_FDEF_RETNUM) Then
                         dbcprint("     CheckArg out: 3")
                         Exit Function   'type mismatch
                      End If
                 Case %SE_TOKEN_ALPHA
                      If IsFalse(result) Then
                         result = Switch&((typearg(@ses.@ct[start].cmd) = %SE_FDEF_RETNUM), %SE_ARGTYPE_EXPNUM, (typearg(@ses.@ct[start].cmd) = %SE_FDEF_RETSTR), %SE_ARGTYPE_EXPSTR)
                      ElseIf (typearg(result) <> typearg(@ses.@ct[start].cmd)) Then
                         dbcprint("     CheckArg out: 4")
                         Exit Function   'type mismatch
                      End If
                      If funargs(@ses.@ct[start].cmd) Then
                         If parargs(@ses.@ct[start].cmd) Then
                            start = @ses.@ct[start].arg2
                         'else
                         '   dbcprint("     CheckArg out: 5")
                         '   EXIT FUNCTION
                         End If
                      End If
                 Case %ASCII_COMMA
                      If IsFalse(parflag) Then
                         dbcprint("     CheckArg out: 6")
                         Exit Do         'finished
                      End If
                 Case %SE_TOKEN_EOL
                      dbcprint("     CheckArg out: 7")
                      Exit Do            'finished
          End Select
    Loop While (start < @ses.@ct[start].arg2)

    Function = result
    dbcprint("     CheckArg out: start [" +  Format$(startin) + "] found[" + Format$(start) + "-" + Format$(arg) + "] result " + argtypetext2(result))
End Function

'takes argument arg, solve it and return the result as single   (n1, n2,...)
Function procargn(ByVal ses As ses_type Ptr, ByVal start As Long, ByVal arg As Long) As Single
    ifdbgx(Trace Print FuncName$)
    ifdbgx(Trace Print CallStk$(1))
    Local Count, tmp1 As Long
    dbcprint("     procargN In : [" + Format$(start) + "-" + Format$(0) + "]")
    Incr start
    Do
         tmp1 = lookfor(ses, start, %SE_LOOK4_COMMA)
         Incr Count
         If (Count = arg) Then Exit Do
         Incr tmp1
         start = tmp1
    Loop While tmp1
    dbcprint("     procargN out: [" + Format$(start) + "-" + Format$(tmp1 - 1) + "]")
    If tmp1 Then
       Function = processnumber(ses, start, tmp1 - 1)
    End If
End Function

'takes argument arg, solve it and return the result as string    (st1, st2,...)
Function procargs(ByVal ses As ses_type Ptr, ByVal start As Long, ByVal arg As Long) As String
    ifdbgx(Trace Print FuncName$)
    ifdbgx(Trace Print CallStk$(1))
    Local Count, tmp1 As Long
    dbcprint("     procargS In : [" + Format$(start) + "-" + Format$(0) + "]")
    Incr start
    Do
         tmp1 = lookfor(ses, start, %SE_LOOK4_COMMA)
         Incr Count
         If (Count = arg) Then Exit Do
         Incr tmp1
         start = tmp1
    Loop While tmp1
    dbcprint("     procargS out: [" + Format$(start) + "-" + Format$(tmp1 - 1) + "]")
    If tmp1 Then
       Function = processstring(ses, start, tmp1 - 1)
    End If
End Function

'This function call itself to solve arguments
'but the math engine is not recursive. Expression is
'converted to postfix then solved without recursion.
'A stack is constructed using a little array and pointers.
'Operators precedence is set in tokenizer function (can be changed)
Function processnumber(ByVal ses As ses_type Ptr, ByVal start As Long, ByVal ends As Long) As Single
    ifdbgx(Trace Print FuncName$)
    ifdbgx(Trace Print CallStk$(1))
    Local Count As Long
    Local tmp1, tmp2, xpc As Long, ido, ids As Long, result, sgn1, sgn2 As Single
    Local sp As Single Ptr
    sp = @ses.msp
    Count = ends - start
    dbcprint("     processnumber start-ends: [" + Format$(start) + "-" + Format$(ends) + "]")
    If (Count < 0) Then
       dbcprint("     processnumber Result: nothing to do")
       Exit Function
    End If
    If Count > %SE_MAXEXPRLEN Then
       'dbcprint("err expression too long/complex")
       @ses.errcode = %SE_ERROR_EXPRTOOCOMPLEX
       dbcprint(se_errortext(ses))
       tprint se_errortext(ses)
       Exit Function
    End If
    @sp[%SE_EVAL_PRECE Of 4, ids Of %SE_MAXEXPRLEN] = 1000
    For xpc = start To ends                 'replace vars, solve built in functions, store in postfix
        tmp1 = @ses.@ct[xpc].arg1
        tmp2 = @ses.@ct[xpc].arg2
        Select Case As Long @ses.@ct[xpc].tktype
               Case %SE_TOKEN_NUMBER        'push to output
                      If (Count = 0) Then
                         ifdbgx(result = @ses.@ct[xpc].pre)
                         dbcprint("     processnumber Result value: " + Format$(result))
                         Function = @ses.@ct[xpc].pre: Exit Function
                      End If
                      @sp[%SE_EVAL_OUTPT Of 4, ido Of %SE_MAXEXPRLEN] = @ses.@ct[xpc].pre
                      @sp[%SE_EVAL_OTYPE Of 4, ido Of %SE_MAXEXPRLEN] = %SE_TOKENCMD_PRENUM
                      Incr ido
               Case %SE_TOKEN_ALPHA         'push to output
                    Select Case As Long @ses.@ct[xpc].cmd
                           Case %SE_TOKENCMD_GNUMVAR
                                @sp[%SE_EVAL_OUTPT Of 4, ido Of %SE_MAXEXPRLEN] = @ses.@nvars[@ses.@ct[xpc].arg1]
                                @sp[%SE_EVAL_OTYPE Of 4, ido Of %SE_MAXEXPRLEN] = %SE_TOKENCMD_PRENUM
                                Incr ido
                           Case %SE_TOKENCMD_GSTRVAR
                                @ses.errcode = %SE_ERROR_NUMEXPECTED
                                Exit Select
                           Case %SE_TOKENCMD_ISTRUE
                                @sp[%SE_EVAL_OUTPT Of 4, ido Of %SE_MAXEXPRLEN] = IsTrue(processnumber(ses, tmp1 + 1, tmp2 - 1))
                                @sp[%SE_EVAL_OTYPE Of 4, ido Of %SE_MAXEXPRLEN] = %SE_TOKENCMD_PRENUM
                                Incr ido
                           Case %SE_TOKENCMD_ISFALSE
                                @sp[%SE_EVAL_OUTPT Of 4, ido Of %SE_MAXEXPRLEN] = IsFalse(processnumber(ses, tmp1 + 1, tmp2 - 1))
                                @sp[%SE_EVAL_OTYPE Of 4, ido Of %SE_MAXEXPRLEN] = %SE_TOKENCMD_PRENUM
                                Incr ido
                           Case %SE_TOKENCMD_NOT
                                @sp[%SE_EVAL_OUTPT Of 4, ido Of %SE_MAXEXPRLEN] = Not(processnumber(ses, tmp1 + 1, tmp2 - 1))
                                @sp[%SE_EVAL_OTYPE Of 4, ido Of %SE_MAXEXPRLEN] = %SE_TOKENCMD_PRENUM
                                Incr ido
                           Case %SE_TOKENCMD_INSTR
                                @sp[%SE_EVAL_OUTPT Of 4, ido Of %SE_MAXEXPRLEN] = InStr(procargn(ses, tmp1, 1), procargs(ses, tmp1, 2), procargs(ses, tmp1, 3))
                                @sp[%SE_EVAL_OTYPE Of 4, ido Of %SE_MAXEXPRLEN] = %SE_TOKENCMD_PRENUM
                                Incr ido
                           Case %SE_TOKENCMD_LEN
                                @sp[%SE_EVAL_OUTPT Of 4, ido Of %SE_MAXEXPRLEN] = Len(processstring(ses, tmp1 + 1, tmp2 - 1))
                                @sp[%SE_EVAL_OTYPE Of 4, ido Of %SE_MAXEXPRLEN] = %SE_TOKENCMD_PRENUM
                                Incr ido
                           Case %SE_TOKENCMD_VAL
                                @sp[%SE_EVAL_OUTPT Of 4, ido Of %SE_MAXEXPRLEN] = Val(processstring(ses, tmp1 + 1, tmp2 - 1))
                                @sp[%SE_EVAL_OTYPE Of 4, ido Of %SE_MAXEXPRLEN] = %SE_TOKENCMD_PRENUM
                                Incr ido
                           Case %SE_TOKENCMD_ASC
                                @sp[%SE_EVAL_OUTPT Of 4, ido Of %SE_MAXEXPRLEN] = Asc(processstring(ses, tmp1 + 1, tmp2 - 1))
                                @sp[%SE_EVAL_OTYPE Of 4, ido Of %SE_MAXEXPRLEN] = %SE_TOKENCMD_PRENUM
                                Incr ido
                           Case %SE_TOKENCMD_EVEN
                                @sp[%SE_EVAL_OUTPT Of 4, ido Of %SE_MAXEXPRLEN] = (1 And (processnumber(ses, tmp1 + 1, tmp2 - 1)))
                                @sp[%SE_EVAL_OTYPE Of 4, ido Of %SE_MAXEXPRLEN] = %SE_TOKENCMD_PRENUM
                                Incr ido
                           Case %SE_TOKENCMD_ABS
                                @sp[%SE_EVAL_OUTPT Of 4, ido Of %SE_MAXEXPRLEN] = Abs(processnumber(ses, tmp1 + 1, tmp2 - 1))
                                @sp[%SE_EVAL_OTYPE Of 4, ido Of %SE_MAXEXPRLEN] = %SE_TOKENCMD_PRENUM
                                Incr ido
                           Case %SE_TOKENCMD_INT
                                @sp[%SE_EVAL_OUTPT Of 4, ido Of %SE_MAXEXPRLEN] = Int(processnumber(ses, tmp1 + 1, tmp2 - 1))
                                @sp[%SE_EVAL_OTYPE Of 4, ido Of %SE_MAXEXPRLEN] = %SE_TOKENCMD_PRENUM
                                Incr ido
                           Case %SE_TOKENCMD_SGN
                                @sp[%SE_EVAL_OUTPT Of 4, ido Of %SE_MAXEXPRLEN] = Sgn(processnumber(ses, tmp1 + 1, tmp2 - 1))
                                @sp[%SE_EVAL_OTYPE Of 4, ido Of %SE_MAXEXPRLEN] = %SE_TOKENCMD_PRENUM
                                Incr ido
                           Case %SE_TOKENCMD_FRAC
                                @sp[%SE_EVAL_OUTPT Of 4, ido Of %SE_MAXEXPRLEN] = Frac(processnumber(ses, tmp1 + 1, tmp2 - 1))
                                @sp[%SE_EVAL_OTYPE Of 4, ido Of %SE_MAXEXPRLEN] = %SE_TOKENCMD_PRENUM
                                Incr ido
                           Case %SE_TOKENCMD_FIX
                                @sp[%SE_EVAL_OUTPT Of 4, ido Of %SE_MAXEXPRLEN] = Fix(processnumber(ses, tmp1 + 1, tmp2 - 1))
                                @sp[%SE_EVAL_OTYPE Of 4, ido Of %SE_MAXEXPRLEN] = %SE_TOKENCMD_PRENUM
                                Incr ido
                           Case %SE_TOKENCMD_CEIL
                                @sp[%SE_EVAL_OUTPT Of 4, ido Of %SE_MAXEXPRLEN] = Ceil(processnumber(ses, tmp1 + 1, tmp2 - 1))
                                @sp[%SE_EVAL_OTYPE Of 4, ido Of %SE_MAXEXPRLEN] = %SE_TOKENCMD_PRENUM
                                Incr ido
                           Case %SE_TOKENCMD_EXP
                                @sp[%SE_EVAL_OUTPT Of 4, ido Of %SE_MAXEXPRLEN] = Exp(processnumber(ses, tmp1 + 1, tmp2 - 1))
                                @sp[%SE_EVAL_OTYPE Of 4, ido Of %SE_MAXEXPRLEN] = %SE_TOKENCMD_PRENUM
                                Incr ido
                           Case %SE_TOKENCMD_EXP2
                                @sp[%SE_EVAL_OUTPT Of 4, ido Of %SE_MAXEXPRLEN] = Exp2(processnumber(ses, tmp1 + 1, tmp2 - 1))
                                @sp[%SE_EVAL_OTYPE Of 4, ido Of %SE_MAXEXPRLEN] = %SE_TOKENCMD_PRENUM
                                Incr ido
                           Case %SE_TOKENCMD_EXP10
                                @sp[%SE_EVAL_OUTPT Of 4, ido Of %SE_MAXEXPRLEN] = Exp10(processnumber(ses, tmp1 + 1, tmp2 - 1))
                                @sp[%SE_EVAL_OTYPE Of 4, ido Of %SE_MAXEXPRLEN] = %SE_TOKENCMD_PRENUM
                                Incr ido
                           Case %SE_TOKENCMD_COS
                                @sp[%SE_EVAL_OUTPT Of 4, ido Of %SE_MAXEXPRLEN] = Cos(processnumber(ses, tmp1 + 1, tmp2 - 1))
                                @sp[%SE_EVAL_OTYPE Of 4, ido Of %SE_MAXEXPRLEN] = %SE_TOKENCMD_PRENUM
                                Incr ido
                           Case %SE_TOKENCMD_ATN
                                @sp[%SE_EVAL_OUTPT Of 4, ido Of %SE_MAXEXPRLEN] = Atn(processnumber(ses, tmp1 + 1, tmp2 - 1))
                                @sp[%SE_EVAL_OTYPE Of 4, ido Of %SE_MAXEXPRLEN] = %SE_TOKENCMD_PRENUM
                                Incr ido
                           Case %SE_TOKENCMD_SIN
                                @sp[%SE_EVAL_OUTPT Of 4, ido Of %SE_MAXEXPRLEN] = Sin(processnumber(ses, tmp1 + 1, tmp2 - 1))
                                @sp[%SE_EVAL_OTYPE Of 4, ido Of %SE_MAXEXPRLEN] = %SE_TOKENCMD_PRENUM
                                Incr ido
                           Case %SE_TOKENCMD_TAN
                                @sp[%SE_EVAL_OUTPT Of 4, ido Of %SE_MAXEXPRLEN] = Tan(processnumber(ses, tmp1 + 1, tmp2 - 1))
                                @sp[%SE_EVAL_OTYPE Of 4, ido Of %SE_MAXEXPRLEN] = %SE_TOKENCMD_PRENUM
                                Incr ido
                           Case %SE_TOKENCMD_SQR
                                @sp[%SE_EVAL_OUTPT Of 4, ido Of %SE_MAXEXPRLEN] = Sqr(processnumber(ses, tmp1 + 1, tmp2 - 1))
                                @sp[%SE_EVAL_OTYPE Of 4, ido Of %SE_MAXEXPRLEN] = %SE_TOKENCMD_PRENUM
                                Incr ido
                           Case %SE_TOKENCMD_LOG
                                @sp[%SE_EVAL_OUTPT Of 4, ido Of %SE_MAXEXPRLEN] = Log(processnumber(ses, tmp1 + 1, tmp2 - 1))
                                @sp[%SE_EVAL_OTYPE Of 4, ido Of %SE_MAXEXPRLEN] = %SE_TOKENCMD_PRENUM
                                Incr ido
                           Case %SE_TOKENCMD_LOG2
                                @sp[%SE_EVAL_OUTPT Of 4, ido Of %SE_MAXEXPRLEN] = Log2(processnumber(ses, tmp1 + 1, tmp2 - 1))
                                @sp[%SE_EVAL_OTYPE Of 4, ido Of %SE_MAXEXPRLEN] = %SE_TOKENCMD_PRENUM
                                Incr ido
                           Case %SE_TOKENCMD_LOG10
                                @sp[%SE_EVAL_OUTPT Of 4, ido Of %SE_MAXEXPRLEN] = Log10(processnumber(ses, tmp1 + 1, tmp2 - 1))
                                @sp[%SE_EVAL_OTYPE Of 4, ido Of %SE_MAXEXPRLEN] = %SE_TOKENCMD_PRENUM
                                Incr ido
                           Case %SE_TOKENCMD_RND
                                @sp[%SE_EVAL_OUTPT Of 4, ido Of %SE_MAXEXPRLEN] = Rnd(procargn(ses, tmp1, 1), procargn(ses, tmp1, 2))
                                @sp[%SE_EVAL_OTYPE Of 4, ido Of %SE_MAXEXPRLEN] = %SE_TOKENCMD_PRENUM
                                Incr ido
                           Case %SE_TOKENCMD_PI
                                @sp[%SE_EVAL_OUTPT Of 4, ido Of %SE_MAXEXPRLEN] = Atn(1) * 4
                                @sp[%SE_EVAL_OTYPE Of 4, ido Of %SE_MAXEXPRLEN] = %SE_TOKENCMD_PRENUM
                                Incr ido
                           Case %SE_TOKENCMD_PRGLINES
                                @sp[%SE_EVAL_OUTPT Of 4, ido Of %SE_MAXEXPRLEN] = @ses.@ct[@ses.ctks].lncnt
                                @sp[%SE_EVAL_OTYPE Of 4, ido Of %SE_MAXEXPRLEN] = %SE_TOKENCMD_PRENUM
                                Incr ido
                           Case %SE_TOKENCMD_FAC      'factorial, arbitrary 50 limit
                                sgn1 = processnumber(ses, tmp1 + 1, tmp2 - 1)
                                If (sgn1 > 50) Then
                                   @ses.errcode = %SE_ERROR_OVERFLOW
                                   Exit Function
                                End If
                                result = 1
                                For sgn2 = 1 To sgn1
                                    result = result * sgn2
                                Next
                                @sp[%SE_EVAL_OUTPT Of 4, ido Of %SE_MAXEXPRLEN] = result
                                @sp[%SE_EVAL_OTYPE Of 4, ido Of %SE_MAXEXPRLEN] = %SE_TOKENCMD_PRENUM
                                Incr ido
                           Case %SE_TOKENCMD_TIMER
                                @sp[%SE_EVAL_OUTPT Of 4, ido Of %SE_MAXEXPRLEN] =  Timer
                                @sp[%SE_EVAL_OTYPE Of 4, ido Of %SE_MAXEXPRLEN] = %SE_TOKENCMD_PRENUM
                                Incr ido
                           Case %SE_TOKENCMD_RND
                           Case Else
                                @ses.errcode = %SE_ERROR_NUMEXPECTED
                    End Select
                    If ((ido = 1) And IsFalse(Count)) Then   'if no operand, exit
                       dbcprint("     processnumber Result value: " + Format$(@sp[%SE_EVAL_OUTPT Of 4, ido - 1 Of %SE_MAXEXPRLEN]))
                       Function = @sp[%SE_EVAL_OUTPT Of 4, ido - 1 Of %SE_MAXEXPRLEN]
                       Exit Function
                    End If
               Case %ASCII_PARENTHESES_OPEN         'push to stack
                    @sp[%SE_EVAL_STYPE Of 4, ids Of %SE_MAXEXPRLEN] = @ses.@ct[xpc].tktype
                    @sp[%SE_EVAL_STACK Of 4, ids Of %SE_MAXEXPRLEN] = @ses.@ct[xpc].tktype
                    @sp[%SE_EVAL_PRECE Of 4, ids Of %SE_MAXEXPRLEN] = @ses.@ct[xpc].arg1
                    Incr ids
               Case %ASCII_PARENTHESES_CLOSE        'pop stack to output until ( then discard both
                    If ids Then
                       Decr ids
                       While (ids And (@sp[%SE_EVAL_STACK Of 4, ids Of %SE_MAXEXPRLEN] <> %ASCII_PARENTHESES_OPEN))
                             @sp[%SE_EVAL_OUTPT Of 4, ido Of %SE_MAXEXPRLEN] = @sp[%SE_EVAL_STACK Of 4, ids Of %SE_MAXEXPRLEN]
                             @sp[%SE_EVAL_OTYPE Of 4, ido Of %SE_MAXEXPRLEN] = @sp[%SE_EVAL_STYPE Of 4, ids Of %SE_MAXEXPRLEN]
                             Incr ido
                             Decr ids
                       Wend                         'ids = (
                    Else
                       @ses.errcode = %SE_ERROR_PAROPENEEXPECTED
                    End If
               Case > %ASCII_SPACE                  'operator
                      While ((ido < %SE_MAXEXPRLEN) And (ids > 0) And (@ses.@ct[xpc].arg1 <= @sp[%SE_EVAL_PRECE Of 4, ids - 1 Of %SE_MAXEXPRLEN]))
                            Decr ids                'pop to output
                            @sp[%SE_EVAL_OUTPT Of 4, ido Of %SE_MAXEXPRLEN] = @sp[%SE_EVAL_STACK Of 4, ids Of %SE_MAXEXPRLEN]
                            @sp[%SE_EVAL_OTYPE Of 4, ido Of %SE_MAXEXPRLEN] = @sp[%SE_EVAL_STYPE Of 4, ids Of %SE_MAXEXPRLEN]
                            Incr ido
                      Wend                          'then push
                      @sp[%SE_EVAL_STACK Of 4, ids Of %SE_MAXEXPRLEN] = @ses.@ct[xpc].tktype
                      @sp[%SE_EVAL_PRECE Of 4, ids Of %SE_MAXEXPRLEN] = @ses.@ct[xpc].arg1
                      @sp[%SE_EVAL_STYPE Of 4, ids Of %SE_MAXEXPRLEN] = @ses.@ct[xpc].tktype
                      Incr ids
        End Select
    Next

    'just to see how it goes
    #If %DEBUG_FLAG
    Local stmp1, stmp2, stmp3 As String
    stmp2 = ""
    For tmp1 = start To ends
        Select Case As Long @ses.@ct[tmp1].tktype
               Case %SE_TOKEN_UNDEFINED
               Case %SE_TOKEN_NUMBER
                    stmp2 = stmp2 + "N"
                    stmp3 = stmp3 + Format$(@ses.@ct[tmp1].pre)
               Case %SE_TOKEN_ALPHA
                    If (@ses.@ct[tmp1].cmd = %SE_TOKENCMD_PRENUM) Then
                       stmp2 = stmp2 + "F"
                       stmp3 = stmp3 + Format$(@ses.@ct[tmp1].pre)
                    ElseIf (@ses.@ct[tmp1].cmd = %SE_TOKENCMD_GNUMVAR) Then
                       stmp2 = stmp2 + "V"
                       stmp3 = stmp3 + Format$(@ses.@ct[tmp1].arg1) + " val[" + Format$(@ses.@nvars[@ses.@ct[tmp1].arg1]) + "]"
                    End If
               Case Else
                    stmp2 = stmp2 + Chr$(@ses.@ct[tmp1].tktype)
                    stmp3 = stmp3 + Chr$(@ses.@ct[tmp1].tktype)
        End Select
    Next
    #EndIf

    While (ids > 0)    'pop all stack to output
          Decr ids
          @sp[%SE_EVAL_OUTPT Of 4, ido Of %SE_MAXEXPRLEN] = @sp[%SE_EVAL_STACK Of 4, ids Of %SE_MAXEXPRLEN]
          @sp[%SE_EVAL_OTYPE Of 4, ido Of %SE_MAXEXPRLEN] = @sp[%SE_EVAL_STYPE Of 4, ids Of %SE_MAXEXPRLEN]
          Incr ido
    Wend

    'all expression is on output stack in postfix format now, so try to solve

    'postfix solver, pseudocode from wiki (?)
    'a real asm stack would be nicer and faster
    'while more tokens (operands or operators) to read
    '    Read next token
    '    if token is an operand
    '        Push token onto stack
    '    else if token is an operator ("op", say)
    '        Pop stack and put value in temp2
    '        Pop stack and put value in temp1
    '        Push the value of temp1 op temp2 back onto stack
    '    endif
    'endwhile
    'Pop value from stack and return it

    ifdbgx(stmp1 = "")
    Decr ido
    For tmp1 = 0 To ido
        Select Case As Long @sp[%SE_EVAL_OTYPE Of 4, tmp1 Of %SE_MAXEXPRLEN]
               Case %SE_TOKENCMD_PRENUM
                    'a operand, push to stack
                    ifdbgx(stmp1 = stmp1 + Format$(@sp[%SE_EVAL_OUTPT Of 4, tmp1 Of %SE_MAXEXPRLEN]))
                    @sp[%SE_EVAL_STACK Of 4, ids Of %SE_MAXEXPRLEN] = @sp[%SE_EVAL_OUTPT Of 4, tmp1 Of %SE_MAXEXPRLEN]
                    @sp[%SE_EVAL_STYPE Of 4, ids Of %SE_MAXEXPRLEN] = @sp[%SE_EVAL_OTYPE Of 4, tmp1 Of %SE_MAXEXPRLEN]
                    Incr ids
               Case > %ASCII_SPACE
                    '> SPACE = operator, pop two operands, do the math and push result
                    ifdbgx(stmp1 = stmp1 + Chr$(@sp[%SE_EVAL_OUTPT Of 4, tmp1 Of %SE_MAXEXPRLEN]))
                    Decr ids
                    result = @sp[%SE_EVAL_STACK Of 4, ids - 1 Of %SE_MAXEXPRLEN]
                    Select Case As Const @sp[%SE_EVAL_OTYPE Of 4, tmp1 Of %SE_MAXEXPRLEN]
                           Case %ASCII_EQUAL              'operator =
                                @sp[%SE_EVAL_STACK Of 4, ids - 1 Of %SE_MAXEXPRLEN] = result = @sp[%SE_EVAL_STACK Of 4, ids Of %SE_MAXEXPRLEN]
                           Case %ASCII_PLUS               'operator +
                                @sp[%SE_EVAL_STACK Of 4, ids - 1 Of %SE_MAXEXPRLEN] = result + @sp[%SE_EVAL_STACK Of 4, ids Of %SE_MAXEXPRLEN]
                           Case %ASCII_MINUS              'operator -
                                @sp[%SE_EVAL_STACK Of 4, ids - 1 Of %SE_MAXEXPRLEN] = result - @sp[%SE_EVAL_STACK Of 4, ids Of %SE_MAXEXPRLEN]
                           Case %ASCII_MUL                'operator *
                                @sp[%SE_EVAL_STACK Of 4, ids - 1 Of %SE_MAXEXPRLEN] = result * @sp[%SE_EVAL_STACK Of 4, ids Of %SE_MAXEXPRLEN]
                           Case %ASCII_INTDIV             'operator /
                                @sp[%SE_EVAL_STACK Of 4, ids - 1 Of %SE_MAXEXPRLEN] = result \ @sp[%SE_EVAL_STACK Of 4, ids Of %SE_MAXEXPRLEN]
                           Case %ASCII_DIV                'operator /
                                @sp[%SE_EVAL_STACK Of 4, ids - 1 Of %SE_MAXEXPRLEN] = result / @sp[%SE_EVAL_STACK Of 4, ids Of %SE_MAXEXPRLEN]
                           Case %ASCII_CARET              'operator ^
                                @sp[%SE_EVAL_STACK Of 4, ids - 1 Of %SE_MAXEXPRLEN] = result ^ @sp[%SE_EVAL_STACK Of 4, ids Of %SE_MAXEXPRLEN]
                           Case %ASCII_LESS               'operator <
                                @sp[%SE_EVAL_STACK Of 4, ids - 1 Of %SE_MAXEXPRLEN] = result < @sp[%SE_EVAL_STACK Of 4, ids Of %SE_MAXEXPRLEN]
                           Case %ASCII_MORE               'operator >
                                @sp[%SE_EVAL_STACK Of 4, ids - 1 Of %SE_MAXEXPRLEN] = result > @sp[%SE_EVAL_STACK Of 4, ids Of %SE_MAXEXPRLEN]
                           Case %ASCII_LCASE_A            'operator <>
                                @sp[%SE_EVAL_STACK Of 4, ids - 1 Of %SE_MAXEXPRLEN] = result <> @sp[%SE_EVAL_STACK Of 4, ids Of %SE_MAXEXPRLEN]
                           Case %ASCII_LCASE_B            'operator <=
                                @sp[%SE_EVAL_STACK Of 4, ids - 1 Of %SE_MAXEXPRLEN] = result <= @sp[%SE_EVAL_STACK Of 4, ids Of %SE_MAXEXPRLEN]
                           Case %ASCII_LCASE_C            'operator =>
                                @sp[%SE_EVAL_STACK Of 4, ids - 1 Of %SE_MAXEXPRLEN] = result => @sp[%SE_EVAL_STACK Of 4, ids Of %SE_MAXEXPRLEN]
                           Case %ASCII_LCASE_M            'operator MOD
                                @sp[%SE_EVAL_STACK Of 4, ids - 1 Of %SE_MAXEXPRLEN] = result Mod @sp[%SE_EVAL_STACK Of 4, ids Of %SE_MAXEXPRLEN]
                           Case %ASCII_AMPER              'operator AND
                                @sp[%SE_EVAL_STACK Of 4, ids - 1 Of %SE_MAXEXPRLEN] = result And @sp[%SE_EVAL_STACK Of 4, ids Of %SE_MAXEXPRLEN]
                           Case %ASCII_OR                 'operator OR
                                @sp[%SE_EVAL_STACK Of 4, ids - 1 Of %SE_MAXEXPRLEN] = result Or @sp[%SE_EVAL_STACK Of 4, ids Of %SE_MAXEXPRLEN]
                           Case %ASCII_LCASE_X            'operator XOR
                                @sp[%SE_EVAL_STACK Of 4, ids - 1 Of %SE_MAXEXPRLEN] = result Xor @sp[%SE_EVAL_STACK Of 4, ids Of %SE_MAXEXPRLEN]
                           Case %ASCII_LCASE_E            'operator EQV
                                @sp[%SE_EVAL_STACK Of 4, ids - 1 Of %SE_MAXEXPRLEN] = result Eqv @sp[%SE_EVAL_STACK Of 4, ids Of %SE_MAXEXPRLEN]
                           Case %ASCII_LCASE_I            'operator IMP
                                @sp[%SE_EVAL_STACK Of 4, ids - 1 Of %SE_MAXEXPRLEN] = result Imp @sp[%SE_EVAL_STACK Of 4, ids Of %SE_MAXEXPRLEN]
                    End Select
        End Select
    Next
    dbcprint("     processnumber Input : " + stmp2 + " [" + stmp3 + "]" + "(" + Format$(start) + "-" + Format$(ends) + ")")
    dbcprint("     processnumber Prefix: " + stmp1)
    If (ids > 1) Then
       @ses.errcode = %SE_ERROR_MATHMODULE
    Else
       'all right, result is first on stack (and should be the only one...)
       result = @sp[%SE_EVAL_STACK Of 4, ids - 1 Of %SE_MAXEXPRLEN]
       dbcprint("     processnumber Result: " + stmp1)
       dbcprint("     processnumber Result value: " + Format$(result))
       Function = result
    End If
End Function

'must improve this one...processes print statement argument
Function processprint(ByVal ses As ses_type Ptr, ByVal start As Long, ByVal ends As Long) As String
    Local Count As Long, stmp1, result As String
    Local tmp1, tmp2, tmp3, xpc, nested, ope As Long, olen As Dword
    Count = ends - start
    dbcprint("     processprint input: (" + Format$(start) + "-" + Format$(ends) + ")"))
    If (Count < 0) Then Exit Function
    tmp1 = start
    tmp3 = %ASCII_COMMA
    ope  = %ASCII_SEMICOLON
    While tmp3
          tmp2 = lookfor(ses, tmp1, %SE_LOOK4_COMMA)
          If IsFalse(tmp2) Then
             tmp2 = lookfor(ses, tmp1, %SE_LOOK4_SEMICOLON)
             tmp3 = %ASCII_SEMICOLON
          End If
          If IsFalse(tmp2) Then
             tmp2 = lookfor(ses, tmp1, %SE_LOOK4_EOL)
             tmp3 = 0
          End If
          stmp1 = processstring(ses, tmp1, tmp2 - 1)
          Select Case As Const ope
                 Case %ASCII_COMMA
                      tmp1 = 10 - olen
                      While (tmp1 < 0)
                        Incr Count
                        tmp1 = (10 * Count) - olen
                      Wend
                      result = result + Space$(tmp1) + extdq(stmp1)
                 Case %ASCII_PLUS, %ASCII_SEMICOLON
                      result = result + extdq(stmp1)
          End Select
          tmp1 = tmp2 + 1
          olen = Len(stmp1)
          ope  = tmp3
    Wend
    dbcprint("     processprint result: " + result)
    Function = result
End Function

'processes an string expression, replaces vars by its values, solves string functions and evaluations
Function processstring(ByVal ses As ses_type Ptr, ByVal start As Long, ByVal ends As Long) As String
    ifdbgx(Trace Print FuncName$)
    ifdbgx(Trace Print CallStk$(1))
    Local Count As Long, stmp1, result, comp As String
    Local tmp1, tmp2, xpc, nested, ope, alpha As Long, plus As Dword
    Count = ends - start
    If (Count < 0) Then Exit Function
    #If %DEBUG_FLAG
    stmp1 = ""
    For xpc = start To ends
        Select Case As Const @ses.@ct[xpc].tktype
               Case %SE_TOKEN_ALPHA
                    Select Case As Long @ses.@ct[xpc].cmd
                           Case %SE_TOKENCMD_GNUMVAR
                                stmp1 = stmp1 + "N"
                           Case %SE_TOKENCMD_GSTRVAR
                                stmp1 = stmp1 + "V"
                           Case Else
                                stmp1 = stmp1 + "F"
                    End Select
               Case %SE_TOKEN_STRING
                    stmp1 = stmp1 + "S"
               Case Else
                    stmp1 = stmp1 + Chr$(@ses.@ct[xpc].tktype)
        End Select
    Next
    dbcprint("     processstring input: [" + stmp1 + "]" + "(" + Format$(start) + "-" + Format$(ends) + ")"))
    #EndIf

    'replace vars and solve built in functions
    For xpc = start To ends
        If ((@ses.@ct[xpc].tktype = %ASCII_PARENTHESES_OPEN) And(alpha))Then
           Incr nested
           Iterate
        ElseIf ((@ses.@ct[xpc].tktype = %ASCII_PARENTHESES_CLOSE) And(alpha)) Then
           Decr nested
           Iterate
        End If
        If (nested = 0) Then
           If plus Then
              Select Case As Const @ses.@ct[xpc].tktype
                     Case %ASCII_SPACE, %SE_TOKEN_UNDEFINED
                     Case %ASCII_PLUS
                          plus = 0
                          alpha = 0
                     Case %ASCII_LESS, %ASCII_MORE, %ASCII_EQUAL, %ASCII_LCASE_A, _
                          %ASCII_LCASE_B, %ASCII_LCASE_C
                          ope = @ses.@ct[xpc].tktype
                          comp = result
                          result = ""
                          plus = 0
                     Case Else
                          @ses.errcode = %SE_ERROR_PLUSEXPECTED
              End Select
           Else
              Select Case As Const @ses.@ct[xpc].tktype
                     Case %SE_TOKEN_ALPHA
                          plus = 1
                          alpha = 1
                          tmp1 = @ses.@ct[xpc].arg1
                          tmp2 = @ses.@ct[xpc].arg2
                          Select Case As Long @ses.@ct[xpc].cmd
                                 Case %SE_TOKENCMD_GNUMVAR
                                      @ses.errcode = %SE_ERROR_STREXPECTED
                                 Case %SE_TOKENCMD_GSTRVAR
                                      dbcprint("     processstring: %SE_TOKENCMD_GSTRVAR " + Format$(xpc) + " " + Format$(@ses.@ct[xpc].arg1) + " " + Format$(@ses.ubs))
                                      stmp1 = @ses.@svars[@ses.@ct[xpc].arg1]
                                      dbcprint("     processstring: %SE_TOKENCMD_GSTRVAR ok " + Format$(xpc) + " " + Format$(@ses.@ct[xpc].arg1) + "[" + stmp1 + "]")
                                      result = result + stmp1
                                      dbcprint("     processstring: %SE_TOKENCMD_GSTRVAR ok " + Format$(xpc) + " " + Format$(@ses.@ct[xpc].arg1))
                                 Case %SE_TOKENCMD_STR
                                      dbcprint("     processstring: %SE_TOKENCMD_STR ")
                                      result = result + Str$(processnumber(ses, tmp1 + 1, tmp2 - 1))
                                      dbcprint("     processstring: %SE_TOKENCMD_STR " + result)
                                 Case %SE_TOKENCMD_CHR
                                      dbcprint("     processstring: %SE_TOKENCMD_CHR ")
                                      result = result + Chr$(processnumber(ses, tmp1 + 1, tmp2 - 1))
                                 Case %SE_TOKENCMD_SPACE
                                      result = result + Space$(processnumber(ses, tmp1 + 1, tmp2 - 1))
                                 Case %SE_TOKENCMD_STRING
                                      result = result + String$(procargn(ses, tmp1, 1), procargs(ses, tmp1, 2))
                                 Case %SE_TOKENCMD_RIGHT
                                      result = result + Right$(procargs(ses, tmp1, 1), procargn(ses, tmp1, 2))
                                 Case %SE_TOKENCMD_LEFT
                                      result = result + Left$(procargs(ses, tmp1, 1), procargn(ses, tmp1, 2))
                                 Case %SE_TOKENCMD_MID
                                      result = result + Mid$(procargs(ses, tmp1, 1), procargn(ses, tmp1, 2), procargn(ses, tmp1, 3))
                                 Case %SE_TOKENCMD_TRIM
                                      result = result + Trim$(processstring(ses, tmp1 + 1, tmp2 - 1))
                                 Case %SE_TOKENCMD_LCASE
                                      result = result + LCase$(processstring(ses, tmp1 + 1, tmp2 - 1))
                                 Case %SE_TOKENCMD_UCASE
                                      result = result + UCase$(processstring(ses, tmp1 + 1, tmp2 - 1))
                                 Case %SE_TOKENCMD_MCASE
                                      result = result + MCase$(processstring(ses, tmp1 + 1, tmp2 - 1))
                                 Case %SE_TOKENCMD_HCASE
                                      stmp1 = (processstring(ses, tmp1 + 1, tmp2 - 1))
                                      For tmp1 = 1 To Len(stmp1)
                                          If (tmp1 And 1) Then
                                             Mid$(stmp1, tmp1, 1) = UCase$(Mid$(stmp1, tmp1, 1))
                                          Else
                                             Mid$(stmp1, tmp1, 1) = LCase$(Mid$(stmp1, tmp1, 1))
                                          End If
                                      Next
                                      result = result + stmp1
                                 Case %SE_TOKENCMD_HEX
                                      result = result + Hex$(processnumber(ses, tmp1 + 1, tmp2 - 1))
                                 Case %SE_TOKENCMD_OCT
                                      result = result + Oct$(processnumber(ses, tmp1 + 1, tmp2 - 1))
                                 Case %SE_TOKENCMD_BIN
                                      result = result + Bin$(processnumber(ses, tmp1 + 1, tmp2 - 1))
                                 Case %SE_TOKENCMD_NUL
                                      result = result + Nul$(processnumber(ses, tmp1 + 1, tmp2 - 1))
                                 Case %SE_TOKENCMD_DATE
                                      result = result + Date$
                                 Case %SE_TOKENCMD_TIME
                                      result = result + Time$
                                 Case %SE_TOKENCMD_ACODE
                                      result = result + ACode$(processstring(ses, tmp1 + 1, tmp2 - 1))
                                 Case %SE_TOKENCMD_UCODE
                                      result = result + UCode$(processstring(ses, tmp1 + 1, tmp2 - 1))
                                 Case %SE_TOKENCMD_STDIN
                                      result = result + stdin
                                 Case %SE_TOKENCMD_TAB
                                      result = result + Tab$(procargs(ses, tmp1, 1), procargn(ses, tmp1, 2))
                                 Case Else
                                      'IF (ISTRUE(@ses.@ct[xpc].cmd AND %SE_FDEF_RETSTR) AND ISTRUE(isusrfun(@ses.@ct[xpc].cmd))) THEN
                                      '   'funcall
                                      'ELSE
                                         @ses.errcode = %SE_ERROR_STREXPECTED
                                      'END IF
                          End Select
                     Case %SE_TOKEN_STRING
                          result = result + extdq((@ses.@tk[@ses.@ct[xpc].token].token))
                          dbcprint("     processstring: %SE_TOKEN_STRING " + result)
                          plus = 1
                     Case %ASCII_SPACE, %SE_TOKEN_UNDEFINED
                     Case Else
                          If (@ses.@ct[xpc].cmd And %SE_FDEF_RETNUM) Then
                             @ses.errcode = %SE_ERROR_STREXPECTED
                          End If
              End Select
           End If
        End If
        If @ses.errcode Then Exit Function
    Next
    Select Case As Const ope
           Case %ASCII_LESS      '<
                If (comp < result) Then result = "true" Else result = "false"
           Case %ASCII_MORE      '>
                If (comp > result) Then result = "true" Else result = "false"
           Case %ASCII_EQUAL     '=
                If (comp = result) Then result = "true" Else result = "false"
           Case %ASCII_LCASE_A   '<>
                If (comp = result) Then result = "false" Else result = "true"
           Case %ASCII_LCASE_B   '<=
                If (comp = result) Then result = "true": Exit Select
                If (comp < result) Then result = "true" Else result = "false"
           Case %ASCII_LCASE_C   '=>
                If (comp = result) Then result = "true": Exit Select
                If (comp > result) Then result = "true" Else result = "false"
    End Select
    dbcprint("     processstring result: " + result)
    Function = result
End Function

'this code actually 'executes' the script
Function execfun(ByVal ses As ses_type Ptr) As Dword
    ifdbgx(Trace Print FuncName$)
    ifdbgx(Trace Print CallStk$(1))
    Local stmp1, dbg As String
    Local tmp1, tmp2 As Long
    Do
        If (@ses.@ct[@ses.pc].tktype =  %SE_TOKEN_ALPHA) Then
           ifdbgx(dbg = "               CT:" + Format$(@ses.pc, "000") + " LN:" + Format$(@ses.@ct[@ses.pc].lncnt, "000") + " SN:" + Format$(@ses.@ct[@ses.pc].secnt, "000") + IIf$(@ses.@ct[@ses.pc].cmd, " exec: " + funtext(@ses.@ct[@ses.pc].cmd), ""))
           dbcprint(dbg)
           Select Case As Long @ses.@ct[@ses.pc].cmd
                  Case %SE_TOKENCMD_JUMPTO, %SE_TOKENCMD_GOTO, %SE_TOKENCMD_LOOP, %SE_TOKENCMD_WEND, _
                       %SE_TOKENCMD_EXITIF, %SE_TOKENCMD_EXITDO, %SE_TOKENCMD_EXITWHI, _
                       %SE_TOKENCMD_EXITFOR, %SE_TOKENCMD_EXITSEL
                       'a jump is in @ses.@ct[pc].arg1
                       If @ses.@ct[@ses.pc].arg1 Then
                          dbcprint("                 jump from "  + Format$(@ses.pc) + " to " + Format$(@ses.@ct[@ses.pc].arg1))
                          @ses.pc = @ses.@ct[@ses.pc].arg1
                       End If
                  Case %SE_TOKEN_UNDEFINED, %SE_TOKENCMD_ENDIF, %SE_TOKENCMD_ELSE, %SE_TOKENCMD_DO
                       'just ignore these
                       Exit Select
                  Case %SE_TOKENCMD_IF, %SE_TOKENCMD_ELSEIF
                       'arg1 true branch
                       'arg2 elseif/else branch, or 0 if none
                       'arg3 endif
                       'arg4 end condition
                       'false branch = arg2 or arg3 if arg2 = 0
                       'IF evalcond(ses, pc) THEN
                       If processnumber(ses, @ses.pc + 1, @ses.@ct[@ses.pc].arg4) Then
                          ifdbgx(stmp1 = "                 if cond TRUE  jump from "  + Format$(@ses.pc) + " to " + Format$(@ses.@ct[@ses.pc].arg1))
                          @ses.pc = @ses.@ct[@ses.pc].arg1
                       Else
                          ifdbgx(stmp1 = "                 if cond FALSE jump from "  + Format$(@ses.pc) + " to " + Format$(@ses.@ct[@ses.pc].arg2))
                          @ses.pc = IIf&(@ses.@ct[@ses.pc].arg2, @ses.@ct[@ses.pc].arg2, @ses.@ct[@ses.pc].arg3)
                       End If
                       dbcprint(stmp1)
                  Case %SE_TOKENCMD_IFS, %SE_TOKENCMD_ELSEIFS
                       stmp1 = processstring(ses, @ses.pc + 1, @ses.@ct[@ses.pc].arg4)
                       If stmp1 = "true" Then
                          ifdbgx(stmp1 = "                 ifs cond TRUE  jump from "  + Format$(@ses.pc) + " to " + Format$(@ses.@ct[@ses.pc].arg1))
                          @ses.pc = @ses.@ct[@ses.pc].arg1
                       Else
                          ifdbgx(stmp1 = "                 ifs cond FALSE jump from "  + Format$(@ses.pc) + " to " + Format$(@ses.@ct[@ses.pc].arg2))
                          @ses.pc = IIf&(@ses.@ct[@ses.pc].arg2, @ses.@ct[@ses.pc].arg2, @ses.@ct[@ses.pc].arg3)
                       End If
                       dbcprint(stmp1)
                  Case %SE_TOKENCMD_DOW, %SE_TOKENCMD_WHILE, %SE_TOKENCMD_LOOPW
                       'do/dow/dou
                       'loop/loopw/loopu
                       'arg1 = after do   (true branch)
                       'arg2 = after loop (false branch)
                       'arg3 = start condition (after while/until if any)
                       'arg4 = end condition
                       If processnumber(ses, @ses.@ct[@ses.pc].arg3, @ses.@ct[@ses.pc].arg4) Then
                          ifdbgx(stmp1 = "                 dow cond TRUE  jump from "  + Format$(@ses.pc) + " to " + Format$(@ses.@ct[@ses.pc].arg1))
                          @ses.pc = @ses.@ct[@ses.pc].arg1
                       Else
                          ifdbgx(stmp1 = "                 dow cond FALSE jump from "  + Format$(@ses.pc) + " to " + Format$(@ses.@ct[@ses.pc].arg2))
                          @ses.pc = @ses.@ct[@ses.pc].arg2
                       End If
                       dbcprint(stmp1)
                  Case %SE_TOKENCMD_DOU, %SE_TOKENCMD_LOOPU
                       If IsFalse(processnumber(ses, @ses.@ct[@ses.pc].arg3, @ses.@ct[@ses.pc].arg4)) Then
                          ifdbgx(stmp1 = "                 dow cond TRUE branch jump from "  + Format$(@ses.pc) + " to " + Format$(@ses.@ct[@ses.pc].arg1))
                          @ses.pc = @ses.@ct[@ses.pc].arg1
                       Else
                          ifdbgx(stmp1 = "                 dow cond FALSE branch jump from "  + Format$(@ses.pc) + " to " + Format$(@ses.@ct[@ses.pc].arg2))
                          @ses.pc = @ses.@ct[@ses.pc].arg2
                       End If
                       dbcprint(stmp1)
                  Case %SE_TOKENCMD_FOR
                       'complex one, missed a match of my favorite soccer team solving this one :@
                       'for
                       ' arg1 = equal + 1        start = arg1     : arg2 - 1
                       ' arg2 = to addr          max   = arg2 + 1 : step/eol
                       ' arg3 = step/eol         step  = arg3 + 1 : eol
                       ' arg4 = var idx
                       ' pre  = step value
                       'to
                       ' arg1 = step addr if any
                       ' arg2 = false branch
                       ' arg3 = next addr
                       ' arg4 = eol
                       'step
                       ' arg1 = eol
                       'next
                       ' arg1 = for addr
                       ' arg2 = to addr
                       ' arg3 = true branch
                       ' arg4 = false branch
                       'for/next setup
                       dbcprint("                 for loop setup " + Format$(@ses.pc))
                       'assign var with start
                       @ses.@nvars[@ses.@ct[@ses.pc].arg4] = processnumber(ses, @ses.@ct[@ses.pc].arg1, _
                                                                          @ses.@ct[@ses.pc].arg2 - 1)
                       dbcprint("                 for start: " + Format$(@ses.@nvars[@ses.@ct[@ses.pc].arg4]))
                       'to  pre = max
                       @ses.@ct[@ses.@ct[@ses.pc].arg2].pre = processnumber(ses, @ses.@ct[@ses.pc].arg2 + 1, _
                                                                           @ses.@ct[@ses.pc].arg3 - 1)
                       dbcprint("                 for max  : " + Format$(@ses.@ct[@ses.@ct[@ses.pc].arg2].pre))
                       'if step, for pre = step
                       If @ses.@ct[@ses.@ct[@ses.pc].arg2].arg1 Then
                          @ses.@ct[@ses.pc].pre = processnumber(ses, @ses.@ct[@ses.@ct[@ses.pc].arg2].arg1 + 1, _
                                                               @ses.@ct[@ses.@ct[@ses.pc].arg2].arg4 - 1)
                       Else
                          @ses.@ct[@ses.pc].pre = 1
                       End If
                       dbcprint("                 for step : " + Format$(@ses.@ct[@ses.pc].pre))
                       'initial evaluation
                       'positive step?
                       If (@ses.@ct[@ses.pc].pre => 0) Then
                          If (@ses.@nvars[@ses.@ct[@ses.pc].arg4] <= @ses.@ct[@ses.@ct[@ses.pc].arg2].pre) Then
                             @ses.pc = @ses.@ct[@ses.pc].arg3 '+ 1
                             dbcprint("                 for true branch jumpto " + Format$(@ses.pc))
                          Else
                             @ses.pc = @ses.@ct[@ses.@ct[@ses.pc].arg2].arg2
                             dbcprint("                 for false branch jumpto " + Format$(@ses.pc))
                          End If
                       Else
                          'negative step, compare backwards
                          If (@ses.@nvars[@ses.@ct[@ses.pc].arg4] => @ses.@ct[@ses.@ct[@ses.pc].arg2].pre) Then
                             @ses.pc = @ses.@ct[@ses.pc].arg3 '+ 1
                             dbcprint("                 for true branch jumpto " + Format$(@ses.pc))
                          Else
                             @ses.pc = @ses.@ct[@ses.@ct[@ses.pc].arg2].arg2
                             dbcprint("                 for false branch jumpto " + Format$(@ses.pc))
                          End If
                       End If
                  Case %SE_TOKENCMD_NEXT
                       'next evaluation
                       'add step to var
                       dbcprint("                 next var    = " + Format$(@ses.@nvars[@ses.@ct[@ses.@ct[@ses.pc].arg1].arg4]))
                       @ses.@nvars[@ses.@ct[@ses.@ct[@ses.pc].arg1].arg4] = @ses.@nvars[@ses.@ct[@ses.@ct[@ses.pc].arg1].arg4] + @ses.@ct[@ses.@ct[@ses.pc].arg1].pre
                       dbcprint("                 next step   = " + Format$(@ses.@ct[@ses.@ct[@ses.pc].arg1].pre))
                       dbcprint("                 next result = " + Format$(@ses.@nvars[@ses.@ct[@ses.@ct[@ses.pc].arg1].arg4]))
                       dbcprint("                 next max    = " + Format$(@ses.@ct[@ses.@ct[@ses.pc].arg2].pre))
                       'check step sign
                       If (@ses.@ct[@ses.@ct[@ses.pc].arg1].pre => 0) Then
                          If (@ses.@nvars[@ses.@ct[@ses.@ct[@ses.pc].arg1].arg4] <= @ses.@ct[@ses.@ct[@ses.pc].arg2].pre) Then
                             @ses.pc = @ses.@ct[@ses.pc].arg3
                             dbcprint("                 next true branch jumpto " + Format$(@ses.pc))
                          Else
                             @ses.pc = @ses.@ct[@ses.pc].arg4
                             dbcprint("                 next false branch jumpto " + Format$(@ses.pc))
                          End If
                       Else
                          If (@ses.@nvars[@ses.@ct[@ses.@ct[@ses.pc].arg1].arg4] => @ses.@ct[@ses.@ct[@ses.pc].arg2].pre) Then
                             @ses.pc = @ses.@ct[@ses.pc].arg3
                             dbcprint("                 next true branch jumpto " + Format$(@ses.pc))
                          Else
                             @ses.pc = @ses.@ct[@ses.pc].arg4
                             dbcprint("                 next false branch jumpto " + Format$(@ses.pc))
                          End If
                       End If
                  Case %SE_TOKENCMD_INCR
                       'global var
                       If IsTrue(@ses.@ct[@ses.pc].arg1) Then Incr @ses.@nvars[@ses.@ct[@ses.pc].arg1]
                  Case %SE_TOKENCMD_DECR
                       'global var
                       If IsTrue(@ses.@ct[@ses.pc].arg1) Then Decr @ses.@nvars[@ses.@ct[@ses.pc].arg1]
                  Case %SE_TOKENCMD_GLETNUM
                       'global numeric var assignment
                       'arg1 = var index
                       'arg2 = after '='
                       'arg3 = eol - 1
                       @ses.@nvars[@ses.@ct[@ses.pc].arg1] = processnumber(ses, @ses.@ct[@ses.pc].arg2, @ses.@ct[@ses.pc].arg3)
                  Case %SE_TOKENCMD_GLETSTR
                       'global string var assignment
                       'arg1 = var
                       'arg2 = start expr
                       'arg3 = end expr
                       stmp1 = processstring(ses, @ses.@ct[@ses.pc].arg2, @ses.@ct[@ses.pc].arg3)
                       tmp1 = @ses.@ct[@ses.pc].arg1
                       dbcprint("               string " + stmp1 + " arg1: " + Format$(tmp1) + " ubs: " + Format$(@ses.ubs))
                       @ses.@svars[tmp1] = stmp1
                  Case %SE_TOKENCMD_PRINT
                       tprint processprint(ses, @ses.@ct[@ses.pc].arg1, @ses.@ct[@ses.pc].arg2 - 1)
                  Case %SE_TOKENCMD_STDOUT
                       stmp1 = processstring(ses, @ses.@ct[@ses.pc].arg1 + 1, @ses.@ct[@ses.pc].arg2 - 1)
                       'cprint stmp1
                       stdout stmp1
                  Case %SE_TOKENCMD_STDERR
                  Case %SE_TOKENCMD_BEEP
                       'BEEP!
                       Beep
                  Case %SE_TOKENCMD_RANDOM
                       'always use timer as seed
                       Randomize Timer
                  Case %SE_TOKENCMD_WAITKEY
                       waitkey
                  Case %SE_TOKENCMD_MSGBOX
                       MsgBox procargs(ses, @ses.@ct[@ses.pc].arg1, 1), procargn(ses, @ses.@ct[@ses.pc].arg1, 2), procargs(ses, @ses.@ct[@ses.pc].arg1, 3)
                  Case %SE_TOKENCMD_ENDSCR
                       'script finished, it is a miracle it went so far
                       dbcprint("               Finished " + Format$(@ses.pc))
                       Exit Do
                  Case Else
           End Select
        End If
        If @ses.errcode Then
           dbcprint("               execfun error " + Format$(@ses.pc))
           Function = 0
           Exit Function
        End If
        Incr @ses.pc
    Loop Until thstop
    dbcprint("               Execfun exiting..." + Format$(@ses.pc))
End Function

'guess what it does
Function checkvalidname(ByVal ses As ses_type Ptr, ByVal x As String) As Long
    Local tmp1 As Long
    If IsFalse(Len(x)) Then Exit Function                                      'must have len...
    x = LCase$(x)
    If fundefs(x) Then Exit Function                                           'can't be a reserved word
    If Verify(x, $ALLOWEDCHARS) Then Exit Function                             'must contain just these
    If Verify(Mid$(x, 1, 1), $ALLOWEDFIRSTCHAR) Then Exit Function             'must start with one of these
    'check here for user function names
    Function = 1   'everything seems ok
End Function

'looks for a matching codetoken as if/elseif/else/end if/endif/do/loop/while/wend/...and friends
'used by tokenizer and others to find some things addresses
Function lookfor(ByVal ses As ses_type Ptr, ByVal start As Long, ByVal match As Dword) As Dword
    Local stmp1, stmp2 As String, tmp1, nested As Dword, pc As Long
    Select Case As Long match
           Case %SE_LOOK4_EOL, %SE_LOOK4_ALPHA, %SE_LOOK4_NUM, %SE_TOKEN_STRING, _
                %SE_LOOK4_PAROPEN, %SE_LOOK4_PARCLOSE, %SE_LOOK4_EQUAL
                For pc = start To @ses.ctks - 1
                    If (@ses.@ct[pc].tktype = match) Then
                       Function = pc
                       Exit Function
                    End If
                    If (@ses.@ct[pc].tktype = %SE_TOKEN_EOL) Then Exit Function
                Next
           Case %SE_LOOK4_COMMA
                For pc = start To @ses.ctks - 1
                    Select Case As Const @ses.@ct[pc].tktype
                           Case %ASCII_COMMA
                                If IsFalse(nested) Then
                                   Function = pc
                                   Exit Function
                                End If
                           Case %ASCII_PARENTHESES_CLOSE
                                If IsFalse(nested) Then
                                   Function = pc
                                   Exit Function
                                Else
                                   Decr nested
                                End If
                           Case %ASCII_PARENTHESES_OPEN
                                Incr nested
                           Case %SE_TOKEN_EOL
                                Exit Function
                    End Select
                Next
           Case %SE_LOOK4_SEMICOLON
                For pc = start To @ses.ctks - 1
                    Select Case As Const @ses.@ct[pc].tktype
                           Case %ASCII_SEMICOLON
                                If IsFalse(nested) Then
                                   Function = pc
                                   Exit Function
                                End If
                           Case %ASCII_PARENTHESES_CLOSE
                                If IsFalse(nested) Then
                                   Function = pc
                                   Exit Function
                                Else
                                   Decr nested
                                End If
                           Case %ASCII_PARENTHESES_OPEN
                                Incr nested
                           Case %SE_TOKEN_EOL
                                Exit Function
                    End Select
                Next
           Case %SE_LOOK4_MATCHPAR
                Incr start
                For pc = start To @ses.ctks - 1
                    If (@ses.@ct[pc].tktype = %SE_TOKEN_EOL) Then Exit Function
                    If (@ses.@ct[pc].tktype = %ASCII_PARENTHESES_CLOSE) Then
                       If IsFalse(nested) Then
                          Function = pc
                          Exit Function
                       Else
                          Decr nested
                       End If
                    End If
                    If (@ses.@ct[pc].tktype = %ASCII_PARENTHESES_OPEN) Then Incr nested
                Next
           Case %SE_LOOK4_STEP, %SE_LOOK4_TO, %SE_LOOK4_THEN, %SE_LOOK4_DOWHILE, %SE_LOOK4_DOUNTIL
                For pc = start To @ses.ctks - 1
                    If (@ses.@ct[pc].tktype = %SE_TOKEN_EOL) Then Exit Function
                    If (@ses.@ct[pc].cmd = match) Then
                       Function = pc
                       Exit Function
                    End If
                Next
           Case %SE_LOOK4_ELSEIF, %SE_LOOK4_ELSE, %SE_LOOK4_ENDIF
                For pc = start To @ses.ctks - 1
                    Select Case @ses.@ct[pc].cmd
                           Case %SE_TOKENCMD_IF, %SE_TOKENCMD_IFS
                                Incr nested
                                'dbcprint ("  if nested + 1: " + FORMAT$(nested))
                           Case %SE_TOKENCMD_ELSE
                                If (nested = 0) Then
                                   If (match = %SE_LOOK4_ELSE) Then Function = pc: Exit Function
                                End If
                           Case %SE_TOKENCMD_ELSEIF, %SE_TOKENCMD_ELSEIFS
                                If (nested = 0) Then
                                   If (match = %SE_LOOK4_ELSEIF) Then Function = pc: Exit Function
                                End If
                           Case %SE_TOKENCMD_ENDIF
                                If (nested = 0) Then
                                   If (match = %SE_LOOK4_ENDIF) Then Function = pc: Exit Function
                                End If
                                Decr nested
                                'dbcprint ("  if nested - 1: " + FORMAT$(nested))
                           Case %SE_TOKENCMD_ENDFUN, %SE_TOKENCMD_ENDSUB, %SE_TOKENCMD_FUNCTION, %SE_TOKENCMD_SUB
                                Exit Function
                    End Select
                Next
           Case %SE_LOOK4_LOOP
                For pc = start To @ses.ctks - 1
                    Select Case As Long @ses.@ct[pc].cmd
                           Case %SE_TOKENCMD_LOOP, %SE_TOKENCMD_LOOPW, %SE_TOKENCMD_LOOPU
                                If (nested = 0) Then
                                   Function = pc
                                   Exit Function
                                End If
                                Decr nested
                           Case %SE_TOKENCMD_DO, %SE_TOKENCMD_DOW, %SE_TOKENCMD_DOU
                                Incr nested
                           Case %SE_TOKENCMD_ENDFUN, %SE_TOKENCMD_ENDSUB, %SE_TOKENCMD_FUNCTION, %SE_TOKENCMD_SUB
                                Exit Function
                    End Select
                Next
           Case %SE_LOOK4_WEND
                For pc = start To @ses.ctks - 1
                    Select Case As Long @ses.@ct[pc].cmd
                           Case %SE_TOKENCMD_WHILE
                                If (@ses.@ct[pc].secnt = 1) Then    'no 'do while'/'loop while'
                                   Incr nested
                                End If
                           Case %SE_TOKENCMD_WEND
                                If (nested = 0) Then
                                   Function = pc 'lookfor(ses, pc + 1, %SE_LOOK4_EOL) + 1
                                   Exit Function
                                End If
                                Decr nested
                           Case %SE_TOKENCMD_ENDFUN, %SE_TOKENCMD_ENDSUB, %SE_TOKENCMD_FUNCTION, %SE_TOKENCMD_SUB
                                Exit Function
                    End Select
                Next
           Case %SE_LOOK4_NEXT
                For pc = start To @ses.ctks - 1
                    Select Case As Long @ses.@ct[pc].cmd
                           Case %SE_TOKENCMD_FOR
                                Incr nested
                           Case %SE_TOKENCMD_NEXT
                                If (nested = 0) Then
                                   Function = pc 'lookfor(ses, pc + 1, %SE_LOOK4_EOL) + 1
                                   Exit Function
                                End If
                                Decr nested
                           Case %SE_TOKENCMD_ENDFUN, %SE_TOKENCMD_ENDSUB, %SE_TOKENCMD_FUNCTION, %SE_TOKENCMD_SUB
                                Exit Function
                    End Select
                Next
           Case %SE_LOOK4_ENDFUNC
                For pc = start To @ses.ctks - 1
                    If @ses.@ct[pc].cmd = %SE_TOKENCMD_ENDFUN Then
                       Function = pc
                       Exit Function
                    ElseIf @ses.@ct[pc].cmd = %SE_TOKENCMD_FUNCTION Then
                       Exit Function
                    ElseIf @ses.@ct[pc].cmd = %SE_TOKENCMD_SUB Then
                       Exit Function
                    ElseIf @ses.@ct[pc].cmd = %SE_TOKENCMD_ENDSUB Then
                       Exit Function
                    End If
                Next
           Case %SE_LOOK4_ENDSEL
                For pc = start To @ses.ctks - 1
                    Select Case As Long @ses.@ct[pc].cmd
                           Case %SE_TOKENCMD_SELECT
                                Incr nested
                           Case %SE_TOKENCMD_ENDSEL
                                If (nested = 0) Then
                                   Function = lookfor(ses, pc + 1, %SE_LOOK4_EOL) + 1
                                   Exit Function
                                End If
                                Decr nested
                           Case %SE_TOKENCMD_ENDFUN, %SE_TOKENCMD_ENDSUB, %SE_TOKENCMD_FUNCTION, %SE_TOKENCMD_SUB
                                Exit Function
                    End Select
                Next
    End Select
End Function

'count arguments from a list like (n1,n2,n3...st4), ignore args inside parenthesis
Function countargs(ByVal ses As ses_type Ptr, ByVal start As Long, ByVal ends As Long) As Dword
    Local Count, nested, something As Dword, pc As Long
    Incr start
    Decr ends
    For pc = start To ends
        Select Case As Const @ses.@ct[pc].tktype
               Case %SE_TOKEN_EOL            : Exit Function
               Case %ASCII_PARENTHESES_CLOSE : Decr nested
               Case %ASCII_PARENTHESES_OPEN  : Incr nested
               Case %ASCII_COMMA
                    Incr something
                    If IsFalse(nested) Then Incr Count
               Case %ASCII_SPACE
               Case %SE_TOKEN_UNDEFINED
               Case Else
                    Incr something
        End Select
    Next
    Function = IIf&(something, Count + 1, 0)
End Function

'This code takes the input string cointaining the whole script and parses its contents
'filling an array of se_codetoken structs and another of se_token_type. Alpha strings
'are checked, if identified as keywords they are not stored as tokens but loaded with
'a function definition code. Then builtin functions are scanned, its arguments counted
'and checked. Also all loops and if/then structs jumps are pre-calculated. Finally the
'processed script is executed. Most errors are reported before that.
'This routine could be improved to have less pass but I keep it this way for clarity.
'Operators precedence is set here, and can be changed.
'
Function tokenizer(ByVal inscript As String Ptr) As Dword
    If IsFalse(Len(@inscript)) Then Exit Function
    Local pcnt, lcnt, secnt, dqflag, alflag, numflag, comflag, eolflag, labcnt As Dword
    Local last, this, tkcnt, buffcnt, lastk, pc As Dword
    Local bptr, optr As Byte Ptr
    Local tokens() As se_token_type, codetk() As se_codetoken
    Local tmp1, tmp2, tmp3, tmp4 As Long
    Local buffout As Asciiz * %SE_MAXTOKENLEN
    Local script, stmp1, stmp2 As String
    Local strvar() As String               'actual script global strings content
    Local numvar() As Single               '  "      "    global numbers    "
    Local strvarn() As Dword               'points to global strings name token
    Local numvarn() As Dword               '  "        "     numbers   "    "
    Local ses As ses_type                  'main struct
    Local sesptr As Dword                  'main struct pointer
    Local var As Long                      'tmp
    Local mstack() As Single               'math stack
    ReDim mstack(0 To 4, 0 To %SE_MAXEXPRLEN)
    ReDim strvar(0), numvar(0), strvarn(0), numvarn(0)
    ReDim tokens(%SE_MAXTOKENS)            'tokens array
    ReDim codetk(%SE_MAXCODETOKENS)        'codetokens array
    ses.msp        = VarPtr(mstack(0, 0))  'math stack pointer
    ses.tk         = VarPtr(tokens(0))     'tokens pointer
    ses.ct         = VarPtr(codetk(0))     'codetokens pointer
    'ses.funname    = 0
    sesptr         = VarPtr(ses)           'main struct pointer
    script         = @inscript + $CrLf     'ensure end
    optr           = VarPtr(buffout)       'two byte pointers to scan the input script
    bptr           = StrPtr(script)        '

    dbcprint("")
    dbcprint("##################################################")
    dbcprint("Tokenizing...")

    Incr pc
    Incr lcnt
    Incr secnt
    Incr tkcnt

    last = %SE_TOKEN_UNDEFINED
    this = %SE_TOKEN_UNDEFINED

    'start checking the script, byte by byte
    For pcnt = 0 To Len(script) - 1
        Select Case As Long @bptr[pcnt]
               Case %ASCII_DOUBLEQUOTE
                    dbcprint("%ASCII_DOUBLEQUOTE")
                    dbcprint("%ASCII_STRING")
                    dqflag = Not(dqflag)
                    this = %SE_TOKEN_STRING
               Case %ASCII_PARENTHESES_OPEN, %ASCII_PARENTHESES_CLOSE
                    dbcprint("%ASCII_PAR_()")
                    If dqflag Then
                       this = %SE_TOKEN_STRING
                    Else
                       'parflag = NOT(parflag)
                       this = %SE_TOKEN_DELIMITER
                    End If
               Case %ASCII_MUL, %ASCII_PLUS, %ASCII_MINUS, _
                    %ASCII_BRACKETOPEN, %ASCII_BRACKETCLOSE, %ASCII_CARET, %ASCII_INTDIV, _
                    %ASCII_DIV, %ASCII_TAB, %ASCII_SPACE, %ASCII_COMMA, %ASCII_SEMICOLON
                    dbcprint("%ASCII_SPACE_ETC")
                    If dqflag Then
                       this = %SE_TOKEN_STRING
                    Else
                       this = %SE_TOKEN_DELIMITER
                    End If
               Case %ASCII_LESS, %ASCII_MORE, %ASCII_EQUAL
                    dbcprint("%ASCII_SPACE_PAR_ETC")
                    If dqflag Then
                       this = %SE_TOKEN_STRING
                    Else
                       this = %SE_TOKEN_DELIMITER
                       Select Case @bptr[pcnt]
                              Case %ASCII_LESS
                                   Select Case @bptr[pcnt + 1]
                                          Case %ASCII_MORE
                                               @bptr[pcnt] = 97   '<> a
                                               @bptr[pcnt + 1] = 32
                                          Case %ASCII_EQUAL
                                               @bptr[pcnt] = 98   '<= b
                                               @bptr[pcnt + 1] = 32
                                   End Select
                              Case %ASCII_MORE
                                   Select Case @bptr[pcnt + 1]
                                          Case %ASCII_LESS
                                               @bptr[pcnt] = 97   '<> a
                                               @bptr[pcnt + 1] = 32
                                          Case %ASCII_EQUAL
                                               @bptr[pcnt] = 99   '>= c
                                               @bptr[pcnt + 1] = 32
                                   End Select
                              Case %ASCII_EQUAL
                                   Select Case @bptr[pcnt + 1]
                                          Case %ASCII_LESS
                                               @bptr[pcnt] = 98   '<= b
                                               @bptr[pcnt + 1] = 32
                                          Case %ASCII_MORE
                                               @bptr[pcnt] = 99   '>= c
                                               @bptr[pcnt + 1] = 32
                                   End Select
                       End Select
                    End If
               Case %ASCII_COLON
                    If dqflag Then
                       this = %SE_TOKEN_STRING
                       dbcprint("%ASCII_STRING")
                    Else
                       this = %SE_TOKEN_COLON
                       dbcprint("%ASCII_COLON")
                    End If
               Case %ASCII_LINEFEED, %ASCII_ENTER
                    dbcprint("%ASCII_CRLF")
                    this = %SE_TOKEN_CRLF
                    comflag = 0
               Case %ASCII_QUESTION
                    If dqflag Then
                       this = %SE_TOKEN_STRING
                       dbcprint("%ASCII_STRING")
                    Else
                       this = %SE_TOKEN_PRINT
                       dbcprint("%ASCII_QUESTION")
                    End If
               Case %ASCII_APOSTROPHE
                    If dqflag Then
                       this = %SE_TOKEN_STRING
                       dbcprint("%ASCII_STRING")
                    Else
                       comflag = 1
                       this = %SE_TOKEN_CRLF
                       dbcprint("%ASCII_APOSTROPHE")
                    End If
               Case %ASCII_NUM0 To %ASCII_NUM9, %ASCII_PERIOD
                    If dqflag Then
                       this = %SE_TOKEN_STRING
                       dbcprint("%ASCII_STRING")
                    Else
                       numflag = IIf&((last = %SE_TOKEN_ALPHA), 0, 1)
                       dbcprint("NUMFLAG =" + IIf$(numflag, "1", "0"))
                       'this = %SE_TOKEN_ALPHA
                       this = IIf&(numflag, %SE_TOKEN_NUMBER, %SE_TOKEN_ALPHA)
                       dbcprint(IIf$(numflag, "%SE_TOKEN_NUMBER","%ASCII_ALPHA"))
                    End If
               Case Else
               '     dbcprint("%ASCII_???"
               '     this = %SE_TOKEN_UNDEFINED
               'CASE %ASCII_UCASE_A TO %ASCII_UCASE_Z, %ASCII_LCASE_A TO %ASCII_LCASE_Z, _
               '     %ASCII_QUESTION
                    If dqflag Then
                       this = %SE_TOKEN_STRING
                       dbcprint("%ASCII_STRING")
                    Else
                       numflag = 0
                       this = %SE_TOKEN_ALPHA
                       dbcprint("%ASCII_ALPHA")
                    End If
        End Select
        If (last <> this) Then
           If (buffcnt > 0) Then
              Select Case As Const last
                     Case %SE_TOKEN_UNDEFINED
                          dbcprint("%SE_TOKEN_UNDEFINED")
                          eolflag = 0
                     Case %SE_TOKEN_CRLF, %SE_TOKEN_COLON
                          eolflag = 1
                          dbcprint("%SE_TOKEN_CRLF")
                          codetk(pc).tktype = %SE_TOKEN_EOL
                          codetk(pc).lncnt = lcnt
                          codetk(pc).secnt = secnt
                          secnt = 1
                          Incr pc
                          If (last <> %SE_TOKEN_COLON)Then Incr lcnt
                          'IF (this = %SE_TOKEN_DELIMITER) THEN ITERATE
                     Case %SE_TOKEN_DELIMITER
                          eolflag = 0
                          stmp1 = buffout
                          stmp2 = Trim$(stmp1, Any $Spc + Chr$(0))
                          'must be at least 1 char outside parenthessis
                          'if isfalse(parflag) then
                          'stmp2 = IIF$(LEN(stmp2), stmp2, $SPC)
                          For tmp1 = 1 To Len(stmp2)
                              stmp1 = Mid$(stmp2, tmp1, 1)
                              dbcprint("%SE_TOKEN_DELIMITER " + stmp1 + " len: " + Format$(Len(stmp1)))
                              codetk(pc).tktype = Asc(stmp1)
                              codetk(pc).lncnt = lcnt
                              codetk(pc).secnt = secnt
                              codetk(pc).cmd = %SE_FDEF_OPERATOR
                              'weight precedence               m & | x o i
                              Select Case codetk(pc).tktype
                                     Case %ASCII_CARET             : tmp2 = 7      '^
                                     Case %ASCII_MUL               : tmp2 = 5      '*
                                     Case %ASCII_DIV               : tmp2 = 5      '/
                                     Case %ASCII_INTDIV            : tmp2 = 4      '\
                                     Case %ASCII_PLUS              : tmp2 = 2      '+
                                     Case %ASCII_MINUS             : tmp2 = 2      '-
                                     Case %ASCII_PARENTHESES_OPEN  : tmp2 = 0      '(
                                     Case %ASCII_PARENTHESES_CLOSE : tmp2 = 0      ')
                                     Case %ASCII_LCASE_A, _                        '<>
                                          %ASCII_LCASE_B, _                        '<=
                                          %ASCII_LCASE_C, _                        '=>
                                          %ASCII_MORE, _                           '>
                                          %ASCII_LESS, _                           '<
                                          %ASCII_EQUAL             : tmp2 = 1      '=
                              End Select
                              codetk(pc).arg1 = tmp2               '<- precedence
                              Incr pc
                          Next
                     Case %SE_TOKEN_ALPHA, %SE_TOKEN_STRING, %SE_TOKEN_NUMBER, %SE_TOKEN_PRINT
                          dbcprint(IIf$(numflag, "%SE_TOKEN_NUMBER" ,"%SE_TOKEN_OTHER"))
                          codetk(pc).lncnt = lcnt
                          codetk(pc).secnt = secnt
                          If last = %SE_TOKEN_PRINT Then last = %SE_TOKEN_ALPHA
                          tmp1 = 1
                          If last = %SE_TOKEN_ALPHA Then
                             'check if label
                             If (this = %SE_TOKEN_COLON) Then
                                If (eolflag) Then
                                   dbcprint ("label at: " + Format$(pc) + " " + buffout)
                                   codetk(pc).cmd = %SE_TOKENCMD_LABEL
                                   Incr labcnt
                                End If
                             End If
                             stmp1 = buffout
                             stmp1 = LCase$(Trim$(stmp1, Any $Spc + Chr$(0)))
                             'replace operators and weight precedence
                             Select Case stmp1
                                    Case "mod"     : tmp1 = 0: tmp2 =  3: stmp1 = "m" 'm'
                                    Case "and"     : tmp1 = 0: tmp2 = 10: stmp1 = "&" '&'
                                    Case "or"      : tmp1 = 0: tmp2 = 11: stmp1 = "|" '|'
                                    Case "xor"     : tmp1 = 0: tmp2 = 11: stmp1 = "x" 'x'
                                    Case "eqv"     : tmp1 = 0: tmp2 = 12: stmp1 = "e" 'e'
                                    Case "imp"     : tmp1 = 0: tmp2 = 13: stmp1 = "i" 'i'
                                    Case "?"       : buffout = "print": buffcnt = 5
                                                     codetk(pc).tktype = %SE_TOKEN_ALPHA
                             End Select
                             If tmp1 Then
                                codetk(pc).tktype = %SE_TOKEN_ALPHA
                                tmp2 = fundefs(LCase$(buffout))       'identify built in functions and statements
                                If tmp2 Then                          'set fundef and don't save token
                                   Select Case tmp2                   'insert a jumpto just before these
                                          Case %SE_TOKENCMD_ELSE, %SE_TOKENCMD_ELSEIF
                                               codetk(pc).tktype = %SE_TOKEN_ALPHA
                                               codetk(pc).cmd = %SE_TOKENCMD_JUMPTO
                                               Incr pc
                                          Case %SE_TOKENCMD_LET       '
                                               Decr secnt
                                   End Select
                                   codetk(pc).tktype = %SE_TOKEN_ALPHA
                                   codetk(pc).lncnt = lcnt
                                   codetk(pc).secnt = secnt
                                   codetk(pc).cmd = tmp2              '
                                   Incr secnt
                                   tmp1 = 0
                                End If
                             Else
                                codetk(pc).tktype = Asc(stmp1)
                                codetk(pc).arg1   = tmp2   '<- precedence
                                codetk(pc).cmd = %SE_FDEF_OPERATOR
                                Incr secnt
                             End If
                          End If                                      'do not save token for these
                          If tmp1 Then
                             'codetk(pc).tktype = IIF&(numflag, %SE_TOKEN_NUMBER, last)
                             If numflag Then
                                codetk(pc).tktype = %SE_TOKEN_NUMBER
                                codetk(pc).cmd = %SE_TOKENCMD_NUMCONST
                                codetk(pc).pre = Val(buffout)
                             Else
                                codetk(pc).tktype = last
                                If (last = %SE_TOKEN_STRING) Then codetk(pc).cmd = %SE_TOKENCMD_STRCONST
                             End If
                             Incr secnt
                             For tmp1 = 1 To tkcnt - 1
                                 If (tokens(tmp1).token = buffout) Then
                                    If (codetk(pc).cmd = %SE_TOKENCMD_LABEL)Then
                                       tokens(tmp1).addrs = pc
                                       codetk(pc).arg1 = pc
                                    End If
                                    codetk(pc).token = tmp1
                                    dbcprint("                       token old " + buffout)
                                    tmp1 = -4
                                    Exit For
                                 End If
                             Next
                             If (tmp1 <> -4) Then
                                    dbcprint("                       token new " + buffout)
                                If (codetk(pc).cmd = %SE_TOKENCMD_LABEL)Then
                                   tokens(tkcnt).addrs = pc
                                End If
                                codetk(pc).token = tkcnt
                                tokens(tkcnt).tktype = IIf&(numflag, %SE_TOKEN_NUMBER, last)
                                'tokens(tkcnt).tklen = buffcnt
                                tokens(tkcnt).token = Left$(buffout, buffcnt)
                                Incr tkcnt
                             End If
                          End If
                          numflag = 0
                          Incr pc
                     Case Else
                          eolflag = 0
              End Select
              Reset buffout
              buffcnt = 0
           End If
           last = this
        End If
        If (IsFalse(comflag) And (buffcnt < %SE_MAXTOKENLEN)) Then
           @optr[buffcnt] = @bptr[pcnt]
           Incr buffcnt
        End If
    Next

    'script scanned and tokenized, process it

    'add an EOL
    codetk(pc).tktype = %SE_TOKEN_EOL
    codetk(pc).lncnt  = lcnt
    codetk(pc).secnt  = secnt
    Incr pc
    'add a ENDSCRIPT token
    codetk(pc).lncnt  = lcnt
    codetk(pc).secnt  = secnt
    codetk(pc).cmd = %SE_TOKENCMD_ENDSCR
    codetk(pc).tktype = %SE_TOKEN_ALPHA

    dbcprint(Format$(pc) + " codetoken/s"))
    dbcprint(Format$(tkcnt - 1) + " token/s"))
    dbcprint(Format$(labcnt) + " label/s"))

    ReDim Preserve codetk(pc) 'free some mem
    ses.tks = tkcnt
    ses.ctks = pc
    ses.pc = 1

    'start analizing
    dbcprint("Analizing...pass 1")
    'replace some inconvenient secuences for easy handling ie. 'end if', 'do while', 'exit if', etc
    'also search for global var declares and 'dim' them
    Do
        If codetk(ses.pc).tktype = %SE_TOKEN_ALPHA Then
           tmp2 = 0
           Select Case As Long codetk(ses.pc).cmd
                  Case %SE_TOKENCMD_END
                       If codetk(ses.pc + 1).cmd = %SE_TOKENCMD_IF Then tmp2 = %SE_TOKENCMD_ENDIF
                       If codetk(ses.pc + 1).cmd = %SE_TOKENCMD_SUB Then tmp2 = %SE_TOKENCMD_ENDSUB: alflag = 0
                       If codetk(ses.pc + 1).cmd = %SE_TOKENCMD_FUNCTION Then tmp2 = %SE_TOKENCMD_ENDFUN: alflag = 0
                       If codetk(ses.pc + 1).cmd = %SE_TOKENCMD_SELECT Then tmp2 = %SE_TOKENCMD_ENDSEL
                  Case %SE_TOKENCMD_EXIT
                       If codetk(ses.pc + 1).cmd = %SE_TOKENCMD_IF Then tmp2 = %SE_TOKENCMD_EXITIF
                       If codetk(ses.pc + 1).cmd = %SE_TOKENCMD_SUB Then tmp2 = %SE_TOKENCMD_EXITSUB
                       If codetk(ses.pc + 1).cmd = %SE_TOKENCMD_FUNCTION Then tmp2 = %SE_TOKENCMD_EXITFUN
                       If codetk(ses.pc + 1).cmd = %SE_TOKENCMD_FOR Then tmp2 = %SE_TOKENCMD_EXITFOR
                       If codetk(ses.pc + 1).cmd = %SE_TOKENCMD_DO Then tmp2 = %SE_TOKENCMD_EXITDO
                       If codetk(ses.pc + 1).cmd = %SE_TOKENCMD_WHILE Then tmp2 = %SE_TOKENCMD_EXITWHI
                       If codetk(ses.pc + 1).cmd = %SE_TOKENCMD_WEND Then tmp2 = %SE_TOKENCMD_EXITWHI
                       If codetk(ses.pc + 1).cmd = %SE_TOKENCMD_LOOP Then tmp2 = %SE_TOKENCMD_EXITDO
                       If codetk(ses.pc + 1).cmd = %SE_TOKENCMD_SELECT Then tmp2 = %SE_TOKENCMD_EXITSEL
                  Case %SE_TOKENCMD_DO
                       If codetk(ses.pc + 1).cmd = %SE_TOKENCMD_WHILE Then tmp2 = %SE_TOKENCMD_DOW
                       If codetk(ses.pc + 1).cmd = %SE_TOKENCMD_UNTIL Then tmp2 = %SE_TOKENCMD_DOU
                  Case %SE_TOKENCMD_LOOP
                       If codetk(ses.pc + 1).cmd = %SE_TOKENCMD_WHILE Then tmp2 = %SE_TOKENCMD_LOOPW
                       If codetk(ses.pc + 1).cmd = %SE_TOKENCMD_UNTIL Then tmp2 = %SE_TOKENCMD_LOOPU
                  Case %SE_TOKENCMD_STRINGS
                       'dim global 'strings' type vars
                       dbcprint("strings")
                       tmp1 = lookfor(sesptr, ses.pc + 1, %SE_LOOK4_ALPHA)
                       If tmp1 Then
                          While tmp1
                            If checkvalidname(sesptr, (tokens(codetk(tmp1).token).token)) Then
                               Array Scan strvarn(), = codetk(tmp1).token, To var
                               Array Scan numvarn(), = codetk(tmp1).token, To tmp3
                               If (IsTrue(var) Or IsTrue(tmp3)) Then
                                  dbcprint("duplicated string var " + tokens(codetk(tmp1).token).token)
                                  ses.errcode = %SE_ERROR_DUPLICATEDECL
                                  Exit, Exit
                               Else
                                  dbcprint("new string var " + tokens(codetk(tmp1).token).token)
                                  ReDim Preserve strvar(UBound(strvar) + 1)
                                  ReDim Preserve strvarn(UBound(strvarn) + 1)
                                  ses.ubs = UBound(strvar)
                                  strvar(ses.ubs) = ""
                                  strvarn(ses.ubs) = codetk(tmp1).token
                                  dbcprint("strings " + tokens(codetk(tmp1).token).token)
                               End If
                            Else
                               'stmp1 = tokens(codetk(tmp1).token).token
                               'dbcprint("name:" + stmp1)
                               ses.errcode = %SE_ERROR_ILLEGALNAME
                               Exit, Exit
                            End If
                            tmp1 = lookfor(sesptr, tmp1 + 1, %SE_LOOK4_ALPHA)
                          Wend
                          While (codetk(ses.pc).tktype <> %SE_TOKEN_EOL)
                            codetk(ses.pc).tktype = %ASCII_SPACE
                            Incr ses.pc
                          Wend
                       Else
                          ses.errcode = %SE_ERROR_SYNTAXERROR
                       End If
                       dbcprint("strings ok")
                  Case %SE_TOKENCMD_NUMBERS
                       'dim global 'numbers' type vars
                       dbcprint("numbers")
                       tmp1 = lookfor(sesptr, ses.pc + 1, %SE_LOOK4_ALPHA)
                       If tmp1 Then
                          While tmp1
                            If checkvalidname(sesptr, (tokens(codetk(tmp1).token).token)) Then
                               Array Scan numvarn(), = codetk(tmp1).token, To var
                               Array Scan strvarn(), = codetk(tmp1).token, To tmp3
                               If (var Or tmp3) Then
                                  ses.errcode = %SE_ERROR_DUPLICATEDECL
                                  Exit, Exit
                               Else
                                  ReDim Preserve numvar(UBound(numvar) + 1)
                                  ReDim Preserve numvarn(UBound(numvar) + 1)
                                  ses.ubn = UBound(numvar)
                                  numvar(ses.ubn) = 0
                                  numvarn(ses.ubn) = codetk(tmp1).token
                                  dbcprint("numbers " + tokens(codetk(tmp1).token).token)
                               End If
                            Else
                               ses.errcode = %SE_ERROR_ILLEGALNAME
                               Exit, Exit
                            End If
                            tmp1 = lookfor(sesptr, tmp1 + 1, %SE_LOOK4_ALPHA)
                          Wend
                          While (codetk(ses.pc).tktype <> %SE_TOKEN_EOL)
                            codetk(ses.pc).tktype = %ASCII_SPACE
                            Incr ses.pc
                          Wend
                          dbcprint("numbers ok")
                       Else
                          ses.errcode = %SE_ERROR_SYNTAXERROR
                       End If
           End Select
           If ses.errcode Then Exit Do
           If tmp2 Then
              codetk(ses.pc).cmd = tmp2
              codetk(ses.pc + 1).tktype = %ASCII_SPACE
              codetk(ses.pc + 1).cmd = %SE_TOKEN_UNDEFINED
           End If
        End If
        'preview results for debug
        #If %DEBUG_FLAG
        stmp1 = ""
        Select Case codetk(ses.pc).tktype
               'case %SE_TOKEN_UNDEFINED: stmp1 = stmp1 + "<%SE_TOKEN_UNDEFINED>"
               Case %SE_TOKEN_EOL
                    stmp1 = "<%SE_TOKEN_EOL  >"
               Case %SE_TOKEN_DELIMITER
                    stmp1 = "<%SE_TOKEN_DELIM> = ?"
               Case %SE_TOKEN_NUMBER
                    stmp1 = "<%SE_TOKEN_NUMBE> = " + tokens(codetk(ses.pc).token).token
               Case %SE_TOKEN_ALPHA
                    If codetk(ses.pc).cmd Then
                       stmp1 = "<%SE_TOKEN_KEYWD> = " + Format$((codetk(ses.pc).cmd And &hff), "000") + " " + funtext(codetk(ses.pc).cmd)
                    Else
                       stmp1 = "<%SE_TOKEN_ALPHA> = " + tokens(codetk(ses.pc).token).token
                    End If
               Case %SE_TOKEN_STRING
                    stmp1 = "<%SE_TOKEN_STRIN> = " + tokens(codetk(ses.pc).token).token
               Case %SE_TOKEN_CRLF
                    stmp1 = "<%SE_TOKEN_CRLF >"
               Case > %ASCII_ESCAPE
                    stmp1 = "<%SE_TOKEN_DELIM> = " + Chr$(codetk(ses.pc).tktype)
        End Select
          stmp1 = "nl: " + Format$(codetk(ses.pc).lncnt, "000") + " tk: " + Format$(ses.pc, "000") + " -> " + stmp1 ' + " " + FORMAT$(codetk(ses.pc).cmd, "000")
          dbcprint (stmp1)
        #EndIf

        Incr ses.pc

    Loop While ses.pc <= ses.ctks

    If ses.errcode Then
       'exit if some error
       dbcprint(se_errortext(sesptr))
       tprint se_errortext(sesptr)
       Exit Function
    End If

    'delete all generated spaces from codetokens
    dbcprint("Analizing...pass 2")
    tmp1 = 1
    For pc = 1 To ses.ctks
        If (codetk(pc).tktype = %ASCII_SPACE) Then
        Else
           Poke$ VarPtr(codetk(tmp1)), Peek$(VarPtr(codetk(pc)), SizeOf(se_codetoken))
           Incr tmp1
        End If
    Next
    ses.ctks = tmp1 - 1

    'load ses, the main struct, with pointers to vars storage
    ses.nvarsn = VarPtr(numvarn(0))
    ses.nvars  = VarPtr(numvar(0))
    ses.svarsn = VarPtr(strvarn(0))
    ses.svars  = VarPtr(strvar(0))

    dbcprint("Analizing...pass 3")
    'all global vars declared, so set global vars references, saves many array scan
    'all vars .arg1 = var index and .cmd = %SE_TOKENCMD_GNUMVAR or %SE_TOKENCMD_GSTRVAR
    'also, check built in functions arguments, count them and set parenthesis positions arg1, arg2, arg3
    For pc = 1 To ses.ctks - 1
        ses.pc = pc
        If (codetk(pc).tktype = %SE_TOKEN_ALPHA) Then
           If (codetk(pc).cmd = 0) Then                           '<- avoid assignments
              dbcprint("checking alpha " + tokens(codetk(pc).token).token)
              Array Scan numvarn(), = codetk(pc).token, To var
              If var Then
                 dbcprint("is %SE_TOKENCMD_GNUMVAR " + tokens(codetk(pc).token).token)
                 codetk(pc).cmd = %SE_TOKENCMD_GNUMVAR
                 codetk(pc).arg1 = var - 1
              Else
                 Array Scan strvarn(), = codetk(pc).token, To var
                 If var Then
                    dbcprint("is %SE_TOKENCMD_GSTRVAR " + tokens(codetk(pc).token).token)
                    codetk(pc).cmd = %SE_TOKENCMD_GSTRVAR
                    codetk(pc).arg1 = var - 1
                 Else
                    dbcprint("not found... " + tokens(codetk(pc).token).token)
                    '?
                 End If
              End If
           Else
              'just set arguments bounds and count, we will check each arg later and will need these bounds
              Select Case As Long codetk(pc).cmd
                     Case %SE_TOKENCMD_BIN, %SE_TOKENCMD_OCT, %SE_TOKENCMD_HEX, %SE_TOKENCMD_CHR, _
                          %SE_TOKENCMD_SPACE, %SE_TOKENCMD_STR, %SE_TOKENCMD_NUL, _
                          %SE_TOKENCMD_LCASE, %SE_TOKENCMD_MCASE, %SE_TOKENCMD_HCASE, %SE_TOKENCMD_UCODE, %SE_TOKENCMD_UCASE, _
                          %SE_TOKENCMD_ACODE, %SE_TOKENCMD_TRIM, %SE_TOKENCMD_MID, %SE_TOKENCMD_RND, _
                          %SE_TOKENCMD_INT, %SE_TOKENCMD_ROUND, %SE_TOKENCMD_FIX, %SE_TOKENCMD_FRAC, %SE_TOKENCMD_ABS, _
                          %SE_TOKENCMD_CEIL, %SE_TOKENCMD_CINT, %SE_TOKENCMD_EVEN, %SE_TOKENCMD_ATN, %SE_TOKENCMD_TAN, _
                          %SE_TOKENCMD_COS, %SE_TOKENCMD_SGN, %SE_TOKENCMD_SQR, %SE_TOKENCMD_EXP2, %SE_TOKENCMD_EXP10, _
                          %SE_TOKENCMD_LOG, %SE_TOKENCMD_LOG2, %SE_TOKENCMD_LOG10, %SE_TOKENCMD_EXP, _
                          %SE_TOKENCMD_MIN, %SE_TOKENCMD_MAX, %SE_TOKENCMD_ISTRUE, %SE_TOKENCMD_ISFALSE, %SE_TOKENCMD_NOT, _
                          %SE_TOKENCMD_LEFT, %SE_TOKENCMD_RIGHT, %SE_TOKENCMD_STRING, %SE_TOKENCMD_INSTR, %SE_TOKENCMD_MSGBOX, _
                          %SE_TOKENCMD_LEN, %SE_TOKENCMD_VAL, %SE_TOKENCMD_ASC, %SE_TOKENCMD_STDOUT
                          'arg1 = (
                          'arg2 = )
                          'arg3 = number of parameters
                          'cmd  = function index and definition
                          If funargs(codetk(pc).cmd) Then                       'function has arguments?
                             If parargs(codetk(pc).cmd) Then                    'are they parenthised?
                                codetk(pc).arg1 = lookfor(sesptr, pc, %SE_LOOK4_PAROPEN)
                                If codetk(pc).arg1 Then                         'look for bounds
                                   codetk(pc).arg2 = lookfor(sesptr, codetk(pc).arg1, %SE_LOOK4_MATCHPAR)
                                   If codetk(pc).arg2 Then
                                      codetk(pc).arg3 = countargs(sesptr, codetk(pc).arg1, codetk(pc).arg2)
                                      If (codetk(pc).arg3 <> funargs(codetk(pc).cmd)) Then
                                         dbcprint ("   parameter mismatch: 12 " + Format$(codetk(pc).arg3) + " " + Format$(funargs(codetk(pc).cmd)) + " " + Format$(pc) + " " + funtext(codetk(pc).cmd))
                                         ses.errcode = %SE_ERROR_PARMISMATCH
                                         Exit For
                                      End If
                                   Else
                                      dbcprint ("  here ): " + funtext(codetk(pc).cmd) + " ln:" + Format$(codetk(pc).lncnt))
                                      ses.errcode = %SE_ERROR_PARCLOSEEXPECTED
                                      Exit For
                                   End If
                                Else
                                   dbcprint ("  here (: " + funtext(codetk(pc).cmd) + " ln:" + Format$(codetk(pc).lncnt))
                                   ses.errcode = %SE_ERROR_PAROPENEEXPECTED
                                   Exit For
                                End If
                             End If
                          End If
                     Case %SE_TOKENCMD_PRINT
                          codetk(pc).arg1 = pc + 1
                          codetk(pc).arg2 = lookfor(sesptr, codetk(pc).arg1, %SE_LOOK4_EOL)
              End Select
           End If
        End If
    Next

    If ses.errcode Then
       'exit if some error
       dbcprint(se_errortext(sesptr))
       tprint se_errortext(sesptr)
       Exit Function
    End If

    dbcprint("  num vars: " + Format$(ses.ubn))
    dbcprint("  str vars: " + Format$(ses.ubs))

    dbcprint("Analizing...pass 4")
    'finally, precalculate all jumps and loops, check functions arguments types, etc
    ses.pc = 1
    Do
        If codetk(ses.pc).tktype = %SE_TOKEN_EOL Then
           Incr ses.pc
           Iterate Do
        End If
        If codetk(ses.pc).tktype = %SE_TOKEN_ALPHA Then
           'if (last <> codetk(ses.pc).lncnt) then secnt codetk(ses.pc).secnt
           dbcprint("analizing line " + Format$(codetk(ses.pc).lncnt) + " of " + Format$(lcnt) + " ctk: " + Format$(ses.pc) + " of " + Format$(ses.ctks))
           Select Case As Long codetk(ses.pc).cmd
                  Case %SE_TOKENCMD_JUMPTO
                       'ses.pc = ses.@ct[ses.pc].arg1
                  Case %SE_TOKENCMD_IF, %SE_TOKENCMD_ELSEIF
                       'if/elseif
                       'arg1 = true branch, if/elseif eol
                       'arg2 = false branch, next elseif/else or 0
                       'arg3 = endif
                       'arg4 = end condition (then - 1)
                       tmp2 = lookfor(sesptr, ses.pc + 1, %SE_LOOK4_ENDIF)
                       dbcprint ("  endif " + Format$(tmp2))
                       If tmp2 Then                                                 'endif?
                          codetk(tmp2).arg1 = ses.pc                                'mark owner
                          tmp1 = lookfor(sesptr, ses.pc + 1, %SE_LOOK4_ELSEIF)
                          dbcprint ("  elseif " + Format$(tmp1))
                          If IsFalse(tmp1) Then                                     'elseif?
                             tmp1 = lookfor(sesptr, ses.pc + 1, %SE_LOOK4_ELSE)     'else?
                             If tmp1 Then codetk(tmp1).arg1 = ses.pc                'mark owner
                          End If
                          dbcprint ("  else " + Format$(tmp1))
                          codetk(ses.pc).arg1 = lookfor(sesptr, ses.pc + 1, %SE_LOOK4_EOL)
                          If tmp1 Then codetk(tmp1 - 1).arg1 = tmp2                 'set jumpto endif
                          Decr tmp1
                          codetk(ses.pc).arg2 = IIf&(tmp1, tmp1, 0) 'tmp2)
                          tmp1 = lookfor(sesptr, ses.pc + 1, %SE_LOOK4_THEN)
                          dbcprint ("  then " + Format$(tmp1))
                          If tmp1 Then                                              'then?
                             codetk(ses.pc).arg3 = tmp2                             'endif address
                             codetk(ses.pc).arg4 = tmp1 - 1                         'end condition
                             'ses.pc = tmp1 + 1   'jump after 'then'
                          Else
                             'err then expected
                             ses.errcode = %SE_ERROR_EXITDOWDO
                             dbcprint ("  no then")
                          End If
                          If IsTrue(checkarg(sesptr, ses.pc, 1) And %SE_FDEF_RETSTR) Then
                             codetk(ses.pc).cmd = IIf&((codetk(ses.pc).cmd = %SE_TOKENCMD_IF), %SE_TOKENCMD_IFS, %SE_TOKENCMD_ELSEIFS)
                          End If
                       Else
                          'err end if expected
                          ses.errcode = %SE_ERROR_ENDIFEXPECTED
                          dbcprint ("   no endif")
                       End If
                  Case %SE_TOKENCMD_ELSE, %SE_TOKENCMD_ENDIF                         'just check these
                       If IsFalse(codetk(ses.pc).arg1) Then
                          ses.errcode = %SE_ERROR_IFEXPECTED
                       End If
                  Case %SE_TOKENCMD_EXITDO
                       tmp1 = lookfor(sesptr, ses.pc + 1, %SE_LOOK4_LOOP)
                       If IsFalse(tmp1) Then
                          ses.errcode = %SE_ERROR_EXITDOWDO
                       End If
                       codetk(ses.pc).arg1 = tmp1 + 1
                  Case %SE_TOKENCMD_EXITWHI
                       tmp1 = lookfor(sesptr, ses.pc + 1, %SE_LOOK4_WEND)
                       If IsFalse(tmp1) Then
                          ses.errcode = %SE_ERROR_EXITWHILEWWHILE
                       End If
                       codetk(ses.pc).arg1 = tmp1 + 1
                  Case %SE_TOKENCMD_EXITIF
                       tmp1 = lookfor(sesptr, ses.pc + 1, %SE_LOOK4_ENDIF)
                       If IsFalse(tmp1) Then
                          ses.errcode = %SE_ERROR_EXITIFWIF
                       End If
                       codetk(ses.pc).arg1 = tmp1
                  Case %SE_TOKENCMD_EXITFOR
                       tmp1 = lookfor(sesptr, ses.pc + 1, %SE_LOOK4_NEXT)
                       If IsFalse(tmp1) Then
                          ses.errcode = %SE_ERROR_EXITFORWFOR
                       End If
                       codetk(ses.pc).arg1 = tmp1 + 1
                  Case %SE_TOKENCMD_EXITSEL
                       tmp1 = lookfor(sesptr, ses.pc + 1, %SE_LOOK4_ENDSEL)
                       If IsFalse(tmp1) Then
                          ses.errcode = %SE_ERROR_EXITSELWSEL
                       End If
                       codetk(ses.pc).arg1 = tmp1 + 1
                  Case %SE_TOKENCMD_DO, %SE_TOKENCMD_DOW, %SE_TOKENCMD_DOU
                       'do/dow/dou
                       'loop/loopw/loopu
                       'arg1 = after do   (true branch)
                       'arg2 = after loop (false branch)
                       'arg3 = start condition (after while/until if any)
                       'arg4 = end condition
                       tmp2 = lookfor(sesptr, ses.pc + 1, %SE_LOOK4_LOOP)
                       If tmp2 Then
                          dbcprint ("  loop  " + Format$(tmp2))
                          If ((codetk(ses.pc).cmd <> %SE_TOKENCMD_DO) And (codetk(tmp2).cmd <> %SE_TOKENCMD_LOOP)) Then
                             ses.errcode = %SE_ERROR_SYNTAXERROR
                          Else
                             tmp3 = lookfor(sesptr, ses.pc + 1, %SE_LOOK4_EOL)
                             tmp4 = lookfor(sesptr, tmp2 + 1, %SE_LOOK4_EOL)
                             codetk(ses.pc).arg1 = tmp3                                              'after do
                             codetk(ses.pc).arg2 = tmp4                                              'after loop
                             codetk(tmp2).arg1 = ses.pc - 1'codetk(ses.pc).arg1
                             codetk(tmp2).arg2 = codetk(ses.pc).arg2
                             If (codetk(ses.pc).cmd <> %SE_TOKENCMD_DO) Then                         'dow/dou?
                                dbcprint ("  do while/until " + Format$(ses.pc))
                                codetk(ses.pc).arg3 = ses.pc + 1                                     'start codition
                                codetk(ses.pc).arg4 = tmp3 - 1                                       'end codition
                             ElseIf (codetk(tmp2).cmd <> %SE_TOKENCMD_LOOP) Then                     'loopw/loopu?
                                dbcprint ("  loop while/until " + Format$(tmp2))
                                codetk(tmp2).arg3 = tmp2 + 1                                         'start codition
                                codetk(tmp2).arg4 = tmp4 - 1                                         'end codition
                             End If
                          End If
                       Else
                          dbcprint ("err do wo/loop " + Format$(ses.pc))
                          ses.errcode = %SE_ERROR_LOOPEXPECTED
                       End If
                  Case %SE_TOKENCMD_LOOP, %SE_TOKENCMD_LOOPW, %SE_TOKENCMD_LOOPU, %SE_TOKENCMD_WEND
                       If IsFalse(codetk(ses.pc).arg2) Then
                          ses.errcode = %SE_ERROR_DOEXPECTED
                       End If
                  Case %SE_TOKENCMD_WHILE
                       'arg1 = after while eol (true branch)
                       'arg2 = after wend eol  (false branch)
                       'arg3 = start condition (after while)
                       'arg4 = end condition   (before eol)
                       tmp2 = lookfor(sesptr, ses.pc + 1, %SE_LOOK4_WEND)
                       tmp3 = lookfor(sesptr, ses.pc + 1, %SE_LOOK4_EOL)
                       If tmp2 Then
                          dbcprint ("  wend  " + Format$(tmp2))
                          codetk(ses.pc).arg1 = tmp3 + 1                                        'after while
                          codetk(ses.pc).arg2 = lookfor(sesptr, tmp2 + 1, %SE_LOOK4_EOL) + 1    'after wend
                          codetk(tmp2).arg1 = ses.pc - 1                                        'before wend
                          codetk(tmp2).arg2 = codetk(ses.pc).arg2                                   '
                          codetk(ses.pc).arg3 = ses.pc + 1                                      'start codition
                          codetk(ses.pc).arg4 = tmp3 - 1                                        'end codition
                       Else
                          ses.errcode = %SE_ERROR_WENDEXPECTED
                       End If
                  Case %SE_TOKENCMD_FOR
                       'for
                       ' arg1 = equal + 1        start = arg1     : arg2 - 1
                       ' arg2 = to addr          max   = arg2 + 1 : step/eol
                       ' arg3 = step/eol         step  = arg3 + 1 : eol
                       ' arg4 = var idx
                       'to
                       ' arg1 = step addr if any
                       ' arg2 = false branch
                       ' arg3 = next addr
                       ' arg4 = eol (true branch)
                       'step
                       ' arg1 = eol
                       'next
                       ' arg1 = for addr
                       ' arg2 = to addr
                       ' arg3 = true branch
                       ' arg4 = false branch
                       tmp1 = lookfor(sesptr, ses.pc + 1, %SE_LOOK4_ALPHA)
                       dbcprint ("  for var " + Format$(tmp1))
                       'IF tmp1 AND ISTRUE(codetk(tmp1).cmd = %SE_TOKENCMD_GNUMVAR) THEN   'num var?
                       'IF tmp1 THEN
                          If isnumvar(codetk(tmp1).cmd) Then   'num var?
                             tmp2 = lookfor(sesptr, tmp1, %SE_LOOK4_EQUAL)
                             dbcprint ("  for = " + Format$(tmp2))
                             If tmp2 Then
                                tmp3 = lookfor(sesptr, tmp2, %SE_LOOK4_TO)
                                dbcprint ("  for to " + Format$(tmp3))
                                If tmp3 Then
                                   tmp4 = lookfor(sesptr, tmp3, %SE_LOOK4_STEP)
                                   dbcprint ("  for step " + Format$(tmp4))
                                   If tmp4 Then
                                      codetk(tmp3).arg1 = tmp4
                                      codetk(tmp4).arg1 = tmp1 = lookfor(sesptr, tmp3, %SE_LOOK4_EOL)
                                   Else
                                      tmp4 = lookfor(sesptr, tmp3 + 1, %SE_LOOK4_EOL)
                                   End If
                                   'for setup
                                   codetk(ses.pc).arg1 = tmp2 + 1
                                   codetk(ses.pc).arg2 = tmp3
                                   codetk(ses.pc).arg3 = tmp4
                                   'to setup
                                   codetk(ses.pc).arg4 = codetk(tmp1).arg1
                                   codetk(tmp3).arg2 = lookfor(sesptr, tmp3, %SE_LOOK4_NEXT)
                                   codetk(tmp3).arg3 = codetk(tmp3).arg2
                                   codetk(tmp3).arg4 = lookfor(sesptr, tmp3, %SE_LOOK4_EOL)
                                   dbcprint ("  for next " + Format$(codetk(tmp3).arg2))
                                   'next setup
                                   codetk(codetk(tmp3).arg2).arg1 = ses.pc
                                   codetk(codetk(tmp3).arg2).arg2 = tmp3
                                   codetk(codetk(tmp3).arg2).arg3 = codetk(tmp3).arg4
                                   codetk(codetk(tmp3).arg2).arg4 = codetk(tmp3).arg2
                                Else
                                   ses.errcode = %SE_ERROR_TOEXPECTED
                                End If
                             Else
                                ses.errcode = %SE_ERROR_SYNTAXERROR
                             End If
                          Else
                             dbcprint("cmd: " + Bin$(codetk(tmp1).cmd))
                             ses.errcode = %SE_ERROR_NUMVAREXPECTED
                          End If
                       'END IF
                  Case %SE_TOKENCMD_NEXT
                       If IsFalse(codetk(ses.pc).arg2) Then
                          ses.errcode = %SE_ERROR_FOREXPECTED
                       End If
                  Case %SE_TOKENCMD_LET, %SE_TOKENCMD_GNUMVAR, %SE_TOKENCMD_GSTRVAR
                       'arg1 = var index
                       'arg2 = after '='
                       'arg3 = eol - 1
                       dbcprint("let")
                       If (codetk(ses.pc).cmd = %SE_TOKENCMD_LET) Then Incr ses.pc
                       If (codetk(ses.pc).secnt = 1) Then
                          If (codetk(ses.pc + 1).tktype = %ASCII_EQUAL) Then
                             Select Case codetk(ses.pc).cmd
                                    Case %SE_TOKENCMD_GNUMVAR
                                         codetk(ses.pc).cmd = %SE_TOKENCMD_GLETNUM
                                    Case %SE_TOKENCMD_GSTRVAR
                                         codetk(ses.pc).cmd = %SE_TOKENCMD_GLETSTR
                                    Case Else
                                         ses.errcode = %SE_ERROR_SYNTAXERROR
                             End Select
                             tmp3 = lookfor(sesptr, ses.pc + 1, %SE_LOOK4_EOL)
                             If IsTrue(tmp3) Then
                                codetk(ses.pc).arg2 = ses.pc + 2                  'after =
                                codetk(ses.pc).arg3 = tmp3 - 1                    'eol - 1
                                'ses.pc = tmp3
                                dbcprint ("   var: " + Format$(codetk(ses.pc).arg1))
                                dbcprint ("     =: " + Format$(ses.pc + 1))
                                dbcprint ("   EOL: " + Format$(tmp3))
                                dbcprint("let ok")
                             Else
                                '?...
                                ses.errcode = %SE_ERROR_SYNTAXERROR
                                dbcprint(se_errortext(sesptr))
                             End If
                          Else
                             ses.errcode = %SE_ERROR_SYNTAXERROR
                          End If
                       End If
                  Case %SE_TOKENCMD_INCR, %SE_TOKENCMD_DECR
                       'tmp1 = lookfor(sesptr, ses.pc + 1, %SE_LOOK4_ALPHA)
                       dbcprint("incr/decr ")
                       tmp1 = ses.pc + 1
                       Select Case codetk(tmp1).cmd
                              Case %SE_TOKENCMD_GNUMVAR
                                   codetk(ses.pc).arg1 = codetk(tmp1).arg1
                              Case Else
                                   dbcprint("incr/decr error")
                                   ses.errcode = %SE_ERROR_VAREXPECTED
                       End Select
                  Case %SE_TOKENCMD_GOTO
                       tmp1 = lookfor(sesptr, ses.pc + 1, %SE_LOOK4_ALPHA)
                       If tmp1 Then
                          If tokens(codetk(tmp1).token).addrs Then
                             codetk(ses.pc).arg1 = tokens(codetk(tmp1).token).addrs
                          Else
                             'undefined equate
                             dbcprint("goto 1 " + tokens(codetk(tmp1).token).token)
                             ses.errcode = %SE_ERROR_UNDEFEQUATE
                          End If
                       Else
                          'syntax error
                          dbcprint("goto 2 " + tokens(codetk(tmp1).token).token)
                          ses.errcode = %SE_ERROR_SYNTAXERROR
                       End If
                  Case %SE_TOKENCMD_RESET
                       'codetk(ses.pc).cmd = %SE_TOKENCMD_RSTNUM '/ STR
                  Case %SE_TOKENCMD_ERASE
                       'codetk(ses.pc).cmd = %SE_TOKENCMD_ERNUM  '/ STR
                  Case %SE_TOKENCMD_STDERR
                  Case %SE_TOKENCMD_STDIN
                  Case %SE_TOKENCMD_ENDSCR, %SE_TOKENCMD_END
                       Exit Do
                  Case %SE_TOKENCMD_PRGLINES, %SE_TOKENCMD_PI, %SE_TOKENCMD_BEEP
                       '0 arg, returns number, static
                  Case %SE_TOKENCMD_TIMER
                       '0 arg, returns number, dynamic
                  Case %SE_TOKENCMD_DATE, %SE_TOKENCMD_TIME
                       '0 arg, returns string, dynamic
                  Case %SE_TOKENCMD_LEN, %SE_TOKENCMD_VAL, %SE_TOKENCMD_ASC, %SE_TOKENCMD_LEFT, %SE_TOKENCMD_RIGHT, _
                       %SE_TOKENCMD_SPACE, %SE_TOKENCMD_STR, _
                       %SE_TOKENCMD_LCASE, %SE_TOKENCMD_MCASE, %SE_TOKENCMD_HCASE, %SE_TOKENCMD_UCODE, %SE_TOKENCMD_UCASE, _
                       %SE_TOKENCMD_BIN, %SE_TOKENCMD_OCT, %SE_TOKENCMD_HEX, %SE_TOKENCMD_CHR, _
                       %SE_TOKENCMD_ACODE, %SE_TOKENCMD_TRIM, %SE_TOKENCMD_INSTR, %SE_TOKENCMD_NUL, _
                       %SE_TOKENCMD_INT, %SE_TOKENCMD_ROUND, %SE_TOKENCMD_FIX, %SE_TOKENCMD_FRAC, %SE_TOKENCMD_ABS, _
                       %SE_TOKENCMD_CEIL, %SE_TOKENCMD_CINT, %SE_TOKENCMD_EVEN, %SE_TOKENCMD_ATN, %SE_TOKENCMD_TAN, _
                       %SE_TOKENCMD_COS, %SE_TOKENCMD_SGN, %SE_TOKENCMD_SQR, %SE_TOKENCMD_EXP2, %SE_TOKENCMD_EXP10, _
                       %SE_TOKENCMD_LOG, %SE_TOKENCMD_LOG2, %SE_TOKENCMD_LOG10, %SE_TOKENCMD_EXP, %SE_TOKENCMD_MID, _
                       %SE_TOKENCMD_MIN, %SE_TOKENCMD_MAX, %SE_TOKENCMD_ISTRUE, %SE_TOKENCMD_ISFALSE, %SE_TOKENCMD_NOT, _
                       %SE_TOKENCMD_STRING, %SE_TOKENCMD_MSGBOX, _
                       %SE_TOKENCMD_STDOUT, %SE_TOKENCMD_RND
                       'arg1 = (
                       'arg2 = )
                       'arg3 = arguments count
                       'cmd  = function index and definition
                       If funargs(codetk(ses.pc).cmd) Then                       'function has arguments?
                          If parargs(codetk(ses.pc).cmd) Then                    'are they parenthised?
                             For tmp1 = 1 To codetk(ses.pc).arg3                 'check all them
                                 tmp2 = checkarg(sesptr, codetk(ses.pc).arg1, tmp1)
                                 If IsFalse(tmp2 And codetk(ses.pc).cmd) Then
                                    dbcprint ("   parameter mismatch type : " + Hex$(codetk(ses.pc).cmd) + " " + Hex$(tmp2)))
                                    dbcprint ("   parameter mismatch count: " + Format$(codetk(ses.pc).arg3) + " " + Format$(funargs(codetk(ses.pc).cmd)) + " " + Format$(ses.pc))
                                    ses.errcode = %SE_ERROR_PARMISMATCH
                                 End If
                             Next
                          End If
                       End If
                  Case %SE_TOKENCMD_PRINT
                  Case Else
           End Select
        End If
        If ses.errcode Then Exit Do
        Incr ses.pc
        If (ses.pc => ses.ctks) Then Exit Do
    Loop

    dbcprint("Printing...")
    ifdbgx(prtcode(sesptr, 1, ses.ctks))
    ifdbgx(For tmp1 = 1 To ses.ubs: dbcprint("strings " + tokens(strvarn(tmp1)).token + " = " + strvar(tmp1)): Next)
    If ses.errcode Then
       'report error if any
       dbcprint (se_errortext(sesptr))
       tprint se_errortext(sesptr)
       Exit Function
    End If

    ses.errcode = %SE_ERROR_EXECUTING
    ifdbgx(stdout(se_errortext(sesptr)))
    'tprint se_errortext(sesptr)
    ses.errcode = %SE_ERROR_NOERROR

    'all done, exec the code!
    ses.pc = 1
    execfun sesptr

    'script exited, finished or had an error
    ifdbgx(stdout (se_errortext(sesptr)))
    'tprint se_errortext(sesptr)
    ses.errcode = %SE_ERROR_EXITING
    ifdbgx(stdout (se_errortext(sesptr)))
    'tprint se_errortext(sesptr)

    ifdbgx(Trace Close)
    Function = ses.errcode
End Function

'prints all formated codetokens to a textbox, for debug
Function prtcode(ByVal ses As ses_type Ptr, ByVal start As Long, ByVal ends As Long) As Dword
    Local stmp1 As String, tmp1 As Long
    stdout "########################################################"
    For tmp1 = start To ends
        stmp1 = "CT:" + Format$(tmp1, "000") + " LN:" + Format$(@ses.@ct[tmp1].lncnt, "000") + " SN:" + Format$(@ses.@ct[tmp1].secnt, "000")
        Select Case @ses.@ct[tmp1].tktype
               Case %SE_TOKEN_ALPHA    : stmp1 = stmp1 + " A " + Format$((@ses.@ct[tmp1].cmd And &hff), "000") + " "
                    stmp1 = stmp1 + "a1:" + Format$(@ses.@ct[tmp1].arg1, "000") + " "
                    stmp1 = stmp1 + "a2:" + Format$(@ses.@ct[tmp1].arg2, "000") + " "
                    stmp1 = stmp1 + "a3:" + Format$(@ses.@ct[tmp1].arg3, "000") + " "
                    stmp1 = stmp1 + "a4:" + Format$(@ses.@ct[tmp1].arg4, "000") + " "
                    stmp1 = stmp1 + funtext(@ses.@ct[tmp1].cmd)
               Case %SE_TOKEN_NUMBER   : stmp1 = stmp1 + " N "
               Case %SE_TOKEN_EOL      : stmp1 = stmp1 + "EOL"
               Case %SE_TOKEN_STRING   : stmp1 = stmp1 + " S "
               Case %SE_TOKEN_DELIMITER: stmp1 = stmp1 + " D "
               Case > %ASCII_ESCAPE    : stmp1 = stmp1 + " " + Chr$(@ses.@ct[tmp1].tktype)+ " "
        End Select
        If (@ses.@ct[tmp1].cmd = %SE_TOKENCMD_PRENUM) Then
           stmp1 = stmp1 + " " + Format$(@ses.@ct[tmp1].pre)
        End If
        dbcprint(stmp1)
    Next
End Function

'takes function cmd and return function text name, for debug
Function funtext(Code As Long) As String
         Select Case As Long Code
                Case %SE_TOKENCMD_ABS
                     Function = "%SE_TOKENCMD_ABS      "
                Case %SE_TOKENCMD_AND
                     Function = "%SE_TOKENCMD_AND      "
                Case %SE_TOKENCMD_ACODE
                     Function = "%SE_TOKENCMD_ACODE    "
                Case %SE_TOKENCMD_ASC
                     Function = "%SE_TOKENCMD_ASC      "
                Case %SE_TOKENCMD_ATN
                     Function = "%SE_TOKENCMD_ATN      "
                Case %SE_TOKENCMD_BEEP
                     Function = "%SE_TOKENCMD_BEEP     "
                Case %SE_TOKENCMD_BIN
                     Function = "%SE_TOKENCMD_BIN      "
                Case %SE_TOKENCMD_CASE
                     Function = "%SE_TOKENCMD_CASE     "
                Case %SE_TOKENCMD_CEIL
                     Function = "%SE_TOKENCMD_CEIL     "
                Case %SE_TOKENCMD_CHR
                     Function = "%SE_TOKENCMD_CHR      "
                Case %SE_TOKENCMD_CINT
                     Function = "%SE_TOKENCMD_CINT     "
                Case %SE_TOKENCMD_COS
                     Function = "%SE_TOKENCMD_COS      "
                Case %SE_TOKENCMD_DATE
                     Function = "%SE_TOKENCMD_DATE     "
                Case %SE_TOKENCMD_DECR
                     Function = "%SE_TOKENCMD_DECR     "
                Case %SE_TOKENCMD_DO
                     Function = "%SE_TOKENCMD_DO       "
                Case %SE_TOKENCMD_END
                     Function = "%SE_TOKENCMD_END      "
                Case %SE_TOKENCMD_ELSE
                     Function = "%SE_TOKENCMD_ELSE     "
                Case %SE_TOKENCMD_ELSEIF
                     Function = "%SE_TOKENCMD_ELSEIF   "
                Case %SE_TOKENCMD_EQV
                     Function = "%SE_TOKENCMD_EQV      "
                Case %SE_TOKENCMD_ERASE
                     Function = "%SE_TOKENCMD_ERASE    "
                Case %SE_TOKENCMD_EVEN
                     Function = "%SE_TOKENCMD_EVEN     "
                Case %SE_TOKENCMD_EXP
                     Function = "%SE_TOKENCMD_EXP      "
                Case %SE_TOKENCMD_EXP2
                     Function = "%SE_TOKENCMD_EXP2     "
                Case %SE_TOKENCMD_EXP10
                     Function = "%SE_TOKENCMD_EXP10    "
                Case %SE_TOKENCMD_EXIT
                     Function = "%SE_TOKENCMD_EXIT     "
                Case %SE_TOKENCMD_FIX
                     Function = "%SE_TOKENCMD_FIX      "
                Case %SE_TOKENCMD_FOR
                     Function = "%SE_TOKENCMD_FOR      "
                Case %SE_TOKENCMD_FUNCTION
                     Function = "%SE_TOKENCMD_FUNCTION "
                Case %SE_TOKENCMD_FRAC
                     Function = "%SE_TOKENCMD_FRAC     "
                Case %SE_TOKENCMD_GOTO
                     Function = "%SE_TOKENCMD_GOTO     "
                Case %SE_TOKENCMD_GOSUB
                     Function = "%SE_TOKENCMD_GOSUB    "
                Case %SE_TOKENCMD_HCASE
                     Function = "%SE_TOKENCMD_HCASE    "
                Case %SE_TOKENCMD_HEX
                     Function = "%SE_TOKENCMD_HEX      "
                Case %SE_TOKENCMD_IF
                     Function = "%SE_TOKENCMD_IF       "
                Case %SE_TOKENCMD_IMP
                     Function = "%SE_TOKENCMD_IMP      "
                Case %SE_TOKENCMD_INCR
                     Function = "%SE_TOKENCMD_INCR     "
                Case %SE_TOKENCMD_INSTR
                     Function = "%SE_TOKENCMD_INSTR    "
                Case %SE_TOKENCMD_INT
                     Function = "%SE_TOKENCMD_INT      "
                Case %SE_TOKENCMD_ISTRUE
                     Function = "%SE_TOKENCMD_ISTRUE   "
                Case %SE_TOKENCMD_ISFALSE
                     Function = "%SE_TOKENCMD_ISFALSE  "
                Case %SE_TOKENCMD_MAX
                     Function = "%SE_TOKENCMD_MAX      "
                Case %SE_TOKENCMD_MSGBOX
                     Function = "%SE_TOKENCMD_MSGBOX   "
                Case %SE_TOKENCMD_MCASE
                     Function = "%SE_TOKENCMD_MCASE    "
                Case %SE_TOKENCMD_MID
                     Function = "%SE_TOKENCMD_MID      "
                Case %SE_TOKENCMD_MIN
                     Function = "%SE_TOKENCMD_MIN      "
                Case %SE_TOKENCMD_MOD
                     Function = "%SE_TOKENCMD_MOD      "
                Case %SE_TOKENCMD_NEXT
                     Function = "%SE_TOKENCMD_NEXT     "
                Case %SE_TOKENCMD_NOT
                     Function = "%SE_TOKENCMD_NOT      "
                Case %SE_TOKENCMD_NUMBERS
                     Function = "%SE_TOKENCMD_NUMBERS  "
                Case %SE_TOKENCMD_LCASE
                     Function = "%SE_TOKENCMD_LCASE    "
                Case %SE_TOKENCMD_LEFT
                     Function = "%SE_TOKENCMD_LEFT     "
                Case %SE_TOKENCMD_LEN
                     Function = "%SE_TOKENCMD_LEN      "
                Case %SE_TOKENCMD_LOG
                     Function = "%SE_TOKENCMD_LOG      "
                Case %SE_TOKENCMD_LOG2
                     Function = "%SE_TOKENCMD_LOG2     "
                Case %SE_TOKENCMD_LOG10
                     Function = "%SE_TOKENCMD_LOG10    "
                Case %SE_TOKENCMD_LOOP
                     Function = "%SE_TOKENCMD_LOOP     "
                Case %SE_TOKENCMD_LET
                     Function = "%SE_TOKENCMD_LET      "
                Case %SE_TOKENCMD_OCT
                     Function = "%SE_TOKENCMD_OCT      "
                Case %SE_TOKENCMD_OR
                     Function = "%SE_TOKENCMD_OR       "
                Case %SE_TOKENCMD_PRGLINES
                     Function = "%SE_TOKENCMD_PRGLINES "
                Case %SE_TOKENCMD_PI
                     Function = "%SE_TOKENCMD_PI       "
                Case %SE_TOKENCMD_RANDOM
                     Function = "%SE_TOKENCMD_RANDOM   "
                Case %SE_TOKENCMD_RESET
                     Function = "%SE_TOKENCMD_RESET    "
                Case %SE_TOKENCMD_RETURN
                     Function = "%SE_TOKENCMD_RETURN   "
                Case %SE_TOKENCMD_RIGHT
                     Function = "%SE_TOKENCMD_RIGHT    "
                Case %SE_TOKENCMD_RND
                     Function = "%SE_TOKENCMD_RND      "
                Case %SE_TOKENCMD_ROUND
                     Function = "%SE_TOKENCMD_ROUND    "
                Case %SE_TOKENCMD_SGN
                     Function = "%SE_TOKENCMD_SGN      "
                Case %SE_TOKENCMD_SPACE
                     Function = "%SE_TOKENCMD_SPACE    "
                Case %SE_TOKENCMD_SQR
                     Function = "%SE_TOKENCMD_SQR      "
                Case %SE_TOKENCMD_STDERR
                     Function = "%SE_TOKENCMD_STDERR   "
                Case %SE_TOKENCMD_STDIN
                     Function = "%SE_TOKENCMD_STDIN    "
                Case %SE_TOKENCMD_STDOUT
                     Function = "%SE_TOKENCMD_STDOUT   "
                Case %SE_TOKENCMD_STR
                     Function = "%SE_TOKENCMD_STR      "
                Case %SE_TOKENCMD_STRING
                     Function = "%SE_TOKENCMD_STRING   "
                Case %SE_TOKENCMD_SUB
                     Function = "%SE_TOKENCMD_SUB      "
                Case %SE_TOKENCMD_SELECT
                     Function = "%SE_TOKENCMD_SELECT   "
                Case %SE_TOKENCMD_STRINGS
                     Function = "%SE_TOKENCMD_STRINGS  "
                Case %SE_TOKENCMD_TAN
                     Function = "%SE_TOKENCMD_TAN      "
                Case %SE_TOKENCMD_TIME
                     Function = "%SE_TOKENCMD_TIME     "
                Case %SE_TOKENCMD_THEN
                     Function = "%SE_TOKENCMD_THEN     "
                Case %SE_TOKENCMD_TIMER
                     Function = "%SE_TOKENCMD_TIMER    "
                Case %SE_TOKENCMD_TO
                     Function = "%SE_TOKENCMD_TO       "
                Case %SE_TOKENCMD_TRIM
                     Function = "%SE_TOKENCMD_TRIM     "
                Case %SE_TOKENCMD_UCASE
                     Function = "%SE_TOKENCMD_UCASE    "
                Case %SE_TOKENCMD_UCODE
                     Function = "%SE_TOKENCMD_UCODE    "
                Case %SE_TOKENCMD_UNTIL
                     Function = "%SE_TOKENCMD_UNTIL    "
                Case %SE_TOKENCMD_VAL
                     Function = "%SE_TOKENCMD_VAL      "
                Case %SE_TOKENCMD_WEND
                     Function = "%SE_TOKENCMD_WEND     "
                Case %SE_TOKENCMD_WHILE
                     Function = "%SE_TOKENCMD_WHILE    "
                Case %SE_TOKENCMD_XOR
                     Function = "%SE_TOKENCMD_XOR      "
                Case %SE_TOKENCMD_FUNSTR
                     Function = "%SE_TOKENCMD_FUNSTR   "
                Case %SE_TOKENCMD_ENDIF
                     Function = "%SE_TOKENCMD_ENDIF    "
                Case %SE_TOKENCMD_DOW
                     Function = "%SE_TOKENCMD_DOW      "
                Case %SE_TOKENCMD_DOU
                     Function = "%SE_TOKENCMD_DOU      "
                Case %SE_TOKENCMD_ENDFUN
                     Function = "%SE_TOKENCMD_ENDFUN   "
                Case %SE_TOKENCMD_EXITIF
                     Function = "%SE_TOKENCMD_EXITIF   "
                Case %SE_TOKENCMD_EXITDO
                     Function = "%SE_TOKENCMD_EXITDO   "
                Case %SE_TOKENCMD_EXITWHI
                     Function = "%SE_TOKENCMD_EXITWHI  "
                Case %SE_TOKENCMD_EXITFOR
                     Function = "%SE_TOKENCMD_EXITFOR  "
                Case %SE_TOKENCMD_EXITFUN
                     Function = "%SE_TOKENCMD_EXITFUN  "
                Case %SE_TOKENCMD_EXITSUB
                     Function = "%SE_TOKENCMD_EXITSUB  "
                Case %SE_TOKENCMD_EXITSEL
                     Function = "%SE_TOKENCMD_EXITSEL  "
                Case %SE_TOKENCMD_FAC
                     Function = "%SE_TOKENCMD_FAC      "
                Case %SE_TOKENCMD_LOOPW
                     Function = "%SE_TOKENCMD_LOOPW    "
                Case %SE_TOKENCMD_LOOPU
                     Function = "%SE_TOKENCMD_LOOPU    "
                Case %SE_TOKENCMD_GLETNUM
                     Function = "%SE_TOKENCMD_GLETNUM   "
                Case %SE_TOKENCMD_GLETSTR
                     Function = "%SE_TOKENCMD_GLETSTR   "
                Case %SE_TOKENCMD_RSTNUM
                     Function = "%SE_TOKENCMD_RSTNUM   "
                Case %SE_TOKENCMD_RSTSTR
                     Function = "%SE_TOKENCMD_RSTSTR   "
                Case %SE_TOKENCMD_ERNUM
                     Function = "%SE_TOKENCMD_ERNUM    "
                Case %SE_TOKENCMD_ERSTR
                     Function = "%SE_TOKENCMD_ERSTR    "
                Case %SE_TOKENCMD_LABEL
                     Function = "%SE_TOKENCMD_LABEL    "
                Case %SE_TOKENCMD_PRENUM
                     Function = "%SE_TOKENCMD_PRENUM   "
                Case %SE_TOKENCMD_PRESTR
                     Function = "%SE_TOKENCMD_PRESTR   "
                Case %SE_TOKENCMD_GNUMVAR
                     Function = "%SE_TOKENCMD_GNUMVAR   "
                Case %SE_TOKENCMD_GSTRVAR
                     Function = "%SE_TOKENCMD_GSTRVAR   "
                Case %SE_TOKENCMD_STEP
                     Function = "%SE_TOKENCMD_STEP     "
                Case %SE_TOKENCMD_FUNNUM
                     Function = "%SE_TOKENCMD_FUNNUM   "
                Case %SE_TOKENCMD_ENDSUB
                     Function = "%SE_TOKENCMD_ENDSUB   "
                Case %SE_TOKENCMD_ENDSEL
                     Function = "%SE_TOKENCMD_ENDSEL   "
                Case %SE_TOKENCMD_ENDSCR
                     Function = "%SE_TOKENCMD_ENDSCR   "
                Case %SE_TOKENCMD_JUMPTO
                     Function = "%SE_TOKENCMD_JUMPTO   "
                Case %SE_TOKENCMD_LABEL
                     Function = "%SE_TOKENCMD_LABEL    "
                Case %SE_TOKENCMD_OPERAT
                     Function = "%SE_TOKENCMD_OPERAT   "
                Case %SE_TOKENCMD_NUMCONST
                     Function = "%SE_TOKENCMD_NUMCONST "
                Case %SE_TOKENCMD_STRCONST
                     Function = "%SE_TOKENCMD_STRCONST "
                Case %SE_TOKENCMD_WAITKEY
                     Function = "%SE_TOKENCMD_WAITKEY  "
                Case %SE_TOKENCMD_CMD
                     Function = "%SE_TOKENCMD_CMD      "
                Case %SE_TOKENCMD_STRREV
                     Function = "%SE_TOKENCMD_STRREV   "
                Case %SE_TOKENCMD_STRDEL
                     Function = "%SE_TOKENCMD_STRDEL   "
                Case %SE_TOKENCMD_STRINGS
                     Function = "%SE_TOKENCMD_STRINGS  "
                Case %SE_TOKENCMD_STRING
                     Function = "%SE_TOKENCMD_STRING   "
                Case %SE_TOKENCMD_MAXS
                     Function = "%SE_TOKENCMD_MAXS     "
                Case %SE_TOKENCMD_MINS
                     Function = "%SE_TOKENCMD_MINS     "
                Case %SE_TOKENCMD_RETAIN
                     Function = "%SE_TOKENCMD_RETAIN   "
                Case %SE_TOKENCMD_REMAIN
                     Function = "%SE_TOKENCMD_REMAIN   "
                Case %SE_TOKENCMD_REMOVE
                     Function = "%SE_TOKENCMD_REMOVE   "
                Case %SE_TOKENCMD_REPEAT
                     Function = "%SE_TOKENCMD_REPEAT   "
                Case %SE_TOKENCMD_RTRIM
                     Function = "%SE_TOKENCMD_RTRIM    "
                Case %SE_TOKENCMD_JOIN
                     Function = "%SE_TOKENCMD_JOIN     "
                Case %SE_TOKENCMD_NUL
                     Function = "%SE_TOKENCMD_NUL      "
                Case %SE_TOKENCMD_ENVGET
                     Function = "%SE_TOKENCMD_ENVGET   "
                Case %SE_TOKENCMD_ENVSET
                     Function = "%SE_TOKENCMD_ENVSET   "
                Case %SE_TOKENCMD_FORMAT
                     Function = "%SE_TOKENCMD_FORMAT   "
                Case %SE_TOKENCMD_EXTRACT
                     Function = "%SE_TOKENCMD_EXTRACT  "
                Case %SE_TOKENCMD_TAB
                     Function = "%SE_TOKENCMD_TAB      "
                Case %SE_TOKENCMD_PRINT
                     Function = "%SE_TOKENCMD_PRINT    "
                Case %SE_TOKENCMD_IFS
                     Function = "%SE_TOKENCMD_IFS      "
                Case %SE_TOKENCMD_ELSEIFS
                     Function = "%SE_TOKENCMD_ELSEIFS  "
                Case Else
                     Function = "????????? [" + Hex$(Code) + "] " + Bin$(Code)
         End Select
End Function

'test a string, if a keyword return function name and definition constant
Function fundefs(Code As String) As Long
         Select Case As Const$ Code
                Case  "as"
                      Function = %SE_TOKENCMD_AS
                Case  "abs"
                      Function = %SE_TOKENCMD_ABS
                Case  "and"
                      Function = %SE_TOKENCMD_AND
                Case  "acode"
                      Function = %SE_TOKENCMD_ACODE
                Case  "asc"
                      Function = %SE_TOKENCMD_ASC
                Case  "atn"
                      Function = %SE_TOKENCMD_ATN
                Case  "beep"
                      Function = %SE_TOKENCMD_BEEP
                Case  "bin"
                      Function = %SE_TOKENCMD_BIN
                Case  "case"
                      Function = %SE_TOKENCMD_CASE
                Case  "ceil"
                      Function = %SE_TOKENCMD_CEIL
                Case  "chr"
                      Function = %SE_TOKENCMD_CHR
                Case  "cint"
                      Function = %SE_TOKENCMD_CINT
                Case  "cos"
                      Function = %SE_TOKENCMD_COS
                Case  "command"
                      Function = %SE_TOKENCMD_CMD
                Case  "date"
                      Function = %SE_TOKENCMD_DATE
                Case  "decr"
                      Function = %SE_TOKENCMD_DECR
                Case  "do"
                      Function = %SE_TOKENCMD_DO
                Case  "end"
                      Function = %SE_TOKENCMD_END
                Case  "else"
                      Function = %SE_TOKENCMD_ELSE
                Case  "elseif"
                      Function = %SE_TOKENCMD_ELSEIF
                Case  "eqv"
                      Function = %SE_TOKENCMD_EQV
                Case  "erase"
                      Function = %SE_TOKENCMD_ERASE
                Case  "even"
                      Function = %SE_TOKENCMD_EVEN
                Case  "exp"
                      Function = %SE_TOKENCMD_EXP
                Case  "exp2"
                      Function = %SE_TOKENCMD_EXP2
                Case  "exp10"
                      Function = %SE_TOKENCMD_EXP10
                Case  "exit"
                      Function = %SE_TOKENCMD_EXIT
                Case  "fac"
                      Function = %SE_TOKENCMD_FAC
                Case  "fix"
                      Function = %SE_TOKENCMD_FIX
                Case  "for"
                      Function = %SE_TOKENCMD_FOR
                Case  "function"
                      Function = %SE_TOKENCMD_FUNCTION
                Case  "frac"
                      Function = %SE_TOKENCMD_FRAC
                Case  "goto"
                      Function = %SE_TOKENCMD_GOTO
                Case  "gosub"
                      Function = %SE_TOKENCMD_GOSUB
                Case  "hcase"
                      Function = %SE_TOKENCMD_HCASE
                Case  "hex"
                      Function = %SE_TOKENCMD_HEX
                Case  "if"
                      Function = %SE_TOKENCMD_IF
                Case  "imp"
                      Function = %SE_TOKENCMD_IMP
                Case  "incr"
                      Function = %SE_TOKENCMD_INCR
                Case  "instr"
                      Function = %SE_TOKENCMD_INSTR
                Case  "int"
                      Function = %SE_TOKENCMD_INT
                Case  "istrue"
                      Function = %SE_TOKENCMD_ISTRUE
                Case  "isfalse"
                      Function = %SE_TOKENCMD_ISFALSE
                Case  "max"
                      Function = %SE_TOKENCMD_MAX
                Case  "msgbox"
                      Function = %SE_TOKENCMD_MSGBOX
                Case  "mcase"
                      Function = %SE_TOKENCMD_MCASE
                Case  "mid"
                      Function = %SE_TOKENCMD_MID
                Case  "min"
                      Function = %SE_TOKENCMD_MIN
                Case  "mod"
                      Function = %SE_TOKENCMD_MOD
                Case  "next"
                      Function = %SE_TOKENCMD_NEXT
                Case  "not"
                      Function = %SE_TOKENCMD_NOT
                Case  "numbers"
                      Function = %SE_TOKENCMD_NUMBERS
                Case  "lcase"
                      Function = %SE_TOKENCMD_LCASE
                Case  "left"
                      Function = %SE_TOKENCMD_LEFT
                Case  "len"
                      Function = %SE_TOKENCMD_LEN
                Case  "log"
                      Function = %SE_TOKENCMD_LOG
                Case  "log2"
                      Function = %SE_TOKENCMD_LOG2
                Case  "log10"
                      Function = %SE_TOKENCMD_LOG10
                Case  "loop"
                      Function = %SE_TOKENCMD_LOOP
                Case  "let"
                      Function = %SE_TOKENCMD_LET
                Case  "oct"
                      Function = %SE_TOKENCMD_OCT
                Case  "or"
                      Function = %SE_TOKENCMD_OR
                Case  "prglines"
                      Function = %SE_TOKENCMD_PRGLINES
                Case  "pi"
                      Function = %SE_TOKENCMD_PI
                Case "randomize"
                      Function = %SE_TOKENCMD_RANDOM
                Case  "reset"
                      Function = %SE_TOKENCMD_RESET
                Case  "return"
                      Function = %SE_TOKENCMD_RETURN
                Case  "right"
                      Function = %SE_TOKENCMD_RIGHT
                Case  "rnd"
                      Function = %SE_TOKENCMD_RND
                Case  "round"
                      Function = %SE_TOKENCMD_ROUND
                Case  "sgn"
                      Function = %SE_TOKENCMD_SGN
                Case  "space"
                      Function = %SE_TOKENCMD_SPACE
                Case  "sqr"
                      Function = %SE_TOKENCMD_SQR
                Case  "stderr"
                      Function = %SE_TOKENCMD_STDERR
                Case  "step"
                      Function = %SE_TOKENCMD_STEP
                Case  "stdin"
                      Function = %SE_TOKENCMD_STDIN
                Case  "stdout"
                      Function = %SE_TOKENCMD_STDOUT
                Case  "str"
                      Function = %SE_TOKENCMD_STR
                Case  "string"
                      Function = %SE_TOKENCMD_STRING
                Case  "select"
                      Function = %SE_TOKENCMD_SELECT
                Case  "strings"
                      Function = %SE_TOKENCMD_STRINGS
                Case  "tan"
                      Function = %SE_TOKENCMD_TAN
                Case  "time"
                      Function = %SE_TOKENCMD_TIME
                Case  "then"
                      Function = %SE_TOKENCMD_THEN
                Case  "timer"
                      Function = %SE_TOKENCMD_TIMER
                Case  "to"
                      Function = %SE_TOKENCMD_TO
                Case  "trim"
                      Function = %SE_TOKENCMD_TRIM
                Case  "ucase"
                      Function = %SE_TOKENCMD_UCASE
                Case  "ucode"
                      Function = %SE_TOKENCMD_UCODE
                Case  "until"
                      Function = %SE_TOKENCMD_UNTIL
                Case  "val"
                      Function = %SE_TOKENCMD_VAL
                Case  "wend"
                      Function = %SE_TOKENCMD_WEND
                Case  "while"
                      Function = %SE_TOKENCMD_WHILE
                Case  "xor"
                      Function = %SE_TOKENCMD_XOR
                Case  "waitkey"
                      Function = %SE_TOKENCMD_WAITKEY
                Case  "funstr"
                      Function = %SE_TOKENCMD_FUNSTR
                Case  "endif"
                      Function = %SE_TOKENCMD_ENDIF
                Case  "dow"
                      Function = %SE_TOKENCMD_DOW
                Case  "dou"
                      Function = %SE_TOKENCMD_DOU
                Case  "endfun"
                      Function = %SE_TOKENCMD_ENDFUN
                Case  "exitif"
                      Function = %SE_TOKENCMD_EXITIF
                Case  "exitdo"
                      Function = %SE_TOKENCMD_EXITDO
                Case  "exitwhi"
                      Function = %SE_TOKENCMD_EXITWHI
                Case  "exitfor"
                      Function = %SE_TOKENCMD_EXITFOR
                Case  "exitfun"
                      Function = %SE_TOKENCMD_EXITFUN
                Case  "exitsub"
                      Function = %SE_TOKENCMD_EXITSUB
                Case  "exitsel"
                      Function = %SE_TOKENCMD_EXITSEL
                Case  "loopw"
                      Function = %SE_TOKENCMD_LOOPW
                Case  "loopu"
                      Function = %SE_TOKENCMD_LOOPU
                Case  "strreverse"
                      Function = %SE_TOKENCMD_STRREV
                Case  "strdelete"
                      Function = %SE_TOKENCMD_STRDEL
                Case  "strinsert"
                      Function = %SE_TOKENCMD_STRINS
                Case  "max"
                      Function = %SE_TOKENCMD_MAX
                Case  "max$"
                      Function = %SE_TOKENCMD_MAXS
                Case  "min"
                      Function = %SE_TOKENCMD_MIN
                Case  "min$"
                      Function = %SE_TOKENCMD_MINS
                Case  "retain"
                      Function = %SE_TOKENCMD_RETAIN
                Case  "remain"
                      Function = %SE_TOKENCMD_REMAIN
                Case  "remove"
                      Function = %SE_TOKENCMD_REMOVE
                Case  "repeat"
                      Function = %SE_TOKENCMD_REPEAT
                Case  "rtrim"
                      Function = %SE_TOKENCMD_RTRIM
                Case  "join"
                      Function = %SE_TOKENCMD_JOIN
                Case  "nul"
                      Function = %SE_TOKENCMD_NUL
                Case  "environ"
                      Function = %SE_TOKENCMD_ENVGET
                Case  "environ$"
                      Function = %SE_TOKENCMD_ENVSET
                Case  "format"
                      Function = %SE_TOKENCMD_FORMAT
                Case  "extract"
                      Function = %SE_TOKENCMD_EXTRACT
                Case  "tab"
                      Function = %SE_TOKENCMD_TAB
                Case  "print"
                      Function = %SE_TOKENCMD_PRINT
         End Select
End Function