#PBForms CREATED V1.51
'------------------------------------------------------------------------------
' The first line in this file is a PB/Forms metastatement.
' It should ALWAYS be the first line of the file. Other
' PB/Forms metastatements are placed at the beginning and
' end of "Named Blocks" of code that should be edited
' with PBForms only. Do not manually edit or delete these
' metastatements or PB/Forms will not be able to reread
' the file correctly.  See the PB/Forms documentation for
' more information.
' Named blocks begin like this:    #PBFORMS BEGIN ...
' Named blocks end like this:      #PBFORMS END ...
' Other PB/Forms metastatements such as:
'     #PBFORMS DECLARATIONS
' are used by PB/Forms to insert additional code.
' Feel free to make changes anywhere else in the file.
'------------------------------------------------------------------------------

#Compile Exe
#Dim All
#Debug Error On
#Stack 1024 * 1024 * 4
#Tools Off
'------------------------------------------------------------------------------
'   ** Includes **
'------------------------------------------------------------------------------
#PBForms BEGIN INCLUDES
#If Not %def(%WINAPI)
    #Include "WIN32API.INC"
#EndIf
#Include "PBForms.INC"
#PBForms END INCLUDES
'------------------------------------------------------------------------------

'------------------------------------------------------------------------------
'   ** Constants **
'------------------------------------------------------------------------------
#PBForms BEGIN CONSTANTS
%IDD_DIALOG1          =  101
%IDC_TxSource         = 1001
%IDC_txTokenizer      = 1003
%IDR_MENU1            =  102
%IDM_FILE_OPEN        = 1008
%IDM_FILE_SAVE        = 1009
%IDM_FILE_EXIT        = 1010
%IDM_EDIT_COPY        = 1011
%IDM_FILE_NEW         = 1012
%IDM_RUN_RUN          = 1013
%IDM_RUN_STOP         = 1016
%IDM_RUN_DEBUG        = 1017
%IDM_EDIT_RESETSOURCE = 1018
%IDM_EDIT_RESETRESULT = 1019
%IDM_HELP_HELP        = 1020
%IDM_HELP_ABOUT       = 1021
%IDD_dlgHelp          =  130
%IDC_txHelp           = 1030
%IDM_FILE_SAVEAS      = 1031
#PBForms END CONSTANTS
'------------------------------------------------------------------------------

'------------------------------------------------------------------------------
'   ** Declarations **
'------------------------------------------------------------------------------
Declare CallBack Function ShowDIALOG1Proc()
Declare Function ShowDIALOG1(ByVal hParent As Dword) As Long
Declare Function AttachMENU1(ByVal hDlg As Dword) As Dword
Declare CallBack Function ShowdlgHelpProc()
Declare Function ShowdlgHelp(ByVal hDlg As Dword) As Long
#PBForms DECLARATIONS
'------------------------------------------------------------------------------

Global g_hwnd As Long
Global scriptstring As String
Global thstop As Long
Global DEBUG_FLAG As Long

Function tprint(ByVal stext As String) As Long
    Local stmp1, stmp2, param As String
    Control Get Text g_hwnd, %IDC_txTokenizer To stmp1
    stmp1 = stmp1 + $CrLf + stext
    Control Set Text g_hwnd, %IDC_txTokenizer, stmp1
End Function

#Include "se_engine.INC"
#Include "comdlg32.inc"

'------------------------------------------------------------------------------
'   ** Main Application Entry Point **
'------------------------------------------------------------------------------
Function PBMain()
    ShowDIALOG1 %HWND_DESKTOP
End Function
'------------------------------------------------------------------------------

'------------------------------------------------------------------------------
'   ** CallBacks **
'------------------------------------------------------------------------------
CallBack Function ShowDIALOG1Proc()
    Local hthread As Dword
    Local txt, file, stmp1 As String, frr As Long
    Static filename As String
    Select Case As Long CbMsg
           Case %wm_initdialog
                ' Initialization handler
                g_hwnd = CbHndl
                Try
                  frr = FreeFile
                  file = "testcode2.txt"
                  Open file For Input As frr
                  While Not Eof(frr)
                      Line Input #frr, txt
                      stmp1 = stmp1 + txt + $CrLf
                  Wend
                  Close frr
                  Control Set Text CbHndl, %IDC_TxSource, stmp1
                  filename = file
                  Dialog Set Text CbHndl, filename
                Catch
                End Try
                settimer CbHndl, 205, 100, %null
           Case %wm_ncactivate
                Static hWndSaveFocus As Dword
                If IsFalse CbWParam Then
                   ' Save control focus
                   hWndSaveFocus = GetFocus()
                ElseIf hWndSaveFocus Then
                   ' Restore control focus
                   SetFocus(hWndSaveFocus)
                   hWndSaveFocus = 0
                End If
           Case %wm_destroy
                thstop = 1
           Case %wm_timer
                killtimer CbHndl, 205
                Control Handle CbHndl, %IDC_TxSource To frr
                sendmessage frr, %EM_SETSEL, 0, 0
           Case %wm_command
                ' Process control notifications
                Select Case As Long CbCtl
                    Case %IDC_TxSource
                         If CbCtlMsg = %en_setfocus Then
                            'sendmessage getdlgitem(g_hwnd, %IDC_TxSource), %EM_SETSEL, 0, 0
                         End If
                    Case %IDC_Txtokenizer
                         If CbCtlMsg = %en_setfocus Then
                            sendmessage getdlgitem(g_hwnd, %IDC_TxSource), %wm_setfocus, 0, 0
                         End If
                    Case %IDM_FILE_OPEN
                         File = ""
                         txt = "Select a script file"
                         OpenFileDialog (0, txt, File , "", "*.*", "", 0)
                         If Len(File) Then
                            Try
                              frr = FreeFile
                              Open file For Input As frr
                              While Not Eof(frr)
                                  Line Input #frr, txt
                                  stmp1 = stmp1 + txt + $CrLf
                              Wend
                              Close frr
                              Control Set Text CbHndl, %IDC_TxSource, stmp1
                              filename = file
                              Dialog Set Text CbHndl, filename
                            Catch
                            End Try
                         End If
                    Case %IDM_FILE_SAVE
                         If Len(filename) Then
                            Try
                              frr = FreeFile
                              file = filename
                              Open file For Binary As frr
                              Control Get Text CbHndl, %IDC_TxSource To stmp1
                              Seek frr, 1
                              Put$ frr, stmp1
                              SetEof frr
                            Catch
                              MsgBox "Error ocurred while saving " + file
                            End Try
                            Close frr
                         Else
                            Dialog Send CbHndl, %wm_command, Mak(Dword, %IDM_FILE_SAVEAS, 0), 0
                         End If
                    Case %IDM_FILE_SAVEAS
                         File = ""
                         txt = "Save file"
                         OpenFileDialog (0, txt, File , "", "*.*", "", 0)
                         If Len(file) Then
                            Try
                              frr = FreeFile
                              Open file For Binary As frr
                              If (Lof(frr) > 1) Then
                                 If MsgBox(file + " already exist, overwrite?", %mb_iconquestion Or %mb_yesno, "Overwrite") = %idno Then
                                    Close frr
                                    Exit Function
                                 End If
                              End If
                              Control Get Text CbHndl, %IDC_TxSource To stmp1
                              Seek frr, 1
                              Put$ frr, stmp1
                              SetEof frr
                              filename = file
                              Dialog Set Text CbHndl, filename
                            Catch
                              MsgBox "Error ocurred while saving " + file
                            End Try
                            Close frr
                         End If
                    Case %IDM_FILE_EXIT
                         Dialog End CbHndl
                    Case %IDM_EDIT_COPY
                    Case %IDM_FILE_NEW
                    Case %IDM_RUN_RUN
                         Control Get Text CbHndl, %IDC_TxSource To scriptstring
                         Thread Create tokenizer (VarPtr(scriptstring)) To hthread
                         Thread Close hthread To hthread
                    Case %IDM_RUN_DEBUG
                    Case %IDM_RUN_STOP
                         thstop = 1
                    Case %IDM_EDIT_RESETSOURCE
                         Control Set Text CbHndl, %IDC_TxSource, ""
                    Case %IDM_EDIT_RESETRESULT
                         Control Set Text CbHndl, %IDC_Txtokenizer, ""
                    Case %IDM_HELP_HELP
                         ShowdlgHelp CbHndl
                    Case %IDM_HELP_ABOUT
                End Select
       End Select
End Function

'------------------------------------------------------------------------------

'------------------------------------------------------------------------------
'   ** Dialogs **
'------------------------------------------------------------------------------

Function ShowDIALOG1(ByVal hParent As Dword) As Long
    Local lRslt  As Long

#PBForms BEGIN DIALOG %IDD_DIALOG1->%IDR_MENU1->
    Local hDlg   As Dword
    Local hFont1 As Dword

    Dialog New hParent, "SE_ENGINE DEMO", 271, 36, 406, 383, %ws_popup Or _
        %ws_border Or %ws_dlgframe Or %ws_thickframe Or %ws_caption Or _
        %ws_sysmenu Or %ws_minimizebox Or %ws_maximizebox Or _
        %ws_clipsiblings Or %ws_visible Or %ds_modalframe Or %ds_3dlook Or _
        %ds_nofailcreate Or %ds_setfont, %ws_ex_controlparent Or %ws_ex_left _
        Or %ws_ex_ltrreading Or %ws_ex_rightscrollbar, To hDlg
    Control Add TextBox, hDlg, %IDC_TxSource, "", 4, 176, 398, 192, %ws_child _
        Or %ws_visible Or %ws_tabstop Or %ws_hscroll Or %ws_vscroll Or _
        %es_left Or %es_multiline Or %es_autohscroll Or %es_autovscroll Or _
        %es_wantreturn, %ws_ex_clientedge Or %ws_ex_left Or _
        %ws_ex_ltrreading Or %ws_ex_rightscrollbar
    Control Set Color    hDlg, %IDC_TxSource, %cyan, RGB(0, 0, 128)
    Control Add TextBox, hDlg, %IDC_txTokenizer, "", 4, 4, 398, 168, _
        %ws_child Or %ws_visible Or %ws_tabstop Or %ws_hscroll Or _
        %ws_vscroll Or %es_left Or %es_multiline Or %es_autohscroll Or _
        %es_autovscroll, %ws_ex_clientedge Or %ws_ex_left Or _
        %ws_ex_ltrreading Or %ws_ex_rightscrollbar
    Control Set Color    hDlg, %IDC_txTokenizer, %cyan, RGB(0, 0, 128)

    hFont1 = PBFormsMakeFont("Swedish", 8, 700, %FALSE, %FALSE, %FALSE, _
        %ANSI_CHARSET)

    Control Send hDlg, %IDC_TxSource, %WM_SETFONT, hFont1, 0
    Control Send hDlg, %IDC_txTokenizer, %WM_SETFONT, hFont1, 0

    AttachMENU1 hDlg
#PBForms END DIALOG

    Dialog Show Modal hDlg, Call ShowDIALOG1Proc To lRslt

#PBForms BEGIN CLEANUP %IDD_DIALOG1
    DeleteObject hFont1
#PBForms END CLEANUP

    Function = lRslt
End Function

'------------------------------------------------------------------------------

Function AttachMENU1(ByVal hDlg As Dword) As Dword
#PBForms BEGIN MENU %IDR_MENU1->%IDD_DIALOG1
    Local hMenu   As Dword
    Local hPopUp1 As Dword

    Menu New Bar To hMenu
    Menu New PopUp To hPopUp1
    Menu Add PopUp, hMenu, "File", hPopUp1, %mf_enabled
        Menu Add String, hPopUp1, "New", %IDM_FILE_NEW, %mf_enabled
        Menu Add String, hPopUp1, "Open", %IDM_FILE_OPEN, %mf_enabled
        Menu Add String, hPopUp1, "Save", %IDM_FILE_SAVE, %mf_enabled
        Menu Add String, hPopUp1, "Save as...", %IDM_FILE_SAVEAS, %mf_enabled
        Menu Add String, hPopUp1, "Exit", %IDM_FILE_EXIT, %mf_enabled
    Menu New PopUp To hPopUp1
    Menu Add PopUp, hMenu, "Edit", hPopUp1, %mf_enabled
        Menu Add String, hPopUp1, "Reset source", %IDM_EDIT_RESETSOURCE, _
            %mf_enabled
        Menu Add String, hPopUp1, "Reset result", %IDM_EDIT_RESETRESULT, _
            %mf_enabled
    Menu New PopUp To hPopUp1
    Menu Add PopUp, hMenu, "Run", hPopUp1, %mf_enabled
        Menu Add String, hPopUp1, "Run", %IDM_RUN_RUN, %mf_enabled
        Menu Add String, hPopUp1, "Stop", %IDM_RUN_STOP, %mf_enabled
    Menu New PopUp To hPopUp1
    Menu Add PopUp, hMenu, "Help", hPopUp1, %mf_enabled
        Menu Add String, hPopUp1, "Help", %IDM_HELP_HELP, %mf_enabled
        Menu Add String, hPopUp1, "About", %IDM_HELP_ABOUT, %mf_enabled

    Menu Attach hMenu, hDlg
#PBForms END MENU
    Function = hMenu
End Function

'------------------------------------------------------------------------------

CallBack Function ShowdlgHelpProc()
    Local frr As Long, stmp1, txt As String
    Static this As Long
    Select Case As Long CbMsg
        Case %wm_initdialog
            ' Initialization handler
             this = CbHndl
             Try
               frr = FreeFile
               Open "se_engine.inc" For Input As frr
               While Not Eof(frr)
                   Line Input #frr, txt
                   If InStr(txt, "#ENDIF") Then Exit Do
                   If IsFalse(InStr(txt, "#IF")) Then
                      stmp1 = stmp1 + Mid$(txt, 2) + $CrLf
                   End If
               Wend
               Control Set Text CbHndl, %IDC_Txhelp, stmp1
             Catch
             End Try
             Close frr
        Case %wm_ncactivate
            Static hWndSaveFocus As Dword
            If IsFalse CbWParam Then
                ' Save control focus
                hWndSaveFocus = GetFocus()
            ElseIf hWndSaveFocus Then
                ' Restore control focus
                SetFocus(hWndSaveFocus)
                hWndSaveFocus = 0
            End If
        Case %wm_command
            ' Process control notifications
            Select Case As Long CbCtl
                Case %IDC_txHelp
                     If CbCtlMsg = %en_setfocus Then
                        sendmessage getdlgitem(this, %IDC_txHelp), %EM_SETSEL, 0, 0
                     End If
            End Select
    End Select
End Function

'------------------------------------------------------------------------------

Function ShowdlgHelp(ByVal hParent As Dword) As Long
    Local lRslt  As Long
    Static already As Long
    If already Then Exit Function
#PBForms BEGIN DIALOG %IDD_dlgHelp->->
    Local hDlg   As Dword
    Local hFont1 As Dword

    Dialog New hParent, "SE Script engine Help", 70, 70, 353, 225, %ws_popup _
        Or %ws_border Or %ws_dlgframe Or %ws_sysmenu Or %ws_clipsiblings Or _
        %ws_visible Or %ds_modalframe Or %ds_center Or %ds_3dlook Or _
        %ds_nofailcreate Or %ds_setfont, %ws_ex_controlparent Or _
        %ws_ex_toolwindow Or %ws_ex_left Or %ws_ex_ltrreading Or _
        %ws_ex_rightscrollbar, To hDlg
    Control Add TextBox, hDlg, %IDC_txHelp, "", 4, 4, 344, 216, %ws_child Or _
        %ws_visible Or %ws_tabstop Or %ws_vscroll Or %es_left Or _
        %es_multiline Or %es_autohscroll Or %es_readonly, %ws_ex_clientedge _
        Or %ws_ex_left Or %ws_ex_ltrreading Or %ws_ex_rightscrollbar
    Control Set Color    hDlg, %IDC_txHelp, %green, %black

    hFont1 = PBFormsMakeFont("Arial", 9, 700, %FALSE, %FALSE, %FALSE, _
        %ANSI_CHARSET)

    Control Send hDlg, %IDC_txHelp, %WM_SETFONT, hFont1, 0
#PBForms END DIALOG
    already = 1
    Dialog Show Modal hDlg, Call ShowdlgHelpProc To lRslt
    already = 0
#PBForms BEGIN CLEANUP %IDD_dlgHelp
    DeleteObject hFont1
#PBForms END CLEANUP

    Function = lRslt
End Function
'------------------------------------------------------------------------------
