%SE_ERROR_FIRST              = 150
%SE_ERROR_NOERROR            = 0
%SE_ERROR_IFEXPECTED         = %SE_ERROR_FIRST + 1
%SE_ERROR_ENDIFEXPECTED      = %SE_ERROR_FIRST + 2
%SE_ERROR_DOEXPECTED         = %SE_ERROR_FIRST + 3
%SE_ERROR_LOOPEXPECTED       = %SE_ERROR_FIRST + 4
%SE_ERROR_WENDEXPECTED       = %SE_ERROR_FIRST + 5
%SE_ERROR_WHILEEXPECTED      = %SE_ERROR_FIRST + 6
%SE_ERROR_FOREXPECTED        = %SE_ERROR_FIRST + 7
%SE_ERROR_NEXTEXPECTED       = %SE_ERROR_FIRST + 8
%SE_ERROR_STREXPECTED        = %SE_ERROR_FIRST + 9
%SE_ERROR_NUMEXPECTED        = %SE_ERROR_FIRST + 10
%SE_ERROR_STATEXPECTED       = %SE_ERROR_FIRST + 11
%SE_ERROR_TOEXPECTED         = %SE_ERROR_FIRST + 12
%SE_ERROR_NUMVAREXPECTED     = %SE_ERROR_FIRST + 13
%SE_ERROR_STRVAREXPECTED     = %SE_ERROR_FIRST + 14
%SE_ERROR_QUOTEEXPECTED      = %SE_ERROR_FIRST + 15
%SE_ERROR_PARENEXPECTED      = %SE_ERROR_FIRST + 16
%SE_ERROR_EXITDOWDO          = %SE_ERROR_FIRST + 17
%SE_ERROR_EXITFORWFOR        = %SE_ERROR_FIRST + 18
%SE_ERROR_EXITIFWIF          = %SE_ERROR_FIRST + 19
%SE_ERROR_EXITWHILEWWHILE    = %SE_ERROR_FIRST + 20
%SE_ERROR_ASEXPECTED         = %SE_ERROR_FIRST + 21
%SE_ERROR_BYPASSEXPECTED     = %SE_ERROR_FIRST + 22
%SE_ERROR_ASTYPEEXPECTED     = %SE_ERROR_FIRST + 23
%SE_ERROR_FUNNAMEEXPECTED    = %SE_ERROR_FIRST + 24
%SE_ERROR_NESTEDFUN          = %SE_ERROR_FIRST + 25
%SE_ERROR_ONLYINFUN          = %SE_ERROR_FIRST + 26
%SE_ERROR_NOSE_MAIN          = %SE_ERROR_FIRST + 27
%SE_ERROR_FUNSUBEXPECTED     = %SE_ERROR_FIRST + 28

%SE_ERROR_MISSINGDECL        = %SE_ERROR_FIRST + 30
%SE_ERROR_ILLEGALNAME        = %SE_ERROR_FIRST + 31
%SE_ERROR_ALREADYDECL        = %SE_ERROR_FIRST + 32
%SE_ERROR_DUPLICATEDECL      = %SE_ERROR_FIRST + 33
%SE_ERROR_MATHMODULE         = %SE_ERROR_FIRST + 34
%SE_ERROR_FORSTEPZERO        = %SE_ERROR_FIRST + 35
%SE_ERROR_PLUSEXPECTED       = %SE_ERROR_FIRST + 36
%SE_ERROR_EXITING            = %SE_ERROR_FIRST + 37
%SE_ERROR_STARTING           = %SE_ERROR_FIRST + 38
%SE_ERROR_PARSING            = %SE_ERROR_FIRST + 39
%SE_ERROR_EXECUTING          = %SE_ERROR_FIRST + 40
%SE_ERROR_EXPRTOOCOMPLEX     = %SE_ERROR_FIRST + 41
%SE_ERROR_SYNTAXERROR        = %SE_ERROR_FIRST + 42
%SE_ERROR_EXITSELWSEL        = %SE_ERROR_FIRST + 43
%SE_ERROR_ENDFUNEXPECTED     = %SE_ERROR_FIRST + 44
%SE_ERROR_VAREXPECTED        = %SE_ERROR_FIRST + 45
%SE_ERROR_PARMISMATCH        = %SE_ERROR_FIRST + 46
%SE_ERROR_PARCLOSEEXPECTED   = %SE_ERROR_FIRST + 47
%SE_ERROR_PAROPENEEXPECTED   = %SE_ERROR_FIRST + 48
%SE_ERROR_OVERFLOW           = %SE_ERROR_FIRST + 49
%SE_ERROR_UNDEFEQUATE        = %SE_ERROR_FIRST + 50

'takes the main struct containing all the info and returns a descriptive error string
Function se_errortext(ByVal ses As ses_type Ptr) As String
         Local stmp1 As String
         Select Case As Long @ses.errcode
                Case %SE_ERROR_NOERROR
                     stmp1 = "no error"
                Case %SE_ERROR_IFEXPECTED
                     stmp1 = "syntax error 'if' expected"
                Case %SE_ERROR_ENDIFEXPECTED
                     stmp1 = "syntax error 'end if' expected"
                Case %SE_ERROR_DOEXPECTED
                     stmp1 = "syntax error 'do' without 'loop'"
                Case %SE_ERROR_LOOPEXPECTED
                     stmp1 = "syntax error 'loop' without 'do'"
                Case %SE_ERROR_WENDEXPECTED
                     stmp1 = "syntax error 'wend' without 'while'"
                Case %SE_ERROR_WHILEEXPECTED
                     stmp1 = "syntax error 'while' without 'wend'"
                Case %SE_ERROR_FOREXPECTED
                     stmp1 = "syntax error 'for' without 'next'"
                Case %SE_ERROR_NEXTEXPECTED
                     stmp1 = "syntax error 'next' without 'for'"
                Case %SE_ERROR_STREXPECTED
                     stmp1 = "error string operand expected"
                Case %SE_ERROR_NUMEXPECTED
                     stmp1 = "error numeric operand expected"
                Case %SE_ERROR_STATEXPECTED
                     stmp1 = "error statment expected"
                Case %SE_ERROR_TOEXPECTED
                     stmp1 = "syntax error 'to' expected"
                Case %SE_ERROR_NUMVAREXPECTED
                     stmp1 = "error numeric variable expected"
                Case %SE_ERROR_STRVAREXPECTED
                     stmp1 = "error string variable expected"
                Case %SE_ERROR_QUOTEEXPECTED
                     stmp1 = "error quote expected"
                Case %SE_ERROR_PARENEXPECTED
                     stmp1 = "error parenthessis expected"
                Case %SE_ERROR_EXITDOWDO
                     stmp1 = "error exit 'do' without 'do'"
                Case %SE_ERROR_EXITFORWFOR
                     stmp1 = "error exit 'for' without 'for'"
                Case %SE_ERROR_EXITIFWIF
                     stmp1 = "error exit 'if' without 'if'"
                Case %SE_ERROR_EXITWHILEWWHILE
                     stmp1 = "error exit 'while' without 'while'"
                Case %SE_ERROR_MISSINGDECL
                     stmp1 = "error missing declaration"
                Case %SE_ERROR_ILLEGALNAME
                     stmp1 = "error illegal name"
                Case %SE_ERROR_ALREADYDECL
                     stmp1 = "error variable already declared"
                Case %SE_ERROR_DUPLICATEDECL
                     stmp1 = "error duplicated declaration"
                Case %SE_ERROR_MATHMODULE
                     stmp1 = "some obscure math module error happened"
                Case %SE_ERROR_FORSTEPZERO
                     stmp1 = "error 'step' can't be zero"
                Case %SE_ERROR_PLUSEXPECTED
                     stmp1 = "error '+' expected "
                Case %SE_ERROR_EXITING
                     stmp1 = "exiting"
                Case %SE_ERROR_STARTING
                     stmp1 = "starting"
                Case %SE_ERROR_PARSING
                     stmp1 = "parsing"
                Case %SE_ERROR_EXECUTING
                     stmp1 = "executing"
                Case %SE_ERROR_EXPRTOOCOMPLEX
                     stmp1 = "expression too complex"
                Case %SE_ERROR_SYNTAXERROR
                     stmp1 = "syntax error"
                Case %SE_ERROR_EXITSELWSEL
                     stmp1 = "'exit select' w/o 'select'"
                Case %SE_ERROR_ENDFUNEXPECTED
                     stmp1 = "'end function' expected"
                Case %SE_ERROR_VAREXPECTED
                     stmp1 = "var name expected"
                Case %SE_ERROR_PARMISMATCH
                     stmp1 = "parameter mismatch"
                Case %SE_ERROR_PARCLOSEEXPECTED
                     stmp1 = "')' expected"
                Case %SE_ERROR_PAROPENEEXPECTED
                     stmp1 = "'(' expected"
                Case %SE_ERROR_OVERFLOW
                     stmp1 = "overflow"
                Case %SE_ERROR_UNDEFEQUATE
                     stmp1 = "undefined equate"
                Case %SE_ERROR_BYPASSEXPECTED
                     stmp1 = "'byval/byref/bycopy' expected"
                Case %SE_ERROR_ASTYPEEXPECTED
                     stmp1 = "'as long/single/dword/string' expected"
                Case %SE_ERROR_FUNNAMEEXPECTED
                     stmp1 = "function name expected"
                Case %SE_ERROR_NESTEDFUN
                     stmp1 = "'function/sub' can't be nested"
                Case %SE_ERROR_ONLYINFUN
                     stmp1 = "'function=' allowed only in functions"
                Case %SE_ERROR_NOSE_MAIN
                     stmp1 = "'se_main' not found..."
                Case Else
                     stmp1 = "unknown error code"
         End Select

         Function = "CT:" + Format$(@ses.pc, "00000") + " LN:" + _
                    Format$(@ses.@ct[@ses.pc].lncnt, "00000") + " SE:" + _
                    Format$(@ses.@ct[@ses.pc].secnt, "00") + " FN:" + _
                    " :" + stmp1 + " [" + Format$(@ses.errcode, "000") + "] "
End Function


'I GOT THIS ROUTINES FROM THE FORUM, THANKS TO THE AUTHORS

Function STDOUT (Z As String) As Long
' returns TRUE (non-zero) on success
   Local hStdOut As Long, nCharsWritten As Long
   Local w As String
   Static CSInitialized As Long, CS As CRITICAL_SECTION
   If IsFalse CSInitialized Then
       InitializeCriticalSection CS
       CSInitialized = 1
   End If
   EnterCriticalSection Cs
   hStdOut = GetStdHandle (%STD_OUTPUT_HANDLE)
   Select Case As Long hStdOut
       Case %Null, -1&
           AllocConsole
           hStdOut       = GetStdHandle (%STD_OUTPUT_HANDLE)
   End Select
   LeaveCriticalSection    CS
   w                     = Z & $CrLf
   Function              = WriteFile(hStdOut, ByVal StrPtr(W), Len(W),  nCharsWritten, ByVal %Null)
End Function

Macro dbcprint (stext)
#If %DEBUG_FLAG
    stdout stext
#EndIf
End Macro

Function stdin() As String
   Dim hInput As Long
   Dim iRead As Long
   Dim iResult As Long
   Dim sBuffer As String
   Dim sOutBuffer As String
   hInput = GetStdHandle(%STD_INPUT_HANDLE)
   If hInput Then
      Do
         sBuffer = Space$(32000)
         iResult = ReadFile(hInput, ByVal StrPtr(sBuffer), Len(sBuffer), iRead, ByVal %Null)
         '- If there was an error, return nothing
         If iResult = 0 Then
            Exit Do
         '- We're done if iRead is 0
         ElseIf iRead = 0 Then
            Exit Do
         '- Otherwise, accumulate the buffer
         Else
            sOutBuffer = sOutBuffer + Left$(sBuffer, iRead)
         End If
         '- Bail if there's nothing left to read.
         If iRead < Len(sBuffer) Then
            Exit Do
         End If
      Loop
   End If
   Function = sOutBuffer
End Function

Sub WaitKey()
    Local hStdIn As Dword
    Local dwBytesRead As Dword
    Local dwConsoleMode As Dword
    Local lpBuffer As INPUT_RECORD
    hStdIn = GetStdHandle(%STD_INPUT_HANDLE)
    If hStdIn <> %Null And hStdIn <> %INVALID_HANDLE_VALUE Then
        GetConsoleMode(hStdIn, dwConsoleMode)
        SetConsoleMode(hStdIn, %ENABLE_LINE_INPUT Or %ENABLE_ECHO_INPUT Or %ENABLE_PROCESSED_INPUT)
        FlushConsoleInputBuffer(hStdIn)
        dwBytesRead = 0
        Do
            PeekConsoleInput(hStdIn, lpBuffer, 1, dwBytesRead)
            Sleep 0
        Loop While dwBytesRead = 0
        FlushConsoleInputBuffer(hStdIn)
        SetConsoleMode(hStdIn, dwConsoleMode)
    End If
End Sub