#Compile Exe
#Register None
#Dim All
#Include "win32api.INC"

' TEXT MESSAGES FROM Win32API  'GetLastError' calls
Declare Function SystemErrorMessageText (ByVal ECode As Long) As String
Function SystemErrorMessageText (ByVal ECode As Long) As String
  Local Buffer As Asciiz * 255
  FormatMessage %FORMAT_MESSAGE_FROM_SYSTEM, ByVal %NULL, ECode, %NULL, buffer, SizeOf(buffer), ByVal %NULL
  Function = Format$(ECode, "#####") & Buffer
End Function

%IDC_OPEN_DOCUMENT  = 101   ' control IDs
%IDC_OPEN_PROGRAM   = 102
%IDC_PRINT_DOCUMENT = 103
%IDC_QUIT           = 104

Declare Function DoTheShellEx (ByVal hWnd As Long, ByVal ControlId As Long) As Long

CallBack Function DialogProc () As Long
  Local stat As Long
  If CbCtlMsg= %bn_clicked Then
              Select Case CbCtl
                     Case %IDC_OPEN_DOCUMENT, %IDC_OPEN_PROGRAM, %IDC_PRINT_DOCUMENT
                          stat = DoTheShellEx (CbHndl, CbCtl)
                          setfocus CbHndl
                      Case %IDC_QUIT
                           Dialog End CbHndl
              End Select
  End If

End Function

Function WinMain (ByVal hInstance     As Long, _
                  ByVal hPrevInstance As Long, _
                  lpCmdLine           As Asciiz Ptr, _
                  ByVal iCmdShow      As Long) As Long

   Local Stat As Long, hDlg As Long

   Dialog New 0, "ShellExecute Process Monitoring",,, 240, 120,, To hDlg
   Control Add Button, hDlg, %IDC_OPEN_DOCUMENT,  "Open Doc"   , 20, 40, 60,16
   Control Add Button, hDlg, %IDC_OPEN_PROGRAM,   "Open Program", 90, 40, 60,16
   Control Add Button, hDlg, %IDC_PRINT_DOCUMENT, "Print Doc"   , 170, 40, 60,16
   Control Add Button, hDlg, %IDC_QUIT, "Quit"                  , 80, 100, 60,14

   Dialog Show Modal hDlg, Call DialogProc

End Function

Function DoTheShellEx (ByVal hwnd As Long, ByVal ControlID As Long) As Long

   Local SEI As ShellExecuteInfo, Stat As Long, E As Long

   Local hWaitProcess As Long
   Local lpVerb As Asciiz * 20, lpParameters As Asciiz * 20, lpDirectory As Asciiz * 20, lpFile As Asciiz * %MAX_PATH
   Local TimeOut2 As Long   ' "timeout" is another un-hilited "reserved" word which is truly only reserved
                            '  in the context of a TCP or UDP verb and can only be found with "search."
                            '  The error message if you use 'timeout' as a variable name is
                            '  "statement expected," which is a useless error message.

   Select Case ControlId
          Case %IDC_OPEN_DOCUMENT
              lpVerb = "Open"
              lpParameters   = ""
              lpFile = "C:\TestShExec.txt"
              Timeout2 = 30 * 1000            ' 30 secs
           Case %IDC_PRINT_DOCUMENT
              lpVerb = "PRINT"
              lpFile = "C:\TestShExec.txt"
              lpParameters = ""
              Timeout2 = 60 * 1000            ' 60 secs
           Case  %IDC_OPEN_PROGRAM
             'Windows Program
             lpVerb = "Open"
             lpFile = "notepad.exe"
            lpParameters = "C:\TestShExec.txt"
             ' DOS PROGRAM
             lpFile ="C:\Software_Development\Pb-Dos\Exe\horse.exe"
             lpParameters = ""
             Timeout2 = 30 * 1000            ' 30 secs
   End Select

   SEI.cbSize       = SizeOf(SEI)
   SEI.fmask        = %SEE_MASK_NOCLOSEPROCESS
   SEI.hWnd         = hWnd
   SEI.lpVerb       = VarPtr(lpVerb)
   SEI.LpFile       = VarPtr(lpFile)
   SEI.lpParameters = VarPtr (lpParameters)
   SEI.lpDirectory  = %NULL
   SEI.nShow        = %sw_show      ' should be zero for a document file PER MSDN DOC.
                                    ' MSDN DOC IS WRONG, use SW_SHOW!
   SEI.hInstApp     = 0             ' updated by function
   SEI.lpIdList     = %NULL         ' here down to hprocess ignored unless appropriate mask included in fmask
   SEI.lpClass      = %NULL
   SEI.hkeyClass    = %NULL
   SEI.dwHotKey     = %NULL
   SEI.item         = %NULL
   SEI.hProcess     = 0             ' will be updated by ShellExecuteEx

   If IsTrue ShellExecuteEx(SEI) Then       ' function succeeded and returned
        hWaitProcess = SEI.hProcess
        Stat = WaitForSingleObjectEx (hWaitProcess, Timeout2, 0)
        Select Case Stat
              Case -1&
                   E = GetLastError
                   MsgBox "Wait Failed:" & SystemErrorMessageText (E)
              Case %WAIT_OBJECT_0
                   MsgBox "Wait returned from " & lpVerb & " on process completion"
              Case %WAIT_TIMEOUT
                   MsgBox "Wait returned from " & lpVerb & " on Timeout"
              Case Else
                   MsgBox "Unexpected Return, code=" & Str$(Stat)
        End Select
        CloseHandle hWaitProcess
  Else
      E = GetLastError
      MsgBox "ShellExecuteEx failed:" & SystemErrorMessageText(E)
  End If


End Function
