/* 
	Bitmap to ascii converter
	Created by Hoax3r
*/

#include <windows.h>
#include <stdio.h>
#include <stdbool.h>


#define BMP24		24
#define BMP24_SIZE	3

bool ConvertImage( char *FileName, char *OutputFile )
{
	FILE *fBmp, *fOut;
	char *color_table, *ps;
	int pading, bytePerLine;
	BITMAPFILEHEADER bmf;
	BITMAPINFOHEADER bmi;

	memset(&bmf, 0, sizeof(BITMAPFILEHEADER));
	memset(&bmi, 0, sizeof(BITMAPINFOHEADER));
	
	fBmp = fopen(FileName, "rb");

	if ( fBmp == NULL )
	{
		fprintf(stderr, "Cannot open %s\n", FileName);
		return false;
	}

	fread(&bmf, sizeof(BITMAPFILEHEADER), 1, fBmp);
	fread(&bmi, sizeof(BITMAPINFOHEADER), 1, fBmp);

	color_table = (char *) calloc( bmi.biSizeImage, sizeof(char) );

	if ( bmi.biBitCount != BMP24 )
	{
		fprintf(stderr, "'%s' not 24bit Bitmap !! %s\n", FileName);
		return false;
	}

	fread(color_table, 1, bmi.biSizeImage, fBmp);
	fclose(fBmp);
		
	bytePerLine = bmi.biWidth * bmi.biBitCount / 8;
	pading = 4 - ( bytePerLine % 4);

	if ( pading == 4 )
		pading  = 0;

	if ( OutputFile != NULL )
		fOut = fopen(OutputFile, "w");
	else
		fOut = stdout;
		
	for ( int line = bmi.biHeight - 1; line >= 0; line-- )
	{
		ps = color_table;
		ps += (line * (BMP24_SIZE * (bmi.biWidth + pading)));

		for ( int rgb = 0; rgb < bmi.biWidth; rgb++ )
		{
			if ( memcmp(ps, "\xFF\xFF\xFF", BMP24_SIZE) == 0 )		/* for white pixel*/
				fprintf(fOut, "0");
			else		 /* for black and other pixel */
				fprintf(fOut, "1");

			ps += 3;
		}

		fprintf(fOut, "\n");
	}

	if ( OutputFile != NULL )
		fclose(fOut);

	free(color_table);

	return true;
}

int main(int argc, char *argv[])
{

	if ( argc < 2 || argc > 3 )
	{
		printf("Argument error!\n");
		printf("\tArgument Format : bitmapconv BmpFile [OutputFile]\n");
		printf("\tUsage Example : bitmapconv pic.bmp output.txt\n");
		return -1;
	}

	if ( !ConvertImage(argv[1], (argc == 2 ? NULL : argv[2]) ) )
		return -1;

	return 0;
}
