/****************************************
/ Calculator program for basic computer
/ Author: Mr.T (mrtofigh@gmail.com)
/ Last change: 1386.4.2
/ All rights reserved.
/****************************************

	org	0

/------------------------------------------------
interrupt,
	bun	start

	bun	interrupt i

/------------------------------------------------
	include	'math.inc'
	include	'display.inc'
	include	'keypad.inc'

/------------------------------------------------
start,	
reset,
	cla
	sta	operand
	sta	result
	sta	operator
	sta	eqWasEntered

	bsa	writeHex

loop,
	bsa	readNum16
	sta	newOperand
	cla
	cil
	sta	newOpEntered

	bsa	readKey
	sta	key

	add	resetKey
	sza
	bun	noReset
	bun	reset

noReset,
checkOpEntered,
	lda	newOpEntered
	sza
	bun	checkSuccess

checkEqKey,
	lda	key
	add	equalityKey
	sza
	bun	noOperand
	bun	doOperand

checkSuccess,
	lda	newOperand
	sta	operand

	lda	eqWasEntered
	sza
	bun	ignorePrevOperand
	bun	doOperand
	
ignorePrevOperand,
	cla
	sta	operator

doOperand,
	lda	operator
	bsa	lookup
	addr	routines

	sta	routine
	sze
	bun	callRoutine

	lda	operand
	bun	afterCall

callRoutine,
	lda	result
	bsa	routine i
	addr	operand

afterCall,
	sta	result
	bsa	writeNumber

	lda	key
	add	equalityKey
	sza
	bun	noEqKey
	bun	eqKey

noOperand,
noEqKey,
	lda	key
	sta	operator

	cla
	bun	loopEnd

eqKey,
	cla
	cma

loopEnd,
	sta	eqWasEntered

	bsa	waitNoKey
	bun	loop

key,
	hex	0
newOperand,
	hex	0
newOpEntered,
	hex	0
eqWasEntered,
	hex	0
operand,
	hex	0
result,
	hex	0
operator,
	hex	0
routine,
	hex	0
resetKey,
	dec	-13
equalityKey,
	dec	-15
routines,
	dec	4
	addr	divide

	dec	8
	addr	mul8

	dec	12
	addr	sub16

	dec	16
	addr	add16

	dec	0

/----------------------------------------
divide,
	nop

	sta	divide_Op1

	lda	divide i
	sta	divide_Op2
	lda	divide_Op2 i
	sta	divide_Op2
	isz	divide

	lda	divide_Op1
	bsa	div16
	addr	divide_Op2
	addr	divide_Rem

	bun	divide i

divide_Op1,
	hex	0
divide_Op2,
	hex	0
divide_Rem,
	hex	0

/----------------------------------------
	end