<?php
                         
$LeapMonth = array("dkSolar" => 12 /*Esfand*/, "dkGregorian" => 2 /*February*/);
$DaysOfMonths = array(
    "dkSolar" =>
    array(  1 => 31,  31,  31,  31,  31,  31,  30,  30,  30,  30,  30,  29 ),
    #{ Far, Ord, Kho, Tir, Mor, Sha, Meh, Aba, Aza, $Day, Bah,^Esf },
    "dkGregorian"=>
    array(  1 => 31,  28,  31,  30,  31,  30,  31,  31,  30,  31,  30,  31 ));
    #{ Jan,^Feb, Mar, Apr, May, Jun, Jul, Aug, Sep, Oct, Nov, Dec }
    
$DaysToMonth = array(
    "dkSolar" =>
    array(   1 => 0,  31,  62,  93, 124, 155, 186, 216, 246, 276, 306, 336, 365 ),
    #{ Far, Ord, Kho, Tir, Mor, Sha, Meh, Aba, Aza, $Day, Bah,^Esf, *** },
    "dkGregorian" =>
    array(   1 => 0,  31,  59,  90, 120, 151, 181, 212, 243, 273, 304, 334, 365 ));
    #{ Jan,^Feb, Mar, Apr, May, Jun, Jul, Aug, Sep, Oct, Nov, Dec, *** }
  

function IsLeapYear($DateKind, $Year)
{
  if ($DateKind == "dkSolar")  
    return (((( $Year + 38) * 31) % 128) <= 30);
  else
    return (($Year % 4) == 0) && ((($Year % 100) != 0) || (($Year % 400) == 0));
}

function DaysOfMonth($DateKind, $Year, $Month)
{
  global $LeapMonth;
  global $DaysOfMonths; 
  
  if (($Year != 0) && (($Month >= 1) && ($Month <= 12)))
  {
    $Result = $DaysOfMonths[$DateKind][$Month];
    if (($Month == $LeapMonth[$DateKind]) && (IsLeapYear($DateKind, $Year)))
      $Result++;
  }
  else
    $Result = 0;
  return $Result;
}

function IsDateValid($DateKind, $Year, $Month, $Day)
{   
  $result = ($Year != 0) && ($Month >= 1) && ($Month <= 12) && 
            ($Day >= 1) && ($Day <= DaysOfMonth($DateKind, $Year, $Month));
  return $result;          
}

function DaysToDate($DateKind, $Year, $Month, $Day)
{
  global $LeapMonth;
  global $DaysToMonth;
    
  if (IsDateValid($DateKind, $Year, $Month, $Day))
  {
    $Result = $DaysToMonth[$DateKind][$Month] + $Day;
    if (($Month > $LeapMonth[$DateKind]) && IsLeapYear($DateKind, $Year))
      $Result++;
  }
  else
    $Result = 0;
  return $Result;  
}

function DateOfDay($DateKind, $Days, $Year, &$Month, &$Day)
{
  global $LeapMonth;
  global $DaysToMonth;
    
  $Day = 0;
  $Month = 0;
  $LeapDay = 0;
  
  for ($m=2;$m<=13;++$m)
  {
    if (($m > $LeapMonth[$DateKind]) && IsLeapYear($DateKind, $Year))
      $LeapDay = 1;
    if ($Days <= ($DaysToMonth[$DateKind][$m] + $LeapDay))
    {
      $Month = $m - 1;
      if ($Month <= $LeapMonth[$DateKind])
        $LeapDay = 0;
      $Day = $Days - ($DaysToMonth[$DateKind][$Month] + $LeapDay);
      Break;
    }
  }
  $Result = IsDateValid($DateKind, $Year, $Month, $Day);
  return $Result;
}

function GregorianToSolar(&$Year, &$Month, &$Day)
{   
  if (IsDateValid("dkGregorian", $Year, $Month, $Day))
  {
    $PrevGregorianLeap = IsLeapYear("dkGregorian", $Year-1);
    $Days = DaysToDate("dkGregorian", $Year, $Month, $Day);
    $Year -= 622;
    if (IsLeapYear("dkSolar", $Year))
      $LeapDay = 1;
    else
      $LeapDay = 0;
    if ($PrevGregorianLeap && ($LeapDay == 1))
      $Days += 287;
    else
      $Days += 286;
      
    if ($Days > (365 + $LeapDay))
    {
      $Year++;
      $Days -= (365 + $LeapDay);
    }
    $Result = DateOfDay("dkSolar", $Days, $Year, &$Month, &$Day);
  }
  else
    $Result = false;
  return $Result;
}

function SolarToGregorian(&$Year, &$Month, &$Day)
{
  if (IsDateValid("dkSolar", $Year, $Month, $Day))
  {
    $PrevSolarLeap = IsLeapYear("dkSolar", $Year-1);
    $Days = DaysToDate("dkSolar", $Year, $Month, $Day);
    $Year += 621;
    if (IsLeapYear("dkGregorian", $Year))
      $LeapDay = 1;
    else
      $LeapDay = 0;
    if ($PrevSolarLeap && ($LeapDay == 1))
      $Days += 80;
    else
      $Days += 79;
    if ($Days > (365 + LeapDay))
    {
      $Year++;
      $Days -= (365 + $LeapDay);
    }
    $Result = DateOfDay("dkGregorian", $Days, $Year, &$Month, &$Day);
  }
  else
    $Result = false;
  return $Result;
}

function SolarEncodeDate($Year, $Month, $Day)
{
  if (SolarToGregorian(&$Year, &$Month, &$Day))
    $Result = $Year.'/'.$Month.'/'.$Day;
  else
    $Result = '';
  return $Result;    
}

function GetSolarDate()
{
  $today = getdate();
  $Year = $today[year];
  $Month = $today[mon];
  $Day = $today[mday];
  GregorianToSolar(&$Year, &$Month, &$Day);
  $Result = $Year.'/'.$Month.'/'.$Day;
  return $Result;
}
?>