// MorseCodeView.h : interface of the CMorseCodeView class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_MORSECODEVIEW_H__3FD242B9_29F0_4B04_AB9C_F015A0FAE6C3__INCLUDED_)
#define AFX_MORSECODEVIEW_H__3FD242B9_29F0_4B04_AB9C_F015A0FAE6C3__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

enum e_modulation { AM_LO, AM_HI, CW };

class CMorseCodeView : public CEditView
{
protected: // create from serialization only
        CMorseCodeView();
        DECLARE_DYNCREATE(CMorseCodeView)

// Attributes
public:
        CMorseCodeDoc* GetDocument();

// Operations
public:

// Overrides
        // ClassWizard generated virtual function overrides
        //{{AFX_VIRTUAL(CMorseCodeView)
        public:
        virtual void OnDraw(CDC* pDC);  // overridden to draw this view
        virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
        protected:
        virtual BOOL OnPreparePrinting(CPrintInfo* pInfo);
        virtual void OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo);
        virtual void OnEndPrinting(CDC* pDC, CPrintInfo* pInfo);
        //}}AFX_VIRTUAL

// Implementation
public:
        virtual ~CMorseCodeView();
#ifdef _DEBUG
        virtual void AssertValid() const;
        virtual void Dump(CDumpContext& dc) const;
#endif

        bool transmitting( void ) { return _transmitting; }
        void transmitting( bool t ) { _transmitting = t; }

        bool repeat( void ) { return _repeat; }
        void repeat( bool r ) { _repeat = r;}

        char *com_port( void ) { return _com_port; }
        void com_port( char *c ) { _com_port = c; }

        int speed( void ) { return _speed; }
        void speed( int s ) { _speed = s; set_speed(s); }

        e_modulation modulation( void ) { return _modulation; }
        void modulation( e_modulation m ) { _modulation = m; }

        bool opencomm( char * );
        void on( void );
        void off( void );
        void dot( void );
        void dash( void );
        void long_tone( void );
        char *lookup( char );
        void send_char( char );
        void send( char *str );
        void send_lines( void );
        void set_speed( int );
        void init_morse( void );
        void kill_morse( void );

private:
        int dot_length;
        int dash_length;
        int token_sep;
        int char_sep;
        int space_length;

protected:

        e_modulation _modulation;
        bool _transmitting;
        bool _repeat;
        char *_com_port;
        int _speed;

// Generated message map functions
protected:
        //{{AFX_MSG(CMorseCodeView)
        afx_msg void OnAmHigh();
        afx_msg void OnUpdateAmHigh(CCmdUI* pCmdUI);
        afx_msg void OnAmLow();
        afx_msg void OnUpdateAmLow(CCmdUI* pCmdUI);
        afx_msg void OnCom1();
        afx_msg void OnUpdateCom1(CCmdUI* pCmdUI);
        afx_msg void OnCom2();
        afx_msg void OnUpdateCom2(CCmdUI* pCmdUI);
        afx_msg void OnCom3();
        afx_msg void OnUpdateCom3(CCmdUI* pCmdUI);
        afx_msg void OnCom4();
        afx_msg void OnUpdateCom4(CCmdUI* pCmdUI);
        afx_msg void OnCom5();
        afx_msg void OnUpdateCom5(CCmdUI* pCmdUI);
        afx_msg void OnCom6();
        afx_msg void OnUpdateCom6(CCmdUI* pCmdUI);
        afx_msg void OnCom7();
        afx_msg void OnUpdateCom7(CCmdUI* pCmdUI);
        afx_msg void OnCom8();
        afx_msg void OnUpdateCom8(CCmdUI* pCmdUI);
        afx_msg void OnCw();
        afx_msg void OnUpdateCw(CCmdUI* pCmdUI);
        afx_msg void OnRepeat();
        afx_msg void OnUpdateRepeat(CCmdUI* pCmdUI);
        afx_msg void OnSpeed10();
        afx_msg void OnUpdateSpeed10(CCmdUI* pCmdUI);
        afx_msg void OnSpeed100();
        afx_msg void OnUpdateSpeed100(CCmdUI* pCmdUI);
        afx_msg void OnSpeed2();
        afx_msg void OnUpdateSpeed2(CCmdUI* pCmdUI);
        afx_msg void OnSpeed20();
        afx_msg void OnUpdateSpeed20(CCmdUI* pCmdUI);
        afx_msg void OnSpeed25();
        afx_msg void OnUpdateSpeed25(CCmdUI* pCmdUI);
        afx_msg void OnSpeed3();
        afx_msg void OnUpdateSpeed3(CCmdUI* pCmdUI);
        afx_msg void OnSpeed40();
        afx_msg void OnUpdateSpeed40(CCmdUI* pCmdUI);
        afx_msg void OnSpeed5();
        afx_msg void OnUpdateSpeed5(CCmdUI* pCmdUI);
        afx_msg void OnSpeed50();
        afx_msg void OnUpdateSpeed50(CCmdUI* pCmdUI);
        afx_msg void OnSpeed80();
        afx_msg void OnUpdateSpeed80(CCmdUI* pCmdUI);
        afx_msg void OnSpeed30();
        afx_msg void OnUpdateSpeed30(CCmdUI* pCmdUI);
        afx_msg void OnSpeed1();
        afx_msg void OnUpdateSpeed1(CCmdUI* pCmdUI);
        afx_msg void OnShowWindow(BOOL bShow, UINT nStatus);
        afx_msg void OnTransmitter();
        afx_msg void OnUpdateTransmitter(CCmdUI* pCmdUI);
        //}}AFX_MSG
        DECLARE_MESSAGE_MAP()
};

#ifndef _DEBUG  // debug version in MorseCodeView.cpp
inline CMorseCodeDoc* CMorseCodeView::GetDocument()
   { return (CMorseCodeDoc*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_MORSECODEVIEW_H__3FD242B9_29F0_4B04_AB9C_F015A0FAE6C3__INCLUDED_)
