# include <windows.h>
# include <stdio.h>
# include <time.h>

struct
{
    char l;
    char *c;
}
code[] =
{
    'A', ".-",
    'B', "-...",
    'C', "-.-.",
    'D', "-..",
    'E', ".",
    'F', "..-.",
    'G', "--.",
    'H', "....",
    'I', "..",
    'J', ".---",
    'K', "-.-",
    'L', ".-..",
    'M', "--",
    'N', "-.",
    'O', "---",
    'P', ".--.",
    'Q', "--.-",
    'R', ".-.",
    'S', "...",
    'T', "-",
    'U', "..-",
    'V', "...-",
    'W', ".--",
    'X', "-..-",
    'Y', "-.--",
    'Z', "--..",
    '0', "-----",
    '1', ".----",
    '2', "..---",
    '3', "...--",
    '4', "....-",
    '5', ".....",
    '6', "-....",
    '7', "--...",
    '8', "---..",
    '9', "----.",
    '/', "-..-.",
    '+', ".-.-.",
    '=', "-...-",
    '.', ".-.-.-",
    ',', "--..--",
    '?', "..--..",
    '(', "-.--.",
    ')', "-.--.-",
    '-', "-....-",
    '"', ".-..-.",
    '_', "..--.-",
    '\'', ".----.",
    ':', "---...",
    ';', "-.-.-.",
    '$', "...-..-",
    '\1', "=",
    0, 0,
};


char *port = "com1:";

HANDLE hFile = INVALID_HANDLE_VALUE;

bool
opencomm( char *which )
{

    int da = GENERIC_READ | GENERIC_WRITE;
    int sm = FILE_SHARE_DELETE | FILE_SHARE_READ | FILE_SHARE_WRITE;
    int cd = OPEN_EXISTING;
    int flags = FILE_ATTRIBUTE_NORMAL | FILE_FLAG_NO_BUFFERING;

    hFile = CreateFile( which, da, sm, 0, cd, flags, 0 );

    if( hFile == INVALID_HANDLE_VALUE )
    {
        printf( "Can't open '%s'\n", which );
        return false;
    }

    DCB dcb;

    if( ! GetCommState( hFile, &dcb ) )
    {
        printf( "Can't get comm state for '%s'\n", which );
        return false;
    }

    dcb.fOutxCtsFlow = FALSE;
    dcb.fOutxDsrFlow = FALSE;
    dcb.fDtrControl = DTR_CONTROL_ENABLE;
    dcb.fDsrSensitivity = FALSE;
    dcb.fRtsControl = RTS_CONTROL_DISABLE;

    if( ! SetCommState( hFile, &dcb ) )
    {
        printf( "Can't set comm state for '%s'\n", which );
        return false;
    }

    return true;
}

void
on( void )
{
    EscapeCommFunction( hFile, SETDTR );
    EscapeCommFunction( hFile, SETRTS );
}

void
off( void )
{
    EscapeCommFunction( hFile, CLRDTR );
    EscapeCommFunction( hFile, CLRRTS );
}


int dot_length = 100;
int dash_length = 300;
int token_sep = 100;
int char_sep = 300;
int space_length = 700;

enum e_mode { CW, AM };

e_mode mode = AM;
bool low_tone = false;

void
dot( void )
{
    if( mode == CW )
    {
        on();
        Sleep( dot_length );
        off();
    }
    else if( mode == AM )
    {
        for( int i = 0; i < dot_length / 2; i++ )
        {
            on();
            Sleep( 1 );
            if( low_tone )
                Sleep( 1 );
            off();
            Sleep( 1 );
            if( low_tone )
                Sleep( 1 );
        }
    }

    Sleep( token_sep );
}

void
dash( void )
{
    if( mode == CW )
    {
        on();
        Sleep( dash_length );
        off();
    }
    else if( mode == AM )
    {
        for( int i = 0; i < dash_length / 2; i++ )
        {
            on();
            Sleep( 1 );
            if( low_tone )
                Sleep( 1 );
            off();
            Sleep( 1 );
            if( low_tone )
                Sleep( 1 );
        }
    }

    Sleep( token_sep );
}

void
long_tone( void )
{
    printf( "5 second tone\n" );

    on();
    Sleep( 5000 );
    off();
}

char *
lookup( char c )
{
    for( int i = 0; code[i].c; i++ )
        if( code[i].l == c )
            return code[i].c;

    return "";
}

void
send_char( char c )
{
    if( c == ' ' )
    {
        Sleep( space_length );
        return;
    }

    c = toupper( c );

    char *str = lookup( c );

    while( *str )
    {
        if( *str == '.' )
            dot();
        else if( *str == '-' )
            dash();
        else if( *str == '=' )
            long_tone();
        str++;
    }

    Sleep( char_sep );
    off();
}

void
send( char *str )
{
    while( *str )
        send_char( *str++ );
}


int the_speed = 5;
int character_speed = 15.0;

void
set_speed( char *str )
{
    the_speed = atoi( str );

    //
    // Using + to mean the transmitter is on for one unit,
    // and - to mean it is off for one unit, the word 'PARIS ' looks like
    //
    // P +- +++- +++- +- --             14 units
    // A +- +++- --                      8 units
    // R +- +++- +- --                  10 units
    // I +- +- --                        6 units
    // S +- +- +- --                     8 units
    //   -- --                           4 units
    //                                  ==============
    //                                  50 units total
    //
    // After each dot or dash, we wait one unit.
    // After each letter, we wait three units (i.e. two additional units).
    // After each word, we wait seven units (i.e. four additional units).
    //
    // We want to send the letters at a speed of at least 15 words per
    // minute, so they can be recognized by their sound.  But we want
    // to only send N words per minute.  So, if N is less than 15, we
    // must add extra time to the space between the letters and the
    // words.  After each letter there are 2 units of silence that
    // have to be stretched.  After each word there are 4 units that
    // have to be stretched.  That makes 14 units that have to be stretched.
    // There are 50 units in all, so there are 50 - 14 = 36 units that are
    // not stretched.  The 14 units come in pairs, so we divide by 7 to
    // get the length of each silence.
    //

    if( character_speed < the_speed )   // farnsworth
        character_speed = the_speed;    // all letters sent at 15 wpm minimum

    dot_length = 60 * 1000 / character_speed / 50;     // 60 seconds, 50 units

    dash_length = 3 * dot_length;
    token_sep = dot_length;

    int milliseconds_per_word = 60 * 1000 / the_speed;
    int milliseconds_in_36_units = 36 * 60 * 1000 / character_speed / 50; 

    char_sep = (milliseconds_per_word - milliseconds_in_36_units) / 7;
    space_length = (milliseconds_per_word - milliseconds_in_36_units) / 3.5;

    if( low_tone && mode == AM )
    {
        dot_length /= 2;
        dash_length /= 2;
    }
}

bool speed_test = false;
bool tone = false;
int repeat = 1;
char *message = 0;
char *file = 0;

int
main( int ac, char **av )
{
    ac--;
    av++;

    char *speed = "5";

    while( ac > 0 )
    {
        if( av[0][0] == '-' )
        {
            if( av[0][1] == 'p' )               // port
            {
                port = av[1];
                ac--;
                av++;
            }
            else if( av[0][1] == 'r' )          // repeat
            {
                repeat = atoi( av[1] );
                ac--;
                av++;
            }
            else if( av[0][1] == 'f' )          // file
            {
                file = av[1];
                ac--;
                av++;
            }
            else if( av[0][1] == 'm' )          // message
            {
                message = av[1];
                ac--;
                av++;
            }
            else if( av[0][1] == 's' )          // speed
            {
                speed = av[1];
                ac--;
                av++;
            }
            else if( av[0][1] == 'l' )          // low
            {
                low_tone = true;
            }
            else if( av[0][1] == 't' )          // test
            {
                speed_test = true;
            }
            else if( av[0][1] == 'o' )          // on
            {
                tone = true;
            }
            else if( av[0][1] == 'c' )          // continuous wave
            {
                mode = CW;
            }
            else if( av[0][1] == 'a' )          // amplitude modulation
            {
                mode = AM;
            }
            else
            {
                printf( "Usage: morse [-p port] [-s speed] [-r repeat_count]"
                    " [-f file] [-m message] [-c]\n\n" );

                printf( "Example: morse -p com2: -s 5\n" );
                printf( "    gives 5 words per minute to com2\n" );

                printf( "\n" );

                printf( "Complete list of all options:\n" );
                printf( " -p port        use 'port' for the serial port\n" );
                printf( " -r number      repeat 'number' times\n" );
                printf( " -f file        read text from a file\n" );
                printf( " -m message     send message from command line\n" );
                printf( " -t             send the word 'paris ' for a minute\n" );
                printf( " -o             keep the transmitter on\n" );
                printf( " -c             Use CW instead of AM\n" );
                printf( " -l             Use 500 hz tone instead of 1,000 hz\n" );
                return 0;
            }
        }
        av++;
        ac--;
    }

    set_speed( speed );

    opencomm( port );

    off();

    if( tone )
    {
        on();
        printf( "Transmiter is on\n" );
        for(;;)
            Sleep( 1000 );
    }

    if( speed_test )
    {
        time_t t = time(0);
        for( int i = 0; i < the_speed; i++ )
            send( "paris " );
        printf( "%d word%s in %d seconds\n", the_speed,
                the_speed == 1 ? "" : "s", time(0) - t );
        return 0;
    }

    printf( "Speed set to %d words per minute.\n", the_speed );
    printf( "Mode is %s.\n", mode == AM ? "AM" : "CW" );

    if( file )
    {
        printf( "File is '%s'.\n", file );

        for( int i = 0; i < repeat; i++ )
        {
            char buf[1024];
            FILE *fd = fopen( file, "r" );

            if( fd == 0 )
            {
                printf( "Can't open '%s' for reading\n", file );
                return 0;
            }

            for( ;; )
            {
                int cnt = fread( buf, 1, sizeof buf, fd );

                if( cnt < 0 )
                {
                    printf( "Can't read '%s'\n", file );
                    return 0;
                }

                if( cnt == 0 )
                    break;

                buf[cnt] = 0;

                send( buf );
            }

            fclose( fd );
        }
        return 0;
    }

    if( message )
    {
        for( int i = 0; i < repeat; i++ )
            send( message );
        return 0;
    }

    printf( "Type your messages:\n" );

    printf( "> " );
    fflush( stdout );

    char out[1024];
    while( gets( out ) )
    {
        for( int i = 0; i < repeat; i++ )
            send( out );
        printf( "> " );
        fflush( stdout );
    }

    return 0;
}
