Attribute VB_Name = "mImport"
Option Explicit

Function ImportTextFile(sSourceFile As String, sDestinationFile As String) As Integer
Dim dDestination As Database
Dim dSource As Database
Dim dsSource As Dynaset
Dim sConnect As String
Dim sOldTblName$, sNewTblName$

On Error GoTo ImportTextFileErr

    'open destination database
    Set dDestination = OpenDatabase(sDestinationFile)
    
    'make table names
    sOldTblName = MakeTableName(sSourceFile, False, dDestination)
    sNewTblName = MakeTableName(sSourceFile, True, dDestination)
    
    'Set dSource = OpenDatabase(StripFileName(sSourceFile), False, False, "Text;")
    sConnect = "[Text;database=" & StripFileName(sSourceFile) & "]."
    dDestination.Execute "select * into " & sNewTblName & " from " & sConnect & sOldTblName
    
    dDestination.Close
    'dSource.Close
    ImportTextFile = True
    
    Exit Function
    
ImportTextFileErr:
    ImportTextFile = False
    dDestination.Close
End Function

Function StripFileName(sFileName As String) As String
'------------------------------------------------------------
'this function strips the file name from a path\file string
'------------------------------------------------------------
  On Error Resume Next
  Dim i As Integer

  For i = Len(sFileName) To 1 Step -1
    If Mid(sFileName, i, 1) = "\" Then
      Exit For
    End If
  Next

  StripFileName = Mid(sFileName, 1, i - 1)

End Function

Function MakeTableName(fname As String, newname As Integer, dbCurrentDB As Database) As String
  On Error Resume Next
  Dim i As Integer, t As Integer
  Dim tmp As String

  If InStr(fname, "\") > 0 Then
    'strip off path
    For i = Len(fname) To 1 Step -1
      If Mid(fname, i, 1) = "\" Then
        Exit For
      End If
    Next
    tmp = Mid(fname, i + 1, Len(fname))
    If newname Then
        i = InStr(1, tmp, ".")
        If i > 0 Then
          tmp = Mid(tmp, 1, i - 1)
        End If
    End If
  Else
    tmp = fname
  End If

  If newname Then
    If DupeTableName(tmp, dbCurrentDB, "JET") Then
      t = 1
      While DupeTableName(tmp + CStr(t), dbCurrentDB, "JET")
        t = t + 1
      Wend
      tmp = tmp + CStr(t)
    End If
  End If

  MakeTableName = tmp

End Function

Function DupeTableName(rName As String, dbCurrentDB As Database, sDataBaseType As String) As Integer
  On Error GoTo DTNErr
'------------------------------------------------------------
'this function checks to see if the passed in name exists
'in either the Tabledefs or Querydefs collection
'it found, it prompts to delete it and returns false
'if the user selects to delete it or true if not
'if not found, it returns false
'------------------------------------------------------------
  Dim tdf As TableDef
  Dim qdf As QueryDef
  Dim i As Integer
 
  For Each tdf In dbCurrentDB.TableDefs
    If UCase(tdf.Name) = UCase(rName) Then
      If MsgBox("Table '" & rName & "' exists, Delete it?", 36) = 6 Then
        dbCurrentDB.TableDefs.Delete rName
        DupeTableName = False
      Else
        DupeTableName = True
      End If
      Exit Function
    End If
  Next

  If sDataBaseType = "JET" Then
    For Each qdf In dbCurrentDB.QueryDefs
      If UCase(qdf.Name) = UCase(rName) Then
        If MsgBox("QueryDef '" & rName & "' exists, Delete it?", 36) = 6 Then
          dbCurrentDB.QueryDefs.Delete rName
          DupeTableName = False
        Else
          DupeTableName = True
        End If
        Exit Function
      End If
    Next
  End If

  DupeTableName = False
  Exit Function

DTNErr:
  DupeTableName = False
  Exit Function

End Function

