//*************************************************************************/
//Using the ADC.
// This file contains the ADC initiation, interrupt routines and fifo storage of the results.
//
// Written 3 Nov 2005 By Murray Horn.
//*************************************************************************/

#include <avr/interrupt.h>
#include <avr/signal.h>

#include <adc001.inc>		// setup the tx and rx que size here


//-----------------------------------------------------
// Prototypes
#include <adc001.h>

//-----------------------------------------------------


#define circular_t	uint8_t
//-----------------------------------------------------
// Static Variables
static uint16_t ADC_Buf[ADC_BUFSIZE];
static volatile circular_t ADC_head;
static volatile circular_t ADC_tail;
//-----------------------------------------------------

#include <avr/io.h>			// included to enable the writing of strings from rom


// this is the only routine that is allowed to change the ADC_head
SIGNAL(SIG_ADC)
{
	uint16_t data;
	circular_t tmp_head,nxt_head,tmp_tail;
	
//	Read the received data
	data = ADCL; // always read the lower byte first
	data = data + (ADCH << 8);
	
	tmp_head = ADC_head;
// catch the pointer. if a interrupt routine accessed it and corrupted the read, recatch it.
	do	
		tmp_tail = ADC_tail;
	while 	(tmp_tail != ADC_tail);

	//	Calculate buffer index
	nxt_head = ( tmp_head + 1 ) & ADC_BUFFER_MASK;

	if ( nxt_head == tmp_tail )
	{
// ERROR! Receive buffer overflow
	}
	else{
		ADC_Buf[tmp_head] = data; // Store received data in buffer
		ADC_head = nxt_head;      // Store new index */
	}	


}

//-----------------------------------------------------



void adc_init(uint8_t	channel)
{
//===========
//		Flush buffers // twice incase a int came along
	ADC_tail = 0;
	ADC_tail = 0;
	ADC_head = 0;
	ADC_head = 0;

// 		enable the adc
//		set the prescaler
// free running 
	ADCSRA = (1 << ADEN) | (1 << ADFR)| (1 << ADIF)  | (1 << ADIE) | (1 << ADPS2) | (1 << ADPS1) | (1 << ADPS0);
	channel = channel & 0x0f;
	ADMUX = (1 << REFS1) | (1 << REFS0) | channel; // select channel with 2.56v internal ref and right justification
//	ADMUX = (1 << REFS0); // select channel 0 with vcc as a ref and right justification

}






//-----------------------------------------------------
//	RX function
// this is the only routine that is allowed to change the ADC_tail
uint16_t ADC_get( void )
{
	circular_t tmp_tail,tmp_head;
	uint16_t data;

	do	{
		tmp_tail = ADC_tail;
// catch the pointer. if a interrupt routine accessed it and corrupted the read, recatch it.
		do	tmp_head = ADC_head;
		while 	(tmp_head != ADC_head);

		}
	while (tmp_tail == tmp_head);		// Wait for incomming data

	data = ADC_Buf[tmp_tail]; // get the data
	tmp_tail = (tmp_tail + 1 ) & ADC_BUFFER_MASK; // Calculate buffer index
	ADC_tail = tmp_tail;			// Store new index

	return data;					// Return data
}
//-----------------------------------------------------


//-----------------------------------------------------
uint8_t ADC_DataInBuffer( void )
{
	uint8_t	again;
	circular_t tmp_tail,tmp_head;
// protection against interrupt interference (non atomic access)
	do	{
		again = 0;
		tmp_head = ADC_head;
		tmp_tail = ADC_tail;
		if (tmp_head != ADC_head) again = 1;
		if (tmp_tail != ADC_tail) again = 1;
		}
	while (again);		// Wait for incomming data

	if (tmp_head == tmp_tail) 
		return (0);	//	Return 0 (FALSE) if the receive buffer is empty
	else	
		return (1);	//	Return 1 (TRUEE) if the receive buffer has data
}
//-----------------------------------------------------

