//===========================================================================================
//	This file contains a eeprom saving routine and a low voltage detection system
//
//  Writen by Murray Horn
//	25 Jan 2005.
//===========================================================================================


#include <inttypes.h>
#include <avr/eeprom.h>
#include "eeprom_001.h"



void eeprom_write_16(uint16_t val16 , int16_t addr)
{

union word_byte {
		uint16_t v_16;
		uint8_t	b[2];
	};

	union	word_byte mix;

	mix.v_16 = val16;
	while (!eeprom_is_ready())		;	eeprom_write_byte ((uint8_t *)(addr++),mix.b[0]);
	while (!eeprom_is_ready())		;	eeprom_write_byte ((uint8_t *)(addr++),mix.b[1]);
}


uint16_t eeprom_read_16(int16_t addr)
{
union word_byte {
		uint16_t v_16;
		uint8_t	b[2];
	};

	union	word_byte mix;

	while (!eeprom_is_ready())		;	mix.b[0] = eeprom_read_byte((uint8_t *)(addr++));
	while (!eeprom_is_ready())		;	mix.b[1] = eeprom_read_byte((uint8_t *)(addr++));
	return(mix.v_16);
}	
