// 14 Hour NiMH charger.
// fw version 0.1
// the software includes the use of the PWM, ADC, USART and EEPROM storage.
// The software implementation of a SMPSU uses the PWM and the ADC for feedback.  
// The USART is used for the initial callibration of the input selector and the current regulator feedback voltage.
// available from http://www.opend.co.za/
// Written by: Murray Horn
// Created : 6 December 2005
// Compiled on WinAVR 20040404

// Includes
#include <inttypes.h>
#include <avr/interrupt.h>
#include <uart001.h>
#include <pwm001.h>
#include <adc001.h>
#include <timer0_001.h>
#include <eeprom_001.h>

#include <avr/io.h>			// included to enable the writing of strings from rom
#include <avr/pgmspace.h>	// included to enable the writing of strings from rom

// constants
#define FCPU         16000000      /* CPU speed */


#define GreenLed	7	/* the pin number of the green side of the bi coloured led*/
#define RedLed		6	/* the pin number of the red side of the bi coloured led*/
#define keypin 		3

static	uint16_t	voltage_100,voltage_300,pwm_100,pwm_300;


static uint16_t	setpnt = 0;
volatile uint32_t	runtime;

//--------------------------------------------------------------
// this function reads adc channel 1 to get the user set current.
// the value is then corrected for gain and offset using the correction foactors
void get_set(void)
{
	uint32_t	temp_32;
	uint16_t	temp_16;
	
	adc_init(1);
	ADC_get(); // flush the next 2 adc values
	ADC_get(); // flush the next 2 adc values

	temp_16 = ADC_get();
	if (voltage_100 <= temp_16)
	{
		temp_32 = temp_16 - voltage_100;
		temp_32 = temp_32 * (pwm_300-pwm_100);
		temp_32 = temp_32 / (voltage_300-voltage_100);
		temp_32 = pwm_100 + temp_32;
	}
	else
	{
		temp_32 = voltage_100 - temp_16;
		temp_32 = temp_32 * (pwm_300-pwm_100);
		temp_32 = temp_32 / (voltage_300-voltage_100);
		temp_32 = pwm_100 - temp_32;
	}
	setpnt = temp_32;

	adc_init(0);
	ADC_get(); // flush the next 2 adc values
	ADC_get(); // flush the next 2 adc values
}
//------------------------------------------------------


//------------------------------------------------------+
// this is a cheap 16 bit word to ascii hex function
void print16(uint16_t num)
{
	uint8_t	b;
	uint8_t	i;
//-------------------------------------
// now for a cheap byte to ascii conversion
	uart_puts_p(PSTR("0x"));
	for (i=0;i<4;i++)
	{
		b = (num >> 12) & 0x0f;
		if (b <= 0x09)
			b = b + '0';
		else
			b = b - 10 + 'A';
		USART_Transmit(b);
		num = num << 4;
	}	
//-------------------------------------
}	

//------------------------------------------------------
// the soft implementation of the SMPSU control
//------------------------------------------------------
void control_pwm(void)
{
//#define max_duty 127	
//#define min_duty 0	

#define max_duty 100	
#define min_duty 4	

static	uint8_t		dutycycle = min_duty;
static uint32_t	adc_ave = 0;

static uint8_t		pre = 0;
static uint32_t	adc_ave_tmp;
		uint16_t	adcv;

	if (ADC_DataInBuffer()) // only if there is data waiting for me
	{
//------------------------------------------------------
// the adc sample collection
// average a number of samples out to get a smoothed average
//------------------------------------------------------
		adcv = ADC_get();

		adc_ave = adc_ave + adcv;
//------------------
// a prescaler used in the averaging of the adc
		if (pre >= 16)
			pre = 0;
		pre +=1;		

		if (1 == pre)
		{
			adc_ave = adc_ave >> 3;	
		
			adc_ave_tmp = adc_ave;
			while ((adc_ave_tmp < setpnt) && (dutycycle < max_duty))
			{
				dutycycle += 1;  
				adc_ave_tmp = adc_ave_tmp + (adc_ave_tmp >> 3); // exponential duty cycle control for fast accurate responce
			}	

			adc_ave_tmp = adc_ave;
			while ((adc_ave_tmp > setpnt) && (dutycycle > min_duty))
			{
				dutycycle -= 1;  
				adc_ave_tmp = adc_ave_tmp - (adc_ave_tmp >> 3); // exponential duty cycle control for fast accurate responce
			}	
			pwm_duty_cycle(dutycycle);

			adc_ave = 0; // flush the averaging accumulator 
		}
	}
//------------------------------------------------------
}

//------------------------------------------------------
// this routine rins only once, when the system is powered up.
// If the access code 'set' is entered via the serial port within the first 1.5 seconds,
// only thenwill the system will go through the callibration procedures.
// It is expected that this will only happen once, following construction.
//------------------------------------------------------
void	calibrate( void )
{
	uint8_t		b,charcnt;
	uint8_t		c1 = 0;
	uint8_t		c2 = 0;
	uint8_t		c3 = 0;
	
	int	i;
	
//-------------------------
// getting the password
	charcnt = 0;
	runtime = 2000; // about 1.5 seconds
	while ((runtime > 0) && (charcnt < 3))
	{
		if (ADC_DataInBuffer())	ADC_get(); //------keep the buffer empty
		if (USART_DataRx())
		{
			runtime = 2000; // about 1.5 seconds
			c1 = c2;
			c2 = c3;
			c3 = USART_Receive_lc();
			charcnt++;
		}
	}
	

	if ((3 == charcnt) && ('s' == c1) && ('e' == c2) && ('t' == c3))
	{
		adc_init(1);
		ADC_get(); // flush the next 2 adc values
		ADC_get(); // flush the next 2 adc values

// set the pot location of 1000ma
		b = 0;	
		while ('n' != b)
		{
			uart_putsl_p(PSTR("Move dial to 1000mAH"));
			uart_putsl_p(PSTR("Press <N> to continue"));
			while (!(USART_DataRx()))
			{
				if (ADC_DataInBuffer())	voltage_100 = ADC_get(); //------get pot pos
				
			}	
			b = USART_Receive_lc();
		}	


// set the pot location of 3000ma
		b = 0;	
		while ('n' != b)
		{
			uart_putsl_p(PSTR("Move dial to 3000mAH"));
			uart_putsl_p(PSTR("Press <N> to continue"));
			while (!(USART_DataRx()))
			{
				if (ADC_DataInBuffer())	voltage_300 = ADC_get(); //------get pot pos
				
			}	
			b = USART_Receive_lc();
		}	

		adc_init(0);
		ADC_get(); // flush the next 2 adc values
		ADC_get(); // flush the next 2 adc values
		
// set current to 1AH
		b = 0;	
		setpnt = 0xcc;
		uart_putsl_p(PSTR("Insert a set of cells with an Ammeter in series and adjust the current to 100mA"));
		uart_putsl_p(PSTR("Press <U> to increace the current and <D> to decreace it."));
		uart_putsl_p(PSTR("When the current is finally set, press <N>"));
		while ('n' != b)
		{
			if  (USART_DataRx())
			{
				b = USART_Receive_lc();
				if (('d' == b) && (setpnt > 0))
					setpnt--;
				if (('u' == b) && (setpnt < 0x8000))
					setpnt++;
			}		
			control_pwm();
		}
		pwm_100 = setpnt;

// set current to 3AH
		b = 0;	
		setpnt = 0x0368;
		uart_putsl_p(PSTR("Insert a set of cells with an Ammeter in series and adjust the current to 300mA"));
		uart_putsl_p(PSTR("Press <U> to increace the current and <D> to decreace it."));
		uart_putsl_p(PSTR("When the current is finally set, press <N>"));
		while ('n' != b)
		{
			if  (USART_DataRx())
			{
				b = USART_Receive_lc();
				if (('d' == b) && (setpnt > 0))
					setpnt--;
				if (('u' == b) && (setpnt < 0x8000))
					setpnt++;
			}		
			control_pwm();
		}
		pwm_300 = setpnt;
		setpnt = 0;

		uart_putsl_p(PSTR("----------------------------"));
		uart_puts_p(PSTR("Pot location for 100mA = "));
		print16(voltage_100);
		uart_putsl_p(PSTR(" "));
		uart_puts_p(PSTR("Setpoint for 100mA = "));
		print16(pwm_100);
		uart_putsl_p(PSTR(" "));

		uart_puts_p(PSTR("Pot location for 300mA = "));
		print16(voltage_300);
		uart_putsl_p(PSTR(" "));
		uart_puts_p(PSTR("Setpoint for 300mA = "));
		print16(pwm_300);
		uart_putsl_p(PSTR("----------------------------"));
		uart_putsl_p(PSTR(" "));
		uart_putsl_p(PSTR(" "));
		
		b = 0;	
		uart_putsl_p(PSTR("Pot linearity check"));
		uart_putsl_p(PSTR("Move the POT and check the current on the meter"));
		uart_putsl_p(PSTR("Press <N> to continue"));
		while ('n' != b)
		{
			if (USART_DataRx())
				b = USART_Receive_lc();
			
			get_set();

			for (i=0;i<10000;i++)
				control_pwm();
		}
// save the callibration values in the eeprom
		eeprom_write_16(voltage_100,0);
		eeprom_write_16(voltage_300,2);
		eeprom_write_16(pwm_100,4);
		eeprom_write_16(pwm_300,6);
	}
// fetch the callibration values from the eeprom
	voltage_100 = eeprom_read_16(0);
	voltage_300 = eeprom_read_16(2);
	pwm_100 = eeprom_read_16(4);
	pwm_300 = eeprom_read_16(6);
}



//-----------------------------------------------------
// Main - the main application
// the user will have the opertunity to adjust the callibration values via the usart within the first 1.5 seconds.
// Thereafter a flashing red light will indicate that the system is ready to accept a set current. (accepted by a keypress)
// An alternating red and green light will indicate the system has entered the 14 hour timer period.
// 		in this mode no further adjustments can be made to the set current.
// A flashing green light indicates the completion of the 14 hour charging cycle.
// to restart the charging, cycle the power.
//-----------------------------------------------------
int main( void )
{

	outp((1 << RedLed ) | (1 << GreenLed ),DDRD);
	outp(0,PORTD);
	outp((1 << keypin),PORTC); // this enables the pullup resistor

	USART_Init(UART_BAUD_SELECT(9600,FCPU),USART_SET_8_1_N);   //baudrate = 9600 bps 8 data bits 1 stop bit no parity

	pwm_init();
	adc_init(0);
	timer0_init();
    sei(); // enable interupts

	uart_putsl_p(PSTR("from www.opend.co.za")); // into string
	uart_putsl_p(PSTR("PWM nimh charger")); // into string
	uart_putsl_p(PSTR("FW version 0.1")); // into string
	uart_putsl_p(PSTR("HW version 1.0")); // into string
	uart_putsl_p(PSTR("Type <set> to calibrate the selector")); // into string

	__adc_start; // this starts the adc. define in adc001.inc

	outp(1 << RedLed,PORTD);
	calibrate();


	while(1)// forever
	{

		runtime = 0;
		outp(0,PORTD);
		
		
		uart_putsl_p(PSTR("Time for calibration is over!")); // into string
		uart_putsl_p(PSTR("Waiting for capacity entry")); // into string
		pwm_duty_cycle(0);

		runtime = 0;
		while ((inp(PINC) & (1 << keypin)) != 0)
		{
//------------------------------
//------keep the buffers empty
			if (ADC_DataInBuffer())	ADC_get();
			if (USART_DataRx())		USART_Receive();
//------------------------------

			get_set();
			if (0 == runtime)	runtime = 488;
			if (runtime > 50)	outp(0,PORTD);
			else				outp(1 << RedLed,PORTD);
		}		


		uart_puts_p(PSTR("Capacity set, charging started"));
		
		runtime = (uint32_t)(14*3515625); // 14 hours 
//		runtime = (uint32_t)(14*60*60*31250/32); // 14 hours 
		while (runtime > 0)
		{
			control_pwm();
			if (0 == (runtime & 0x200))	outp(1 << RedLed,PORTD);
			else							outp(1 << GreenLed,PORTD);
		}	

		uart_puts_p(PSTR("Charging completed"));
		pwm_duty_cycle(0);

		runtime = 0;
//		while ((inp(PINC) & (1 << keypin)) != 0)
		while (1)
		{
//------------------------------
//------keep the buffers empty
			if (ADC_DataInBuffer())	ADC_get();
			if (USART_DataRx())		USART_Receive();
//------------------------------

			if (0 == runtime)	runtime = 200;
			if (runtime > 50)	outp(0,PORTD);
			else				outp(1 << GreenLed,PORTD);
		}		
	}
}
//-----------------------------------------------------
