// Routines for pwm controll
//
// created : 3 Nov 2005
// Modified by: Murray Horn

#include <inttypes.h>
#include <avr/io.h>
#include <pwm001.h>

void	pwm_init(void)
{
	// set OC1A pin as output, required for output toggling
//	outp((1 << 1),DDRB); //
    
	// fast 8bit pwm, phase correct max set to 0xff
	TCCR1A = _BV(COM1A1) | /* _BV(COM1A0) |*/ _BV(WGM12) | _BV(WGM11);
    
	// fast 8bit pwm prescaled freq  = xtal/2
	TCCR1B = _BV(CS10) | _BV(WGM13);

// set the port pin and direction
	outp(0x2 | DDRB,DDRB);
	outp((0xff ^ 0x02) & PORTB,PORTB);

// pwm freq set to xtal/(2*ICR1)
	ICR1 = 0x7f;
};


void	pwm_duty_cycle(uint16_t w)
{
	OCR1AH = (0xff & (w >> 8));
	OCR1AL = (0xff & w);
};
