/*
 * General LCD defines
 */

/* CPU frequency */
#define F_CPU 1000000UL

/**/
#define ON 1
#define OFF 0
/* Define bitset/clr */
#define bitset(port,bit) ((port) |= (1<<bit))
#define bitclr(port,bit) ((port) &= (~(1<<bit)))
/* HD44780 LCD port connections */
#define HD44780_PORT B
#define HD44780_RS PORT0
#define HD44780_RW PORT1
#define HD44780_E  PORT2
/* The data bits have to be in ascending order. */
#define HD44780_D4 PORT4
#define HD44780_D5 PORT5
#define HD44780_D6 PORT6
#define HD44780_D7 PORT7
/* LCD LED */
#define LLED_DDR DDRB
#define LLED_PORT PORTB
#define LLED_PIN 3
#define LLED(val) if(val) bitset(LLED_PORT,LLED_PIN),bitset(LLED_DDR,LLED_PIN); else bitclr(LLED_PORT,LLED_PIN),bitclr(LLED_DDR,LLED_PIN)
