#include "defines.h"
#include <ctype.h>
#include <stdint.h>
#include <stdio.h>
#include <avr/io.h>
#include <avr/pgmspace.h>
#include <util/delay.h>
#include "lcd.h"

static void
ioinit(void)
{
	lcd_init();
}

FILE lcd_str = FDEV_SETUP_STREAM(lcd_putchar, NULL, _FDEV_SETUP_WRITE);

static void
delay_s(uint8_t s)
{
	uint8_t i;
	uint8_t j=0;
	
	while (j<s)
	{
		for (i = 0; i < 100; i++)
			_delay_ms(10);
		j++;
	}
}

int
main(void)
{
	ioinit();
	stderr = &lcd_str;

	LLED(ON);
	delay_s(1);
	LLED(OFF);
	delay_s(1);
	LLED(ON);
	delay_s(1);

	fprintf(stderr, "Hello world!\n");

	delay_s(2);
	lcd_cls();
	delay_s(1);

	fprintf(stderr, "Vahid Eskandar\n");

	delay_s(4);

	int i,b;
	b=1;

	for(i=0;i<6;i++)
	{
		if (b==1) b=0 ; else b=1;
		LLED(b);
		delay_s(1);
	}

	delay_s(2);
	lcd_dispctl(0,0,0);
	delay_s(2);
	lcd_dispctl(1,0,0);	
	delay_s(2);
	lcd_dispctl(1,1,0);
	delay_s(2);
	lcd_dispctl(1,1,1);
	delay_s(2);

	fprintf(stderr, "END");
	for(i=0;i<3;i++)
	{
		putc('.', stderr);
		delay_s(1);
	}

	lcd_dispctl(0,0,0);
	LLED(OFF);
	while(1);
}
