VERSION 5.00
Begin VB.UserControl Shadow 
   AutoRedraw      =   -1  'True
   CanGetFocus     =   0   'False
   ClientHeight    =   495
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   1215
   EditAtDesignTime=   -1  'True
   FillStyle       =   0  'Solid
   ForwardFocus    =   -1  'True
   ScaleHeight     =   495
   ScaleWidth      =   1215
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "Label1"
      ForeColor       =   &H00404040&
      Height          =   195
      Left            =   120
      TabIndex        =   0
      Top             =   120
      Width           =   480
   End
   Begin VB.Label Label2 
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "Label1"
      ForeColor       =   &H00FFFFFF&
      Height          =   195
      Left            =   600
      TabIndex        =   1
      Top             =   240
      Width           =   480
   End
End
Attribute VB_Name = "Shadow"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Enum BackStyleEnum
    TransParent = 0
    Opaque = 1
End Enum
Enum AlignEnum
    LeftJustify = 0
    RightJustify = 1
    Center = 2
End Enum
Enum BorderStyleEnum
    None = 0
    FixedSingle = 1
End Enum
'Default Property Values:
Const m_def_ShadeLeft = 15
Const m_def_ShadeTop = 15
'Property Variables:
Dim m_AutoSize As Boolean
Dim m_ShadeLeft As Integer
Dim m_ShadeTop As Integer
Dim InResize As Boolean
'Event Declarations:
Event Change() 'MappingInfo=Label1,Label1,-1,Change
Attribute Change.VB_Description = "Occurs when the contents of a control have changed."
Event Click() 'MappingInfo=UserControl,UserControl,-1,Click
Attribute Click.VB_Description = "Occurs when the user presses and then releases a mouse button over an object."
Event DblClick() 'MappingInfo=UserControl,UserControl,-1,DblClick
Attribute DblClick.VB_Description = "Occurs when the user presses and releases a mouse button and then presses and releases it again over an object."
Event MouseDown(Button As Integer, Shift As Integer, X As Single, Y As Single) 'MappingInfo=UserControl,UserControl,-1,MouseDown
Attribute MouseDown.VB_Description = "Occurs when the user presses the mouse button while an object has the focus."
Event MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single) 'MappingInfo=UserControl,UserControl,-1,MouseMove
Attribute MouseMove.VB_Description = "Occurs when the user moves the mouse."
Event MouseUp(Button As Integer, Shift As Integer, X As Single, Y As Single) 'MappingInfo=UserControl,UserControl,-1,MouseUp
Attribute MouseUp.VB_Description = "Occurs when the user releases the mouse button while an object has the focus."
Event OLECompleteDrag(Effect As Long) 'MappingInfo=UserControl,UserControl,-1,OLECompleteDrag
Attribute OLECompleteDrag.VB_Description = "Occurs at the OLE drag/drop source control after a manual or automatic drag/drop has been completed or canceled."
Event OLEDragDrop(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single) 'MappingInfo=UserControl,UserControl,-1,OLEDragDrop
Attribute OLEDragDrop.VB_Description = "Occurs when data is dropped onto the control via an OLE drag/drop operation, and OLEDropMode is set to manual."
Event OLEDragOver(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single, State As Integer) 'MappingInfo=UserControl,UserControl,-1,OLEDragOver
Attribute OLEDragOver.VB_Description = "Occurs when the mouse is moved over the control during an OLE drag/drop operation, if its OLEDropMode property is set to manual."
Event OLEGiveFeedback(Effect As Long, DefaultCursors As Boolean) 'MappingInfo=UserControl,UserControl,-1,OLEGiveFeedback
Attribute OLEGiveFeedback.VB_Description = "Occurs at the source control of an OLE drag/drop operation when the mouse cursor needs to be changed."
Event OLESetData(Data As DataObject, DataFormat As Integer) 'MappingInfo=UserControl,UserControl,-1,OLESetData
Attribute OLESetData.VB_Description = "Occurs at the OLE drag/drop source control when the drop target requests data that was not provided to the DataObject during the OLEDragStart event."
Event OLEStartDrag(Data As DataObject, AllowedEffects As Long) 'MappingInfo=UserControl,UserControl,-1,OLEStartDrag
Attribute OLEStartDrag.VB_Description = "Occurs when an OLE drag/drop operation is initiated either manually or automatically."

Private Sub Recheck()
    Dim uWidth As Integer, uHeight As Integer
    Label1.AutoSize = True
    Label2.AutoSize = True
    Label1.AutoSize = False
    Label2.AutoSize = False
    If m_ShadeLeft < 0 Then
        Label1.Left = Abs(m_ShadeLeft)
        Label2.Left = 0
        uWidth = Label1.Left + Label1.Width
    Else
        Label1.Left = 0
        Label2.Left = m_ShadeLeft
        uWidth = Label2.Left + Label2.Width
    End If
    If m_ShadeTop < 0 Then
        Label1.Top = Abs(m_ShadeTop)
        Label2.Top = 0
        uHeight = Label1.Top + Label1.Height
    Else
        Label1.Top = 0
        Label2.Top = m_ShadeTop
        uHeight = Label2.Top + Label2.Height
    End If
    InResize = True
    If AutoSize Then
        UserControl.Size UserControl.Width - UserControl.ScaleWidth + uWidth, UserControl.Height - UserControl.ScaleHeight + uHeight
    Else
        Label1.Width = UserControl.ScaleWidth - Abs(m_ShadeLeft)
        Label1.Height = UserControl.ScaleHeight - Abs(m_ShadeTop)
        Label2.Width = UserControl.ScaleWidth - Abs(m_ShadeLeft)
        Label2.Height = UserControl.ScaleHeight - Abs(m_ShadeTop)
    End If
    InResize = False
End Sub

'WARNING! DO NOT REMOVE OR MODIFY THE FOLLOWING COMMENTED LINES!
'MappingInfo=Label1,Label1,-1,Alignment
Public Property Get Alignment() As AlignEnum
Attribute Alignment.VB_Description = "Returns/sets the alignment of a CheckBox or OptionButton, or a control's text."
    Alignment = Label1.Alignment
End Property

Public Property Let Alignment(ByVal New_Alignment As AlignEnum)
    Label1.Alignment() = New_Alignment
    PropertyChanged "Alignment"
    Label2.Alignment = Label1.Alignment
End Property

'WARNING! DO NOT REMOVE OR MODIFY THE FOLLOWING COMMENTED LINES!
'MappingInfo=Label1,Label1,-1,AutoSize
Public Property Get AutoSize() As Boolean
Attribute AutoSize.VB_Description = "Determines whether a control is automatically resized to display its entire contents."
    AutoSize = m_AutoSize
End Property

Public Property Let AutoSize(ByVal New_AutoSize As Boolean)
    m_AutoSize = New_AutoSize
    PropertyChanged "AutoSize"
    Recheck
End Property

'WARNING! DO NOT REMOVE OR MODIFY THE FOLLOWING COMMENTED LINES!
'MappingInfo=UserControl,UserControl,-1,BackColor
Public Property Get BackColor() As OLE_COLOR
Attribute BackColor.VB_Description = "Returns/sets the background color used to display text and graphics in an object."
    BackColor = UserControl.BackColor
End Property

Public Property Let BackColor(ByVal New_BackColor As OLE_COLOR)
    UserControl.BackColor() = New_BackColor
    PropertyChanged "BackColor"
    Recheck
End Property

'WARNING! DO NOT REMOVE OR MODIFY THE FOLLOWING COMMENTED LINES!
'MappingInfo=UserControl,UserControl,-1,BackStyle
Public Property Get BackStyle() As BackStyleEnum
Attribute BackStyle.VB_Description = "Indicates whether a Label or the background of a Shape is transparent or opaque."
    BackStyle = UserControl.BackStyle
End Property

Public Property Let BackStyle(ByVal New_BackStyle As BackStyleEnum)
    UserControl.BackStyle() = New_BackStyle
    PropertyChanged "BackStyle"
    Recheck
End Property

'WARNING! DO NOT REMOVE OR MODIFY THE FOLLOWING COMMENTED LINES!
'MappingInfo=UserControl,UserControl,-1,BorderStyle
Public Property Get BorderStyle() As BorderStyleEnum
Attribute BorderStyle.VB_Description = "Returns/sets the border style for an object."
    BorderStyle = UserControl.BorderStyle
End Property

Public Property Let BorderStyle(ByVal New_BorderStyle As BorderStyleEnum)
    UserControl.BorderStyle() = New_BorderStyle
    PropertyChanged "BorderStyle"
    Recheck
End Property

'WARNING! DO NOT REMOVE OR MODIFY THE FOLLOWING COMMENTED LINES!
'MappingInfo=Label1,Label1,-1,Caption
Public Property Get Caption() As String
Attribute Caption.VB_Description = "Returns/sets the text displayed in an object's title bar or below an object's icon."
    Caption = Label1.Caption
End Property

Public Property Let Caption(ByVal New_Caption As String)
    Label1.Caption() = New_Caption
    PropertyChanged "Caption"
    Label2.Caption = Label1.Caption
    Recheck
End Property

'Private Sub Label1_Change()
'    RaiseEvent Change
'End Sub
'
'Private Sub Label1_Click()
'    RaiseEvent Click
'End Sub
'
'Private Sub Label1_DblClick()
'    RaiseEvent DblClick
'End Sub
'
'Private Sub Label2_Click()
'    RaiseEvent Click
'End Sub
'
'Private Sub Label2_DblClick()
'    RaiseEvent DblClick
'End Sub
'
Private Sub UserControl_Click()
    RaiseEvent Click
End Sub

Private Sub UserControl_DblClick()
    RaiseEvent DblClick
End Sub

'WARNING! DO NOT REMOVE OR MODIFY THE FOLLOWING COMMENTED LINES!
'MappingInfo=UserControl,UserControl,-1,Enabled
Public Property Get Enabled() As Boolean
Attribute Enabled.VB_Description = "Returns/sets a value that determines whether an object can respond to user-generated events."
    Enabled = UserControl.Enabled
End Property

Public Property Let Enabled(ByVal New_Enabled As Boolean)
    UserControl.Enabled() = New_Enabled
    PropertyChanged "Enabled"
    Recheck
End Property

'WARNING! DO NOT REMOVE OR MODIFY THE FOLLOWING COMMENTED LINES!
'MappingInfo=Label1,Label1,-1,Font
Public Property Get Font() As Font
Attribute Font.VB_Description = "Returns a Font object."
Attribute Font.VB_UserMemId = -512
    Set Font = Label1.Font
End Property

Public Property Set Font(ByVal New_Font As Font)
    Set Label1.Font = New_Font
    PropertyChanged "Font"
    Label2.Font.Bold = Label1.Font.Bold
    Label2.Font.Charset = Label1.Font.Charset
    Label2.Font.Italic = Label1.Font.Italic
    Label2.Font.Name = Label1.Font.Name
    Label2.Font.Size = Label1.Font.Size
    Label2.Font.Strikethrough = Label1.Font.Strikethrough
    Label2.Font.Underline = Label1.Font.Underline
    Label2.Font.Weight = Label1.Font.Weight
    Recheck
End Property

'WARNING! DO NOT REMOVE OR MODIFY THE FOLLOWING COMMENTED LINES!
'MappingInfo=Label1,Label1,-1,ForeColor
Public Property Get ForeColor() As OLE_COLOR
Attribute ForeColor.VB_Description = "Returns/sets the foreground color used to display text and graphics in an object."
    ForeColor = Label1.ForeColor
End Property

Public Property Let ForeColor(ByVal New_ForeColor As OLE_COLOR)
    Label1.ForeColor() = New_ForeColor
    PropertyChanged "ForeColor"
    Recheck
End Property

Private Sub UserControl_MouseDown(Button As Integer, Shift As Integer, X As Single, Y As Single)
    RaiseEvent MouseDown(Button, Shift, X, Y)
End Sub

'WARNING! DO NOT REMOVE OR MODIFY THE FOLLOWING COMMENTED LINES!
'MappingInfo=UserControl,UserControl,-1,MouseIcon
Public Property Get MouseIcon() As Picture
Attribute MouseIcon.VB_Description = "Sets a custom mouse icon."
    Set MouseIcon = UserControl.MouseIcon
End Property

Public Property Set MouseIcon(ByVal New_MouseIcon As Picture)
    Set UserControl.MouseIcon = New_MouseIcon
    PropertyChanged "MouseIcon"
End Property

Private Sub UserControl_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)
    RaiseEvent MouseMove(Button, Shift, X, Y)
End Sub

'WARNING! DO NOT REMOVE OR MODIFY THE FOLLOWING COMMENTED LINES!
'MappingInfo=UserControl,UserControl,-1,MousePointer
Public Property Get MousePointer() As Integer
Attribute MousePointer.VB_Description = "Returns/sets the type of mouse pointer displayed when over part of an object."
    MousePointer = UserControl.MousePointer
End Property

Public Property Let MousePointer(ByVal New_MousePointer As Integer)
    UserControl.MousePointer() = New_MousePointer
    PropertyChanged "MousePointer"
End Property

Private Sub UserControl_MouseUp(Button As Integer, Shift As Integer, X As Single, Y As Single)
    RaiseEvent MouseUp(Button, Shift, X, Y)
End Sub

Private Sub UserControl_OLECompleteDrag(Effect As Long)
    RaiseEvent OLECompleteDrag(Effect)
End Sub

'WARNING! DO NOT REMOVE OR MODIFY THE FOLLOWING COMMENTED LINES!
'MappingInfo=UserControl,UserControl,-1,OLEDrag
Public Sub OLEDrag()
Attribute OLEDrag.VB_Description = "Starts an OLE drag/drop event with the given control as the source."
    UserControl.OLEDrag
End Sub

Private Sub UserControl_OLEDragDrop(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single)
    RaiseEvent OLEDragDrop(Data, Effect, Button, Shift, X, Y)
End Sub

Private Sub UserControl_OLEDragOver(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single, State As Integer)
    RaiseEvent OLEDragOver(Data, Effect, Button, Shift, X, Y, State)
End Sub

'WARNING! DO NOT REMOVE OR MODIFY THE FOLLOWING COMMENTED LINES!
'MappingInfo=UserControl,UserControl,-1,OLEDropMode
Public Property Get OLEDropMode() As Integer
Attribute OLEDropMode.VB_Description = "Returns/Sets whether this object can act as an OLE drop target."
    OLEDropMode = UserControl.OLEDropMode
End Property

Public Property Let OLEDropMode(ByVal New_OLEDropMode As Integer)
    UserControl.OLEDropMode() = New_OLEDropMode
    PropertyChanged "OLEDropMode"
End Property

Private Sub UserControl_OLEGiveFeedback(Effect As Long, DefaultCursors As Boolean)
    RaiseEvent OLEGiveFeedback(Effect, DefaultCursors)
End Sub

Private Sub UserControl_OLESetData(Data As DataObject, DataFormat As Integer)
    RaiseEvent OLESetData(Data, DataFormat)
End Sub

Private Sub UserControl_OLEStartDrag(Data As DataObject, AllowedEffects As Long)
    RaiseEvent OLEStartDrag(Data, AllowedEffects)
End Sub

'WARNING! DO NOT REMOVE OR MODIFY THE FOLLOWING COMMENTED LINES!
'MappingInfo=Label1,Label1,-1,RightToLeft
Public Property Get RightToLeft() As Boolean
Attribute RightToLeft.VB_Description = "Determines text display direction and control visual appearance on a bidirectional system."
    RightToLeft = Label1.RightToLeft
End Property

Public Property Let RightToLeft(ByVal New_RightToLeft As Boolean)
    Label1.RightToLeft() = New_RightToLeft
    PropertyChanged "RightToLeft"
    Label2.RightToLeft = Label1.RightToLeft
    Recheck
End Property

'WARNING! DO NOT REMOVE OR MODIFY THE FOLLOWING COMMENTED LINES!
'MappingInfo=Label1,Label1,-1,UseMnemonic
Public Property Get UseMnemonic() As Boolean
Attribute UseMnemonic.VB_Description = "Returns/sets a value that specifies whether an & in a Label's Caption property defines an access key."
    UseMnemonic = Label1.UseMnemonic
End Property

Public Property Let UseMnemonic(ByVal New_UseMnemonic As Boolean)
    Label1.UseMnemonic() = New_UseMnemonic
    PropertyChanged "UseMnemonic"
    Recheck
End Property

'WARNING! DO NOT REMOVE OR MODIFY THE FOLLOWING COMMENTED LINES!
'MappingInfo=Label1,Label1,-1,WordWrap
Public Property Get WordWrap() As Boolean
Attribute WordWrap.VB_Description = "Returns/sets a value that determines whether a control expands to fit the text in its Caption."
    WordWrap = Label1.WordWrap
End Property

Public Property Let WordWrap(ByVal New_WordWrap As Boolean)
    Label1.WordWrap() = New_WordWrap
    PropertyChanged "WordWrap"
    Recheck
End Property

'WARNING! DO NOT REMOVE OR MODIFY THE FOLLOWING COMMENTED LINES!
'MemberInfo=7,0,0,1
Public Property Get ShadeLeft() As Integer
    ShadeLeft = m_ShadeLeft / 15
End Property

Public Property Let ShadeLeft(ByVal New_ShadeLeft As Integer)
    m_ShadeLeft = New_ShadeLeft * 15
    PropertyChanged "ShadeLeft"
    Recheck
End Property

'WARNING! DO NOT REMOVE OR MODIFY THE FOLLOWING COMMENTED LINES!
'MemberInfo=7,0,0,1
Public Property Get ShadeTop() As Integer
    ShadeTop = m_ShadeTop / 15
End Property

Public Property Let ShadeTop(ByVal New_ShadeTop As Integer)
    m_ShadeTop = New_ShadeTop * 15
    PropertyChanged "ShadeTop"
    Recheck
End Property

'WARNING! DO NOT REMOVE OR MODIFY THE FOLLOWING COMMENTED LINES!
'MappingInfo=Label2,Label2,-1,ForeColor
Public Property Get ForColor2() As OLE_COLOR
Attribute ForColor2.VB_Description = "Returns/sets the foreground color used to display text and graphics in an object."
    ForColor2 = Label2.ForeColor
End Property

Public Property Let ForColor2(ByVal New_ForColor2 As OLE_COLOR)
    Label2.ForeColor() = New_ForColor2
    PropertyChanged "ForColor2"
    Recheck
End Property

'Initialize Properties for User Control
Private Sub UserControl_InitProperties()
    m_ShadeLeft = m_def_ShadeLeft
    m_ShadeTop = m_def_ShadeTop
    m_AutoSize = True
    Label1 = Ambient.DisplayName
    Label2 = Ambient.DisplayName
    Recheck
End Sub

'Load property values from storage
Private Sub UserControl_ReadProperties(PropBag As PropertyBag)
    Label1.Alignment = PropBag.ReadProperty("Alignment", 0)
    Label1.AutoSize = PropBag.ReadProperty("AutoSize", True)
    UserControl.BackColor = PropBag.ReadProperty("BackColor", &H8000000F)
    UserControl.BackStyle = PropBag.ReadProperty("BackStyle", 1)
    UserControl.BorderStyle = PropBag.ReadProperty("BorderStyle", 0)
    Label1.Caption = PropBag.ReadProperty("Caption", "Label1")
    UserControl.Enabled = PropBag.ReadProperty("Enabled", True)
    Set Label1.Font = PropBag.ReadProperty("Font", Ambient.Font)
    Label1.ForeColor = PropBag.ReadProperty("ForeColor", &H80000012)
    Set MouseIcon = PropBag.ReadProperty("MouseIcon", Nothing)
    UserControl.MousePointer = PropBag.ReadProperty("MousePointer", 0)
    UserControl.OLEDropMode = PropBag.ReadProperty("OLEDropMode", 0)
    Label1.RightToLeft = PropBag.ReadProperty("RightToLeft", False)
    Label1.UseMnemonic = PropBag.ReadProperty("UseMnemonic", True)
    Label1.WordWrap = PropBag.ReadProperty("WordWrap", False)
    m_ShadeLeft = PropBag.ReadProperty("ShadeLeft", m_def_ShadeLeft)
    m_ShadeTop = PropBag.ReadProperty("ShadeTop", m_def_ShadeTop)
    
    Label2.Alignment = PropBag.ReadProperty("Alignment", 0)
    Label2.AutoSize = PropBag.ReadProperty("AutoSize", True)
    UserControl.BackColor = PropBag.ReadProperty("BackColor", &H8000000F)
    Label2.Caption = PropBag.ReadProperty("Caption", "Label1")
    UserControl.Enabled = PropBag.ReadProperty("Enabled", True)
    Set Label2.Font = PropBag.ReadProperty("Font", Ambient.Font)
    Label2.ForeColor = PropBag.ReadProperty("ForeColor2", &HFFFFFF)
    Label2.RightToLeft = PropBag.ReadProperty("RightToLeft", False)
    Label2.UseMnemonic = PropBag.ReadProperty("UseMnemonic", True)
    Label2.WordWrap = PropBag.ReadProperty("WordWrap", False)
    
    Label1.Left = PropBag.ReadProperty("Left1", IIf(m_ShadeLeft < 0, Abs(m_ShadeLeft), 0))
    Label2.Left = PropBag.ReadProperty("Left2", IIf(m_ShadeLeft < 0, 0, Abs(m_ShadeLeft)))
    Label1.Top = PropBag.ReadProperty("Top1", IIf(m_ShadeTop < 0, Abs(m_ShadeTop), 0))
    Label2.Top = PropBag.ReadProperty("Top2", IIf(m_ShadeTop < 0, 0, Abs(m_ShadeTop)))
    Label2.Width = PropBag.ReadProperty("Width", UserControl.ScaleWidth - Abs(m_ShadeLeft))
    Label2.Height = PropBag.ReadProperty("Height", UserControl.ScaleHeight - Abs(m_ShadeTop))
    Recheck
End Sub

Private Sub UserControl_Resize()
    If Not InResize Then Recheck
End Sub

'Write property values to storage
Private Sub UserControl_WriteProperties(PropBag As PropertyBag)

    Call PropBag.WriteProperty("Alignment", Label1.Alignment, 0)
    Call PropBag.WriteProperty("AutoSize", Label1.AutoSize, True)
    Call PropBag.WriteProperty("BackColor", UserControl.BackColor, &H8000000F)
    Call PropBag.WriteProperty("BackStyle", UserControl.BackStyle, 1)
    Call PropBag.WriteProperty("BorderStyle", UserControl.BorderStyle, 0)
    Call PropBag.WriteProperty("Caption", Label1.Caption, "Label1")
    Call PropBag.WriteProperty("Enabled", UserControl.Enabled, True)
    Call PropBag.WriteProperty("Font", Label1.Font, Ambient.Font)
    Call PropBag.WriteProperty("ForeColor", Label1.ForeColor, &H80000012)
    Call PropBag.WriteProperty("MouseIcon", MouseIcon, Nothing)
    Call PropBag.WriteProperty("MousePointer", UserControl.MousePointer, 0)
    Call PropBag.WriteProperty("OLEDropMode", UserControl.OLEDropMode, 0)
    Call PropBag.WriteProperty("RightToLeft", Label1.RightToLeft, False)
    Call PropBag.WriteProperty("UseMnemonic", Label1.UseMnemonic, True)
    Call PropBag.WriteProperty("WordWrap", Label1.WordWrap, False)
    Call PropBag.WriteProperty("ShadeLeft", m_ShadeLeft, m_def_ShadeLeft)
    Call PropBag.WriteProperty("ShadeTop", m_ShadeTop, m_def_ShadeTop)
    Call PropBag.WriteProperty("ForColor2", Label2.ForeColor, &HFFFFFF)
    
    PropBag.WriteProperty "Left1", Label1.Left, IIf(m_ShadeLeft < 0, Abs(m_ShadeLeft), 0)
    PropBag.WriteProperty "Left2", Label2.Left, IIf(m_ShadeLeft < 0, 0, Abs(m_ShadeLeft))
    PropBag.WriteProperty "Top1", Label1.Top, IIf(m_ShadeTop < 0, Abs(m_ShadeTop), 0)
    PropBag.WriteProperty "Top2", Label2.Top, IIf(m_ShadeTop < 0, 0, Abs(m_ShadeTop))
    PropBag.WriteProperty "Width", Label2.Width, UserControl.ScaleWidth - Abs(m_ShadeLeft)
    PropBag.WriteProperty "Height", Label2.Height, UserControl.ScaleHeight - Abs(m_ShadeTop)
End Sub

