

function Lagrange(resolution)
    global func01_x func01_y;
    func01_x = [-1,0,1,2];
    func01_y = [2,1,3,8] ;
	step_x = 1/resolution;
	%----------------------
	x_min = min(func01_x);
	x_max = max(func01_x);
	%----------------------
	y_min = min(func01_y);
	y_max = max(func01_y);
	%----------------------
	points_x = x_min:step_x:x_max;
	%======================================
	points_y = zeros(1,resolution*(abs(x_max - x_min))+1);
	for array_indx=1:resolution*(abs(x_max - x_min))+1 
		for	indx=1:numel(func01_x)
			points_y(array_indx) = points_y(array_indx) + func01_y(indx) * lag_i(indx,points_x(array_indx));
		end
	end
	%======================================
	figure;
	set(gcf,'color','white');
	plot(points_x,points_y);
	hold on;
	plot(func01_x,func01_y,'r.','MarkerSize',25);
end

function L=lag_i(index,x)
    global func01_x func01_y;
    i=numel(func01_x);
	tmp=1;
	for k=1:i
		if(k~=index)
			tmp = tmp * ( (x-func01_x(k))/(func01_x(index) - func01_x(k)) ); 
		end
	end
	L=tmp;
end
